<?php 
	$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
	query_posts( array( 
		'post_type'             => 'agenda', 
		'ignore_sticky_posts'   => 1,
		'paged'                 => $paged, 
		'meta_key'              => '_minus',
		'meta_query'            => array(
			                        array(
								    	'key'         => '_minus',
										'compare' => '>='
									)
								),
		'orderby'               => 'meta_value',
		'order'                 => 'DESC'
		) 
	); 
	
	$offset      = get_option( 'gmt_offset' );
	if ( $offset = 7 ) {
		$localtime = 'UTC+0700';
	} elseif ( $offset = 8 ) {
		$localtime = 'UTC+0800';
	} elseif ( $offset = 9 ) {
		$localtime ='UTC+0900';
	}
	$today       = strtotime(date('Y-m-d H:i:s', strtotime('+'.$offset.' hours')));
	
	$noagenda = 0;
    if (have_posts()):
	    echo '<div class="post_loop">';
	    while (have_posts()): the_post(); 
		$noagenda++;
			global $post;
			
			$minus       = strtotime(get_post_meta($post->ID, '_tevent', true).' '.get_post_meta($post->ID, '_jam', true));
			$tevent      = get_post_meta($post->ID, '_tevent', true);
			$jam         = get_post_meta($post->ID, '_jam', true);
						
			$pack24      = date( "H:i:s", strtotime( $jam ) );		
			$sisa        = $minus-$today;
            $end         = $tevent . ' ' . $pack24;	
						
			$lokasi      = get_post_meta( $post->ID, '_lokasi', true );
			$koordinator = get_post_meta( $post->ID, '_koordinator', true );
			$telepon     = get_post_meta( $post->ID, '_telepon', true );
			$acara       = date_i18n( "d F Y", strtotime( $tevent ) );
			
		    ?>
		    	
				<div class="post_inagenda">
				    <div class="age_arsip <?php if ( $sisa < 0 ) { echo 'age_expired'; } else { echo 'age_active'; } ?>">
						<div class="agedate"><?php echo esc_html( date_i18n( 'd', strtotime( $tevent ) ) ); ?></div>
				        <div class="agemonth"><?php echo esc_html( date_i18n( 'M Y', strtotime( $tevent ) ) ); ?></div>
					</div>
					
					<div class="post_inmeta age_meta">
					    <?php if ( $sisa < 0 ) { 
						    echo '<div class="post_inpublish"><span class="like_link">'.__( 'Agenda is expired', 'mading' ).'</span></div>'; 
						} else { ?>
							<div class="post_inpublish">
							    <?php echo __( 'Go to agenda :', 'mading' ); ?><span id="event<?php echo esc_html( $noagenda ); ?>">
								    <span class="event_day<?php echo esc_html( $noagenda ); ?>"></span> <?php echo __( 'Day + ', 'mading' ); ?>
									<span class="like_link"><span class="event_hour<?php echo esc_html( $noagenda ); ?>"></span> : <span class="event_minutes<?php echo esc_html( $noagenda ); ?>"></span> : <span class="event_seconds<?php echo esc_html( $noagenda ); ?>"></span></span>
								</span>
							</div> 
						<?php } ?>
				    	<h2><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h2>
			        	<div class="post_inexcerpt">
			            	<?php echo smart_excerpt(get_the_excerpt(), 20); ?>
			        	</div>
						
			    	</div>
					
				</div>
			
					<script>

						function getTimeRemaining(endtime){
  						    var t = Date.parse(endtime) - Date.parse(new Date());
  					    	var seconds = Math.floor( (t/1000) % 60 );
  					    	var minutes = Math.floor( (t/1000/60) % 60 );
  					    	var hours = Math.floor( (t/(1000*60*60)) % 24 );
  					    	var days = Math.floor( t/(1000*60*60*24) );
  					    	return {
  						        'total': t,
  						        'days': days,
  						        'hours': hours,
  						        'minutes': minutes,
  						        'seconds': seconds
 						    };
						}

						function initializeClock(id, endtime){
  					    	var clock = document.getElementById(id);
  					    	var daysSpan = clock.querySelector('.event_day<?php echo esc_html( $noagenda ); ?>');
  					    	var hoursSpan = clock.querySelector('.event_hour<?php echo esc_html( $noagenda ); ?>');
  					    	var minutesSpan = clock.querySelector('.event_minutes<?php echo esc_html( $noagenda ); ?>');
  					    	var secondsSpan = clock.querySelector('.event_seconds<?php echo esc_html( $noagenda ); ?>');

  						function updateClock(){
   						    var t = getTimeRemaining(endtime);

    						daysSpan.innerHTML = t.days;
    						hoursSpan.innerHTML = ('0' + t.hours).slice(-2);
    						minutesSpan.innerHTML = ('0' + t.minutes).slice(-2);
    						secondsSpan.innerHTML = ('0' + t.seconds).slice(-2);

    						if(t.total<=0){
     						    clearInterval(timeinterval);
    						}
  						}

  						updateClock();
  						var timeinterval = setInterval(updateClock,1000);
						}

						var deadline = '<?php echo date( "F j Y H:i:s", strtotime( $end ) ); ?> <?php echo esc_html($localtime); ?>';
						initializeClock('event<?php echo esc_html( $noagenda ); ?>', deadline);

					</script>

			
		<?php endwhile; 
		echo '</div>';
    endif; 
	
	wp_reset_query(); 