<?php 
$pagesiswa = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
$posts_per_page = 10;
$counter = ($pagesiswa - 1) * $posts_per_page;

query_posts( array( 
    'post_type' => 'mahasiswa', 
    'ignore_sticky_posts' => 1,
    'posts_per_page' => $posts_per_page, 
    'paged' => $pagesiswa, 
    'orderby' => 'title',
    'order' => 'ASC'
)); 

if (have_posts()): ?>
    <div class="op_tab_siswa">
        <table class="table">
            <tr class="top_tab">
                <td><?php echo esc_html_e( 'No', 'mading'); ?></td>
                <td><?php echo esc_html_e( 'Name', 'mading'); ?> & <?php echo esc_html_e( 'NIM', 'mading'); ?></td>
                <td><?php echo esc_html_e( 'Study', 'mading'); ?></td>
            </tr>
            <?php while (have_posts()): the_post(); 
                global $post;
                $counter++;
                $nisn = get_post_meta($post->ID, '_nisn', true);
                ?>
                <tr>
                    <td><?php echo $counter; ?>.</td>
                    <td>
					    <a class="fn wb" href="<?php the_permalink() ?>"><?php the_title(); ?></a>
                        <div class="op_tab_nik fs"><?php echo esc_html( $nisn ); ?></div>
                    <td>
                        <?php 
                            $terms = get_the_terms( $post->ID , 'fakultas' );
                            if ( $terms != null ){
                                foreach( $terms as $termkelas ) {
                                    $term_link = get_term_link( $termkelas, 'fakultas');
                                    echo '<a href="' . esc_url( $term_link ) . '">' . esc_html( $termkelas->name ) . '</a> ';
                                    unset($termkelas); 
                                } 
                            } 
                        ?>
                    </td>
                </tr>
            <?php endwhile; ?>
        </table>
    </div>
<?php 
endif; 
?>
