<?php
function awe_left_menu_bg_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[284];
	$awe_left_menu_bg = get_theme_mod( 'awe_left_menu_bg', $default_color );

	if ( $awe_left_menu_bg === $default_color ) {
		return;
	}

	$css = '
	.op_header {
        background: %1$s;
	}
	.thisnav .accordion li > a > span {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_left_menu_bg) );
}
add_action( 'wp_enqueue_scripts', 'awe_left_menu_bg_css', 11 );

function awe_left_menu_col_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[285];
	$awe_left_menu_col = get_theme_mod( 'awe_left_menu_col', $default_color );

	if ( $awe_left_menu_col === $default_color ) {
		return;
	}

	$css = '
	.op_header a,
	.thisnav li:has(ul):after {
        color: %1$s;
	}
	.thisnav .accordion li:hover,
    .thisnav .accordion li.current-menu-item {
		border-right: 2px solid %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_left_menu_col) );
}
add_action( 'wp_enqueue_scripts', 'awe_left_menu_col_css', 11 );

function awe_top_bg_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[286];
	$awe_top_bg = get_theme_mod( 'awe_top_bg', $default_color );

	if ( $awe_top_bg === $default_color ) {
		return;
	}

	$css = '
	.op_topscroll,
	.op_school {
        background: %1$s;
	}
	.op_call,
	.awesome .op_call a {
        color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_top_bg) );
}
add_action( 'wp_enqueue_scripts', 'awe_top_bg_css', 11 );

function awe_top_bgs_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[287];
	$awe_top_bgs = get_theme_mod( 'awe_top_bgs', $default_color );

	if ( $awe_top_bgs === $default_color ) {
		return;
	}

	$css = '
	.op_s_input input,
	.op_s_select select,
	.op_dot,
	.op_opmenu,
	.op_school a {
        background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_top_bgs) );
}
add_action( 'wp_enqueue_scripts', 'awe_top_bgs_css', 11 );

function awe_top_col_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[288];
	$awe_top_col = get_theme_mod( 'awe_top_col', $default_color );

	if ( $awe_top_col === $default_color ) {
		return;
	}

	$css = '
	.op_topscroll,
	.op_school,
	.op_s_input input,
	.op_s_select select,
	.op_dot,
	.op_opmenu,
	.op_school a {
        color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_top_col) );
}
add_action( 'wp_enqueue_scripts', 'awe_top_col_css', 11 );

function awe_top_acc_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[289];
	$awe_top_acc = get_theme_mod( 'awe_top_acc', $default_color );

	if ( $awe_top_acc === $default_color ) {
		return;
	}

	$css = '
	.op_call {
        background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_top_acc) );
}
add_action( 'wp_enqueue_scripts', 'awe_top_acc_css', 11 );

function awe_eve_bg_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[290];
	$awe_eve_bg = get_theme_mod( 'awe_eve_bg', $default_color );

	if ( $awe_eve_bg === $default_color ) {
		return;
	}

	$css = '
	.op_event,
	.op_event:hover .op_ev_title span:after,
    .op_next .op_ev_title span:after {
        background: %1$s;
	}
	.op_event:hover .op_ev_title span:before,
    .op_next .op_ev_title span:before {
		border-color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_eve_bg) );
}
add_action( 'wp_enqueue_scripts', 'awe_eve_bg_css', 11 );

function awe_eve_col_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[291];
	$awe_eve_col = get_theme_mod( 'awe_eve_col', $default_color );

	if ( $awe_eve_col === $default_color ) {
		return;
	}

	$css = '
	.op_event,
	.op_ev_title a,
	.op_ev_date span:first-child {
        color: %1$s;
	}
	.op_ev_title span {
		border: 1px solid %1$s;
	}
	.op_ev_title span:before {
		border-color: %1$s;
	}
	.op_ev_title span:after,
	.op_ev_date:before {
        background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_eve_col) );
}
add_action( 'wp_enqueue_scripts', 'awe_eve_col_css', 11 );

function awe_eve_acc_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[292];
	$awe_eve_acc = get_theme_mod( 'awe_eve_acc', $default_color );

	if ( $awe_eve_acc === $default_color ) {
		return;
	}

	$css = '
	.op_event:hover .op_ev_title span,
    .op_next .op_ev_title span {
		background: %1$s;
		border: 1px solid %1$s;
	}
	.op_ev_date span:last-child,
	.op_prev .op_ev_time span:last-child {
        color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_eve_acc) );
}
add_action( 'wp_enqueue_scripts', 'awe_eve_acc_css', 11 );

function awe_peng_bg_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[293];
	$awe_peng_bg = get_theme_mod( 'awe_peng_bg', $default_color );

	if ( $awe_peng_bg === $default_color ) {
		return;
	}

	$css = '
	.op_umum,
	.op_pg_head:after,
	.op_pg_head span,
	.op_pg_head span:after {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_peng_bg) );
}
add_action( 'wp_enqueue_scripts', 'awe_peng_bg_css', 11 );

function awe_peng_col_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[294];
	$awe_peng_col = get_theme_mod( 'awe_peng_col', $default_color );

	if ( $awe_peng_col === $default_color ) {
		return;
	}

	$css = '
	.op_umum,
	.op_pg_link,
	.op_pg_head span,
	.op_pg_box h4 a {
        color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_peng_col) );
}
add_action( 'wp_enqueue_scripts', 'awe_peng_col_css', 11 );

function awe_news_bg_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[295];
	$awe_news_bg = get_theme_mod( 'awe_news_bg', $default_color );

	if ( $awe_news_bg === $default_color ) {
		return;
	}

	$css = '
	.op_news {
		background: %1$s;
	}
	.op_nw_author i,
	.op_nw_open {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_news_bg) );
}
add_action( 'wp_enqueue_scripts', 'awe_news_bg_css', 11 );

function awe_news_col_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[296];
	$awe_news_col = get_theme_mod( 'awe_news_col', $default_color );

	if ( $awe_news_col === $default_color ) {
		return;
	}

	$css = '
	.op_news,
	.op_nw_head a,
	.op_nw_share i {
        color: %1$s;
	}
	.op_nw_head:before,
	.op_nw_share a:before {
        background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_news_col) );
}
add_action( 'wp_enqueue_scripts', 'awe_news_col_css', 11 );

function awe_news_acc_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[297];
	$awe_news_acc = get_theme_mod( 'awe_news_acc', $default_color );

	if ( $awe_news_acc === $default_color ) {
		return;
	}

	$css = '
	.op_nw_author i,
	.op_nw_open {
		background: %1$s;
	}
	.op_nw_share i.i_share {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_news_acc) );
}
add_action( 'wp_enqueue_scripts', 'awe_news_acc_css', 11 );

function awe_quo_bg_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[298];
	$awe_quo_bg = get_theme_mod( 'awe_quo_bg', $default_color );

	if ( $awe_quo_bg === $default_color ) {
		return;
	}

	$css = '
	.op_quote {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_quo_bg) );
}
add_action( 'wp_enqueue_scripts', 'awe_quo_bg_css', 11 );

function awe_quo_col_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[299];
	$awe_quo_col = get_theme_mod( 'awe_quo_col', $default_color );

	if ( $awe_quo_col === $default_color ) {
		return;
	}

	$css = '
	.op_quote {
        color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_quo_col) );
}
add_action( 'wp_enqueue_scripts', 'awe_quo_col_css', 11 );

function awe_info_bg_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[300];
	$awe_info_bg = get_theme_mod( 'awe_info_bg', $default_color );

	if ( $awe_info_bg === $default_color ) {
		return;
	}

	$css = '
	.top_in_right,
	.info_sch span {
        background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_info_bg) );
}
add_action( 'wp_enqueue_scripts', 'awe_info_bg_css', 11 );

function awe_info_col_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[301];
	$awe_info_col = get_theme_mod( 'awe_info_col', $default_color );

	if ( $awe_info_col === $default_color ) {
		return;
	}

	$css = '
	.top_in_right,
	.info_sch span,
	.col_mail a,
	.top_in_right .mas_post h3 a {
        color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_info_col) );
}
add_action( 'wp_enqueue_scripts', 'awe_info_col_css', 11 );

function awe_info_acc1_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[302];
	$awe_info_acc1 = get_theme_mod( 'awe_info_acc1', $default_color );

	if ( $awe_info_acc1 === $default_color ) {
		return;
	}

	$css = '
	.top_in_right:before,
	.col_mail:after {
        background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_info_acc1) );
}
add_action( 'wp_enqueue_scripts', 'awe_info_acc1_css', 11 );

function awe_info_acc2_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[303];
	$awe_info_acc2 = get_theme_mod( 'awe_info_acc2', $default_color );

	if ( $awe_info_acc2 === $default_color ) {
		return;
	}

	$css = '
	.top_in_right:after,
	.col_address:after {
        background: %1$s;
	}
	.coloring i {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_info_acc2) );
}
add_action( 'wp_enqueue_scripts', 'awe_info_acc2_css', 11 );


function awe_blog_bg_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[304];
	$awe_blog_bg = get_theme_mod( 'awe_blog_bg', $default_color );

	if ( $awe_blog_bg === $default_color ) {
		return;
	}

	$css = '
	.op_guru_top {
		background: %1$s;
	}
	.op_gr_img {
        color: %1$s;
        border: 3px solid %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_blog_bg) );
}
add_action( 'wp_enqueue_scripts', 'awe_blog_bg_css', 11 );

function awe_blog_col_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[305];
	$awe_blog_col = get_theme_mod( 'awe_blog_col', $default_color );

	if ( $awe_blog_col === $default_color ) {
		return;
	}

	$css = '
	.op_guru_top {
        color: %1$s;
	}
	.op_tea,
	.op_tea_link,
	.op_tea_head span,
	.op_tea_box h4 a {
        color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_blog_col) );
}
add_action( 'wp_enqueue_scripts', 'awe_blog_col_css', 11 );

function awe_blog_acc_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[306];
	$awe_blog_acc = get_theme_mod( 'awe_blog_acc', $default_color );

	if ( $awe_blog_acc === $default_color ) {
		return;
	}

	$css = '
	.op_gr_img {
        background: %1$s;
	}
	
	.op_tea,
	.op_tea_head:after,
	.op_tea_head span,
	.op_tea_head span:after {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_blog_acc) );
}
add_action( 'wp_enqueue_scripts', 'awe_blog_acc_css', 11 );

function awe_pres_bg_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[307];
	$awe_pres_bg = get_theme_mod( 'awe_pres_bg', $default_color );

	if ( $awe_pres_bg === $default_color ) {
		return;
	}

	$css = '
	.op_press {
		background: %1$s;
	}
	.op_pr_list:hover a i {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_pres_bg) );
}
add_action( 'wp_enqueue_scripts', 'awe_pres_bg_css', 11 );

function awe_pres_col_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[308];
	$awe_pres_col = get_theme_mod( 'awe_pres_col', $default_color );

	if ( $awe_pres_col === $default_color ) {
		return;
	}

	$css = '
	.op_press,
	.op_pr_list a,
	.op_pr_list a i {
        color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_pres_col) );
}
add_action( 'wp_enqueue_scripts', 'awe_pres_col_css', 11 );

function awe_pres_acc_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[309];
	$awe_pres_acc = get_theme_mod( 'awe_pres_acc', $default_color );

	if ( $awe_pres_acc === $default_color ) {
		return;
	}

	$css = '
	.op_press h4 a {
		color: %1$s;
	}
	.op_pr_list:hover a i {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_pres_acc) );
}
add_action( 'wp_enqueue_scripts', 'awe_pres_acc_css', 11 );

function awe_keg_bg_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[310];
	$awe_keg_bg = get_theme_mod( 'awe_keg_bg', $default_color );

	if ( $awe_keg_bg === $default_color ) {
		return;
	}

	$css = '
	.op_keg {
		background: %1$s;
	}
	.facility .op_keg_ttl span {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_keg_bg) );
}
add_action( 'wp_enqueue_scripts', 'awe_keg_bg_css', 11 );

function awe_keg_col_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[311];
	$awe_keg_col = get_theme_mod( 'awe_keg_col', $default_color );

	if ( $awe_keg_col === $default_color ) {
		return;
	}

	$css = '
	.facility .op_keg_ttl span {
        background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_keg_col) );
}
add_action( 'wp_enqueue_scripts', 'awe_keg_col_css', 11 );


function awe_fas_bg_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[312];
	$awe_fas_bg = get_theme_mod( 'awe_fas_bg', $default_color );

	if ( $awe_fas_bg === $default_color ) {
		return;
	}

	$css = '
	.op_fas {
		background: %1$s;
	}
	.op_fas_list:hover a i {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_fas_bg) );
}
add_action( 'wp_enqueue_scripts', 'awe_fas_bg_css', 11 );

function awe_fas_col_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[313];
	$awe_fas_col = get_theme_mod( 'awe_fas_col', $default_color );

	if ( $awe_fas_col === $default_color ) {
		return;
	}

	$css = '
	.op_fas,
	.op_fas_list a,
	.op_fas_list a i {
        color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_fas_col) );
}
add_action( 'wp_enqueue_scripts', 'awe_fas_col_css', 11 );

function awe_fas_acc_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[314];
	$awe_fas_acc = get_theme_mod( 'awe_fas_acc', $default_color );

	if ( $awe_fas_acc === $default_color ) {
		return;
	}

	$css = '
	.op_fas h4 a {
		color: %1$s;
	}
	.op_fas_list:hover a i {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_fas_acc) );
}
add_action( 'wp_enqueue_scripts', 'awe_fas_acc_css', 11 );


function awe_alu_bg_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[315];
	$awe_alu_bg = get_theme_mod( 'awe_alu_bg', $default_color );

	if ( $awe_alu_bg === $default_color ) {
		return;
	}

	$css = '
	.op_al_top {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_alu_bg) );
}
add_action( 'wp_enqueue_scripts', 'awe_alu_bg_css', 11 );

function awe_alu_col_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[316];
	$awe_alu_col = get_theme_mod( 'awe_alu_col', $default_color );

	if ( $awe_alu_col === $default_color ) {
		return;
	}

	$css = '
	.op_al_top,
	.op_al_top a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_alu_col) );
}
add_action( 'wp_enqueue_scripts', 'awe_alu_col_css', 11 );


function awe_gal_bg_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[317];
	$awe_gal_bg = get_theme_mod( 'awe_gal_bg', $default_color );

	if ( $awe_gal_bg === $default_color ) {
		return;
	}

	$css = '
	.op_gv_top {
		background: %1$s;
	}
	.op_gal_link {
		border: 5px solid %1$s;
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_gal_bg) );
}
add_action( 'wp_enqueue_scripts', 'awe_gal_bg_css', 11 );

function awe_gal_col_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[318];
	$awe_gal_col = get_theme_mod( 'awe_gal_col', $default_color );

	if ( $awe_gal_col === $default_color ) {
		return;
	}

	$css = '
	.op_gv_top {
        color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_gal_col) );
}
add_action( 'wp_enqueue_scripts', 'awe_gal_col_css', 11 );

function awe_gal_acc_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[319];
	$awe_gal_acc = get_theme_mod( 'awe_gal_acc', $default_color );

	if ( $awe_gal_acc === $default_color ) {
		return;
	}

	$css = '
	.op_gal_link {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_gal_acc) );
}
add_action( 'wp_enqueue_scripts', 'awe_gal_acc_css', 11 );

function awe_con_top_bg_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[320];
	$awe_con_top_bg = get_theme_mod( 'awe_con_top_bg', $default_color );

	if ( $awe_con_top_bg === $default_color ) {
		return;
	}

	$css = '
	.op_gu_box,
	.op_ar_box,
	.archive .op_news,
	.awesome .pagination a,
	.content_big .widget_block,
	.op_all_alumni,
	.single_box,
	.single_bread,
	.single_view,
	.op_related,
	.rel_title,
	.single_cat:hover .cat_link,
	.single_cat .cat_link:after,
	.op_tab_siswa,
	.awesome .submit_button, 
	.awesome .log_close a,
	.frontend__post,
	.frontend__post input[type="file"],
	.op_sr_box {
		background: %1$s;
	}
	.single_cat .cat_link:before {
		border-color: %1$s;
	}
	.gu_pic,
	.op_guru_all,
	.al_pic,
	.archive .op_nw_author i,
	.archive .op_nw_open,
	.archive .op_ar_add a.download,
	.archive .op_news a.op_mat_pel,
	.archive .op_news a.op_mat_kel,
	.awesome .comment-reply-link,
	.awesome .comment-form #submit,
	.single_cat,
	.text_link,
	.op_sg_event.op_next,
	.single_author i,
	.awesome .login_in,
	.alumni_head,
	.frontend__post input[type="submit"],
	.down_down,
	.awesome .formim a {
		color: %1$s;
	}
	.op_pic_alumni span {
		border: 4px solid %1$s;
		color: %1$s;
	}
	.single_cat .cat_link {
		border: 1px solid %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_con_top_bg) );
}
add_action( 'wp_enqueue_scripts', 'awe_con_top_bg_css', 11 );

function awe_con_top_col_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[321];
	$awe_con_top_col = get_theme_mod( 'awe_con_top_col', $default_color );

	if ( $awe_con_top_col === $default_color ) {
		return;
	}

	$css = '
	.op_gu_box,
	.gu_info,
	.op_ar_box,
	.archive .op_news,
	.awesome .pagination a,
	.content_big .widget_block,
	.op_all_alumni,
	.op_sos_alumni a,
	.single_box,
	.single_bread,
	.single_view,
	.op_related,
	.rel_title,
	.rel_right h3 a,
	.single_share i,
	.op_sg_event.op_prev span:first-child,
	.op_tab_siswa,
	.op_gu_float a,
	.frontend__post input[type="file"],
	.op_sr_box {
        color: %1$s;
	}
	.archive .op_nw_head:before,
	.archive .op_nw_share a:before,
	.op_sg_event.op_next {
        background: %1$s;
	}
	.archive .op_news .op_nw_head a,
	.archive .op_nw_share i,
	.single_tag a,
	.awesome .submit_button, 
	.awesome .log_close a,
	.frontend__post {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_con_top_col) );
}
add_action( 'wp_enqueue_scripts', 'awe_con_top_col_css', 11 );

function awe_con_top_acc_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[322];
	$awe_con_top_acc = get_theme_mod( 'awe_con_top_acc', $default_color );

	if ( $awe_con_top_acc === $default_color ) {
		return;
	}

	$css = '
	.gu_pic,
	.op_guru_all,
	.al_pic,
	.archive .op_nw_author i,
	.archive .op_nw_open,
	.archive .op_ar_add a.download,
	.single_cat,
	.single_cat .cat_link,
	.single_cat:hover .cat_link:after,
	.single_author i,
	.awesome .login_in,
	.alumni_head,
	.frontend__post input[type="submit"],
	.down_down {
		background: %1$s;
	}
	.archive .op_nw_share i.i_share,
	.awesome .pagination a:active,
	.content_big .widget_block a,
	.op_ar_add a,
	.archive .op_news a,
	.op_ar_box a,
	.breadcrumbs a,
	.single_view i,
	.rel_right span.exp,
	.single_share i.i_share,
	.op_sg_event.op_prev,
	.op_tab_siswa a {
		color: %1$s;
	}
	.op_pic_alumni span,
	.archive .op_news a.op_mat_pel {
		background: %1$s;
	}
	.single_tag a {
		border: 1px solid %1$s;
	}
	.single_cat:hover .cat_link:before  {
		border-color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_con_top_acc) );
}
add_action( 'wp_enqueue_scripts', 'awe_con_top_acc_css', 11 );

function awe_con_top_acc2_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[323];
	$awe_con_top_acc2 = get_theme_mod( 'awe_con_top_acc2', $default_color );

	if ( $awe_con_top_acc2 === $default_color ) {
		return;
	}

	$css = '
    .archive .op_news a.op_mat_kel,
	.awesome .comment-reply-link,
	.awesome .comment-form #submit {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_con_top_acc2) );
}
add_action( 'wp_enqueue_scripts', 'awe_con_top_acc2_css', 11 );

function awe_foot_bg_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[324];
	$awe_foot_bg = get_theme_mod( 'awe_foot_bg', $default_color );

	if ( $awe_foot_bg === $default_color ) {
		return;
	}

	$css = '
	.awesome .widget_box-inner {
		background: %1$s;
	} 
	.awesome .to_top {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_foot_bg) );
}
add_action( 'wp_enqueue_scripts', 'awe_foot_bg_css', 11 );

function awe_foot_col_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[325];
	$awe_foot_col = get_theme_mod( 'awe_foot_col', $default_color );

	if ( $awe_foot_col === $default_color ) {
		return;
	}

	$css = '
	.awesome .widget_box-inner {
        color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_foot_col) );
}
add_action( 'wp_enqueue_scripts', 'awe_foot_col_css', 11 );

function awe_foot_acc_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[326];
	$awe_foot_acc = get_theme_mod( 'awe_foot_acc', $default_color );

	if ( $awe_foot_acc === $default_color ) {
		return;
	}

	$css = '
	.awesome .widget_box-inner a {
		color: %1$s;
	} 
	.awesome .to_top {
		background: %1$s;
	} 
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_foot_acc) );
}
add_action( 'wp_enqueue_scripts', 'awe_foot_acc_css', 11 );

function awe_menu_acc_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[327];
	$awe_menu_acc = get_theme_mod( 'awe_menu_acc', $default_color );

	if ( $awe_menu_acc === $default_color ) {
		return;
	}

	$css = ' 
	.thisnav .accordion li a span {
		background: %1$s;
	} 
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $awe_menu_acc) );
}
add_action( 'wp_enqueue_scripts', 'awe_menu_acc_css', 11 );