<?php
function mading_wp_customize_register( $wp_customize ) {
	$color_scheme = mading_get_color_scheme();
    
	// Add color scheme setting and control.
	$wp_customize->add_setting(
		'color_scheme',
		array(
			'default'           => 'default41',
			'sanitize_callback' => 'mading_sanitize_color_scheme',
			'transport'         => 'postMessage',
		)
	);

	$wp_customize->add_control(
		'color_scheme',
		array(
			'label'    => __( 'Choose Color', 'mading' ),
			'section'  => 'colors',
			'type'     => 'select',
			'choices'  => mading_get_color_scheme_choices(),
			'priority' => 1,
		)
	);

	// Add page background color setting and control.
	$wp_customize->add_setting(
		'mading_color1',
		array(
			'default'           => $color_scheme[1],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color1',
			array(
				'label'   => '<div class="color_setting">'.__( 'Global Setting', 'mading' ) .'</div>',
				'description'   => __( 'BG Wrapper', 'mading' ),
				'section' => 'colors',
			)
		)
	);

	// Remove the core header mading_color3 control, as it shares the main text color.
	$wp_customize->remove_control( 'header_textcolor' );

	// Add link color setting and control.
	$wp_customize->add_setting(
		'mading_color2',
		array(
			'default'           => $color_scheme[2],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color2',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
			)
		)
	);

	// Add main text color setting and control.
	$wp_customize->add_setting(
		'mading_color3',
		array(
			'default'           => $color_scheme[3],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
    
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color3',
			array(
				'description'   => __( 'Link Color', 'mading' ),
				'section' => 'colors',
			)
		)
	);

	// Running Text.
	$wp_customize->add_setting(
		'mading_color4',
		array(
			'default'           => $color_scheme[4],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	
	require get_template_directory() . '/include/magazine/coloring.php';
	require get_template_directory() . '/include/awesome/coloring.php';

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color4',
			array(
			    'label'             => '<div class="color_mading">'.__( 'Contact Header', 'mading' ) .'</div>',
				'description'   => __( 'BG Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color5',
		array(
			'default'           => $color_scheme[5],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color5',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color6',
		array(
			'default'           => $color_scheme[6],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color6',
			array(
				'description'   => __( 'BG Icon', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color7',
		array(
			'default'           => $color_scheme[7],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color7',
			array(
				'description'   => __( 'Icon Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color8',
		array(
			'default'           => $color_scheme[8],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color8',
			array(
			    'label'   => '<div class="color_mading">'.__( 'Header Menu', 'mading' ) .'</div>',
				'description'   => __( 'BG Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color9',
		array(
			'default'           => $color_scheme[9],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color9',
			array(
				'description'   => __( 'Link Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color10',
		array(
			'default'           => $color_scheme[10],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color10',
			array(
				'description'   => __( 'Sub Menu BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color11',
		array(
			'default'           => $color_scheme[11],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color11',
			array(
				'description'   => __( 'Sub Menu Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	// Phone Header
	$wp_customize->add_setting(
		'mading_color12',
		array(
			'default'           => $color_scheme[12],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color12',
			array(
				'description'   => __( 'Sub Menu Hover BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color13',
		array(
			'default'           => $color_scheme[13],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color13',
			array(
				'description'   => __( 'Sub Menu Hover Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color14',
		array(
			'default'           => $color_scheme[14],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color14',
			array(
				'label'   => '<div class="color_mading">'.__( 'Search Form', 'mading' ) .'</div>',
				'description'   => __( 'BG Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	// Agenda Home
	$wp_customize->add_setting(
		'mading_color15',
		array(
			'default'           => $color_scheme[15],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color15',
			array(
				'description'   => __( 'Input BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color16',
		array(
			'default'           => $color_scheme[16],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color16',
			array(
				'description'   => __( 'Input Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color17',
		array(
			'default'           => $color_scheme[17],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color17',
			array(
				'description'   => __( 'Button BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	// Listing Home
	$wp_customize->add_setting(
		'mading_color18',
		array(
			'default'           => $color_scheme[18],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color18',
			array(
				'description'   => __( 'Button Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color19',
		array(
			'default'           => $color_scheme[19],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color19',
			array(
				'label'   => '<div class="color_mading">'.__( 'School Info', 'mading' ) .'</div>',
				'description'   => __( 'BG Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color20',
		array(
			'default'           => $color_scheme[20],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color20',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	// Produk
	$wp_customize->add_setting(
		'mading_color21',
		array(
			'default'           => $color_scheme[21],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color21',
			array(
				'description'   => __( 'Facebook BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color22',
		array(
			'default'           => $color_scheme[22],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color22',
			array(
				'description'   => __( 'Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color23',
		array(
			'default'           => $color_scheme[23],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color23',
			array(
				'description'   => __( 'Twitter BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color24',
		array(
			'default'           => $color_scheme[24],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color24',
			array(
				'description'   => __( 'Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	// Agen
	$wp_customize->add_setting(
		'mading_color25',
		array(
			'default'           => $color_scheme[25],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color25',
			array(
				'description'   => __( 'Instagram BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color26',
		array(
			'default'           => $color_scheme[26],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color26',
			array(
				'description'   => __( 'Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color27',
		array(
			'default'           => $color_scheme[27],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color27',
			array(
				'description'   => __( 'Youtube BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color28',
		array(
			'default'           => $color_scheme[28],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color28',
			array(
				'description'   => __( 'Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color29',
		array(
			'default'           => $color_scheme[29],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color29',
			array(
				'description'   => __( 'Email BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color30',
		array(
			'default'           => $color_scheme[30],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color30',
			array(
				'description'   => __( 'Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	// Label Kendaraan
	$wp_customize->add_setting(
		'mading_color31',
		array(
			'default'           => $color_scheme[31],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color31',
			array(
				'description'   => __( 'WhatsApp BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color32',
		array(
			'default'           => $color_scheme[32],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color32',
			array(
				'description'   => __( 'Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color33',
		array(
			'default'           => $color_scheme[33],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color33',
			array(
				'label'   => '<div class="color_mading">'.__( 'Running Text', 'mading' ) .'</div>',
				'description'   => __( 'BG Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color34',
		array(
			'default'           => $color_scheme[34],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color34',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color35',
		array(
			'default'           => $color_scheme[35],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color35',
			array(
				'description'   => __( 'Link Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	// Parallax
	$wp_customize->add_setting(
		'mading_color36',
		array(
			'default'           => $color_scheme[36],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color36',
			array(
				'description'   => __( 'Date BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color37',
		array(
			'default'           => $color_scheme[37],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color37',
			array(
				'description'   => __( 'Date Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color38',
		array(
			'default'           => $color_scheme[38],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color38',
			array(
				'label'   => '<div class="color_mading">'.__( 'News + Editorial', 'mading' ) .'</div>',
				'description'   => __( 'BG Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color39',
		array(
			'default'           => $color_scheme[39],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color39',
			array(
				'description'   => __( 'Span BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color40',
		array(
			'default'           => $color_scheme[40],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color40',
			array(
				'description'   => __( 'Span Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color41',
		array(
			'default'           => $color_scheme[41],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color41',
			array(
				'description'   => __( 'Overlay BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	// Additional
	$wp_customize->add_setting(
		'mading_color42',
		array(
			'default'           => $color_scheme[42],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color42',
			array(
				'description'   => __( 'Date Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color43',
		array(
			'default'           => $color_scheme[43],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color43',
			array(
				'description'   => __( 'Title Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color44',
		array(
			'default'           => $color_scheme[44],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color44',
			array(
				'description'   => __( 'Editorial BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	// Galeri
	$wp_customize->add_setting(
		'mading_color45',
		array(
			'default'           => $color_scheme[45],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color45',
			array(
				'description'   => __( 'Link Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color46',
		array(
			'default'           => $color_scheme[46],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color46',
			array(
				'description'   => __( 'Accent Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color47',
		array(
			'default'           => $color_scheme[47],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color47',
			array(
			    'label'   => '<div class="color_mading">'.__( 'Four Block', 'mading' ) .'</div>',
				'description'   => __( 'BG Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	// Galeri Box
	$wp_customize->add_setting(
		'mading_color48',
		array(
			'default'           => $color_scheme[48],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color48',
			array(
			    'label'   => '<div class="color_mading">'.__( 'Announcement', 'mading' ) .'</div>',
				'description'   => __( 'Head Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color49',
		array(
			'default'           => $color_scheme[49],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color49',
			array(
				'description'   => __( 'Head Accent', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	// Office Box
	$wp_customize->add_setting(
		'mading_color50',
		array(
			'default'           => $color_scheme[50],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color50',
			array(
				'description'   => __( 'Overlay BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color51',
		array(
			'default'           => $color_scheme[51],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color51',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color52',
		array(
			'default'           => $color_scheme[52],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color52',
			array(
				'description'   => __( 'Link Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	    // Aksen
	$wp_customize->add_setting(
		'mading_color53',
		array(
			'default'           => $color_scheme[53],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color53',
			array(
				'description'   => __( 'Box BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	// Halaman Baca
	$wp_customize->add_setting(
		'mading_color54',
		array(
			'default'           => $color_scheme[54],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color54',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color55',
		array(
			'default'           => $color_scheme[55],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color55',
			array(
				'description'   => __( 'Link Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color56',
		array(
			'default'           => $color_scheme[56],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color56',
			array(
				'description'   => __( 'Button BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	// Form Komentar
	$wp_customize->add_setting(
		'mading_color57',
		array(
			'default'           => $color_scheme[57],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color57',
			array(
				'description'   => __( 'Button Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color58',
		array(
			'default'           => $color_scheme[58],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color58',
			array(
				'label'   => '<div class="color_mading">'.__( 'Teacher Blogs', 'mading' ) .'</div>',
				'description'   => __( 'Head Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	// Submit
	$wp_customize->add_setting(
		'mading_color59',
		array(
			'default'           => $color_scheme[59],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color59',
			array(
				'description'   => __( 'Accent Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color60',
		array(
			'default'           => $color_scheme[60],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color60',
			array(
				'description'   => __( 'Overlay BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	// Sidebar
	$wp_customize->add_setting(
		'mading_color61',
		array(
			'default'           => $color_scheme[61],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color61',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color62',
		array(
			'default'           => $color_scheme[62],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color62',
			array(
				'description'   => __( 'Link Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color63',
		array(
			'default'           => $color_scheme[63],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color63',
			array(
				'description'   => __( 'Box BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color64',
		array(
			'default'           => $color_scheme[64],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color64',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	// Sidebar Tag
	$wp_customize->add_setting(
		'mading_color65',
		array(
			'default'           => $color_scheme[65],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color65',
			array(
				'description'   => __( 'Link Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color66',
		array(
			'default'           => $color_scheme[66],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color66',
			array(
				'description'   => __( 'Button BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	// Footer
	$wp_customize->add_setting(
		'mading_color67',
		array(
			'default'           => $color_scheme[67],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color67',
			array(
				'description'   => __( 'Button Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color68',
		array(
			'default'           => $color_scheme[68],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color68',
			array(
				'label'   => '<div class="color_mading">'.__( 'Facility', 'mading' ) .'</div>',
				'description'   => __( 'Head Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color69',
		array(
			'default'           => $color_scheme[69],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color69',
			array(
				'description'   => __( 'Accent Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color70',
		array(
			'default'           => $color_scheme[70],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color70',
			array(
				'description'   => __( 'Overlay BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	// Sidebar Tag
	$wp_customize->add_setting(
		'mading_color71',
		array(
			'default'           => $color_scheme[71],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color71',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color72',
		array(
			'default'           => $color_scheme[72],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color72',
			array(
				'description'   => __( 'Link Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	// Copyright
	$wp_customize->add_setting(
		'mading_color73',
		array(
			'default'           => $color_scheme[73],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color73',
			array(
				'description'   => __( 'Box BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color74',
		array(
			'default'           => $color_scheme[74],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color74',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color75',
		array(
			'default'           => $color_scheme[75],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color75',
			array(
				'description'   => __( 'Link Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
    // Mobile Menu
	$wp_customize->add_setting(
		'mading_color76',
		array(
			'default'           => $color_scheme[76],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color76',
			array(
				'description'   => __( 'Button BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color77',
		array(
			'default'           => $color_scheme[77],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color77',
			array(
				'description'   => __( 'Button Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color78',
		array(
			'default'           => $color_scheme[78],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color78',
			array(
				'label'   => '<div class="color_mading">'.__( 'Extra School', 'mading' ) .'</div>',
				'description'   => __( 'Head Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
    $wp_customize->add_setting(
		'mading_color79',
		array(
			'default'           => $color_scheme[79],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color79',
			array(
				'description'   => __( 'Accent Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color80',
		array(
			'default'           => $color_scheme[80],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color80',
			array(
				'description'   => __( 'Overlay BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
    $wp_customize->add_setting(
		'mading_color81',
		array(
			'default'           => $color_scheme[81],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color81',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color82',
		array(
			'default'           => $color_scheme[82],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color82',
			array(
				'description'   => __( 'Link Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color83',
		array(
			'default'           => $color_scheme[83],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color83',
			array(
				'description'   => __( 'Box BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color84',
		array(
			'default'           => $color_scheme[84],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color84',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color85',
		array(
			'default'           => $color_scheme[85],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color85',
			array(
				'description'   => __( 'Link Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color86',
		array(
			'default'           => $color_scheme[86],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color86',
			array(
				'description'   => __( 'Button BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color87',
		array(
			'default'           => $color_scheme[87],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color87',
			array(
				'description'   => __( 'Button Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	
	
	$wp_customize->add_setting(
		'mading_color231',
		array(
			'default'           => $color_scheme[231],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color231',
			array(
				'label'   => '<div class="color_mading">'.__( 'Achievement', 'mading' ) .'</div>',
				'description'   => __( 'BG Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color232',
		array(
			'default'           => $color_scheme[232],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color232',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color233',
		array(
			'default'           => $color_scheme[233],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color233',
			array(
				'description'   => __( 'Accent Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	
	
	
	$wp_customize->add_setting(
		'mading_color88',
		array(
			'default'           => $color_scheme[88],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color88',
			array(
				'label'   => '<div class="color_mading">'.__( 'Agenda Homepage', 'mading' ) .'</div>',
				'description'   => __( 'BG Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color89',
		array(
			'default'           => $color_scheme[89],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color89',
			array(
				'description'   => __( 'Head Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color90',
		array(
			'default'           => $color_scheme[90],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color90',
			array(
				'description'   => __( 'Date Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color91',
		array(
			'default'           => $color_scheme[91],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color91',
			array(
				'description'   => __( 'Title Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color92',
		array(
			'default'           => $color_scheme[92],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color92',
			array(
				'label'   => '<div class="color_mading">'.__( 'Gallery Homepage', 'mading' ) .'</div>',
				'description'   => __( 'BG Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color93',
		array(
			'default'           => $color_scheme[93],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color93',
			array(
				'description'   => __( 'Box BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color94',
		array(
			'default'           => $color_scheme[94],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color94',
			array(
				'description'   => __( 'Title Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color95',
		array(
			'default'           => $color_scheme[95],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color95',
			array(
				'label'   => '<div class="color_mading">'.__( 'Quotes Homepage', 'mading' ) .'</div>',
				'description'   => __( 'BG Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color96',
		array(
			'default'           => $color_scheme[96],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color96',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color97',
		array(
			'default'           => $color_scheme[97],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color97',
			array(
				'description'   => __( 'Head Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color98',
		array(
			'default'           => $color_scheme[98],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color98',
			array(
				'label'   => '<div class="color_mading">'.__( 'Teachers', 'mading' ) .'</div>',
				'description'   => __( 'BG Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color99',
		array(
			'default'           => $color_scheme[99],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color99',
			array(
				'description'   => __( 'Head Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color100',
		array(
			'default'           => $color_scheme[100],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color100',
			array(
				'description'   => __( 'Accent Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color101',
		array(
			'default'           => $color_scheme[101],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color101',
			array(
				'label'   => __( 'Home Video', 'mading' ),
				'description'   => __( 'BG Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color102',
		array(
			'default'           => $color_scheme[102],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color102',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color103',
		array(
			'default'           => $color_scheme[103],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color103',
			array(
				'description'   => __( 'Accent Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color104',
		array(
			'default'           => $color_scheme[104],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color104',
			array(
				'label'   => '<div class="color_mading">'.__( 'Article Page', 'mading' ) .'</div>',
				'description'   => __( 'Head Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color105',
		array(
			'default'           => $color_scheme[105],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color105',
			array(
				'label'   => '<div class="color_mading">'.__( 'Related Post', 'mading' ) .'</div>',
				'description'   => __( 'BG Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color106',
		array(
			'default'           => $color_scheme[106],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color106',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color107',
		array(
			'default'           => $color_scheme[107],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color107',
			array(
				'description'   => __( 'Link Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color108',
		array(
			'default'           => $color_scheme[108],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color108',
			array(
				'label'   => '<div class="color_mading">'.__( 'Pagination', 'mading' ) .'</div>',
				'description'   => __( 'BG Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color109',
		array(
			'default'           => $color_scheme[109],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color109',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color110',
		array(
			'default'           => $color_scheme[110],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color110',
			array(
				'description'   => __( 'Active BG Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color111',
		array(
			'default'           => $color_scheme[111],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color111',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_mading',
			)
		)
	);
	
	
	
	// Akademi Color
	$wp_customize->add_setting(
		'mading_color117',
		array(
			'default'           => $color_scheme[117],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color117',
			array(
				'label'   => '<div class="color_akademi">'.__( 'Akademi Menu', 'mading' ) .'</div>',
				'description'   => __( 'Menu BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color118',
		array(
			'default'           => $color_scheme[118],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color118',
			array(
				'description'   => __( 'Menu Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color119',
		array(
			'default'           => $color_scheme[119],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color119',
			array(
				'description'   => __( 'Submenu BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color120',
		array(
			'default'           => $color_scheme[120],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color120',
			array(
				'description'   => __( 'Submenu Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color121',
		array(
			'default'           => $color_scheme[121],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color121',
			array(
				'label'   => '<div class="color_akademi">'.__( 'Running Text', 'mading' ) .'</div>',
				'description'   => __( 'Background', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color122',
		array(
			'default'           => $color_scheme[122],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color122',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color123',
		array(
			'default'           => $color_scheme[123],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color123',
			array(
				'description'   => __( 'Link Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color124',
		array(
			'default'           => $color_scheme[124],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color124',
			array(
				'label'   => '<div class="color_akademi">'.__( 'School Name', 'mading' ) .'</div>',
				'description'   => __( 'Background', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color125',
		array(
			'default'           => $color_scheme[125],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color125',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color126',
		array(
			'default'           => $color_scheme[126],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color126',
			array(
				'label'   => '<div class="color_akademi">'.__( 'Editorial & Quotes', 'mading' ) .'</div>',
				'description'   => __( 'Background', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color127',
		array(
			'default'           => $color_scheme[127],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color127',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color128',
		array(
			'default'           => $color_scheme[128],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color128',
			array(
				'description'   => __( 'Accent Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color129',
		array(
			'default'           => $color_scheme[129],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color129',
			array(
				'label'   => '<div class="color_akademi">'.__( 'Latest Post', 'mading' ) .'</div>',
				'description'   => __( 'Background', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color130',
		array(
			'default'           => $color_scheme[130],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color130',
			array(
				'description'   => __( 'Title Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color131',
		array(
			'default'           => $color_scheme[131],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color131',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color132',
		array(
			'default'           => $color_scheme[132],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color132',
			array(
				'description'   => __( 'Span Background', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color133',
		array(
			'default'           => $color_scheme[133],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color133',
			array(
				'description'   => __( 'Span Text', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color134',
		array(
			'default'           => $color_scheme[134],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color134',
			array(
				'label'   => '<div class="color_akademi">'.__( 'School Agenda', 'mading' ) .'</div>',
				'description'   => __( 'Background', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color135',
		array(
			'default'           => $color_scheme[135],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color135',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color136',
		array(
			'default'           => $color_scheme[136],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color136',
			array(
				'description'   => __( 'Accent Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color137',
		array(
			'default'           => $color_scheme[137],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color137',
			array(
				'label'   => '<div class="color_akademi">'.__( 'Teachers', 'mading' ) .'</div>',
				'description'   => __( 'Background', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color138',
		array(
			'default'           => $color_scheme[138],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color138',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color139',
		array(
			'default'           => $color_scheme[139],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color139',
			array(
				'description'   => __( 'Accent Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color140',
		array(
			'default'           => $color_scheme[140],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color140',
			array(
				'label'   => '<div class="color_akademi">'.__( 'Facility', 'mading' ) .'</div>',
				'description'   => __( 'Background', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color141',
		array(
			'default'           => $color_scheme[141],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color141',
			array(
				'description'   => __( 'Heading BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color142',
		array(
			'default'           => $color_scheme[142],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color142',
			array(
				'description'   => __( 'Heading Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color143',
		array(
			'default'           => $color_scheme[143],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color143',
			array(
			    'label'   => '<div class="color_akademi">'.__( 'Announcement', 'mading' ) .'</div>',
				'description'   => __( 'Background', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color144',
		array(
			'default'           => $color_scheme[144],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color144',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color145',
		array(
			'default'           => $color_scheme[145],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color145',
			array(
				'description'   => __( 'Link Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color146',
		array(
			'default'           => $color_scheme[146],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color146',
			array(
				'description'   => __( 'Heading BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color147',
		array(
			'default'           => $color_scheme[147],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color147',
			array(
				'description'   => __( 'Heading Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color148',
		array(
			'default'           => $color_scheme[148],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color148',
			array(
				'label'   => '<div class="color_akademi">'.__( 'Teacher Blogs', 'mading' ) .'</div>',
				'description'   => __( 'Background', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color149',
		array(
			'default'           => $color_scheme[149],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color149',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color150',
		array(
			'default'           => $color_scheme[150],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color150',
			array(
				'description'   => __( 'Link Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color151',
		array(
			'default'           => $color_scheme[151],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color151',
			array(
				'description'   => __( 'Header BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color152',
		array(
			'default'           => $color_scheme[152],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color152',
			array(
				'description'   => __( 'Header Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color153',
		array(
			'default'           => $color_scheme[153],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color153',
			array(
				'label'   => '<div class="color_akademi">'.__( 'Achievement', 'mading' ) .'</div>',
				'description'   => __( 'Background', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color154',
		array(
			'default'           => $color_scheme[154],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color154',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color155',
		array(
			'default'           => $color_scheme[155],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color155',
			array(
				'description'   => __( 'Accent Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color156',
		array(
			'default'           => $color_scheme[156],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color156',
			array(
				'label'   => '<div class="color_akademi">'.__( 'Extra School', 'mading' ) .'</div>',
				'description'   => __( 'Background', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color157',
		array(
			'default'           => $color_scheme[157],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color157',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color158',
		array(
			'default'           => $color_scheme[158],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color158',
			array(
				'description'   => __( 'Accent Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color159',
		array(
			'default'           => $color_scheme[159],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color159',
			array(
				'label'   =>'<div class="color_akademi">'.__( 'Gallery Image', 'mading' ) .'</div>',
				'description'   => __( 'Background', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color160',
		array(
			'default'           => $color_scheme[160],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color160',
			array(
				'description'   => __( 'Header BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color161',
		array(
			'default'           => $color_scheme[161],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color161',
			array(
				'description'   => __( 'Header Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color162',
		array(
			'default'           => $color_scheme[162],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color162',
			array(
			    'label'   => '<div class="color_akademi">'.__( 'Gallery Video', 'mading' ) .'</div>',
				'description'   => __( 'Background', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color163',
		array(
			'default'           => $color_scheme[163],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color163',
			array(
				'description'   => __( 'Header BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color164',
		array(
			'default'           => $color_scheme[164],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color164',
			array(
				'description'   => __( 'Header Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color165',
		array(
			'default'           => $color_scheme[165],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color165',
			array(
			    'label'   => '<div class="color_akademi">'.__( 'Breadcrumb', 'mading' ) .'</div>',
				'description'   => __( 'Background', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color166',
		array(
			'default'           => $color_scheme[166],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color166',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color167',
		array(
			'default'           => $color_scheme[167],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color167',
			array(
				'description'   => __( 'Link Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color168',
		array(
			'default'           => $color_scheme[168],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color168',
			array(
			    'label'   => '<div class="color_akademi">'.__( 'Sidebar', 'mading' ) .'</div>',
				'description'   => __( 'Background', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color169',
		array(
			'default'           => $color_scheme[169],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color169',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color170',
		array(
			'default'           => $color_scheme[170],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color170',
			array(
				'description'   => __( 'Link Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_akademi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color171',
		array(
			'default'           => $color_scheme[171],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color171',
			array(
			    'label'   => '<div class="color_prestasi">'.__( 'Top Header', 'mading' ) .'</div>',
				'description'   => __( 'Background', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color172',
		array(
			'default'           => $color_scheme[172],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color172',
			array(
				'description'   => __( 'Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color173',
		array(
			'default'           => $color_scheme[173],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color173',
			array(
				'description'   => __( 'Search BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color174',
		array(
			'default'           => $color_scheme[174],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color174',
			array(
				'description'   => __( 'Search Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color175',
		array(
			'default'           => $color_scheme[175],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color175',
			array(
				'description'   => __( 'Button BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color176',
		array(
			'default'           => $color_scheme[176],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color176',
			array(
				'description'   => __( 'Button Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color177',
		array(
			'default'           => $color_scheme[177],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color177',
			array(
				'label'   => '<div class="color_prestasi">'.__( 'Header', 'mading' ) .'</div>',
				'description'   => __( 'Background', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color178',
		array(
			'default'           => $color_scheme[178],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color178',
			array(
			    'description'   => __( 'Menu Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color179',
		array(
			'default'           => $color_scheme[179],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color179',
			array(
				'description'   => __( 'Span Menu BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color180',
		array(
			'default'           => $color_scheme[180],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color180',
			array(
				'description'   => __( 'Span Menu Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color181',
		array(
			'default'           => $color_scheme[181],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color181',
			array(
				'description'   => __( 'Sub Menu BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color182',
		array(
			'default'           => $color_scheme[182],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color182',
			array(
				'description'   => __( 'Sub Menu Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color183',
		array(
			'default'           => $color_scheme[183],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color183',
			array(
				'description'   => __( 'Sub Menu Hover BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color184',
		array(
			'default'           => $color_scheme[184],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color184',
			array(
				'description'   => __( 'Sub Menu Hover Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color185',
		array(
			'default'           => $color_scheme[185],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color185',
			array(
				'label'   => '<div class="color_prestasi">'.__( 'After Slider', 'mading' ) .'</div>',
				'description'   => __( 'Block BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color186',
		array(
			'default'           => $color_scheme[186],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color186',
			array(
				'label'   => '<div class="color_prestasi">'.__( 'School Info', 'mading' ) .'</div>',
				'description'   => __( 'Background', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color187',
		array(
			'default'           => $color_scheme[187],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color187',
			array(
				'description'   => __( 'Title Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color188',
		array(
			'default'           => $color_scheme[188],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color188',
			array(
			    'description'   => __( 'Social Background', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color189',
		array(
			'default'           => $color_scheme[189],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color189',
			array(
				'description'   => __( 'Social Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color190',
		array(
			'default'           => $color_scheme[190],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color190',
			array(
			    'label'   => '<div class="color_prestasi">'.__( 'Agenda', 'mading' ) .'</div>',
				'description'   => __( 'Background', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color191',
		array(
			'default'           => $color_scheme[191],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color191',
			array(
				'description'   => __( 'Title Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color192',
		array(
			'default'           => $color_scheme[192],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color192',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color193',
		array(
			'default'           => $color_scheme[193],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color193',
			array(
				'label'   => '<div class="color_prestasi">'.__( 'Latest Post', 'mading' ) .'</div>',
				'description'   => __( 'Background', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color194',
		array(
			'default'           => $color_scheme[194],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color194',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color195',
		array(
			'default'           => $color_scheme[195],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color195',
			array(
				'description'   => __( 'Accent Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color196',
		array(
			'default'           => $color_scheme[196],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color196',
			array(
				'label'   => '<div class="color_prestasi">'.__( 'Announcement', 'mading' ) .'</div>',
				'description'   => __( 'Background', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color197',
		array(
			'default'           => $color_scheme[197],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color197',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color198',
		array(
			'default'           => $color_scheme[198],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color198',
			array(
			    'description'   => __( 'Link Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color199',
		array(
			'default'           => $color_scheme[199],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color199',
			array(
				'label'   => '<div class="color_prestasi">'.__( 'Quotes', 'mading' ) .'</div>',
				'description'   => __( 'Background', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color200',
		array(
			'default'           => $color_scheme[200],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color200',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color201',
		array(
			'default'           => $color_scheme[201],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color201',
			array(
				'label'   => '<div class="color_prestasi">'.__( 'Editorial + Teacher', 'mading' ) .'</div>',
				'description'   => __( 'Background', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color202',
		array(
			'default'           => $color_scheme[202],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color202',
			array(
				'description'   => __( 'Editorial BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color203',
		array(
			'default'           => $color_scheme[203],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color203',
			array(
				'description'   => __( 'Editorial Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color204',
		array(
			'default'           => $color_scheme[204],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color204',
			array(
				'description'   => __( 'Editorial Accent Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color205',
		array(
			'default'           => $color_scheme[205],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color205',
			array(
				'description'   => __( 'Teacher BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color206',
		array(
			'default'           => $color_scheme[206],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color206',
			array(
				'description'   => __( 'Teacher Name', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color207',
		array(
			'default'           => $color_scheme[207],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color207',
			array(
				'description'   => __( 'Position', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color208',
		array(
			'default'           => $color_scheme[208],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color208',
			array(
			    'label'   => '<div class="color_prestasi">'.__( 'Teacher Blogs', 'mading' ) .'</div>',
				'description'   => __( 'Block BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color209',
		array(
			'default'           => $color_scheme[209],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color209',
			array(
				'description'   => __( 'Head Title', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color210',
		array(
			'default'           => $color_scheme[210],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color210',
			array(
				'description'   => __( 'Blog BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color211',
		array(
			'default'           => $color_scheme[211],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color211',
			array(
				'description'   => __( 'Blog Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color212',
		array(
			'default'           => $color_scheme[212],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color212',
			array(
				'description'   => __( 'Title Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color213',
		array(
			'default'           => $color_scheme[213],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color213',
			array(
				'label'   => '<div class="color_prestasi">'.__( 'Activity', 'mading' ) .'</div>',
				'description'   => __( 'Head Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color214',
		array(
			'default'           => $color_scheme[214],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color214',
			array(
				'description'   => __( 'Box BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color215',
		array(
			'default'           => $color_scheme[215],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color215',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color216',
		array(
			'default'           => $color_scheme[216],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color216',
			array(
				'description'   => __( 'Accent Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color217',
		array(
			'default'           => $color_scheme[217],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color217',
			array(
				'label'   => '<div class="color_prestasi">'.__( 'Video', 'mading' ) .'</div>',
				'description'   => __( 'Background', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color218',
		array(
			'default'           => $color_scheme[218],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color218',
			array(
			    'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color219',
		array(
			'default'           => $color_scheme[219],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color219',
			array(
				'description'   => __( 'Accent Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color220',
		array(
			'default'           => $color_scheme[220],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color220',
			array(
				'label'   => '<div class="color_prestasi">'.__( 'Article + Archive', 'mading' ) .'</div>',
				'description'   => __( 'Background', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color221',
		array(
			'default'           => $color_scheme[221],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color221',
			array(
				'description'   => __( 'Title Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color222',
		array(
			'default'           => $color_scheme[222],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color222',
			array(
				'description'   => __( 'Archive Box BG', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color223',
		array(
			'default'           => $color_scheme[223],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color223',
			array(
				'description'   => __( 'Title Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color224',
		array(
			'default'           => $color_scheme[224],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color224',
			array(
				'description'   => __( 'Accent Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color225',
		array(
			'default'           => $color_scheme[225],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color225',
			array(
				'label'   => '<div class="color_prestasi">'.__( 'Mobile Footer', 'mading' ) .'</div>',
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	
	$wp_customize->add_setting(
		'mading_color226',
		array(
			'default'           => $color_scheme[226],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color226',
			array(
				'description'   => __( 'Home Background', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color227',
		array(
			'default'           => $color_scheme[227],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color227',
			array(
				'description'   => __( 'Phone Background', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color228',
		array(
			'default'           => $color_scheme[228],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color228',
			array(
			    'description'   => __( 'Email Background', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color229',
		array(
			'default'           => $color_scheme[229],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color229',
			array(
				'description'   => __( 'WhatsApp Background', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color230',
		array(
			'default'           => $color_scheme[230],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color230',
			array(
				'description'   => __( 'Scroll Background', 'mading' ),
				'section' => 'colors',
				'active_callback'   => 'running_prestasi',
			)
		)
	);
	
	// Tema Prestasi Color Setting
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	

	
	$wp_customize->add_setting(
		'mading_color112',
		array(
			'default'           => $color_scheme[112],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color112',
			array(
				'label'   => '<div class="color_setting">'.__( 'Widget Footer', 'mading' ) .'</div>',
				'description'   => __( 'BG Color', 'mading' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color113',
		array(
			'default'           => $color_scheme[113],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color113',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color114',
		array(
			'default'           => $color_scheme[114],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color114',
			array(
				'description'   => __( 'Link Color', 'mading' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color115',
		array(
			'default'           => $color_scheme[115],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color115',
			array(
				'label'   => '<div class="color_setting">'.__( 'Footer', 'mading' ) .'</div>',
				'description'   => __( 'BG Color', 'mading' ),
				'section' => 'colors',
			)
		)
	);
	$wp_customize->add_setting(
		'mading_color116',
		array(
			'default'           => $color_scheme[116],
			'sanitize_callback' => 'sanitize_hex_color',
			'transport'         => 'postMessage',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mading_color116',
			array(
				'description'   => __( 'Text Color', 'mading' ),
				'section' => 'colors',
			)
		)
	);
	
	
	
	

}
add_action( 'customize_register', 'mading_wp_customize_register', 11 );

if ( ! function_exists( 'mading_get_color_scheme' ) ) :
	
	function mading_get_color_scheme() {
		$color_scheme_option = get_theme_mod( 'color_scheme', 'default' );
		$color_schemes       = mading_get_color_schemes();

		if ( array_key_exists( $color_scheme_option, $color_schemes ) ) {
			return $color_schemes[ $color_scheme_option ]['colors'];
		}

		return $color_schemes['default']['colors'];
	}
endif; 

if ( ! function_exists( 'mading_get_color_scheme_choices' ) ) :
	
	function mading_get_color_scheme_choices() {
		$color_schemes                = mading_get_color_schemes();
		$color_scheme_control_options = array();

		foreach ( $color_schemes as $color_scheme => $value ) {
			$color_scheme_control_options[ $color_scheme ] = $value['label'];
		}

		return $color_scheme_control_options;
	}
endif; 

if ( ! function_exists( 'mading_sanitize_color_scheme' ) ) :
	
	function mading_sanitize_color_scheme( $value ) {
		$color_schemes = mading_get_color_scheme_choices();

		if ( ! array_key_exists( $value, $color_schemes ) ) {
			$value = 'default';
		}

		return $value;
	}
endif; 




