<?php

function web_scripts() {
	
	$body_font = esc_html(get_theme_mod('global_fonts'));
	$header_font = esc_html(get_theme_mod('header_fonts'));
	$menu_font = esc_html(get_theme_mod('menu_fonts'));
	
	if( $body_font ) {
		wp_enqueue_style( 'web-body-fonts', '//fonts.googleapis.com/css?family='. $body_font . '&display=swap' );
	} else {
		wp_enqueue_style( 'web-roboto', '//fonts.googleapis.com/css?family=Roboto');
	}
	if( $header_font ) {
		wp_enqueue_style( 'web-header-fonts', '//fonts.googleapis.com/css?family='. $header_font . '&display=swap' );
	} else {
		wp_enqueue_style( 'web-roboto', '//fonts.googleapis.com/css?family=Roboto');
	}
	if( $menu_font ) {
		wp_enqueue_style( 'web-menu-fonts', '//fonts.googleapis.com/css?family='. $menu_font . '&display=swap' );
	} else {
		wp_enqueue_style( 'web-roboto', '//fonts.googleapis.com/css?family=Roboto');
	}
}
add_action( 'wp_enqueue_scripts', 'web_scripts' );

function web_custom_styles($custom) {
	
	
	$body_font = esc_html(get_theme_mod('global_fonts'));
	$header_font = esc_html(get_theme_mod('header_fonts'));
	$menu_font = esc_html(get_theme_mod('menu_fonts'));
	
	if ( $body_font ) {
		$font_pieces = explode(":", $body_font);
		$custom .= "body, button, input, select, textarea { font-family: {$font_pieces[0]}; }"."\n";
	}
	if ( $header_font ) {
		$font_pieces = explode(":", $header_font);
		$custom .= "h1, h2, h3, h4, h5, h6, .post_inthumb h2, .guru_fullname a, .edit_box h3, .head_name, .mad__schoolname, #clock span, .news_meta h3, .title_four, .first_layer h3, .next_layer h3, .four_bottom a, .title_agenda, .age_title h3 a, .gal_layer h4, .home_quotes h4, .title_guru, .guru_nama, .widget_block h2, .mading_heading, .mading_heads, rel_overlay h4, .comment_heads, .comment-form #submit, .agenda_heading { font-family: {$font_pieces[0]}; }"."\n";
	}
	if ( $menu_font ) {
		$font_pieces = explode(":", $menu_font);
		$custom .= ".nav .dd.desktop li a, .nav .dd.desktop li ul li a, .nav .dd.accord li a { font-family: {$font_pieces[0]}; }"."\n";
	}
	
	wp_add_inline_style( 'web-css', $custom );

}

add_action( 'wp_enqueue_scripts', 'web_custom_styles' );

function head_customizer_style() {
	echo '<style type="text/css">'; 
	
	$body_font = get_theme_mod('global_fonts');
	$header_font = esc_html(get_theme_mod('header_fonts'));
	$menu_font = esc_html(get_theme_mod('menu_fonts'));
	
	if ( $body_font ) {
		$font_pieces = explode(":", $body_font);
		echo "body, button, input, select, textarea { font-family: {$font_pieces[0]}; }"."\n";
	}
	if ( $header_font ) {
		$font_pieces = explode(":", $header_font);
		echo "h1, h2, h3, h4, h5, h6, .post_inthumb h2, .guru_fullname a, .edit_box h3, .head_name, .mad__schoolname, #clock span, .news_meta h3, .title_four, .first_layer h3, .next_layer h3, .four_bottom a, .title_agenda, .age_title h3 a, .gal_layer h4, .home_quotes h4, .title_guru, .guru_nama, .widget_block h2, .mading_heading, .mading_heads, rel_overlay h4, .comment_heads, .comment-form #submit, .agenda_heading { font-family: {$font_pieces[0]}; }"."\n";
	}
	if ( $menu_font ) {
		$font_pieces = explode(":", $menu_font);
		echo ".nav .dd.desktop li a, .nav .dd.desktop li ul li a, .nav .dd.accord li a { font-family: {$font_pieces[0]}; }"."\n";
	}
	?>
	body, button, input, select, textarea {
		font-size: <?php if ( get_theme_mod('global_fontsize') != "" ) {
	    	echo esc_html( get_theme_mod( 'global_fontsize') ); 
		} else {
			echo 14;
		} ?>px;
	}
	<?php
	echo '</style>';
}
add_action( 'wp_head', 'head_customizer_style' );

//Sanitizes Fonts
function web_sanitize_fonts( $input ) {
	$valid = array(
    'ABeeZee:400,400italic' => 'ABeeZee',
    'Abel:400' => 'Abel',
    'Abhaya Libre:400,500,600,700,800' => 'Abhaya Libre',
    'Aboreto:400' => 'Aboreto',
    'Abril Fatface:400' => 'Abril Fatface',
    'Aclonica:400' => 'Aclonica',
    'Acme:400' => 'Acme',
    'Actor:400' => 'Actor',
    'Adamina:400' => 'Adamina',
    'Advent Pro:100,200,300,400,500,600,700' => 'Advent Pro',
    'Aguafina Script:400' => 'Aguafina Script',
    'Akaya Kanadaka:400' => 'Akaya Kanadaka',
    'Akaya Telivigala:400' => 'Akaya Telivigala',
    'Akronim:400' => 'Akronim',
    'Akshar:300,400,500,600,700' => 'Akshar',
    'Aladin:400' => 'Aladin',
    'Alata:400' => 'Alata',
    'Alatsi:400' => 'Alatsi',
    'Albert Sans:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Albert Sans',
    'Aldrich:400' => 'Aldrich',
    'Alef:400,700' => 'Alef',
    'Alegreya:400,500,600,700,800,900,400italic,500italic,600italic,700italic,800italic,900italic' => 'Alegreya',
    'Alegreya SC:400,400italic,500,500italic,700,700italic,800,800italic,900,900italic' => 'Alegreya SC',
    'Alegreya Sans:100,100italic,300,300italic,400,400italic,500,500italic,700,700italic,800,800italic,900,900italic' => 'Alegreya Sans',
    'Alegreya Sans SC:100,100italic,300,300italic,400,400italic,500,500italic,700,700italic,800,800italic,900,900italic' => 'Alegreya Sans SC',
    'Aleo:300,300italic,400,400italic,700,700italic' => 'Aleo',
    'Alex Brush:400' => 'Alex Brush',
    'Alfa Slab One:400' => 'Alfa Slab One',
    'Alice:400' => 'Alice',
    'Alike:400' => 'Alike',
    'Alike Angular:400' => 'Alike Angular',
    'Allan:400,700' => 'Allan',
    'Allerta:400' => 'Allerta',
    'Allerta Stencil:400' => 'Allerta Stencil',
    'Allison:400' => 'Allison',
    'Allura:400' => 'Allura',
    'Almarai:300,400,700,800' => 'Almarai',
    'Almendra:400,400italic,700,700italic' => 'Almendra',
    'Almendra Display:400' => 'Almendra Display',
    'Almendra SC:400' => 'Almendra SC',
    'Alumni Sans:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Alumni Sans',
    'Alumni Sans Collegiate One:400,400italic' => 'Alumni Sans Collegiate One',
    'Alumni Sans Inline One:400,400italic' => 'Alumni Sans Inline One',
    'Alumni Sans Pinstripe:400,400italic' => 'Alumni Sans Pinstripe',
    'Amarante:400' => 'Amarante',
    'Amaranth:400,400italic,700,700italic' => 'Amaranth',
    'Amatic SC:400,700' => 'Amatic SC',
    'Amethysta:400' => 'Amethysta',
    'Amiko:400,600,700' => 'Amiko',
    'Amiri:400,400italic,700,700italic' => 'Amiri',
    'Amita:400,700' => 'Amita',
    'Anaheim:400' => 'Anaheim',
    'Andada Pro:400,500,600,700,800,400italic,500italic,600italic,700italic,800italic' => 'Andada Pro',
    'Andika:400,400italic,700,700italic' => 'Andika',
    'Anek Bangla:100,200,300,400,500,600,700,800' => 'Anek Bangla',
    'Anek Devanagari:100,200,300,400,500,600,700,800' => 'Anek Devanagari',
    'Anek Gujarati:100,200,300,400,500,600,700,800' => 'Anek Gujarati',
    'Anek Gurmukhi:100,200,300,400,500,600,700,800' => 'Anek Gurmukhi',
    'Anek Kannada:100,200,300,400,500,600,700,800' => 'Anek Kannada',
    'Anek Latin:100,200,300,400,500,600,700,800' => 'Anek Latin',
    'Anek Malayalam:100,200,300,400,500,600,700,800' => 'Anek Malayalam',
    'Anek Odia:100,200,300,400,500,600,700,800' => 'Anek Odia',
    'Anek Tamil:100,200,300,400,500,600,700,800' => 'Anek Tamil',
    'Anek Telugu:100,200,300,400,500,600,700,800' => 'Anek Telugu',
    'Angkor:400' => 'Angkor',
    'Annie Use Your Telescope:400' => 'Annie Use Your Telescope',
    'Anonymous Pro:400,400italic,700,700italic' => 'Anonymous Pro',
    'Antic:400' => 'Antic',
    'Antic Didone:400' => 'Antic Didone',
    'Antic Slab:400' => 'Antic Slab',
    'Anton:400' => 'Anton',
    'Antonio:100,200,300,400,500,600,700' => 'Antonio',
    'Anybody:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Anybody',
    'Arapey:400,400italic' => 'Arapey',
    'Arbutus:400' => 'Arbutus',
    'Arbutus Slab:400' => 'Arbutus Slab',
    'Architects Daughter:400' => 'Architects Daughter',
    'Archivo:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Archivo',
    'Archivo Black:400' => 'Archivo Black',
    'Archivo Narrow:400,500,600,700,400italic,500italic,600italic,700italic' => 'Archivo Narrow',
    'Are You Serious:400' => 'Are You Serious',
    'Aref Ruqaa:400,700' => 'Aref Ruqaa',
    'Arima:100,200,300,400,500,600,700' => 'Arima',
    'Arima Madurai:100,200,300,400,500,700,800,900' => 'Arima Madurai',
    'Arimo:400,500,600,700,400italic,500italic,600italic,700italic' => 'Arimo',
    'Arizonia:400' => 'Arizonia',
    'Armata:400' => 'Armata',
    'Arsenal:400,400italic,700,700italic' => 'Arsenal',
    'Artifika:400' => 'Artifika',
    'Arvo:400,400italic,700,700italic' => 'Arvo',
    'Arya:400,700' => 'Arya',
    'Asap:400,500,600,700,400italic,500italic,600italic,700italic' => 'Asap',
    'Asap Condensed:400,400italic,500,500italic,600,600italic,700,700italic' => 'Asap Condensed',
    'Asar:400' => 'Asar',
    'Asset:400' => 'Asset',
    'Assistant:200,300,400,500,600,700,800' => 'Assistant',
    'Astloch:400,700' => 'Astloch',
    'Asul:400,700' => 'Asul',
    'Athiti:200,300,400,500,600,700' => 'Athiti',
    'Atkinson Hyperlegible:400,400italic,700,700italic' => 'Atkinson Hyperlegible',
    'Atma:300,400,500,600,700' => 'Atma',
    'Atomic Age:400' => 'Atomic Age',
    'Aubrey:400' => 'Aubrey',
    'Audiowide:400' => 'Audiowide',
    'Autour One:400' => 'Autour One',
    'Average:400' => 'Average',
    'Average Sans:400' => 'Average Sans',
    'Averia Gruesa Libre:400' => 'Averia Gruesa Libre',
    'Averia Libre:300,300italic,400,400italic,700,700italic' => 'Averia Libre',
    'Averia Sans Libre:300,300italic,400,400italic,700,700italic' => 'Averia Sans Libre',
    'Averia Serif Libre:300,300italic,400,400italic,700,700italic' => 'Averia Serif Libre',
    'Azeret Mono:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Azeret Mono',
    'B612:400,400italic,700,700italic' => 'B612',
    'B612 Mono:400,400italic,700,700italic' => 'B612 Mono',
    'BIZ UDGothic:400,700' => 'BIZ UDGothic',
    'BIZ UDMincho:400' => 'BIZ UDMincho',
    'BIZ UDPGothic:400,700' => 'BIZ UDPGothic',
    'BIZ UDPMincho:400' => 'BIZ UDPMincho',
    'Babylonica:400' => 'Babylonica',
    'Bad Script:400' => 'Bad Script',
    'Bahiana:400' => 'Bahiana',
    'Bahianita:400' => 'Bahianita',
    'Bai Jamjuree:200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic' => 'Bai Jamjuree',
    'Bakbak One:400' => 'Bakbak One',
    'Ballet:400' => 'Ballet',
    'Baloo 2:400,500,600,700,800' => 'Baloo 2',
    'Baloo Bhai 2:400,500,600,700,800' => 'Baloo Bhai 2',
    'Baloo Bhaijaan 2:400,500,600,700,800' => 'Baloo Bhaijaan 2',
    'Baloo Bhaina 2:400,500,600,700,800' => 'Baloo Bhaina 2',
    'Baloo Chettan 2:400,500,600,700,800' => 'Baloo Chettan 2',
    'Baloo Da 2:400,500,600,700,800' => 'Baloo Da 2',
    'Baloo Paaji 2:400,500,600,700,800' => 'Baloo Paaji 2',
    'Baloo Tamma 2:400,500,600,700,800' => 'Baloo Tamma 2',
    'Baloo Tammudu 2:400,500,600,700,800' => 'Baloo Tammudu 2',
    'Baloo Thambi 2:400,500,600,700,800' => 'Baloo Thambi 2',
    'Balsamiq Sans:400,400italic,700,700italic' => 'Balsamiq Sans',
    'Balthazar:400' => 'Balthazar',
    'Bangers:400' => 'Bangers',
    'Barlow:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic' => 'Barlow',
    'Barlow Condensed:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic' => 'Barlow Condensed',
    'Barlow Semi Condensed:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic' => 'Barlow Semi Condensed',
    'Barriecito:400' => 'Barriecito',
    'Barrio:400' => 'Barrio',
    'Basic:400' => 'Basic',
    'Baskervville:400,400italic' => 'Baskervville',
    'Battambang:100,300,400,700,900' => 'Battambang',
    'Baumans:400' => 'Baumans',
    'Bayon:400' => 'Bayon',
    'Be Vietnam Pro:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic' => 'Be Vietnam Pro',
    'Beau Rivage:400' => 'Beau Rivage',
    'Bebas Neue:400' => 'Bebas Neue',
    'Belgrano:400' => 'Belgrano',
    'Bellefair:400' => 'Bellefair',
    'Belleza:400' => 'Belleza',
    'Bellota:300,300italic,400,400italic,700,700italic' => 'Bellota',
    'Bellota Text:300,300italic,400,400italic,700,700italic' => 'Bellota Text',
    'BenchNine:300,400,700' => 'BenchNine',
    'Benne:400' => 'Benne',
    'Bentham:400' => 'Bentham',
    'Berkshire Swash:400' => 'Berkshire Swash',
    'Besley:400,500,600,700,800,900,400italic,500italic,600italic,700italic,800italic,900italic' => 'Besley',
    'Beth Ellen:400' => 'Beth Ellen',
    'Bevan:400,400italic' => 'Bevan',
    'BhuTuka Expanded One:400' => 'BhuTuka Expanded One',
    'Big Shoulders Display:100,200,300,400,500,600,700,800,900' => 'Big Shoulders Display',
    'Big Shoulders Inline Display:100,200,300,400,500,600,700,800,900' => 'Big Shoulders Inline Display',
    'Big Shoulders Inline Text:100,200,300,400,500,600,700,800,900' => 'Big Shoulders Inline Text',
    'Big Shoulders Stencil Display:100,200,300,400,500,600,700,800,900' => 'Big Shoulders Stencil Display',
    'Big Shoulders Stencil Text:100,200,300,400,500,600,700,800,900' => 'Big Shoulders Stencil Text',
    'Big Shoulders Text:100,200,300,400,500,600,700,800,900' => 'Big Shoulders Text',
    'Bigelow Rules:400' => 'Bigelow Rules',
    'Bigshot One:400' => 'Bigshot One',
    'Bilbo:400' => 'Bilbo',
    'Bilbo Swash Caps:400' => 'Bilbo Swash Caps',
    'BioRhyme:200,300,400,700,800' => 'BioRhyme',
    'BioRhyme Expanded:200,300,400,700,800' => 'BioRhyme Expanded',
    'Birthstone:400' => 'Birthstone',
    'Birthstone Bounce:400,500' => 'Birthstone Bounce',
    'Biryani:200,300,400,600,700,800,900' => 'Biryani',
    'Bitter:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Bitter',
    'Black And White Picture:400' => 'Black And White Picture',
    'Black Han Sans:400' => 'Black Han Sans',
    'Black Ops One:400' => 'Black Ops One',
    'Blaka:400' => 'Blaka',
    'Blaka Hollow:400' => 'Blaka Hollow',
    'Blinker:100,200,300,400,600,700,800,900' => 'Blinker',
    'Bodoni Moda:400,500,600,700,800,900,400italic,500italic,600italic,700italic,800italic,900italic' => 'Bodoni Moda',
    'Bokor:400' => 'Bokor',
    'Bona Nova:400,400italic,700' => 'Bona Nova',
    'Bonbon:400' => 'Bonbon',
    'Bonheur Royale:400' => 'Bonheur Royale',
    'Boogaloo:400' => 'Boogaloo',
    'Bowlby One:400' => 'Bowlby One',
    'Bowlby One SC:400' => 'Bowlby One SC',
    'Brawler:400,700' => 'Brawler',
    'Bree Serif:400' => 'Bree Serif',
    'Brygada 1918:400,500,600,700,400italic,500italic,600italic,700italic' => 'Brygada 1918',
    'Bubblegum Sans:400' => 'Bubblegum Sans',
    'Bubbler One:400' => 'Bubbler One',
    'Buda:300' => 'Buda',
    'Buenard:400,700' => 'Buenard',
    'Bungee:400' => 'Bungee',
    'Bungee Hairline:400' => 'Bungee Hairline',
    'Bungee Inline:400' => 'Bungee Inline',
    'Bungee Outline:400' => 'Bungee Outline',
    'Bungee Shade:400' => 'Bungee Shade',
    'Butcherman:400' => 'Butcherman',
    'Butterfly Kids:400' => 'Butterfly Kids',
    'Cabin:400,500,600,700,400italic,500italic,600italic,700italic' => 'Cabin',
    'Cabin Condensed:400,500,600,700' => 'Cabin Condensed',
    'Cabin Sketch:400,700' => 'Cabin Sketch',
    'Caesar Dressing:400' => 'Caesar Dressing',
    'Cagliostro:400' => 'Cagliostro',
    'Cairo:200,300,400,500,600,700,800,900' => 'Cairo',
    'Caladea:400,400italic,700,700italic' => 'Caladea',
    'Calistoga:400' => 'Calistoga',
    'Calligraffitti:400' => 'Calligraffitti',
    'Cambay:400,400italic,700,700italic' => 'Cambay',
    'Cambo:400' => 'Cambo',
    'Candal:400' => 'Candal',
    'Cantarell:400,400italic,700,700italic' => 'Cantarell',
    'Cantata One:400' => 'Cantata One',
    'Cantora One:400' => 'Cantora One',
    'Capriola:400' => 'Capriola',
    'Caramel:400' => 'Caramel',
    'Carattere:400' => 'Carattere',
    'Cardo:400,400italic,700' => 'Cardo',
    'Carme:400' => 'Carme',
    'Carrois Gothic:400' => 'Carrois Gothic',
    'Carrois Gothic SC:400' => 'Carrois Gothic SC',
    'Carter One:400' => 'Carter One',
    'Castoro:400,400italic' => 'Castoro',
    'Catamaran:100,200,300,400,500,600,700,800,900' => 'Catamaran',
    'Caudex:400,400italic,700,700italic' => 'Caudex',
    'Caveat:400,500,600,700' => 'Caveat',
    'Caveat Brush:400' => 'Caveat Brush',
    'Cedarville Cursive:400' => 'Cedarville Cursive',
    'Ceviche One:400' => 'Ceviche One',
    'Chakra Petch:300,300italic,400,400italic,500,500italic,600,600italic,700,700italic' => 'Chakra Petch',
    'Changa:200,300,400,500,600,700,800' => 'Changa',
    'Changa One:400,400italic' => 'Changa One',
    'Chango:400' => 'Chango',
    'Charis SIL:400,400italic,700,700italic' => 'Charis SIL',
    'Charm:400,700' => 'Charm',
    'Charmonman:400,700' => 'Charmonman',
    'Chathura:100,300,400,700,800' => 'Chathura',
    'Chau Philomene One:400,400italic' => 'Chau Philomene One',
    'Chela One:400' => 'Chela One',
    'Chelsea Market:400' => 'Chelsea Market',
    'Chenla:400' => 'Chenla',
    'Cherish:400' => 'Cherish',
    'Cherry Cream Soda:400' => 'Cherry Cream Soda',
    'Cherry Swash:400,700' => 'Cherry Swash',
    'Chewy:400' => 'Chewy',
    'Chicle:400' => 'Chicle',
    'Chilanka:400' => 'Chilanka',
    'Chivo:300,300italic,400,400italic,700,700italic,900,900italic' => 'Chivo',
    'Chonburi:400' => 'Chonburi',
    'Cinzel:400,500,600,700,800,900' => 'Cinzel',
    'Cinzel Decorative:400,700,900' => 'Cinzel Decorative',
    'Clicker Script:400' => 'Clicker Script',
    'Coda:400,800' => 'Coda',
    'Coda Caption:800' => 'Coda Caption',
    'Codystar:300,400' => 'Codystar',
    'Coiny:400' => 'Coiny',
    'Combo:400' => 'Combo',
    'Comfortaa:300,400,500,600,700' => 'Comfortaa',
    'Comforter:400' => 'Comforter',
    'Comforter Brush:400' => 'Comforter Brush',
    'Comic Neue:300,300italic,400,400italic,700,700italic' => 'Comic Neue',
    'Coming Soon:400' => 'Coming Soon',
    'Commissioner:100,200,300,400,500,600,700,800,900' => 'Commissioner',
    'Concert One:400' => 'Concert One',
    'Condiment:400' => 'Condiment',
    'Content:400,700' => 'Content',
    'Contrail One:400' => 'Contrail One',
    'Convergence:400' => 'Convergence',
    'Cookie:400' => 'Cookie',
    'Copse:400' => 'Copse',
    'Corben:400,700' => 'Corben',
    'Corinthia:400,700' => 'Corinthia',
    'Cormorant:300,400,500,600,700,300italic,400italic,500italic,600italic,700italic' => 'Cormorant',
    'Cormorant Garamond:300,300italic,400,400italic,500,500italic,600,600italic,700,700italic' => 'Cormorant Garamond',
    'Cormorant Infant:300,300italic,400,400italic,500,500italic,600,600italic,700,700italic' => 'Cormorant Infant',
    'Cormorant SC:300,400,500,600,700' => 'Cormorant SC',
    'Cormorant Unicase:300,400,500,600,700' => 'Cormorant Unicase',
    'Cormorant Upright:300,400,500,600,700' => 'Cormorant Upright',
    'Courgette:400' => 'Courgette',
    'Courier Prime:400,400italic,700,700italic' => 'Courier Prime',
    'Cousine:400,400italic,700,700italic' => 'Cousine',
    'Coustard:400,900' => 'Coustard',
    'Covered By Your Grace:400' => 'Covered By Your Grace',
    'Crafty Girls:400' => 'Crafty Girls',
    'Creepster:400' => 'Creepster',
    'Crete Round:400,400italic' => 'Crete Round',
    'Crimson Pro:200,300,400,500,600,700,800,900,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Crimson Pro',
    'Crimson Text:400,400italic,600,600italic,700,700italic' => 'Crimson Text',
    'Croissant One:400' => 'Croissant One',
    'Crushed:400' => 'Crushed',
    'Cuprum:400,500,600,700,400italic,500italic,600italic,700italic' => 'Cuprum',
    'Cute Font:400' => 'Cute Font',
    'Cutive:400' => 'Cutive',
    'Cutive Mono:400' => 'Cutive Mono',
    'DM Mono:300,300italic,400,400italic,500,500italic' => 'DM Mono',
    'DM Sans:400,400italic,500,500italic,700,700italic' => 'DM Sans',
    'DM Serif Display:400,400italic' => 'DM Serif Display',
    'DM Serif Text:400,400italic' => 'DM Serif Text',
    'Damion:400' => 'Damion',
    'Dancing Script:400,500,600,700' => 'Dancing Script',
    'Dangrek:400' => 'Dangrek',
    'Darker Grotesque:300,400,500,600,700,800,900' => 'Darker Grotesque',
    'David Libre:400,500,700' => 'David Libre',
    'Dawning of a New Day:400' => 'Dawning of a New Day',
    'Days One:400' => 'Days One',
    'Dekko:400' => 'Dekko',
    'Dela Gothic One:400' => 'Dela Gothic One',
    'Delius:400' => 'Delius',
    'Delius Swash Caps:400' => 'Delius Swash Caps',
    'Delius Unicase:400,700' => 'Delius Unicase',
    'Della Respira:400' => 'Della Respira',
    'Denk One:400' => 'Denk One',
    'Devonshire:400' => 'Devonshire',
    'Dhurjati:400' => 'Dhurjati',
    'Didact Gothic:400' => 'Didact Gothic',
    'Diplomata:400' => 'Diplomata',
    'Diplomata SC:400' => 'Diplomata SC',
    'Do Hyeon:400' => 'Do Hyeon',
    'Dokdo:400' => 'Dokdo',
    'Domine:400,500,600,700' => 'Domine',
    'Donegal One:400' => 'Donegal One',
    'Dongle:300,400,700' => 'Dongle',
    'Doppio One:400' => 'Doppio One',
    'Dorsa:400' => 'Dorsa',
    'Dosis:200,300,400,500,600,700,800' => 'Dosis',
    'DotGothic16:400' => 'DotGothic16',
    'Dr Sugiyama:400' => 'Dr Sugiyama',
    'Duru Sans:400' => 'Duru Sans',
    'DynaPuff:400,500,600,700' => 'DynaPuff',
    'Dynalight:400' => 'Dynalight',
    'EB Garamond:400,500,600,700,800,400italic,500italic,600italic,700italic,800italic' => 'EB Garamond',
    'Eagle Lake:400' => 'Eagle Lake',
    'East Sea Dokdo:400' => 'East Sea Dokdo',
    'Eater:400' => 'Eater',
    'Economica:400,400italic,700,700italic' => 'Economica',
    'Eczar:400,500,600,700,800' => 'Eczar',
    'Edu NSW ACT Foundation:400,500,600,700' => 'Edu NSW ACT Foundation',
    'Edu QLD Beginner:400,500,600,700' => 'Edu QLD Beginner',
    'Edu SA Beginner:400,500,600,700' => 'Edu SA Beginner',
    'Edu TAS Beginner:400,500,600,700' => 'Edu TAS Beginner',
    'Edu VIC WA NT Beginner:400,500,600,700' => 'Edu VIC WA NT Beginner',
    'El Messiri:400,500,600,700' => 'El Messiri',
    'Electrolize:400' => 'Electrolize',
    'Elsie:400,900' => 'Elsie',
    'Elsie Swash Caps:400,900' => 'Elsie Swash Caps',
    'Emblema One:400' => 'Emblema One',
    'Emilys Candy:400' => 'Emilys Candy',
    'Encode Sans:100,200,300,400,500,600,700,800,900' => 'Encode Sans',
    'Encode Sans Condensed:100,200,300,400,500,600,700,800,900' => 'Encode Sans Condensed',
    'Encode Sans Expanded:100,200,300,400,500,600,700,800,900' => 'Encode Sans Expanded',
    'Encode Sans SC:100,200,300,400,500,600,700,800,900' => 'Encode Sans SC',
    'Encode Sans Semi Condensed:100,200,300,400,500,600,700,800,900' => 'Encode Sans Semi Condensed',
    'Encode Sans Semi Expanded:100,200,300,400,500,600,700,800,900' => 'Encode Sans Semi Expanded',
    'Engagement:400' => 'Engagement',
    'Englebert:400' => 'Englebert',
    'Enriqueta:400,500,600,700' => 'Enriqueta',
    'Ephesis:400' => 'Ephesis',
    'Epilogue:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Epilogue',
    'Erica One:400' => 'Erica One',
    'Esteban:400' => 'Esteban',
    'Estonia:400' => 'Estonia',
    'Euphoria Script:400' => 'Euphoria Script',
    'Ewert:400' => 'Ewert',
    'Exo:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Exo',
    'Exo 2:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Exo 2',
    'Expletus Sans:400,500,600,700,400italic,500italic,600italic,700italic' => 'Expletus Sans',
    'Explora:400' => 'Explora',
    'Fahkwang:200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic' => 'Fahkwang',
    'Familjen Grotesk:400,500,600,700,400italic,500italic,600italic,700italic' => 'Familjen Grotesk',
    'Fanwood Text:400,400italic' => 'Fanwood Text',
    'Farro:300,400,500,700' => 'Farro',
    'Farsan:400' => 'Farsan',
    'Fascinate:400' => 'Fascinate',
    'Fascinate Inline:400' => 'Fascinate Inline',
    'Faster One:400' => 'Faster One',
    'Fasthand:400' => 'Fasthand',
    'Fauna One:400' => 'Fauna One',
    'Faustina:300,400,500,600,700,800,300italic,400italic,500italic,600italic,700italic,800italic' => 'Faustina',
    'Federant:400' => 'Federant',
    'Federo:400' => 'Federo',
    'Felipa:400' => 'Felipa',
    'Fenix:400' => 'Fenix',
    'Festive:400' => 'Festive',
    'Figtree:300,400,500,600,700,800,900' => 'Figtree',
    'Finger Paint:400' => 'Finger Paint',
    'Finlandica:400,500,600,700,400italic,500italic,600italic,700italic' => 'Finlandica',
    'Fira Code:300,400,500,600,700' => 'Fira Code',
    'Fira Mono:400,500,700' => 'Fira Mono',
    'Fira Sans:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic' => 'Fira Sans',
    'Fira Sans Condensed:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic' => 'Fira Sans Condensed',
    'Fira Sans Extra Condensed:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic' => 'Fira Sans Extra Condensed',
    'Fjalla One:400' => 'Fjalla One',
    'Fjord One:400' => 'Fjord One',
    'Flamenco:300,400' => 'Flamenco',
    'Flavors:400' => 'Flavors',
    'Fleur De Leah:400' => 'Fleur De Leah',
    'Flow Block:400' => 'Flow Block',
    'Flow Circular:400' => 'Flow Circular',
    'Flow Rounded:400' => 'Flow Rounded',
    'Fondamento:400,400italic' => 'Fondamento',
    'Fontdiner Swanky:400' => 'Fontdiner Swanky',
    'Forum:400' => 'Forum',
    'Francois One:400' => 'Francois One',
    'Frank Ruhl Libre:300,400,500,700,900' => 'Frank Ruhl Libre',
    'Fraunces:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Fraunces',
    'Freckle Face:400' => 'Freckle Face',
    'Fredericka the Great:400' => 'Fredericka the Great',
    'Fredoka:300,400,500,600,700' => 'Fredoka',
    'Fredoka One:400' => 'Fredoka One',
    'Freehand:400' => 'Freehand',
    'Fresca:400' => 'Fresca',
    'Frijole:400' => 'Frijole',
    'Fruktur:400' => 'Fruktur',
    'Fugaz One:400' => 'Fugaz One',
    'Fuggles:400' => 'Fuggles',
    'Fuzzy Bubbles:400,700' => 'Fuzzy Bubbles',
    'GFS Didot:400' => 'GFS Didot',
    'GFS Neohellenic:400,400italic,700,700italic' => 'GFS Neohellenic',
    'Gabriela:400' => 'Gabriela',
    'Gaegu:300,400,700' => 'Gaegu',
    'Gafata:400' => 'Gafata',
    'Galada:400' => 'Galada',
    'Galdeano:400' => 'Galdeano',
    'Galindo:400' => 'Galindo',
    'Gamja Flower:400' => 'Gamja Flower',
    'Gantari:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Gantari',
    'Gayathri:100,400,700' => 'Gayathri',
    'Gelasio:400,400italic,500,500italic,600,600italic,700,700italic' => 'Gelasio',
    'Gemunu Libre:200,300,400,500,600,700,800' => 'Gemunu Libre',
    'Genos:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Genos',
    'Gentium Book Basic:400,400italic,700,700italic' => 'Gentium Book Basic',
    'Gentium Book Plus:400,400italic,700,700italic' => 'Gentium Book Plus',
    'Gentium Plus:400,400italic,700,700italic' => 'Gentium Plus',
    'Geo:400,400italic' => 'Geo',
    'Georama:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Georama',
    'Geostar:400' => 'Geostar',
    'Geostar Fill:400' => 'Geostar Fill',
    'Germania One:400' => 'Germania One',
    'Gideon Roman:400' => 'Gideon Roman',
    'Gidugu:400' => 'Gidugu',
    'Gilda Display:400' => 'Gilda Display',
    'Girassol:400' => 'Girassol',
    'Give You Glory:400' => 'Give You Glory',
    'Glass Antiqua:400' => 'Glass Antiqua',
    'Glegoo:400,700' => 'Glegoo',
    'Gloria Hallelujah:400' => 'Gloria Hallelujah',
    'Glory:100,200,300,400,500,600,700,800,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic' => 'Glory',
    'Gluten:100,200,300,400,500,600,700,800,900' => 'Gluten',
    'Goblin One:400' => 'Goblin One',
    'Gochi Hand:400' => 'Gochi Hand',
    'Goldman:400,700' => 'Goldman',
    'Gorditas:400,700' => 'Gorditas',
    'Gothic A1:100,200,300,400,500,600,700,800,900' => 'Gothic A1',
    'Gotu:400' => 'Gotu',
    'Goudy Bookletter 1911:400' => 'Goudy Bookletter 1911',
    'Gowun Batang:400,700' => 'Gowun Batang',
    'Gowun Dodum:400' => 'Gowun Dodum',
    'Graduate:400' => 'Graduate',
    'Grand Hotel:400' => 'Grand Hotel',
    'Grandstander:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Grandstander',
    'Grape Nuts:400' => 'Grape Nuts',
    'Gravitas One:400' => 'Gravitas One',
    'Great Vibes:400' => 'Great Vibes',
    'Grechen Fuemen:400' => 'Grechen Fuemen',
    'Grenze:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic' => 'Grenze',
    'Grenze Gotisch:100,200,300,400,500,600,700,800,900' => 'Grenze Gotisch',
    'Grey Qo:400' => 'Grey Qo',
    'Griffy:400' => 'Griffy',
    'Gruppo:400' => 'Gruppo',
    'Gudea:400,400italic,700' => 'Gudea',
    'Gugi:400' => 'Gugi',
    'Gulzar:400' => 'Gulzar',
    'Gupter:400,500,700' => 'Gupter',
    'Gurajada:400' => 'Gurajada',
    'Gwendolyn:400,700' => 'Gwendolyn',
    'Habibi:400' => 'Habibi',
    'Hachi Maru Pop:400' => 'Hachi Maru Pop',
    'Hahmlet:100,200,300,400,500,600,700,800,900' => 'Hahmlet',
    'Halant:300,400,500,600,700' => 'Halant',
    'Hammersmith One:400' => 'Hammersmith One',
    'Hanalei:400' => 'Hanalei',
    'Hanalei Fill:400' => 'Hanalei Fill',
    'Handlee:400' => 'Handlee',
    'Hanuman:100,300,400,700,900' => 'Hanuman',
    'Happy Monkey:400' => 'Happy Monkey',
    'Harmattan:400,700' => 'Harmattan',
    'Headland One:400' => 'Headland One',
    'Heebo:100,200,300,400,500,600,700,800,900' => 'Heebo',
    'Henny Penny:400' => 'Henny Penny',
    'Hepta Slab:100,200,300,400,500,600,700,800,900' => 'Hepta Slab',
    'Herr Von Muellerhoff:400' => 'Herr Von Muellerhoff',
    'Hi Melody:400' => 'Hi Melody',
    'Hina Mincho:400' => 'Hina Mincho',
    'Hind:300,400,500,600,700' => 'Hind',
    'Hind Guntur:300,400,500,600,700' => 'Hind Guntur',
    'Hind Madurai:300,400,500,600,700' => 'Hind Madurai',
    'Hind Siliguri:300,400,500,600,700' => 'Hind Siliguri',
    'Hind Vadodara:300,400,500,600,700' => 'Hind Vadodara',
    'Holtwood One SC:400' => 'Holtwood One SC',
    'Homemade Apple:400' => 'Homemade Apple',
    'Homenaje:400' => 'Homenaje',
    'Hubballi:400' => 'Hubballi',
    'Hurricane:400' => 'Hurricane',
    'IBM Plex Mono:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic' => 'IBM Plex Mono',
    'IBM Plex Sans:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic' => 'IBM Plex Sans',
    'IBM Plex Sans Arabic:100,200,300,400,500,600,700' => 'IBM Plex Sans Arabic',
    'IBM Plex Sans Condensed:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic' => 'IBM Plex Sans Condensed',
    'IBM Plex Sans Devanagari:100,200,300,400,500,600,700' => 'IBM Plex Sans Devanagari',
    'IBM Plex Sans Hebrew:100,200,300,400,500,600,700' => 'IBM Plex Sans Hebrew',
    'IBM Plex Sans KR:100,200,300,400,500,600,700' => 'IBM Plex Sans KR',
    'IBM Plex Sans Thai:100,200,300,400,500,600,700' => 'IBM Plex Sans Thai',
    'IBM Plex Sans Thai Looped:100,200,300,400,500,600,700' => 'IBM Plex Sans Thai Looped',
    'IBM Plex Serif:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic' => 'IBM Plex Serif',
    'IM Fell DW Pica:400,400italic' => 'IM Fell DW Pica',
    'IM Fell DW Pica SC:400' => 'IM Fell DW Pica SC',
    'IM Fell Double Pica:400,400italic' => 'IM Fell Double Pica',
    'IM Fell Double Pica SC:400' => 'IM Fell Double Pica SC',
    'IM Fell English:400,400italic' => 'IM Fell English',
    'IM Fell English SC:400' => 'IM Fell English SC',
    'IM Fell French Canon:400,400italic' => 'IM Fell French Canon',
    'IM Fell French Canon SC:400' => 'IM Fell French Canon SC',
    'IM Fell Great Primer:400,400italic' => 'IM Fell Great Primer',
    'IM Fell Great Primer SC:400' => 'IM Fell Great Primer SC',
    'Ibarra Real Nova:400,500,600,700,400italic,500italic,600italic,700italic' => 'Ibarra Real Nova',
    'Iceberg:400' => 'Iceberg',
    'Iceland:400' => 'Iceland',
    'Imbue:100,200,300,400,500,600,700,800,900' => 'Imbue',
    'Imperial Script:400' => 'Imperial Script',
    'Imprima:400' => 'Imprima',
    'Inconsolata:200,300,400,500,600,700,800,900' => 'Inconsolata',
    'Inder:400' => 'Inder',
    'Indie Flower:400' => 'Indie Flower',
    'Ingrid Darling:400' => 'Ingrid Darling',
    'Inika:400,700' => 'Inika',
    'Inknut Antiqua:300,400,500,600,700,800,900' => 'Inknut Antiqua',
    'Inria Sans:300,300italic,400,400italic,700,700italic' => 'Inria Sans',
    'Inria Serif:300,300italic,400,400italic,700,700italic' => 'Inria Serif',
    'Inspiration:400' => 'Inspiration',
    'Inter:100,200,300,400,500,600,700,800,900' => 'Inter',
    'Irish Grover:400' => 'Irish Grover',
    'Island Moments:400' => 'Island Moments',
    'Istok Web:400,400italic,700,700italic' => 'Istok Web',
    'Italiana:400' => 'Italiana',
    'Italianno:400' => 'Italianno',
    'Itim:400' => 'Itim',
    'Jacques Francois:400' => 'Jacques Francois',
    'Jacques Francois Shadow:400' => 'Jacques Francois Shadow',
    'Jaldi:400,700' => 'Jaldi',
    'JetBrains Mono:100,200,300,400,500,600,700,800,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic' => 'JetBrains Mono',
    'Jim Nightshade:400' => 'Jim Nightshade',
    'Joan:400' => 'Joan',
    'Jockey One:400' => 'Jockey One',
    'Jolly Lodger:400' => 'Jolly Lodger',
    'Jomhuria:400' => 'Jomhuria',
    'Jomolhari:400' => 'Jomolhari',
    'Josefin Sans:100,200,300,400,500,600,700,100italic,200italic,300italic,400italic,500italic,600italic,700italic' => 'Josefin Sans',
    'Josefin Slab:100,200,300,400,500,600,700,100italic,200italic,300italic,400italic,500italic,600italic,700italic' => 'Josefin Slab',
    'Jost:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Jost',
    'Joti One:400' => 'Joti One',
    'Jua:400' => 'Jua',
    'Judson:400,400italic,700' => 'Judson',
    'Julee:400' => 'Julee',
    'Julius Sans One:400' => 'Julius Sans One',
    'Junge:400' => 'Junge',
    'Jura:300,400,500,600,700' => 'Jura',
    'Just Another Hand:400' => 'Just Another Hand',
    'Just Me Again Down Here:400' => 'Just Me Again Down Here',
    'K2D:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic' => 'K2D',
    'Kadwa:400,700' => 'Kadwa',
    'Kaisei Decol:400,500,700' => 'Kaisei Decol',
    'Kaisei HarunoUmi:400,500,700' => 'Kaisei HarunoUmi',
    'Kaisei Opti:400,500,700' => 'Kaisei Opti',
    'Kaisei Tokumin:400,500,700,800' => 'Kaisei Tokumin',
    'Kalam:300,400,700' => 'Kalam',
    'Kameron:400,700' => 'Kameron',
    'Kanit:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic' => 'Kanit',
    'Kantumruy:300,400,700' => 'Kantumruy',
    'Kantumruy Pro:100,200,300,400,500,600,700,100italic,200italic,300italic,400italic,500italic,600italic,700italic' => 'Kantumruy Pro',
    'Karantina:300,400,700' => 'Karantina',
    'Karla:200,300,400,500,600,700,800,200italic,300italic,400italic,500italic,600italic,700italic,800italic' => 'Karla',
    'Karma:300,400,500,600,700' => 'Karma',
    'Katibeh:400' => 'Katibeh',
    'Kaushan Script:400' => 'Kaushan Script',
    'Kavivanar:400' => 'Kavivanar',
    'Kavoon:400' => 'Kavoon',
    'Kdam Thmor Pro:400' => 'Kdam Thmor Pro',
    'Keania One:400' => 'Keania One',
    'Kelly Slab:400' => 'Kelly Slab',
    'Kenia:400' => 'Kenia',
    'Khand:300,400,500,600,700' => 'Khand',
    'Khmer:400' => 'Khmer',
    'Khula:300,400,600,700,800' => 'Khula',
    'Kings:400' => 'Kings',
    'Kirang Haerang:400' => 'Kirang Haerang',
    'Kite One:400' => 'Kite One',
    'Kiwi Maru:300,400,500' => 'Kiwi Maru',
    'Klee One:400,600' => 'Klee One',
    'Knewave:400' => 'Knewave',
    'KoHo:200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic' => 'KoHo',
    'Kodchasan:200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic' => 'Kodchasan',
    'Koh Santepheap:100,300,400,700,900' => 'Koh Santepheap',
    'Kolker Brush:400' => 'Kolker Brush',
    'Kosugi:400' => 'Kosugi',
    'Kosugi Maru:400' => 'Kosugi Maru',
    'Kotta One:400' => 'Kotta One',
    'Koulen:400' => 'Koulen',
    'Kranky:400' => 'Kranky',
    'Kreon:300,400,500,600,700' => 'Kreon',
    'Kristi:400' => 'Kristi',
    'Krona One:400' => 'Krona One',
    'Krub:200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic' => 'Krub',
    'Kufam:400,500,600,700,800,900,400italic,500italic,600italic,700italic,800italic,900italic' => 'Kufam',
    'Kulim Park:200,200italic,300,300italic,400,400italic,600,600italic,700,700italic' => 'Kulim Park',
    'Kumar One:400' => 'Kumar One',
    'Kumar One Outline:400' => 'Kumar One Outline',
    'Kumbh Sans:100,200,300,400,500,600,700,800,900' => 'Kumbh Sans',
    'Kurale:400' => 'Kurale',
    'La Belle Aurore:400' => 'La Belle Aurore',
    'Lacquer:400' => 'Lacquer',
    'Laila:300,400,500,600,700' => 'Laila',
    'Lakki Reddy:400' => 'Lakki Reddy',
    'Lalezar:400' => 'Lalezar',
    'Lancelot:400' => 'Lancelot',
    'Langar:400' => 'Langar',
    'Lateef:400' => 'Lateef',
    'Lato:100,100italic,300,300italic,400,400italic,700,700italic,900,900italic' => 'Lato',
    'Lavishly Yours:400' => 'Lavishly Yours',
    'League Gothic:400' => 'League Gothic',
    'League Script:400' => 'League Script',
    'League Spartan:100,200,300,400,500,600,700,800,900' => 'League Spartan',
    'Leckerli One:400' => 'Leckerli One',
    'Ledger:400' => 'Ledger',
    'Lekton:400,400italic,700' => 'Lekton',
    'Lemon:400' => 'Lemon',
    'Lemonada:300,400,500,600,700' => 'Lemonada',
    'Lexend:100,200,300,400,500,600,700,800,900' => 'Lexend',
    'Lexend Deca:100,200,300,400,500,600,700,800,900' => 'Lexend Deca',
    'Lexend Exa:100,200,300,400,500,600,700,800,900' => 'Lexend Exa',
    'Lexend Giga:100,200,300,400,500,600,700,800,900' => 'Lexend Giga',
    'Lexend Mega:100,200,300,400,500,600,700,800,900' => 'Lexend Mega',
    'Lexend Peta:100,200,300,400,500,600,700,800,900' => 'Lexend Peta',
    'Lexend Tera:100,200,300,400,500,600,700,800,900' => 'Lexend Tera',
    'Lexend Zetta:100,200,300,400,500,600,700,800,900' => 'Lexend Zetta',
    'Libre Barcode 128:400' => 'Libre Barcode 128',
    'Libre Barcode 128 Text:400' => 'Libre Barcode 128 Text',
    'Libre Barcode 39:400' => 'Libre Barcode 39',
    'Libre Barcode 39 Extended:400' => 'Libre Barcode 39 Extended',
    'Libre Barcode 39 Extended Text:400' => 'Libre Barcode 39 Extended Text',
    'Libre Barcode 39 Text:400' => 'Libre Barcode 39 Text',
    'Libre Barcode EAN13 Text:400' => 'Libre Barcode EAN13 Text',
    'Libre Baskerville:400,400italic,700' => 'Libre Baskerville',
    'Libre Bodoni:400,500,600,700,400italic,500italic,600italic,700italic' => 'Libre Bodoni',
    'Libre Caslon Display:400' => 'Libre Caslon Display',
    'Libre Caslon Text:400,400italic,700' => 'Libre Caslon Text',
    'Libre Franklin:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Libre Franklin',
    'Licorice:400' => 'Licorice',
    'Life Savers:400,700,800' => 'Life Savers',
    'Lilita One:400' => 'Lilita One',
    'Lily Script One:400' => 'Lily Script One',
    'Limelight:400' => 'Limelight',
    'Linden Hill:400,400italic' => 'Linden Hill',
    'Literata:200,300,400,500,600,700,800,900,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Literata',
    'Liu Jian Mao Cao:400' => 'Liu Jian Mao Cao',
    'Livvic:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,900,900italic' => 'Livvic',
    'Lobster:400' => 'Lobster',
    'Lobster Two:400,400italic,700,700italic' => 'Lobster Two',
    'Londrina Outline:400' => 'Londrina Outline',
    'Londrina Shadow:400' => 'Londrina Shadow',
    'Londrina Sketch:400' => 'Londrina Sketch',
    'Londrina Solid:100,300,400,900' => 'Londrina Solid',
    'Long Cang:400' => 'Long Cang',
    'Lora:400,500,600,700,400italic,500italic,600italic,700italic' => 'Lora',
    'Love Light:400' => 'Love Light',
    'Love Ya Like A Sister:400' => 'Love Ya Like A Sister',
    'Loved by the King:400' => 'Loved by the King',
    'Lovers Quarrel:400' => 'Lovers Quarrel',
    'Luckiest Guy:400' => 'Luckiest Guy',
    'Lusitana:400,700' => 'Lusitana',
    'Lustria:400' => 'Lustria',
    'Luxurious Roman:400' => 'Luxurious Roman',
    'Luxurious Script:400' => 'Luxurious Script',
    'M PLUS 1:100,200,300,400,500,600,700,800,900' => 'M PLUS 1',
    'M PLUS 1 Code:100,200,300,400,500,600,700' => 'M PLUS 1 Code',
    'M PLUS 1p:100,300,400,500,700,800,900' => 'M PLUS 1p',
    'M PLUS 2:100,200,300,400,500,600,700,800,900' => 'M PLUS 2',
    'M PLUS Code Latin:100,200,300,400,500,600,700' => 'M PLUS Code Latin',
    'M PLUS Rounded 1c:100,300,400,500,700,800,900' => 'M PLUS Rounded 1c',
    'Ma Shan Zheng:400' => 'Ma Shan Zheng',
    'Macondo:400' => 'Macondo',
    'Macondo Swash Caps:400' => 'Macondo Swash Caps',
    'Mada:200,300,400,500,600,700,900' => 'Mada',
    'Magra:400,700' => 'Magra',
    'Maiden Orange:400' => 'Maiden Orange',
    'Maitree:200,300,400,500,600,700' => 'Maitree',
    'Major Mono Display:400' => 'Major Mono Display',
    'Mako:400' => 'Mako',
    'Mali:200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic' => 'Mali',
    'Mallanna:400' => 'Mallanna',
    'Mandali:400' => 'Mandali',
    'Manjari:100,400,700' => 'Manjari',
    'Manrope:200,300,400,500,600,700,800' => 'Manrope',
    'Mansalva:400' => 'Mansalva',
    'Manuale:300,400,500,600,700,800,300italic,400italic,500italic,600italic,700italic,800italic' => 'Manuale',
    'Marcellus:400' => 'Marcellus',
    'Marcellus SC:400' => 'Marcellus SC',
    'Marck Script:400' => 'Marck Script',
    'Margarine:400' => 'Margarine',
    'Markazi Text:400,500,600,700' => 'Markazi Text',
    'Marko One:400' => 'Marko One',
    'Marmelad:400' => 'Marmelad',
    'Martel:200,300,400,600,700,800,900' => 'Martel',
    'Martel Sans:200,300,400,600,700,800,900' => 'Martel Sans',
    'Marvel:400,400italic,700,700italic' => 'Marvel',
    'Mate:400,400italic' => 'Mate',
    'Mate SC:400' => 'Mate SC',
    'Maven Pro:400,500,600,700,800,900' => 'Maven Pro',
    'McLaren:400' => 'McLaren',
    'Mea Culpa:400' => 'Mea Culpa',
    'Meddon:400' => 'Meddon',
    'MedievalSharp:400' => 'MedievalSharp',
    'Medula One:400' => 'Medula One',
    'Meera Inimai:400' => 'Meera Inimai',
    'Megrim:400' => 'Megrim',
    'Meie Script:400' => 'Meie Script',
    'Meow Script:400' => 'Meow Script',
    'Merienda:400,700' => 'Merienda',
    'Merienda One:400' => 'Merienda One',
    'Merriweather:300,300italic,400,400italic,700,700italic,900,900italic' => 'Merriweather',
    'Merriweather Sans:300,400,500,600,700,800,300italic,400italic,500italic,600italic,700italic,800italic' => 'Merriweather Sans',
    'Metal:400' => 'Metal',
    'Metal Mania:400' => 'Metal Mania',
    'Metamorphous:400' => 'Metamorphous',
    'Metrophobic:400' => 'Metrophobic',
    'Michroma:400' => 'Michroma',
    'Milonga:400' => 'Milonga',
    'Miltonian:400' => 'Miltonian',
    'Miltonian Tattoo:400' => 'Miltonian Tattoo',
    'Mina:400,700' => 'Mina',
    'Mingzat:400' => 'Mingzat',
    'Miniver:400' => 'Miniver',
    'Miriam Libre:400,700' => 'Miriam Libre',
    'Mirza:400,500,600,700' => 'Mirza',
    'Miss Fajardose:400' => 'Miss Fajardose',
    'Mitr:200,300,400,500,600,700' => 'Mitr',
    'Mochiy Pop One:400' => 'Mochiy Pop One',
    'Mochiy Pop P One:400' => 'Mochiy Pop P One',
    'Modak:400' => 'Modak',
    'Modern Antiqua:400' => 'Modern Antiqua',
    'Mogra:400' => 'Mogra',
    'Mohave:300,400,500,600,700,300italic,400italic,500italic,600italic,700italic' => 'Mohave',
    'Molengo:400' => 'Molengo',
    'Molle:italic' => 'Molle',
    'Monda:400,700' => 'Monda',
    'Monofett:400' => 'Monofett',
    'Monoton:400' => 'Monoton',
    'Monsieur La Doulaise:400' => 'Monsieur La Doulaise',
    'Montaga:400' => 'Montaga',
    'Montagu Slab:100,200,300,400,500,600,700' => 'Montagu Slab',
    'MonteCarlo:400' => 'MonteCarlo',
    'Montez:400' => 'Montez',
    'Montserrat:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Montserrat',
    'Montserrat Alternates:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic' => 'Montserrat Alternates',
    'Montserrat Subrayada:400,700' => 'Montserrat Subrayada',
    'Moo Lah Lah:400' => 'Moo Lah Lah',
    'Moon Dance:400' => 'Moon Dance',
    'Moul:400' => 'Moul',
    'Moulpali:400' => 'Moulpali',
    'Mountains of Christmas:400,700' => 'Mountains of Christmas',
    'Mouse Memoirs:400' => 'Mouse Memoirs',
    'Mr Bedfort:400' => 'Mr Bedfort',
    'Mr Dafoe:400' => 'Mr Dafoe',
    'Mr De Haviland:400' => 'Mr De Haviland',
    'Mrs Saint Delafield:400' => 'Mrs Saint Delafield',
    'Mrs Sheppards:400' => 'Mrs Sheppards',
    'Ms Madi:400' => 'Ms Madi',
    'Mukta:200,300,400,500,600,700,800' => 'Mukta',
    'Mukta Mahee:200,300,400,500,600,700,800' => 'Mukta Mahee',
    'Mukta Malar:200,300,400,500,600,700,800' => 'Mukta Malar',
    'Mukta Vaani:200,300,400,500,600,700,800' => 'Mukta Vaani',
    'Mulish:200,300,400,500,600,700,800,900,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Mulish',
    'Murecho:100,200,300,400,500,600,700,800,900' => 'Murecho',
    'MuseoModerno:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'MuseoModerno',
    'My Soul:400' => 'My Soul',
    'Mystery Quest:400' => 'Mystery Quest',
    'NTR:400' => 'NTR',
    'Nanum Brush Script:400' => 'Nanum Brush Script',
    'Nanum Gothic:400,700,800' => 'Nanum Gothic',
    'Nanum Gothic Coding:400,700' => 'Nanum Gothic Coding',
    'Nanum Myeongjo:400,700,800' => 'Nanum Myeongjo',
    'Nanum Pen Script:400' => 'Nanum Pen Script',
    'Neonderthaw:400' => 'Neonderthaw',
    'Nerko One:400' => 'Nerko One',
    'Neucha:400' => 'Neucha',
    'Neuton:200,300,400,400italic,700,800' => 'Neuton',
    'New Rocker:400' => 'New Rocker',
    'New Tegomin:400' => 'New Tegomin',
    'News Cycle:400,700' => 'News Cycle',
    'Newsreader:200,300,400,500,600,700,800,200italic,300italic,400italic,500italic,600italic,700italic,800italic' => 'Newsreader',
    'Niconne:400' => 'Niconne',
    'Niramit:200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic' => 'Niramit',
    'Nixie One:400' => 'Nixie One',
    'Nobile:400,400italic,500,500italic,700,700italic' => 'Nobile',
    'Nokora:100,300,400,700,900' => 'Nokora',
    'Norican:400' => 'Norican',
    'Nosifer:400' => 'Nosifer',
    'Notable:400' => 'Notable',
    'Nothing You Could Do:400' => 'Nothing You Could Do',
    'Noticia Text:400,400italic,700,700italic' => 'Noticia Text',
    'Noto Emoji:300,400,500,600,700' => 'Noto Emoji',
    'Noto Kufi Arabic:100,200,300,400,500,600,700,800,900' => 'Noto Kufi Arabic',
    'Noto Music:400' => 'Noto Music',
    'Noto Naskh Arabic:400,500,600,700' => 'Noto Naskh Arabic',
    'Noto Nastaliq Urdu:400,700' => 'Noto Nastaliq Urdu',
    'Noto Rashi Hebrew:100,200,300,400,500,600,700,800,900' => 'Noto Rashi Hebrew',
    'Noto Sans:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic' => 'Noto Sans',
    'Noto Sans Adlam:400,500,600,700' => 'Noto Sans Adlam',
    'Noto Sans Adlam Unjoined:400,500,600,700' => 'Noto Sans Adlam Unjoined',
    'Noto Sans Anatolian Hieroglyphs:400' => 'Noto Sans Anatolian Hieroglyphs',
    'Noto Sans Arabic:100,200,300,400,500,600,700,800,900' => 'Noto Sans Arabic',
    'Noto Sans Armenian:100,200,300,400,500,600,700,800,900' => 'Noto Sans Armenian',
    'Noto Sans Avestan:400' => 'Noto Sans Avestan',
    'Noto Sans Balinese:400,500,600,700' => 'Noto Sans Balinese',
    'Noto Sans Bamum:400,500,600,700' => 'Noto Sans Bamum',
    'Noto Sans Bassa Vah:400' => 'Noto Sans Bassa Vah',
    'Noto Sans Batak:400' => 'Noto Sans Batak',
    'Noto Sans Bengali:100,200,300,400,500,600,700,800,900' => 'Noto Sans Bengali',
    'Noto Sans Bhaiksuki:400' => 'Noto Sans Bhaiksuki',
    'Noto Sans Brahmi:400' => 'Noto Sans Brahmi',
    'Noto Sans Buginese:400' => 'Noto Sans Buginese',
    'Noto Sans Buhid:400' => 'Noto Sans Buhid',
    'Noto Sans Canadian Aboriginal:100,200,300,400,500,600,700,800,900' => 'Noto Sans Canadian Aboriginal',
    'Noto Sans Carian:400' => 'Noto Sans Carian',
    'Noto Sans Caucasian Albanian:400' => 'Noto Sans Caucasian Albanian',
    'Noto Sans Chakma:400' => 'Noto Sans Chakma',
    'Noto Sans Cham:100,200,300,400,500,600,700,800,900' => 'Noto Sans Cham',
    'Noto Sans Cherokee:100,200,300,400,500,600,700,800,900' => 'Noto Sans Cherokee',
    'Noto Sans Coptic:400' => 'Noto Sans Coptic',
    'Noto Sans Cuneiform:400' => 'Noto Sans Cuneiform',
    'Noto Sans Cypriot:400' => 'Noto Sans Cypriot',
    'Noto Sans Deseret:400' => 'Noto Sans Deseret',
    'Noto Sans Devanagari:100,200,300,400,500,600,700,800,900' => 'Noto Sans Devanagari',
    'Noto Sans Display:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Noto Sans Display',
    'Noto Sans Duployan:400' => 'Noto Sans Duployan',
    'Noto Sans Egyptian Hieroglyphs:400' => 'Noto Sans Egyptian Hieroglyphs',
    'Noto Sans Elbasan:400' => 'Noto Sans Elbasan',
    'Noto Sans Elymaic:400' => 'Noto Sans Elymaic',
    'Noto Sans Georgian:100,200,300,400,500,600,700,800,900' => 'Noto Sans Georgian',
    'Noto Sans Glagolitic:400' => 'Noto Sans Glagolitic',
    'Noto Sans Gothic:400' => 'Noto Sans Gothic',
    'Noto Sans Grantha:400' => 'Noto Sans Grantha',
    'Noto Sans Gujarati:100,200,300,400,500,600,700,800,900' => 'Noto Sans Gujarati',
    'Noto Sans Gunjala Gondi:400' => 'Noto Sans Gunjala Gondi',
    'Noto Sans Gurmukhi:100,200,300,400,500,600,700,800,900' => 'Noto Sans Gurmukhi',
    'Noto Sans HK:100,300,400,500,700,900' => 'Noto Sans HK',
    'Noto Sans Hanifi Rohingya:400,500,600,700' => 'Noto Sans Hanifi Rohingya',
    'Noto Sans Hanunoo:400' => 'Noto Sans Hanunoo',
    'Noto Sans Hatran:400' => 'Noto Sans Hatran',
    'Noto Sans Hebrew:100,200,300,400,500,600,700,800,900' => 'Noto Sans Hebrew',
    'Noto Sans Imperial Aramaic:400' => 'Noto Sans Imperial Aramaic',
    'Noto Sans Indic Siyaq Numbers:400' => 'Noto Sans Indic Siyaq Numbers',
    'Noto Sans Inscriptional Pahlavi:400' => 'Noto Sans Inscriptional Pahlavi',
    'Noto Sans Inscriptional Parthian:400' => 'Noto Sans Inscriptional Parthian',
    'Noto Sans JP:100,300,400,500,700,900' => 'Noto Sans JP',
    'Noto Sans Javanese:400,700' => 'Noto Sans Javanese',
    'Noto Sans KR:100,300,400,500,700,900' => 'Noto Sans KR',
    'Noto Sans Kaithi:400' => 'Noto Sans Kaithi',
    'Noto Sans Kannada:100,200,300,400,500,600,700,800,900' => 'Noto Sans Kannada',
    'Noto Sans Kayah Li:400,500,600,700' => 'Noto Sans Kayah Li',
    'Noto Sans Kharoshthi:400' => 'Noto Sans Kharoshthi',
    'Noto Sans Khmer:100,200,300,400,500,600,700,800,900' => 'Noto Sans Khmer',
    'Noto Sans Khojki:400' => 'Noto Sans Khojki',
    'Noto Sans Khudawadi:400' => 'Noto Sans Khudawadi',
    'Noto Sans Lao:100,200,300,400,500,600,700,800,900' => 'Noto Sans Lao',
    'Noto Sans Lepcha:400' => 'Noto Sans Lepcha',
    'Noto Sans Limbu:400' => 'Noto Sans Limbu',
    'Noto Sans Linear A:400' => 'Noto Sans Linear A',
    'Noto Sans Linear B:400' => 'Noto Sans Linear B',
    'Noto Sans Lisu:400,500,600,700' => 'Noto Sans Lisu',
    'Noto Sans Lycian:400' => 'Noto Sans Lycian',
    'Noto Sans Lydian:400' => 'Noto Sans Lydian',
    'Noto Sans Mahajani:400' => 'Noto Sans Mahajani',
    'Noto Sans Malayalam:100,200,300,400,500,600,700,800,900' => 'Noto Sans Malayalam',
    'Noto Sans Mandaic:400' => 'Noto Sans Mandaic',
    'Noto Sans Manichaean:400' => 'Noto Sans Manichaean',
    'Noto Sans Marchen:400' => 'Noto Sans Marchen',
    'Noto Sans Masaram Gondi:400' => 'Noto Sans Masaram Gondi',
    'Noto Sans Math:400' => 'Noto Sans Math',
    'Noto Sans Mayan Numerals:400' => 'Noto Sans Mayan Numerals',
    'Noto Sans Medefaidrin:400,500,600,700' => 'Noto Sans Medefaidrin',
    'Noto Sans Meetei Mayek:100,200,300,400,500,600,700,800,900' => 'Noto Sans Meetei Mayek',
    'Noto Sans Meroitic:400' => 'Noto Sans Meroitic',
    'Noto Sans Miao:400' => 'Noto Sans Miao',
    'Noto Sans Modi:400' => 'Noto Sans Modi',
    'Noto Sans Mongolian:400' => 'Noto Sans Mongolian',
    'Noto Sans Mono:100,200,300,400,500,600,700,800,900' => 'Noto Sans Mono',
    'Noto Sans Mro:400' => 'Noto Sans Mro',
    'Noto Sans Multani:400' => 'Noto Sans Multani',
    'Noto Sans Myanmar:100,200,300,400,500,600,700,800,900' => 'Noto Sans Myanmar',
    'Noto Sans N Ko:400' => 'Noto Sans N Ko',
    'Noto Sans Nabataean:400' => 'Noto Sans Nabataean',
    'Noto Sans New Tai Lue:400' => 'Noto Sans New Tai Lue',
    'Noto Sans Newa:400' => 'Noto Sans Newa',
    'Noto Sans Nushu:400' => 'Noto Sans Nushu',
    'Noto Sans Ogham:400' => 'Noto Sans Ogham',
    'Noto Sans Ol Chiki:400,500,600,700' => 'Noto Sans Ol Chiki',
    'Noto Sans Old Hungarian:400' => 'Noto Sans Old Hungarian',
    'Noto Sans Old Italic:400' => 'Noto Sans Old Italic',
    'Noto Sans Old North Arabian:400' => 'Noto Sans Old North Arabian',
    'Noto Sans Old Permic:400' => 'Noto Sans Old Permic',
    'Noto Sans Old Persian:400' => 'Noto Sans Old Persian',
    'Noto Sans Old Sogdian:400' => 'Noto Sans Old Sogdian',
    'Noto Sans Old South Arabian:400' => 'Noto Sans Old South Arabian',
    'Noto Sans Old Turkic:400' => 'Noto Sans Old Turkic',
    'Noto Sans Oriya:100,400,700,900' => 'Noto Sans Oriya',
    'Noto Sans Osage:400' => 'Noto Sans Osage',
    'Noto Sans Osmanya:400' => 'Noto Sans Osmanya',
    'Noto Sans Pahawh Hmong:400' => 'Noto Sans Pahawh Hmong',
    'Noto Sans Palmyrene:400' => 'Noto Sans Palmyrene',
    'Noto Sans Pau Cin Hau:400' => 'Noto Sans Pau Cin Hau',
    'Noto Sans Phags Pa:400' => 'Noto Sans Phags Pa',
    'Noto Sans Phoenician:400' => 'Noto Sans Phoenician',
    'Noto Sans Psalter Pahlavi:400' => 'Noto Sans Psalter Pahlavi',
    'Noto Sans Rejang:400' => 'Noto Sans Rejang',
    'Noto Sans Runic:400' => 'Noto Sans Runic',
    'Noto Sans SC:100,300,400,500,700,900' => 'Noto Sans SC',
    'Noto Sans Samaritan:400' => 'Noto Sans Samaritan',
    'Noto Sans Saurashtra:400' => 'Noto Sans Saurashtra',
    'Noto Sans Sharada:400' => 'Noto Sans Sharada',
    'Noto Sans Shavian:400' => 'Noto Sans Shavian',
    'Noto Sans Siddham:400' => 'Noto Sans Siddham',
    'Noto Sans Sinhala:100,200,300,400,500,600,700,800,900' => 'Noto Sans Sinhala',
    'Noto Sans Sogdian:400' => 'Noto Sans Sogdian',
    'Noto Sans Sora Sompeng:400,500,600,700' => 'Noto Sans Sora Sompeng',
    'Noto Sans Soyombo:400' => 'Noto Sans Soyombo',
    'Noto Sans Sundanese:400,500,600,700' => 'Noto Sans Sundanese',
    'Noto Sans Syloti Nagri:400' => 'Noto Sans Syloti Nagri',
    'Noto Sans Symbols:100,200,300,400,500,600,700,800,900' => 'Noto Sans Symbols',
    'Noto Sans Symbols 2:400' => 'Noto Sans Symbols 2',
    'Noto Sans Syriac:100,400,900' => 'Noto Sans Syriac',
    'Noto Sans TC:100,300,400,500,700,900' => 'Noto Sans TC',
    'Noto Sans Tagalog:400' => 'Noto Sans Tagalog',
    'Noto Sans Tagbanwa:400' => 'Noto Sans Tagbanwa',
    'Noto Sans Tai Le:400' => 'Noto Sans Tai Le',
    'Noto Sans Tai Tham:400,500,600,700' => 'Noto Sans Tai Tham',
    'Noto Sans Tai Viet:400' => 'Noto Sans Tai Viet',
    'Noto Sans Takri:400' => 'Noto Sans Takri',
    'Noto Sans Tamil:100,200,300,400,500,600,700,800,900' => 'Noto Sans Tamil',
    'Noto Sans Tamil Supplement:400' => 'Noto Sans Tamil Supplement',
    'Noto Sans Telugu:100,200,300,400,500,600,700,800,900' => 'Noto Sans Telugu',
    'Noto Sans Thaana:100,200,300,400,500,600,700,800,900' => 'Noto Sans Thaana',
    'Noto Sans Thai:100,200,300,400,500,600,700,800,900' => 'Noto Sans Thai',
    'Noto Sans Thai Looped:100,200,300,400,500,600,700,800,900' => 'Noto Sans Thai Looped',
    'Noto Sans Tifinagh:400' => 'Noto Sans Tifinagh',
    'Noto Sans Tirhuta:400' => 'Noto Sans Tirhuta',
    'Noto Sans Ugaritic:400' => 'Noto Sans Ugaritic',
    'Noto Sans Vai:400' => 'Noto Sans Vai',
    'Noto Sans Wancho:400' => 'Noto Sans Wancho',
    'Noto Sans Warang Citi:400' => 'Noto Sans Warang Citi',
    'Noto Sans Yi:400' => 'Noto Sans Yi',
    'Noto Sans Zanabazar Square:400' => 'Noto Sans Zanabazar Square',
    'Noto Serif:400,400italic,700,700italic' => 'Noto Serif',
    'Noto Serif Ahom:400' => 'Noto Serif Ahom',
    'Noto Serif Armenian:100,200,300,400,500,600,700,800,900' => 'Noto Serif Armenian',
    'Noto Serif Balinese:400' => 'Noto Serif Balinese',
    'Noto Serif Bengali:100,200,300,400,500,600,700,800,900' => 'Noto Serif Bengali',
    'Noto Serif Devanagari:100,200,300,400,500,600,700,800,900' => 'Noto Serif Devanagari',
    'Noto Serif Display:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Noto Serif Display',
    'Noto Serif Dogra:400' => 'Noto Serif Dogra',
    'Noto Serif Ethiopic:100,200,300,400,500,600,700,800,900' => 'Noto Serif Ethiopic',
    'Noto Serif Georgian:100,200,300,400,500,600,700,800,900' => 'Noto Serif Georgian',
    'Noto Serif Grantha:400' => 'Noto Serif Grantha',
    'Noto Serif Gujarati:100,200,300,400,500,600,700,800,900' => 'Noto Serif Gujarati',
    'Noto Serif Gurmukhi:100,200,300,400,500,600,700,800,900' => 'Noto Serif Gurmukhi',
    'Noto Serif HK:200,300,400,500,600,700,800,900' => 'Noto Serif HK',
    'Noto Serif Hebrew:100,200,300,400,500,600,700,800,900' => 'Noto Serif Hebrew',
    'Noto Serif JP:200,300,400,500,600,700,900' => 'Noto Serif JP',
    'Noto Serif KR:200,300,400,500,600,700,900' => 'Noto Serif KR',
    'Noto Serif Kannada:100,200,300,400,500,600,700,800,900' => 'Noto Serif Kannada',
    'Noto Serif Khmer:100,200,300,400,500,600,700,800,900' => 'Noto Serif Khmer',
    'Noto Serif Lao:100,200,300,400,500,600,700,800,900' => 'Noto Serif Lao',
    'Noto Serif Malayalam:100,200,300,400,500,600,700,800,900' => 'Noto Serif Malayalam',
    'Noto Serif Myanmar:100,200,300,400,500,600,700,800,900' => 'Noto Serif Myanmar',
    'Noto Serif Nyiakeng Puachue Hmong:400,500,600,700' => 'Noto Serif Nyiakeng Puachue Hmong',
    'Noto Serif SC:200,300,400,500,600,700,900' => 'Noto Serif SC',
    'Noto Serif Sinhala:100,200,300,400,500,600,700,800,900' => 'Noto Serif Sinhala',
    'Noto Serif TC:200,300,400,500,600,700,900' => 'Noto Serif TC',
    'Noto Serif Tamil:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Noto Serif Tamil',
    'Noto Serif Tangut:400' => 'Noto Serif Tangut',
    'Noto Serif Telugu:100,200,300,400,500,600,700,800,900' => 'Noto Serif Telugu',
    'Noto Serif Thai:100,200,300,400,500,600,700,800,900' => 'Noto Serif Thai',
    'Noto Serif Tibetan:100,200,300,400,500,600,700,800,900' => 'Noto Serif Tibetan',
    'Noto Serif Yezidi:400,500,600,700' => 'Noto Serif Yezidi',
    'Noto Traditional Nushu:400' => 'Noto Traditional Nushu',
    'Nova Cut:400' => 'Nova Cut',
    'Nova Flat:400' => 'Nova Flat',
    'Nova Mono:400' => 'Nova Mono',
    'Nova Oval:400' => 'Nova Oval',
    'Nova Round:400' => 'Nova Round',
    'Nova Script:400' => 'Nova Script',
    'Nova Slim:400' => 'Nova Slim',
    'Nova Square:400' => 'Nova Square',
    'Numans:400' => 'Numans',
    'Nunito:200,300,400,500,600,700,800,900,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Nunito',
    'Nunito Sans:200,200italic,300,300italic,400,400italic,600,600italic,700,700italic,800,800italic,900,900italic' => 'Nunito Sans',
    'Nuosu SIL:400' => 'Nuosu SIL',
    'Odibee Sans:400' => 'Odibee Sans',
    'Odor Mean Chey:400' => 'Odor Mean Chey',
    'Offside:400' => 'Offside',
    'Oi:400' => 'Oi',
    'Old Standard TT:400,400italic,700' => 'Old Standard TT',
    'Oldenburg:400' => 'Oldenburg',
    'Ole:400' => 'Ole',
    'Oleo Script:400,700' => 'Oleo Script',
    'Oleo Script Swash Caps:400,700' => 'Oleo Script Swash Caps',
    'Oooh Baby:400' => 'Oooh Baby',
    'Open Sans:300,400,500,600,700,800,300italic,400italic,500italic,600italic,700italic,800italic' => 'Open Sans',
    'Oranienbaum:400' => 'Oranienbaum',
    'Orbitron:400,500,600,700,800,900' => 'Orbitron',
    'Oregano:400,400italic' => 'Oregano',
    'Orelega One:400' => 'Orelega One',
    'Orienta:400' => 'Orienta',
    'Original Surfer:400' => 'Original Surfer',
    'Oswald:200,300,400,500,600,700' => 'Oswald',
    'Outfit:100,200,300,400,500,600,700,800,900' => 'Outfit',
    'Over the Rainbow:400' => 'Over the Rainbow',
    'Overlock:400,400italic,700,700italic,900,900italic' => 'Overlock',
    'Overlock SC:400' => 'Overlock SC',
    'Overpass:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Overpass',
    'Overpass Mono:300,400,500,600,700' => 'Overpass Mono',
    'Ovo:400' => 'Ovo',
    'Oxanium:200,300,400,500,600,700,800' => 'Oxanium',
    'Oxygen:300,400,700' => 'Oxygen',
    'Oxygen Mono:400' => 'Oxygen Mono',
    'PT Mono:400' => 'PT Mono',
    'PT Sans:400,400italic,700,700italic' => 'PT Sans',
    'PT Sans Caption:400,700' => 'PT Sans Caption',
    'PT Sans Narrow:400,700' => 'PT Sans Narrow',
    'PT Serif:400,400italic,700,700italic' => 'PT Serif',
    'PT Serif Caption:400,400italic' => 'PT Serif Caption',
    'Pacifico:400' => 'Pacifico',
    'Padauk:400,700' => 'Padauk',
    'Palanquin:100,200,300,400,500,600,700' => 'Palanquin',
    'Palanquin Dark:400,500,600,700' => 'Palanquin Dark',
    'Pangolin:400' => 'Pangolin',
    'Paprika:400' => 'Paprika',
    'Parisienne:400' => 'Parisienne',
    'Passero One:400' => 'Passero One',
    'Passion One:400,700,900' => 'Passion One',
    'Passions Conflict:400' => 'Passions Conflict',
    'Pathway Gothic One:400' => 'Pathway Gothic One',
    'Patrick Hand:400' => 'Patrick Hand',
    'Patrick Hand SC:400' => 'Patrick Hand SC',
    'Pattaya:400' => 'Pattaya',
    'Patua One:400' => 'Patua One',
    'Pavanam:400' => 'Pavanam',
    'Paytone One:400' => 'Paytone One',
    'Peddana:400' => 'Peddana',
    'Peralta:400' => 'Peralta',
    'Permanent Marker:400' => 'Permanent Marker',
    'Petemoss:400' => 'Petemoss',
    'Petit Formal Script:400' => 'Petit Formal Script',
    'Petrona:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Petrona',
    'Philosopher:400,400italic,700,700italic' => 'Philosopher',
    'Piazzolla:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Piazzolla',
    'Piedra:400' => 'Piedra',
    'Pinyon Script:400' => 'Pinyon Script',
    'Pirata One:400' => 'Pirata One',
    'Plaster:400' => 'Plaster',
    'Play:400,700' => 'Play',
    'Playball:400' => 'Playball',
    'Playfair Display:400,500,600,700,800,900,400italic,500italic,600italic,700italic,800italic,900italic' => 'Playfair Display',
    'Playfair Display SC:400,400italic,700,700italic,900,900italic' => 'Playfair Display SC',
    'Plus Jakarta Sans:200,300,400,500,600,700,800,200italic,300italic,400italic,500italic,600italic,700italic,800italic' => 'Plus Jakarta Sans',
    'Podkova:400,500,600,700,800' => 'Podkova',
    'Poiret One:400' => 'Poiret One',
    'Poller One:400' => 'Poller One',
    'Poly:400,400italic' => 'Poly',
    'Pompiere:400' => 'Pompiere',
    'Pontano Sans:400' => 'Pontano Sans',
    'Poor Story:400' => 'Poor Story',
    'Poppins:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic' => 'Poppins',
    'Port Lligat Sans:400' => 'Port Lligat Sans',
    'Port Lligat Slab:400' => 'Port Lligat Slab',
    'Potta One:400' => 'Potta One',
    'Pragati Narrow:400,700' => 'Pragati Narrow',
    'Praise:400' => 'Praise',
    'Prata:400' => 'Prata',
    'Preahvihear:400' => 'Preahvihear',
    'Press Start 2P:400' => 'Press Start 2P',
    'Pridi:200,300,400,500,600,700' => 'Pridi',
    'Princess Sofia:400' => 'Princess Sofia',
    'Prociono:400' => 'Prociono',
    'Prompt:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic' => 'Prompt',
    'Prosto One:400' => 'Prosto One',
    'Proza Libre:400,400italic,500,500italic,600,600italic,700,700italic,800,800italic' => 'Proza Libre',
    'Public Sans:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Public Sans',
    'Puppies Play:400' => 'Puppies Play',
    'Puritan:400,400italic,700,700italic' => 'Puritan',
    'Purple Purse:400' => 'Purple Purse',
    'Qahiri:400' => 'Qahiri',
    'Quando:400' => 'Quando',
    'Quantico:400,400italic,700,700italic' => 'Quantico',
    'Quattrocento:400,700' => 'Quattrocento',
    'Quattrocento Sans:400,400italic,700,700italic' => 'Quattrocento Sans',
    'Questrial:400' => 'Questrial',
    'Quicksand:300,400,500,600,700' => 'Quicksand',
    'Quintessential:400' => 'Quintessential',
    'Qwigley:400' => 'Qwigley',
    'Qwitcher Grypen:400,700' => 'Qwitcher Grypen',
    'Racing Sans One:400' => 'Racing Sans One',
    'Radio Canada:300,400,500,600,700,300italic,400italic,500italic,600italic,700italic' => 'Radio Canada',
    'Radley:400,400italic' => 'Radley',
    'Rajdhani:300,400,500,600,700' => 'Rajdhani',
    'Rakkas:400' => 'Rakkas',
    'Raleway:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Raleway',
    'Raleway Dots:400' => 'Raleway Dots',
    'Ramabhadra:400' => 'Ramabhadra',
    'Ramaraja:400' => 'Ramaraja',
    'Rambla:400,400italic,700,700italic' => 'Rambla',
    'Rammetto One:400' => 'Rammetto One',
    'Rampart One:400' => 'Rampart One',
    'Ranchers:400' => 'Ranchers',
    'Rancho:400' => 'Rancho',
    'Ranga:400,700' => 'Ranga',
    'Rasa:300,400,500,600,700,300italic,400italic,500italic,600italic,700italic' => 'Rasa',
    'Rationale:400' => 'Rationale',
    'Ravi Prakash:400' => 'Ravi Prakash',
    'Readex Pro:200,300,400,500,600,700' => 'Readex Pro',
    'Recursive:300,400,500,600,700,800,900' => 'Recursive',
    'Red Hat Display:300,400,500,600,700,800,900,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Red Hat Display',
    'Red Hat Mono:300,400,500,600,700,300italic,400italic,500italic,600italic,700italic' => 'Red Hat Mono',
    'Red Hat Text:300,400,500,600,700,300italic,400italic,500italic,600italic,700italic' => 'Red Hat Text',
    'Red Rose:300,400,500,600,700' => 'Red Rose',
    'Redacted:400' => 'Redacted',
    'Redacted Script:300,400,700' => 'Redacted Script',
    'Redressed:400' => 'Redressed',
    'Reem Kufi:400,500,600,700' => 'Reem Kufi',
    'Reenie Beanie:400' => 'Reenie Beanie',
    'Reggae One:400' => 'Reggae One',
    'Revalia:400' => 'Revalia',
    'Rhodium Libre:400' => 'Rhodium Libre',
    'Ribeye:400' => 'Ribeye',
    'Ribeye Marrow:400' => 'Ribeye Marrow',
    'Righteous:400' => 'Righteous',
    'Risque:400' => 'Risque',
    'Road Rage:400' => 'Road Rage',
    'Roboto:100,100italic,300,300italic,400,400italic,500,500italic,700,700italic,900,900italic' => 'Roboto',
    'Roboto Condensed:300,300italic,400,400italic,700,700italic' => 'Roboto Condensed',
    'Roboto Flex:400' => 'Roboto Flex',
    'Roboto Mono:100,200,300,400,500,600,700,100italic,200italic,300italic,400italic,500italic,600italic,700italic' => 'Roboto Mono',
    'Roboto Serif:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Roboto Serif',
    'Roboto Slab:100,200,300,400,500,600,700,800,900' => 'Roboto Slab',
    'Rochester:400' => 'Rochester',
    'Rock Salt:400' => 'Rock Salt',
    'RocknRoll One:400' => 'RocknRoll One',
    'Rokkitt:100,200,300,400,500,600,700,800,900' => 'Rokkitt',
    'Romanesco:400' => 'Romanesco',
    'Ropa Sans:400,400italic' => 'Ropa Sans',
    'Rosario:300,400,500,600,700,300italic,400italic,500italic,600italic,700italic' => 'Rosario',
    'Rosarivo:400,400italic' => 'Rosarivo',
    'Rouge Script:400' => 'Rouge Script',
    'Rowdies:300,400,700' => 'Rowdies',
    'Rozha One:400' => 'Rozha One',
    'Rubik:300,400,500,600,700,800,900,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Rubik',
    'Rubik Beastly:400' => 'Rubik Beastly',
    'Rubik Bubbles:400' => 'Rubik Bubbles',
    'Rubik Burned:400' => 'Rubik Burned',
    'Rubik Dirt:400' => 'Rubik Dirt',
    'Rubik Distressed:400' => 'Rubik Distressed',
    'Rubik Glitch:400' => 'Rubik Glitch',
    'Rubik Iso:400' => 'Rubik Iso',
    'Rubik Marker Hatch:400' => 'Rubik Marker Hatch',
    'Rubik Maze:400' => 'Rubik Maze',
    'Rubik Microbe:400' => 'Rubik Microbe',
    'Rubik Mono One:400' => 'Rubik Mono One',
    'Rubik Moonrocks:400' => 'Rubik Moonrocks',
    'Rubik Puddles:400' => 'Rubik Puddles',
    'Rubik Wet Paint:400' => 'Rubik Wet Paint',
    'Ruda:400,500,600,700,800,900' => 'Ruda',
    'Rufina:400,700' => 'Rufina',
    'Ruge Boogie:400' => 'Ruge Boogie',
    'Ruluko:400' => 'Ruluko',
    'Rum Raisin:400' => 'Rum Raisin',
    'Ruslan Display:400' => 'Ruslan Display',
    'Russo One:400' => 'Russo One',
    'Ruthie:400' => 'Ruthie',
    'Rye:400' => 'Rye',
    'STIX Two Text:400,500,600,700,400italic,500italic,600italic,700italic' => 'STIX Two Text',
    'Sacramento:400' => 'Sacramento',
    'Sahitya:400,700' => 'Sahitya',
    'Sail:400' => 'Sail',
    'Saira:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Saira',
    'Saira Condensed:100,200,300,400,500,600,700,800,900' => 'Saira Condensed',
    'Saira Extra Condensed:100,200,300,400,500,600,700,800,900' => 'Saira Extra Condensed',
    'Saira Semi Condensed:100,200,300,400,500,600,700,800,900' => 'Saira Semi Condensed',
    'Saira Stencil One:400' => 'Saira Stencil One',
    'Salsa:400' => 'Salsa',
    'Sanchez:400,400italic' => 'Sanchez',
    'Sancreek:400' => 'Sancreek',
    'Sansita:400,400italic,700,700italic,800,800italic,900,900italic' => 'Sansita',
    'Sansita Swashed:300,400,500,600,700,800,900' => 'Sansita Swashed',
    'Sarabun:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic' => 'Sarabun',
    'Sarala:400,700' => 'Sarala',
    'Sarina:400' => 'Sarina',
    'Sarpanch:400,500,600,700,800,900' => 'Sarpanch',
    'Sassy Frass:400' => 'Sassy Frass',
    'Satisfy:400' => 'Satisfy',
    'Sawarabi Gothic:400' => 'Sawarabi Gothic',
    'Sawarabi Mincho:400' => 'Sawarabi Mincho',
    'Scada:400,400italic,700,700italic' => 'Scada',
    'Scheherazade New:400,700' => 'Scheherazade New',
    'Schoolbell:400' => 'Schoolbell',
    'Scope One:400' => 'Scope One',
    'Seaweed Script:400' => 'Seaweed Script',
    'Secular One:400' => 'Secular One',
    'Sedgwick Ave:400' => 'Sedgwick Ave',
    'Sedgwick Ave Display:400' => 'Sedgwick Ave Display',
    'Sen:400,700,800' => 'Sen',
    'Send Flowers:400' => 'Send Flowers',
    'Sevillana:400' => 'Sevillana',
    'Seymour One:400' => 'Seymour One',
    'Shadows Into Light:400' => 'Shadows Into Light',
    'Shadows Into Light Two:400' => 'Shadows Into Light Two',
    'Shalimar:400' => 'Shalimar',
    'Shanti:400' => 'Shanti',
    'Share:400,400italic,700,700italic' => 'Share',
    'Share Tech:400' => 'Share Tech',
    'Share Tech Mono:400' => 'Share Tech Mono',
    'Shippori Antique:400' => 'Shippori Antique',
    'Shippori Antique B1:400' => 'Shippori Antique B1',
    'Shippori Mincho:400,500,600,700,800' => 'Shippori Mincho',
    'Shippori Mincho B1:400,500,600,700,800' => 'Shippori Mincho B1',
    'Shojumaru:400' => 'Shojumaru',
    'Short Stack:400' => 'Short Stack',
    'Shrikhand:400' => 'Shrikhand',
    'Siemreap:400' => 'Siemreap',
    'Sigmar One:400' => 'Sigmar One',
    'Signika:300,400,500,600,700' => 'Signika',
    'Signika Negative:300,400,500,600,700' => 'Signika Negative',
    'Silkscreen:400,700' => 'Silkscreen',
    'Simonetta:400,400italic,900,900italic' => 'Simonetta',
    'Single Day:400' => 'Single Day',
    'Sintony:400,700' => 'Sintony',
    'Sirin Stencil:400' => 'Sirin Stencil',
    'Six Caps:400' => 'Six Caps',
    'Skranji:400,700' => 'Skranji',
    'Slabo 13px:400' => 'Slabo 13px',
    'Slabo 27px:400' => 'Slabo 27px',
    'Slackey:400' => 'Slackey',
    'Smokum:400' => 'Smokum',
    'Smooch:400' => 'Smooch',
    'Smooch Sans:100,200,300,400,500,600,700,800,900' => 'Smooch Sans',
    'Smythe:400' => 'Smythe',
    'Sniglet:400,800' => 'Sniglet',
    'Snippet:400' => 'Snippet',
    'Snowburst One:400' => 'Snowburst One',
    'Sofadi One:400' => 'Sofadi One',
    'Sofia:400' => 'Sofia',
    'Solway:300,400,500,700,800' => 'Solway',
    'Song Myung:400' => 'Song Myung',
    'Sonsie One:400' => 'Sonsie One',
    'Sora:100,200,300,400,500,600,700,800' => 'Sora',
    'Sorts mill__price Goudy:400,400italic' => 'Sorts mill__price Goudy',
    'Source Code Pro:200,300,400,500,600,700,800,900,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Source Code Pro',
    'Source Sans 3:200,300,400,500,600,700,800,900,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Source Sans 3',
    'Source Sans Pro:200,200italic,300,300italic,400,400italic,600,600italic,700,700italic,900,900italic' => 'Source Sans Pro',
    'Source Serif 4:200,300,400,500,600,700,800,900,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Source Serif 4',
    'Source Serif Pro:200,200italic,300,300italic,400,400italic,600,600italic,700,700italic,900,900italic' => 'Source Serif Pro',
    'Space Grotesk:300,400,500,600,700' => 'Space Grotesk',
    'Space Mono:400,400italic,700,700italic' => 'Space Mono',
    'Special Elite:400' => 'Special Elite',
    'Spectral:200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic' => 'Spectral',
    'Spectral SC:200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic' => 'Spectral SC',
    'Spicy Rice:400' => 'Spicy Rice',
    'Spinnaker:400' => 'Spinnaker',
    'Spirax:400' => 'Spirax',
    'Splash:400' => 'Splash',
    'Spline Sans:300,400,500,600,700' => 'Spline Sans',
    'Spline Sans Mono:300,400,500,600,700,300italic,400italic,500italic,600italic,700italic' => 'Spline Sans Mono',
    'Squada One:400' => 'Squada One',
    'Square Peg:400' => 'Square Peg',
    'Sree Krushnadevaraya:400' => 'Sree Krushnadevaraya',
    'Sriracha:400' => 'Sriracha',
    'Srisakdi:400,700' => 'Srisakdi',
    'Staatliches:400' => 'Staatliches',
    'Stalemate:400' => 'Stalemate',
    'Stalinist One:400' => 'Stalinist One',
    'Stardos Stencil:400,700' => 'Stardos Stencil',
    'Stick:400' => 'Stick',
    'Stick No Bills:200,300,400,500,600,700,800' => 'Stick No Bills',
    'Stint Ultra Condensed:400' => 'Stint Ultra Condensed',
    'Stint Ultra Expanded:400' => 'Stint Ultra Expanded',
    'Stoke:300,400' => 'Stoke',
    'Strait:400' => 'Strait',
    'Style Script:400' => 'Style Script',
    'Stylish:400' => 'Stylish',
    'Sue Ellen Francisco:400' => 'Sue Ellen Francisco',
    'Suez One:400' => 'Suez One',
    'Sulphur Point:300,400,700' => 'Sulphur Point',
    'Sumana:400,700' => 'Sumana',
    'Sunflower:300,500,700' => 'Sunflower',
    'Sunshiney:400' => 'Sunshiney',
    'Supermercado One:400' => 'Supermercado One',
    'Sura:400,700' => 'Sura',
    'Suranna:400' => 'Suranna',
    'Suravaram:400' => 'Suravaram',
    'Suwannaphum:100,300,400,700,900' => 'Suwannaphum',
    'Swanky and Moo Moo:400' => 'Swanky and Moo Moo',
    'Syncopate:400,700' => 'Syncopate',
    'Syne:400,500,600,700,800' => 'Syne',
    'Syne Mono:400' => 'Syne Mono',
    'Syne Tactile:400' => 'Syne Tactile',
    'Tai Heritage Pro:400,700' => 'Tai Heritage Pro',
    'Tajawal:200,300,400,500,700,800,900' => 'Tajawal',
    'Tangerine:400,700' => 'Tangerine',
    'Tapestry:400' => 'Tapestry',
    'Taprom:400' => 'Taprom',
    'Tauri:400' => 'Tauri',
    'Taviraj:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic' => 'Taviraj',
    'Teko:300,400,500,600,700' => 'Teko',
    'Telex:400' => 'Telex',
    'Tenali Ramakrishna:400' => 'Tenali Ramakrishna',
    'Tenor Sans:400' => 'Tenor Sans',
    'Text Me One:400' => 'Text Me One',
    'Texturina:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Texturina',
    'Thasadith:400,400italic,700,700italic' => 'Thasadith',
    'The Girl Next Door:400' => 'The Girl Next Door',
    'The Nautigal:400,700' => 'The Nautigal',
    'Tienne:400,700,900' => 'Tienne',
    'Tillana:400,500,600,700,800' => 'Tillana',
    'Timmana:400' => 'Timmana',
    'Tinos:400,400italic,700,700italic' => 'Tinos',
    'Tiro Bangla:400,400italic' => 'Tiro Bangla',
    'Tiro Devanagari Hindi:400,400italic' => 'Tiro Devanagari Hindi',
    'Tiro Devanagari Marathi:400,400italic' => 'Tiro Devanagari Marathi',
    'Tiro Devanagari Sanskrit:400,400italic' => 'Tiro Devanagari Sanskrit',
    'Tiro Gurmukhi:400,400italic' => 'Tiro Gurmukhi',
    'Tiro Kannada:400,400italic' => 'Tiro Kannada',
    'Tiro Tamil:400,400italic' => 'Tiro Tamil',
    'Tiro Telugu:400,400italic' => 'Tiro Telugu',
    'Titan One:400' => 'Titan One',
    'Titillium Web:200,200italic,300,300italic,400,400italic,600,600italic,700,700italic,900' => 'Titillium Web',
    'Tomorrow:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic' => 'Tomorrow',
    'Tourney:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Tourney',
    'Trade Winds:400' => 'Trade Winds',
    'Train One:400' => 'Train One',
    'Trirong:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic' => 'Trirong',
    'Trispace:100,200,300,400,500,600,700,800' => 'Trispace',
    'Trocchi:400' => 'Trocchi',
    'Trochut:400,400italic,700' => 'Trochut',
    'Truculenta:100,200,300,400,500,600,700,800,900' => 'Truculenta',
    'Trykker:400' => 'Trykker',
    'Tulpen One:400' => 'Tulpen One',
    'Turret Road:200,300,400,500,700,800' => 'Turret Road',
    'Twinkle Star:400' => 'Twinkle Star',
    'Ubuntu:300,300italic,400,400italic,500,500italic,700,700italic' => 'Ubuntu',
    'Ubuntu Condensed:400' => 'Ubuntu Condensed',
    'Ubuntu Mono:400,400italic,700,700italic' => 'Ubuntu Mono',
    'Uchen:400' => 'Uchen',
    'Ultra:400' => 'Ultra',
    'Uncial Antiqua:400' => 'Uncial Antiqua',
    'Underdog:400' => 'Underdog',
    'Unica One:400' => 'Unica One',
    'UnifrakturCook:700' => 'UnifrakturCook',
    'UnifrakturMaguntia:400' => 'UnifrakturMaguntia',
    'Unkempt:400,700' => 'Unkempt',
    'Unlock:400' => 'Unlock',
    'Unna:400,400italic,700,700italic' => 'Unna',
    'Updock:400' => 'Updock',
    'Urbanist:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Urbanist',
    'VT323:400' => 'VT323',
    'Vampiro One:400' => 'Vampiro One',
    'Varela:400' => 'Varela',
    'Varela Round:400' => 'Varela Round',
    'Varta:300,400,500,600,700' => 'Varta',
    'Vast Shadow:400' => 'Vast Shadow',
    'Vazirmatn:100,200,300,400,500,600,700,800,900' => 'Vazirmatn',
    'Vesper Libre:400,500,700,900' => 'Vesper Libre',
    'Viaoda Libre:400' => 'Viaoda Libre',
    'Vibes:400' => 'Vibes',
    'Vibur:400' => 'Vibur',
    'Vidaloka:400' => 'Vidaloka',
    'Viga:400' => 'Viga',
    'Voces:400' => 'Voces',
    'Volkhov:400,400italic,700,700italic' => 'Volkhov',
    'Vollkorn:400,500,600,700,800,900,400italic,500italic,600italic,700italic,800italic,900italic' => 'Vollkorn',
    'Vollkorn SC:400,600,700,900' => 'Vollkorn SC',
    'Voltaire:400' => 'Voltaire',
    'Vujahday Script:400' => 'Vujahday Script',
    'Waiting for the Sunrise:400' => 'Waiting for the Sunrise',
    'Wallpoet:400' => 'Wallpoet',
    'Walter Turncoat:400' => 'Walter Turncoat',
    'Warnes:400' => 'Warnes',
    'Water Brush:400' => 'Water Brush',
    'Waterfall:400' => 'Waterfall',
    'Wellfleet:400' => 'Wellfleet',
    'Wendy One:400' => 'Wendy One',
    'Whisper:400' => 'Whisper',
    'WindSong:400,500' => 'WindSong',
    'Wire One:400' => 'Wire One',
    'Work Sans:100,200,300,400,500,600,700,800,900,100italic,200italic,300italic,400italic,500italic,600italic,700italic,800italic,900italic' => 'Work Sans',
    'Xanh Mono:400,400italic' => 'Xanh Mono',
    'Yaldevi:200,300,400,500,600,700' => 'Yaldevi',
    'Yanone Kaffeesatz:200,300,400,500,600,700' => 'Yanone Kaffeesatz',
    'Yantramanav:100,300,400,500,700,900' => 'Yantramanav',
    'Yatra One:400' => 'Yatra One',
    'Yellowtail:400' => 'Yellowtail',
    'Yeon Sung:400' => 'Yeon Sung',
    'Yeseva One:400' => 'Yeseva One',
    'Yesteryear:400' => 'Yesteryear',
    'Yomogi:400' => 'Yomogi',
    'Yrsa:300,400,500,600,700,300italic,400italic,500italic,600italic,700italic' => 'Yrsa',
    'Yuji Boku:400' => 'Yuji Boku',
    'Yuji Mai:400' => 'Yuji Mai',
    'Yuji Syuku:400' => 'Yuji Syuku',
    'Yusei Magic:400' => 'Yusei Magic',
    'ZCOOL KuaiLe:400' => 'ZCOOL KuaiLe',
    'ZCOOL QingKe HuangYou:400' => 'ZCOOL QingKe HuangYou',
    'ZCOOL XiaoWei:400' => 'ZCOOL XiaoWei',
    'Zen Antique:400' => 'Zen Antique',
    'Zen Antique Soft:400' => 'Zen Antique Soft',
    'Zen Dots:400' => 'Zen Dots',
    'Zen Kaku Gothic Antique:300,400,500,700,900' => 'Zen Kaku Gothic Antique',
    'Zen Kaku Gothic New:300,400,500,700,900' => 'Zen Kaku Gothic New',
    'Zen Kurenaido:400' => 'Zen Kurenaido',
    'Zen Loop:400,400italic' => 'Zen Loop',
    'Zen Maru Gothic:300,400,500,700,900' => 'Zen Maru Gothic',
    'Zen Old Mincho:400,700,900' => 'Zen Old Mincho',
    'Zen Tokyo Zoo:400' => 'Zen Tokyo Zoo',
    'Zeyada:400' => 'Zeyada',
    'Zhi Mang Xing:400' => 'Zhi Mang Xing',
    'Zilla Slab:300,300italic,400,400italic,500,500italic,600,600italic,700,700italic' => 'Zilla Slab',
    'Zilla Slab Highlight:400,700' => 'Zilla Slab Highlight',
	);

	if ( array_key_exists( $input, $valid ) ) {
		return $input;
	} else {
		return '';
	}
}