<?php

function additional_user_fields( $user ) { ?>
	    <h3><?php echo esc_html_e( 'Add Photo Profile', 'mading' ); ?></h3>
		<?php wp_enqueue_media(); ?>
	
	    <script>
	    	jQuery(document).ready(function($){
			    var file_frame;
				$('.additional-user-image').on('click', function( event ){
				    event.preventDefault();
					
					if ( file_frame ) {
				    	file_frame.open();
						return;
					}
					
					file_frame = wp.media.frames.file_frame = wp.media({
					    title: $( this ).data( 'uploader_title' ),
						button: {
						text: $( this ).data( 'uploader_button_text' ),
					},
					multiple: false  
				});
				
				file_frame.on( 'select', function() {
			    	attachment = file_frame.state().get('selection').first().toJSON();
					jQuery(".foto").attr('value', attachment.url);
					jQuery('img.image-preview').attr('src', attachment.sizes.full.url);
				});
				
				file_frame.open();
			});
		});
	</script>
	
	<table id="upgrade" class="form-table">
        <tbody>
		<tr class="user-description-wrap">
			<th><label for="user_meta_image"><?php echo esc_html_e( 'Photo Profile', 'mading' ); ?></label></th>
			<td>
				<img class="image-preview" src="<?php echo esc_url( get_the_author_meta( 'user_meta_image', $user->ID ) ); ?>">
				<input type="hidden" name="user_meta_image" class="foto" id="user_meta_image" value="<?php echo esc_url_raw( get_the_author_meta( 'user_meta_image', $user->ID ) ); ?>" class="regular-text" />
				<input type='button' class="additional-user-image button-primary" value="<?php echo esc_attr_e( 'Upload Photo', 'mading' ); ?>" id="uploadimage"/><br />
				<p class="description"><?php echo esc_html_e( 'Add image to set as your profile picture.', 'mading' ); ?></p>
			</td>
		</tr>
	</table>
	
<?php } 

    add_action( 'show_user_profile', 'additional_user_fields' );
    add_action( 'edit_user_profile', 'additional_user_fields' );
	
	function save_additional_user_meta( $user_id ) {
    	if ( !current_user_can( 'edit_user', $user_id ) )
	    	return false;

	update_user_meta( $user_id, 'user_meta_image', isset($_POST['user_meta_image']) ? sanitize_text_field( wp_unslash( $_POST['user_meta_image'] ) ) : '' );
	}

	add_action( 'personal_options_update', 'save_additional_user_meta' );
	add_action( 'edit_user_profile_update', 'save_additional_user_meta' );
	
	function get_attachment_image_by_url( $url ) {
    	$parse_url  = explode( parse_url( WP_CONTENT_URL, PHP_URL_PATH ), $url );
		$this_host = str_ireplace( 'www.', '', parse_url( home_url(), PHP_URL_HOST ) );
        $file_host = str_ireplace( 'www.', '', parse_url( $url, PHP_URL_HOST ) );
		
		if ( !isset( $parse_url[1] ) || empty( $parse_url[1] ) || ( $this_host != $file_host ) ) {
	    	return;
        }
		
		global $wpdb;
 
        $prefix     = $wpdb->prefix;
        $attachment = $wpdb->get_col( $wpdb->prepare( "SELECT ID FROM " . $wpdb->prefix . "posts WHERE guid RLIKE %s;", $parse_url[1] ) );
		
		return $attachment[0];
    }
	
	function get_additional_user_meta_thumb() {
    	$attachment_url = esc_url( get_the_author_meta( 'user_meta_image', $post->post_author ) );
		$attachment_id = get_attachment_image_by_url( $attachment_url );
		$image_thumb = wp_get_attachment_image_src( $attachment_id, 'thumbnail' );
		return $image_thumb[0];
	}
	
	add_role('pendaftar',
            'Pendaftar',
            array(
                'read' => true,
				'upload_files' => true,
            )
    );

    add_role('guru',
            'Guru',
            array(
                'read' => true,
				'upload_files' => true,
            )
    );

    add_role('operator',
            'Operator',
            array(
                'read' => true,
				'upload_files' => true,
            )
    );
	
	add_role('master',
            'Kepala Sekolah',
            array(
                'read' => true,
				'upload_files' => true,
            )
    );
	
	add_role('siswa',
            'Siswa / Mahasiswa',
            array(
                'read' => true,
				'upload_files' => true,
            )
    );
	
function add_ppdb_caps() {
    // gets the ppdb role
    $madingcap = get_role( 'pendaftar' );

    $madingcap->add_cap( 'read' ); 
	$madingcap->add_cap( 'upload_files' );
	
    $madingcap->add_cap( 'edit_ppdb' ); 
    $madingcap->add_cap( 'edit_ppdbs' );
	$madingcap->add_cap( 'edit_other_ppdbs' );
    $madingcap->add_cap( 'edit_private_ppdbs' );
	$madingcap->add_cap( 'edit_published_ppdbs' );
    $madingcap->add_cap( 'read_ppdb' ); 
    $madingcap->add_cap( 'read_private_ppdbs' );
    $madingcap->add_cap( 'publish_ppdbs' );
    $madingcap->add_cap( 'delete_ppdb' ); 
    $madingcap->add_cap( 'delete_ppdbs' );
    $madingcap->add_cap( 'delete_private_ppdbs' );
    $madingcap->add_cap( 'delete_others_ppdbs' );
    $madingcap->add_cap( 'delete_published_ppdbs' ); 
	
}
add_action( 'admin_init', 'add_ppdb_caps');
	
function add_master_caps() {
    // gets the administrator role
    $madingcap = get_role( 'master' );

    $madingcap->add_cap( 'read' ); 
	$madingcap->add_cap( 'upload_files' );
	
        $madingcap->add_cap( 'edit_editorial' ); 
        $madingcap->add_cap( 'edit_editorials' );
	    $madingcap->add_cap( 'edit_other_editorials' );
    	$madingcap->add_cap( 'edit_private_editorials' );
	    $madingcap->add_cap( 'edit_published_editorials' );
    	$madingcap->add_cap( 'read_editorial' ); 
    	$madingcap->add_cap( 'read_private_editorials' );
    	$madingcap->add_cap( 'publish_editorials' );
    	$madingcap->add_cap( 'delete_editorial' ); 
        $madingcap->add_cap( 'delete_editorials' );
    	$madingcap->add_cap( 'delete_private_editorials' );
    	$madingcap->add_cap( 'delete_others_editorials' );
    	$madingcap->add_cap( 'delete_published_editorials' ); 
	
}
add_action( 'admin_init', 'add_master_caps');

function add_gurus_caps() {
    // gets the administrator role
    $madingcap = get_role( 'guru' );

    $madingcap->add_cap( 'read' ); 
	$madingcap->add_cap( 'upload_files' );
	
	    $madingcap->add_cap( 'edit_blog' ); 
        $madingcap->add_cap( 'edit_blogs' );
	    $madingcap->remove_cap( 'edit_other_blogs' );
    	$madingcap->add_cap( 'edit_private_blogs' );
	    $madingcap->add_cap( 'edit_published_blogs' );
    	$madingcap->add_cap( 'read_blog' ); 
    	$madingcap->add_cap( 'read_private_blogs' );
    	$madingcap->add_cap( 'publish_blogs' );
    	$madingcap->add_cap( 'delete_blog' ); 
        $madingcap->add_cap( 'delete_blogs' );
    	$madingcap->add_cap( 'delete_private_blogs' );
    	$madingcap->remove_cap( 'delete_others_blogs' );
    	$madingcap->add_cap( 'delete_published_blogs' ); 
	
	$madingcap->add_cap( 'manage_blogkat' ); 
	$madingcap->add_cap( 'assign_blogkat' ); 
	$madingcap->add_cap( 'edit_blogkat' ); 
	
        $madingcap->add_cap( 'edit_down' ); 
        $madingcap->add_cap( 'edit_downs' );
	    $madingcap->remove_cap( 'edit_other_downs' );
    	$madingcap->add_cap( 'edit_private_downs' );
	    $madingcap->add_cap( 'edit_published_downs' );
    	$madingcap->add_cap( 'read_down' ); 
    	$madingcap->add_cap( 'read_private_downs' );
    	$madingcap->add_cap( 'publish_downs' );
    	$madingcap->add_cap( 'delete_down' ); 
        $madingcap->add_cap( 'delete_downs' );
    	$madingcap->add_cap( 'delete_private_downs' );
    	$madingcap->remove_cap( 'delete_others_downs' );
    	$madingcap->add_cap( 'delete_published_downs' ); 
		
	$madingcap->add_cap( 'manage_catdown' ); 
	$madingcap->add_cap( 'assign_catdown' ); 
	$madingcap->add_cap( 'edit_catdown' ); 
	
	$madingcap->add_cap( 'manage_typedown' ); 
	$madingcap->add_cap( 'assign_typedown' ); 
	$madingcap->add_cap( 'edit_typedown' ); 
		
	if ( get_theme_mod('sekolah_type') == "akademi" ) {
        $madingcap->add_cap( 'edit_dosen' ); 
        $madingcap->add_cap( 'edit_dosens' );
	    $madingcap->remove_cap( 'edit_other_dosens' );
    	$madingcap->add_cap( 'edit_private_dosens' );
	    $madingcap->add_cap( 'edit_published_dosens' );
    	$madingcap->add_cap( 'read_dosen' ); 
    	$madingcap->add_cap( 'read_private_dosens' );
    	$madingcap->add_cap( 'publish_dosens' );
    	$madingcap->add_cap( 'delete_dosen' ); 
        $madingcap->add_cap( 'delete_dosens' );
    	$madingcap->add_cap( 'delete_private_dosens' );
    	$madingcap->remove_cap( 'delete_others_dosens' );
    	$madingcap->add_cap( 'delete_published_dosens' ); 
	} else if ( get_theme_mod('sekolah_type') == "pesantren" ) {
        $madingcap->add_cap( 'edit_ustadz' ); 
        $madingcap->add_cap( 'edit_ustadzs' );
	    $madingcap->remove_cap( 'edit_other_ustadzs' );
    	$madingcap->add_cap( 'edit_private_ustadzs' );
	    $madingcap->add_cap( 'edit_published_ustadzs' );
    	$madingcap->add_cap( 'read_ustadz' ); 
    	$madingcap->add_cap( 'read_private_ustadzs' );
    	$madingcap->add_cap( 'publish_ustadzs' );
    	$madingcap->add_cap( 'delete_ustadz' ); 
        $madingcap->add_cap( 'delete_ustadzs' );
    	$madingcap->add_cap( 'delete_private_ustadzs' );
    	$madingcap->remove_cap( 'delete_others_ustadzs' );
    	$madingcap->add_cap( 'delete_published_ustadzs' ); 
	} else {
        $madingcap->add_cap( 'edit_guru' ); 
        $madingcap->add_cap( 'edit_gurus' );
	    $madingcap->remove_cap( 'edit_other_gurus' );
    	$madingcap->add_cap( 'edit_private_gurus' );
	    $madingcap->add_cap( 'edit_published_gurus' );
    	$madingcap->add_cap( 'read_guru' ); 
    	$madingcap->add_cap( 'read_private_gurus' );
    	$madingcap->add_cap( 'publish_gurus' );
    	$madingcap->add_cap( 'delete_guru' ); 
        $madingcap->add_cap( 'delete_gurus' );
    	$madingcap->add_cap( 'delete_private_gurus' );
    	$madingcap->remove_cap( 'delete_others_gurus' );
    	$madingcap->add_cap( 'delete_published_gurus' ); 
	}
	
	$madingcap->add_cap( 'manage_jab' ); 
	$madingcap->add_cap( 'assign_jab' ); 
	$madingcap->add_cap( 'edit_jab' ); 
	
	$madingcap->add_cap( 'manage_stts' ); 
	$madingcap->add_cap( 'assign_stts' ); 
	$madingcap->add_cap( 'edit_stts' ); 
	
	$madingcap->add_cap( 'manage_structure' ); 
	$madingcap->add_cap( 'assign_structure' ); 
	$madingcap->add_cap( 'edit_structure' ); 
	
	    $madingcap->add_cap( 'edit_tugas' ); 
        $madingcap->add_cap( 'edit_tugass' );
	    $madingcap->remove_cap( 'edit_other_tugass' );
    	$madingcap->add_cap( 'edit_private_tugass' );
	    $madingcap->add_cap( 'edit_published_tugass' );
    	$madingcap->add_cap( 'read_tugas' ); 
    	$madingcap->add_cap( 'read_private_tugass' );
    	$madingcap->add_cap( 'publish_tugass' );
    	$madingcap->add_cap( 'delete_tugas' ); 
        $madingcap->add_cap( 'delete_tugass' );
    	$madingcap->add_cap( 'delete_private_tugass' );
    	$madingcap->remove_cap( 'delete_others_tugass' );
    	$madingcap->add_cap( 'delete_published_tugass' );
		
	$madingcap->add_cap( 'manage_level' ); 
   	$madingcap->add_cap( 'assign_level' ); 
	$madingcap->add_cap( 'edit_level' );
	
	$madingcap->add_cap( 'manage_mapel' ); 
   	$madingcap->add_cap( 'assign_mapel' ); 
	$madingcap->add_cap( 'edit_mapel' );
}
add_action( 'admin_init', 'add_gurus_caps');

function add_operator_caps() {
    
    $madingcap = get_role( 'operator' );

    $madingcap->add_cap( 'read' ); 
	$madingcap->add_cap( 'upload_files' );
	
        $madingcap->add_cap( 'edit_acara' ); 
        $madingcap->add_cap( 'edit_acaras' );
	    $madingcap->add_cap( 'edit_other_acaras' );
    	$madingcap->add_cap( 'edit_private_acaras' );
	    $madingcap->add_cap( 'edit_published_acaras' );
    	$madingcap->add_cap( 'read_acara' ); 
    	$madingcap->add_cap( 'read_private_acaras' );
    	$madingcap->add_cap( 'publish_acaras' );
    	$madingcap->add_cap( 'delete_acara' ); 
        $madingcap->add_cap( 'delete_acaras' );
    	$madingcap->add_cap( 'delete_private_acaras' );
    	$madingcap->add_cap( 'delete_others_acaras' );
    	$madingcap->add_cap( 'delete_published_acaras' ); 
		
		$madingcap->add_cap( 'edit_post' ); 
        $madingcap->add_cap( 'edit_posts' );
	    $madingcap->add_cap( 'edit_other_posts' );
    	$madingcap->add_cap( 'edit_private_posts' );
	    $madingcap->add_cap( 'edit_published_posts' );
    	$madingcap->add_cap( 'read_post' ); 
    	$madingcap->add_cap( 'read_private_posts' );
    	$madingcap->add_cap( 'publish_posts' );
    	$madingcap->add_cap( 'delete_post' ); 
        $madingcap->add_cap( 'delete_posts' );
    	$madingcap->add_cap( 'delete_private_posts' );
    	$madingcap->add_cap( 'delete_others_posts' );
    	$madingcap->add_cap( 'delete_published_posts' ); 
		
	$madingcap->add_cap( 'manage_categories' ); 
	$madingcap->add_cap( 'assign_categories' ); 
	$madingcap->add_cap( 'edit_categories' ); 
	$madingcap->add_cap( 'delete_categories' ); 
		
		$madingcap->add_cap( 'edit_page' ); 
        $madingcap->add_cap( 'edit_pages' );
	    $madingcap->add_cap( 'edit_other_pages' );
    	$madingcap->add_cap( 'edit_private_pages' );
	    $madingcap->add_cap( 'edit_published_pages' );
    	$madingcap->add_cap( 'read_page' ); 
    	$madingcap->add_cap( 'read_private_pages' );
    	$madingcap->add_cap( 'publish_pages' );
    	$madingcap->add_cap( 'delete_page' ); 
        $madingcap->add_cap( 'delete_pages' );
    	$madingcap->add_cap( 'delete_private_pages' );
    	$madingcap->add_cap( 'delete_others_pages' );
    	$madingcap->add_cap( 'delete_published_pages' ); 
		
	if ( get_theme_mod('sekolah_type') != "akademi" ) {
        $madingcap->add_cap( 'edit_extra' ); 
        $madingcap->add_cap( 'edit_extras' );
	    $madingcap->add_cap( 'edit_other_extras' );
    	$madingcap->add_cap( 'edit_private_extras' );
	    $madingcap->add_cap( 'edit_published_extras' );
    	$madingcap->add_cap( 'read_extra' ); 
    	$madingcap->add_cap( 'read_private_extras' );
    	$madingcap->add_cap( 'publish_extras' );
    	$madingcap->add_cap( 'delete_extra' ); 
        $madingcap->add_cap( 'delete_extras' );
    	$madingcap->add_cap( 'delete_private_extras' );
    	$madingcap->add_cap( 'delete_others_extras' );
    	$madingcap->add_cap( 'delete_published_extras' ); 
	} else {
        $madingcap->add_cap( 'edit_kegiatan' ); 
        $madingcap->add_cap( 'edit_kegiatans' );
	    $madingcap->add_cap( 'edit_other_kegiatans' );
    	$madingcap->add_cap( 'edit_private_kegiatans' );
	    $madingcap->add_cap( 'edit_published_kegiatans' );
    	$madingcap->add_cap( 'read_kegiatan' ); 
    	$madingcap->add_cap( 'read_private_kegiatans' );
    	$madingcap->add_cap( 'publish_kegiatans' );
    	$madingcap->add_cap( 'delete_kegiatan' ); 
        $madingcap->add_cap( 'delete_kegiatans' );
    	$madingcap->add_cap( 'delete_private_kegiatans' );
    	$madingcap->add_cap( 'delete_others_kegiatans' );
    	$madingcap->add_cap( 'delete_published_kegiatans' ); 
	}
        $madingcap->add_cap( 'edit_fasil' ); 
        $madingcap->add_cap( 'edit_fasils' );
	    $madingcap->add_cap( 'edit_other_fasils' );
    	$madingcap->add_cap( 'edit_private_fasils' );
	    $madingcap->add_cap( 'edit_published_fasils' );
    	$madingcap->add_cap( 'read_fasil' ); 
    	$madingcap->add_cap( 'read_private_fasils' );
    	$madingcap->add_cap( 'publish_fasils' );
    	$madingcap->add_cap( 'delete_fasil' ); 
        $madingcap->add_cap( 'delete_fasils' );
    	$madingcap->add_cap( 'delete_private_fasils' );
    	$madingcap->add_cap( 'delete_others_fasils' );
    	$madingcap->add_cap( 'delete_published_fasils' ); 
		
        $madingcap->add_cap( 'edit_galer' ); 
        $madingcap->add_cap( 'edit_galers' );
	    $madingcap->add_cap( 'edit_other_galers' );
    	$madingcap->add_cap( 'edit_private_galers' );
	    $madingcap->add_cap( 'edit_published_galers' );
    	$madingcap->add_cap( 'read_galer' ); 
    	$madingcap->add_cap( 'read_private_galers' );
    	$madingcap->add_cap( 'publish_galers' );
    	$madingcap->add_cap( 'delete_galer' ); 
        $madingcap->add_cap( 'delete_galers' );
    	$madingcap->add_cap( 'delete_private_galers' );
    	$madingcap->add_cap( 'delete_others_galers' );
    	$madingcap->add_cap( 'delete_published_galers' ); 
		
	if ( get_theme_mod('sekolah_type') == "akademi" ) {
        $madingcap->add_cap( 'edit_maha' ); 
        $madingcap->add_cap( 'edit_mahas' );
	    $madingcap->add_cap( 'edit_other_mahas' );
    	$madingcap->add_cap( 'edit_private_mahas' );
	    $madingcap->add_cap( 'edit_published_mahas' );
    	$madingcap->add_cap( 'read_maha' ); 
    	$madingcap->add_cap( 'read_private_mahas' );
    	$madingcap->add_cap( 'publish_mahas' );
    	$madingcap->add_cap( 'delete_maha' ); 
        $madingcap->add_cap( 'delete_mahas' );
    	$madingcap->add_cap( 'delete_private_mahas' );
    	$madingcap->add_cap( 'delete_others_mahas' );
    	$madingcap->add_cap( 'delete_published_mahas' ); 
	} else if ( get_theme_mod('sekolah_type') == "pesantren" ) {
        $madingcap->add_cap( 'edit_santri' ); 
        $madingcap->add_cap( 'edit_santris' );
	    $madingcap->add_cap( 'edit_other_santris' );
    	$madingcap->add_cap( 'edit_private_santris' );
	    $madingcap->add_cap( 'edit_published_santris' );
    	$madingcap->add_cap( 'read_santri' ); 
    	$madingcap->add_cap( 'read_private_santris' );
    	$madingcap->add_cap( 'publish_santris' );
    	$madingcap->add_cap( 'delete_santri' ); 
        $madingcap->add_cap( 'delete_santris' );
    	$madingcap->add_cap( 'delete_private_santris' );
    	$madingcap->add_cap( 'delete_others_santris' );
    	$madingcap->add_cap( 'delete_published_santris' ); 
	} else {
        $madingcap->add_cap( 'edit_siswa' ); 
        $madingcap->add_cap( 'edit_siswas' );
	    $madingcap->add_cap( 'edit_other_siswas' );
    	$madingcap->add_cap( 'edit_private_siswas' );
	    $madingcap->add_cap( 'edit_published_siswas' );
    	$madingcap->add_cap( 'read_siswa' ); 
    	$madingcap->add_cap( 'read_private_siswas' );
    	$madingcap->add_cap( 'publish_siswas' );
    	$madingcap->add_cap( 'delete_siswa' ); 
        $madingcap->add_cap( 'delete_siswas' );
    	$madingcap->add_cap( 'delete_private_siswas' );
    	$madingcap->add_cap( 'delete_others_siswas' );
    	$madingcap->add_cap( 'delete_published_siswas' ); 
	}
	
	    $madingcap->add_cap( 'manage_fak' ); 
     	$madingcap->add_cap( 'assign_fak' ); 
     	$madingcap->add_cap( 'edit_fak' );
    	$madingcap->add_cap( 'delete_fak' );
		
		$madingcap->add_cap( 'manage_kel' ); 
     	$madingcap->add_cap( 'assign_kel' ); 
     	$madingcap->add_cap( 'edit_kel' );
    	$madingcap->add_cap( 'delete_kel' );
	
        $madingcap->add_cap( 'edit_peng' ); 
        $madingcap->add_cap( 'edit_pengs' );
	    $madingcap->add_cap( 'edit_other_pengs' );
    	$madingcap->add_cap( 'edit_private_pengs' );
	    $madingcap->add_cap( 'edit_published_pengs' );
    	$madingcap->add_cap( 'read_peng' ); 
    	$madingcap->add_cap( 'read_private_pengs' );
    	$madingcap->add_cap( 'publish_pengs' );
    	$madingcap->add_cap( 'delete_peng' ); 
        $madingcap->add_cap( 'delete_pengs' );
    	$madingcap->add_cap( 'delete_private_pengs' );
    	$madingcap->add_cap( 'delete_others_pengs' );
    	$madingcap->add_cap( 'delete_published_pengs' ); 
		
		$madingcap->add_cap( 'edit_prest' ); 
        $madingcap->add_cap( 'edit_prests' );
	    $madingcap->add_cap( 'edit_other_prests' );
    	$madingcap->add_cap( 'edit_private_prests' );
	    $madingcap->add_cap( 'edit_published_prests' );
    	$madingcap->add_cap( 'read_prest' ); 
    	$madingcap->add_cap( 'read_private_prests' );
    	$madingcap->add_cap( 'publish_prests' );
    	$madingcap->add_cap( 'delete_prest' ); 
        $madingcap->add_cap( 'delete_prests' );
    	$madingcap->add_cap( 'delete_private_prests' );
    	$madingcap->add_cap( 'delete_others_prests' );
    	$madingcap->add_cap( 'delete_published_prests' ); 
		
        $madingcap->add_cap( 'edit_quot' ); 
        $madingcap->add_cap( 'edit_quots' );
	    $madingcap->add_cap( 'edit_other_quots' );
    	$madingcap->add_cap( 'edit_private_quots' );
	    $madingcap->add_cap( 'edit_published_quots' );
    	$madingcap->add_cap( 'read_quot' ); 
    	$madingcap->add_cap( 'read_private_quots' );
    	$madingcap->add_cap( 'publish_quots' );
    	$madingcap->add_cap( 'delete_quot' ); 
        $madingcap->add_cap( 'delete_quots' );
    	$madingcap->add_cap( 'delete_private_quots' );
    	$madingcap->add_cap( 'delete_others_quots' );
    	$madingcap->add_cap( 'delete_published_quots' ); 
		
        $madingcap->add_cap( 'edit_slide' ); 
        $madingcap->add_cap( 'edit_slides' );
	    $madingcap->add_cap( 'edit_other_slides' );
    	$madingcap->add_cap( 'edit_private_slides' );
	    $madingcap->add_cap( 'edit_published_slides' );
    	$madingcap->add_cap( 'read_slide' ); 
    	$madingcap->add_cap( 'read_private_slides' );
    	$madingcap->add_cap( 'publish_slides' );
    	$madingcap->add_cap( 'delete_slide' ); 
        $madingcap->add_cap( 'delete_slides' );
    	$madingcap->add_cap( 'delete_private_slides' );
    	$madingcap->add_cap( 'delete_others_slides' );
    	$madingcap->add_cap( 'delete_published_slides' ); 
		
        $madingcap->add_cap( 'edit_vidio' ); 
        $madingcap->add_cap( 'edit_vidios' );
	    $madingcap->add_cap( 'edit_other_vidios' );
    	$madingcap->add_cap( 'edit_private_vidios' );
	    $madingcap->add_cap( 'edit_published_vidios' );
    	$madingcap->add_cap( 'read_vidio' ); 
    	$madingcap->add_cap( 'read_private_vidios' );
    	$madingcap->add_cap( 'publish_vidios' );
    	$madingcap->add_cap( 'delete_vidio' ); 
        $madingcap->add_cap( 'delete_vidios' );
    	$madingcap->add_cap( 'delete_private_vidios' );
    	$madingcap->add_cap( 'delete_others_vidios' );
    	$madingcap->add_cap( 'delete_published_vidios' ); 
		
	if ( post_type_exists( 'alumni' ) ) {
		$madingcap->add_cap( 'edit_alumni' ); 
        $madingcap->add_cap( 'edit_alumnis' );
	    $madingcap->add_cap( 'edit_other_alumnis' );
    	$madingcap->add_cap( 'edit_private_alumnis' );
	    $madingcap->add_cap( 'edit_published_alumnis' );
    	$madingcap->add_cap( 'read_alumni' ); 
    	$madingcap->add_cap( 'read_private_alumnis' );
    	$madingcap->add_cap( 'publish_alumnis' );
    	$madingcap->add_cap( 'delete_alumni' ); 
        $madingcap->add_cap( 'delete_alumnis' );
    	$madingcap->add_cap( 'delete_private_alumnis' );
    	$madingcap->add_cap( 'delete_others_alumnis' );
    	$madingcap->add_cap( 'delete_published_alumnis' );
	}

if ( get_theme_mod( 'operator_cap' ) == 'on' ) {
	
	
	    $madingcap->add_cap( 'edit_blog' ); 
        $madingcap->add_cap( 'edit_blogs' );
	    $madingcap->add_cap( 'edit_other_blogs' );
    	$madingcap->add_cap( 'edit_private_blogs' );
	    $madingcap->add_cap( 'edit_published_blogs' );
    	$madingcap->add_cap( 'read_blog' ); 
    	$madingcap->add_cap( 'read_private_blogs' );
    	$madingcap->add_cap( 'publish_blogs' );
    	$madingcap->add_cap( 'delete_blog' ); 
        $madingcap->add_cap( 'delete_blogs' );
    	$madingcap->add_cap( 'delete_private_blogs' );
    	$madingcap->add_cap( 'delete_others_blogs' );
    	$madingcap->add_cap( 'delete_published_blogs' ); 
	
	$madingcap->add_cap( 'manage_blogkat' ); 
	$madingcap->add_cap( 'assign_blogkat' ); 
	$madingcap->add_cap( 'edit_blogkat' ); 
	$madingcap->add_cap( 'delete_blogkat' ); 
		
        $madingcap->add_cap( 'edit_down' ); 
        $madingcap->add_cap( 'edit_downs' );
	    $madingcap->add_cap( 'edit_other_downs' );
    	$madingcap->add_cap( 'edit_private_downs' );
	    $madingcap->add_cap( 'edit_published_downs' );
    	$madingcap->add_cap( 'read_down' ); 
    	$madingcap->add_cap( 'read_private_downs' );
    	$madingcap->add_cap( 'publish_downs' );
    	$madingcap->add_cap( 'delete_down' ); 
        $madingcap->add_cap( 'delete_downs' );
    	$madingcap->add_cap( 'delete_private_downs' );
    	$madingcap->add_cap( 'delete_others_downs' );
    	$madingcap->add_cap( 'delete_published_downs' ); 
		
	$madingcap->add_cap( 'manage_catdown' ); 
	$madingcap->add_cap( 'assign_catdown' ); 
	$madingcap->add_cap( 'edit_catdown' ); 
	$madingcap->add_cap( 'delete_catdown' );
	
	$madingcap->add_cap( 'manage_typedown' ); 
	$madingcap->add_cap( 'assign_typedown' ); 
	$madingcap->add_cap( 'edit_typedown' ); 
	$madingcap->add_cap( 'delete_typedown' ); 
	
	    $madingcap->add_cap( 'edit_ppdb' ); 
        $madingcap->add_cap( 'edit_ppdbs' );
	    $madingcap->add_cap( 'edit_other_ppdbs' );
    	$madingcap->add_cap( 'edit_private_ppdbs' );
	    $madingcap->add_cap( 'edit_published_ppdbs' );
    	$madingcap->add_cap( 'read_ppdb' ); 
    	$madingcap->add_cap( 'read_private_ppdbs' );
    	$madingcap->add_cap( 'publish_ppdbs' );
    	$madingcap->add_cap( 'delete_ppdb' ); 
        $madingcap->add_cap( 'delete_ppdbs' );
    	$madingcap->add_cap( 'delete_private_ppdbs' );
    	$madingcap->add_cap( 'delete_others_ppdbs' );
    	$madingcap->add_cap( 'delete_published_ppdbs' ); 
		
if ( get_theme_mod('sekolah_type') == "akademi" ) {
        $madingcap->add_cap( 'edit_dosen' ); 
        $madingcap->add_cap( 'edit_dosens' );
	    $madingcap->add_cap( 'edit_other_dosens' );
    	$madingcap->add_cap( 'edit_private_dosens' );
	    $madingcap->add_cap( 'edit_published_dosens' );
    	$madingcap->add_cap( 'read_dosen' ); 
    	$madingcap->add_cap( 'read_private_dosens' );
    	$madingcap->add_cap( 'publish_dosens' );
    	$madingcap->add_cap( 'delete_dosen' ); 
        $madingcap->add_cap( 'delete_dosens' );
    	$madingcap->add_cap( 'delete_private_dosens' );
    	$madingcap->add_cap( 'delete_others_dosens' );
    	$madingcap->add_cap( 'delete_published_dosens' ); 
	} else if ( get_theme_mod('sekolah_type') == "pesantren" ) {
        $madingcap->add_cap( 'edit_ustadz' ); 
        $madingcap->add_cap( 'edit_ustadzs' );
	    $madingcap->add_cap( 'edit_other_ustadzs' );
    	$madingcap->add_cap( 'edit_private_ustadzs' );
	    $madingcap->add_cap( 'edit_published_ustadzs' );
    	$madingcap->add_cap( 'read_ustadz' ); 
    	$madingcap->add_cap( 'read_private_ustadzs' );
    	$madingcap->add_cap( 'publish_ustadzs' );
    	$madingcap->add_cap( 'delete_ustadz' ); 
        $madingcap->add_cap( 'delete_ustadzs' );
    	$madingcap->add_cap( 'delete_private_ustadzs' );
    	$madingcap->add_cap( 'delete_others_ustadzs' );
    	$madingcap->add_cap( 'delete_published_ustadzs' ); 
	} else {
        $madingcap->add_cap( 'edit_guru' ); 
        $madingcap->add_cap( 'edit_gurus' );
	    $madingcap->add_cap( 'edit_other_gurus' );
    	$madingcap->add_cap( 'edit_private_gurus' );
	    $madingcap->add_cap( 'edit_published_gurus' );
    	$madingcap->add_cap( 'read_guru' ); 
    	$madingcap->add_cap( 'read_private_gurus' );
    	$madingcap->add_cap( 'publish_gurus' );
    	$madingcap->add_cap( 'delete_guru' ); 
        $madingcap->add_cap( 'delete_gurus' );
    	$madingcap->add_cap( 'delete_private_gurus' );
    	$madingcap->add_cap( 'delete_others_gurus' );
    	$madingcap->add_cap( 'delete_published_gurus' ); 
	}
	
	$madingcap->add_cap( 'manage_jab' ); 
	$madingcap->add_cap( 'assign_jab' ); 
	$madingcap->add_cap( 'edit_jab' ); 
	$madingcap->add_cap( 'delete_jab' ); 
	
	$madingcap->add_cap( 'manage_stts' ); 
	$madingcap->add_cap( 'assign_stts' ); 
	$madingcap->add_cap( 'edit_stts' ); 
	$madingcap->add_cap( 'detele_stts' ); 
	
	$madingcap->add_cap( 'manage_structure' ); 
	$madingcap->add_cap( 'assign_structure' ); 
	$madingcap->add_cap( 'edit_structure' ); 
	$madingcap->add_cap( 'detele_structure' ); 
	
        $madingcap->add_cap( 'edit_editorial' ); 
        $madingcap->add_cap( 'edit_editorials' );
	    $madingcap->add_cap( 'edit_other_editorials' );
    	$madingcap->add_cap( 'edit_private_editorials' );
	    $madingcap->add_cap( 'edit_published_editorials' );
    	$madingcap->add_cap( 'read_editorial' ); 
    	$madingcap->add_cap( 'read_private_editorials' );
    	$madingcap->add_cap( 'publish_editorials' );
    	$madingcap->add_cap( 'delete_editorial' ); 
        $madingcap->add_cap( 'delete_editorials' );
    	$madingcap->add_cap( 'delete_private_editorials' );
    	$madingcap->add_cap( 'delete_others_editorials' );
    	$madingcap->add_cap( 'delete_published_editorials' ); 
		
		$madingcap->add_cap( 'edit_tugas' ); 
        $madingcap->add_cap( 'edit_tugass' );
	    $madingcap->add_cap( 'edit_other_tugass' );
    	$madingcap->add_cap( 'edit_private_tugass' );
	    $madingcap->add_cap( 'edit_published_tugass' );
    	$madingcap->add_cap( 'read_tugas' ); 
    	$madingcap->add_cap( 'read_private_tugass' );
    	$madingcap->add_cap( 'publish_tugass' );
    	$madingcap->add_cap( 'delete_tugas' ); 
        $madingcap->add_cap( 'delete_tugass' );
    	$madingcap->add_cap( 'delete_private_tugass' );
    	$madingcap->add_cap( 'delete_others_tugass' );
    	$madingcap->add_cap( 'delete_published_tugass' );
		
	$madingcap->add_cap( 'manage_level' ); 
   	$madingcap->add_cap( 'assign_level' ); 
	$madingcap->add_cap( 'edit_level' );
	$madingcap->add_cap( 'delete_level' );
	
	$madingcap->add_cap( 'manage_mapel' ); 
   	$madingcap->add_cap( 'assign_mapel' ); 
	$madingcap->add_cap( 'edit_mapel' );
	$madingcap->add_cap( 'delete_mapel' );

} else {
	
	    $madingcap->remove_cap( 'edit_blog' ); 
        $madingcap->remove_cap( 'edit_blogs' );
	    $madingcap->remove_cap( 'edit_other_blogs' );
    	$madingcap->remove_cap( 'edit_private_blogs' );
	    $madingcap->remove_cap( 'edit_published_blogs' );
    	$madingcap->remove_cap( 'read_blog' ); 
    	$madingcap->remove_cap( 'read_private_blogs' );
    	$madingcap->remove_cap( 'publish_blogs' );
    	$madingcap->remove_cap( 'delete_blog' ); 
        $madingcap->remove_cap( 'delete_blogs' );
    	$madingcap->remove_cap( 'delete_private_blogs' );
    	$madingcap->remove_cap( 'delete_others_blogs' );
    	$madingcap->remove_cap( 'delete_published_blogs' ); 
	
	$madingcap->remove_cap( 'manage_blogkat' ); 
	$madingcap->remove_cap( 'assign_blogkat' ); 
	$madingcap->remove_cap( 'edit_blogkat' ); 
	$madingcap->remove_cap( 'delete_blogkat' ); 
		
        $madingcap->remove_cap( 'edit_down' ); 
        $madingcap->remove_cap( 'edit_downs' );
	    $madingcap->remove_cap( 'edit_other_downs' );
    	$madingcap->remove_cap( 'edit_private_downs' );
	    $madingcap->remove_cap( 'edit_published_downs' );
    	$madingcap->remove_cap( 'read_down' ); 
    	$madingcap->remove_cap( 'read_private_downs' );
    	$madingcap->remove_cap( 'publish_downs' );
    	$madingcap->remove_cap( 'delete_down' ); 
        $madingcap->remove_cap( 'delete_downs' );
    	$madingcap->remove_cap( 'delete_private_downs' );
    	$madingcap->remove_cap( 'delete_others_downs' );
    	$madingcap->remove_cap( 'delete_published_downs' ); 
		
	$madingcap->remove_cap( 'manage_catdown' ); 
	$madingcap->remove_cap( 'assign_catdown' ); 
	$madingcap->remove_cap( 'edit_catdown' ); 
	$madingcap->remove_cap( 'delete_catdown' );
	
	$madingcap->remove_cap( 'manage_typedown' ); 
	$madingcap->remove_cap( 'assign_typedown' ); 
	$madingcap->remove_cap( 'edit_typedown' ); 
	$madingcap->remove_cap( 'delete_typedown' ); 
		
if ( get_theme_mod('sekolah_type') == "akademi" ) {
        $madingcap->remove_cap( 'edit_dosen' ); 
        $madingcap->remove_cap( 'edit_dosens' );
	    $madingcap->remove_cap( 'edit_other_dosens' );
    	$madingcap->remove_cap( 'edit_private_dosens' );
	    $madingcap->remove_cap( 'edit_published_dosens' );
    	$madingcap->remove_cap( 'read_dosen' ); 
    	$madingcap->remove_cap( 'read_private_dosens' );
    	$madingcap->remove_cap( 'publish_dosens' );
    	$madingcap->remove_cap( 'delete_dosen' ); 
        $madingcap->remove_cap( 'delete_dosens' );
    	$madingcap->remove_cap( 'delete_private_dosens' );
    	$madingcap->remove_cap( 'delete_others_dosens' );
    	$madingcap->remove_cap( 'delete_published_dosens' ); 
	} else if ( get_theme_mod('sekolah_type') == "pesantren" ) {
        $madingcap->remove_cap( 'edit_ustadz' ); 
        $madingcap->remove_cap( 'edit_ustadzs' );
	    $madingcap->remove_cap( 'edit_other_ustadzs' );
    	$madingcap->remove_cap( 'edit_private_ustadzs' );
	    $madingcap->remove_cap( 'edit_published_ustadzs' );
    	$madingcap->remove_cap( 'read_ustadz' ); 
    	$madingcap->remove_cap( 'read_private_ustadzs' );
    	$madingcap->remove_cap( 'publish_ustadzs' );
    	$madingcap->remove_cap( 'delete_ustadz' ); 
        $madingcap->remove_cap( 'delete_ustadzs' );
    	$madingcap->remove_cap( 'delete_private_ustadzs' );
    	$madingcap->remove_cap( 'delete_others_ustadzs' );
    	$madingcap->remove_cap( 'delete_published_ustadzs' ); 
	} else {
        $madingcap->remove_cap( 'edit_guru' ); 
        $madingcap->remove_cap( 'edit_gurus' );
	    $madingcap->remove_cap( 'edit_other_gurus' );
    	$madingcap->remove_cap( 'edit_private_gurus' );
	    $madingcap->remove_cap( 'edit_published_gurus' );
    	$madingcap->remove_cap( 'read_guru' ); 
    	$madingcap->remove_cap( 'read_private_gurus' );
    	$madingcap->remove_cap( 'publish_gurus' );
    	$madingcap->remove_cap( 'delete_guru' ); 
        $madingcap->remove_cap( 'delete_gurus' );
    	$madingcap->remove_cap( 'delete_private_gurus' );
    	$madingcap->remove_cap( 'delete_others_gurus' );
    	$madingcap->remove_cap( 'delete_published_gurus' ); 
	}
	
	$madingcap->remove_cap( 'manage_jab' ); 
	$madingcap->remove_cap( 'assign_jab' ); 
	$madingcap->remove_cap( 'edit_jab' ); 
	$madingcap->remove_cap( 'delete_jab' ); 
	
	$madingcap->remove_cap( 'manage_stts' ); 
	$madingcap->remove_cap( 'assign_stts' ); 
	$madingcap->remove_cap( 'edit_stts' ); 
	$madingcap->remove_cap( 'detele_stts' ); 
	
	$madingcap->add_cap( 'manage_structure' ); 
	$madingcap->add_cap( 'assign_structure' ); 
	$madingcap->add_cap( 'edit_structure' ); 
	$madingcap->add_cap( 'detele_structure' ); 
	
        $madingcap->remove_cap( 'edit_editorial' ); 
        $madingcap->remove_cap( 'edit_editorials' );
	    $madingcap->remove_cap( 'edit_other_editorials' );
    	$madingcap->remove_cap( 'edit_private_editorials' );
	    $madingcap->remove_cap( 'edit_published_editorials' );
    	$madingcap->remove_cap( 'read_editorial' ); 
    	$madingcap->remove_cap( 'read_private_editorials' );
    	$madingcap->remove_cap( 'publish_editorials' );
    	$madingcap->remove_cap( 'delete_editorial' ); 
        $madingcap->remove_cap( 'delete_editorials' );
    	$madingcap->remove_cap( 'delete_private_editorials' );
    	$madingcap->remove_cap( 'delete_others_editorials' );
    	$madingcap->remove_cap( 'delete_published_editorials' ); 
		
		$madingcap->remove_cap( 'edit_tugas' ); 
        $madingcap->remove_cap( 'edit_tugass' );
	    $madingcap->remove_cap( 'edit_other_tugass' );
    	$madingcap->remove_cap( 'edit_private_tugass' );
	    $madingcap->remove_cap( 'edit_published_tugass' );
    	$madingcap->remove_cap( 'read_tugas' ); 
    	$madingcap->remove_cap( 'read_private_tugass' );
    	$madingcap->remove_cap( 'publish_tugass' );
    	$madingcap->remove_cap( 'delete_tugas' ); 
        $madingcap->remove_cap( 'delete_tugass' );
    	$madingcap->remove_cap( 'delete_private_tugass' );
    	$madingcap->remove_cap( 'delete_others_tugass' );
    	$madingcap->remove_cap( 'delete_published_tugass' );
		
	$madingcap->remove_cap( 'manage_level' ); 
   	$madingcap->remove_cap( 'assign_level' ); 
	$madingcap->remove_cap( 'edit_level' );
	$madingcap->remove_cap( 'delete_level' );
	
	$madingcap->remove_cap( 'manage_mapel' ); 
   	$madingcap->remove_cap( 'assign_mapel' ); 
	$madingcap->remove_cap( 'edit_mapel' );
	$madingcap->remove_cap( 'delete_mapel' );
	
}
	
}
add_action( 'admin_init', 'add_operator_caps');

function add_ngadimin_caps() {
    
    $madingcap = get_role( 'administrator' );
	
	$madingcap->add_cap( 'upload_files' );
	
        $madingcap->add_cap( 'edit_acara' ); 
        $madingcap->add_cap( 'edit_acaras' );
	    $madingcap->add_cap( 'edit_other_acaras' );
    	$madingcap->add_cap( 'edit_private_acaras' );
	    $madingcap->add_cap( 'edit_published_acaras' );
    	$madingcap->add_cap( 'read_acara' ); 
    	$madingcap->add_cap( 'read_private_acaras' );
    	$madingcap->add_cap( 'publish_acaras' );
    	$madingcap->add_cap( 'delete_acara' ); 
        $madingcap->add_cap( 'delete_acaras' );
    	$madingcap->add_cap( 'delete_private_acaras' );
    	$madingcap->add_cap( 'delete_others_acaras' );
    	$madingcap->add_cap( 'delete_published_acaras' ); 
		
	    $madingcap->add_cap( 'edit_blog' ); 
        $madingcap->add_cap( 'edit_blogs' );
	    $madingcap->add_cap( 'edit_other_blogs' );
    	$madingcap->add_cap( 'edit_private_blogs' );
	    $madingcap->add_cap( 'edit_published_blogs' );
    	$madingcap->add_cap( 'read_blog' ); 
    	$madingcap->add_cap( 'read_private_blogs' );
    	$madingcap->add_cap( 'publish_blogs' );
    	$madingcap->add_cap( 'delete_blog' ); 
        $madingcap->add_cap( 'delete_blogs' );
    	$madingcap->add_cap( 'delete_private_blogs' );
    	$madingcap->add_cap( 'delete_others_blogs' );
    	$madingcap->add_cap( 'delete_published_blogs' ); 
	
	$madingcap->add_cap( 'manage_blogkat' ); 
	$madingcap->add_cap( 'assign_blogkat' ); 
	$madingcap->add_cap( 'edit_blogkat' ); 
	$madingcap->add_cap( 'delete_blogkat' ); 
		
        $madingcap->add_cap( 'edit_down' ); 
        $madingcap->add_cap( 'edit_downs' );
	    $madingcap->add_cap( 'edit_other_downs' );
    	$madingcap->add_cap( 'edit_private_downs' );
	    $madingcap->add_cap( 'edit_published_downs' );
    	$madingcap->add_cap( 'read_down' ); 
    	$madingcap->add_cap( 'read_private_downs' );
    	$madingcap->add_cap( 'publish_downs' );
    	$madingcap->add_cap( 'delete_down' ); 
        $madingcap->add_cap( 'delete_downs' );
    	$madingcap->add_cap( 'delete_private_downs' );
    	$madingcap->add_cap( 'delete_others_downs' );
    	$madingcap->add_cap( 'delete_published_downs' ); 
		
	$madingcap->add_cap( 'manage_catdown' ); 
	$madingcap->add_cap( 'assign_catdown' ); 
	$madingcap->add_cap( 'edit_catdown' ); 
	$madingcap->add_cap( 'delete_catdown' );
	
	$madingcap->add_cap( 'manage_typedown' ); 
	$madingcap->add_cap( 'assign_typedown' ); 
	$madingcap->add_cap( 'edit_typedown' ); 
	$madingcap->add_cap( 'delete_typedown' ); 
	
		
if ( get_theme_mod('sekolah_type') == "akademi" ) {
        $madingcap->add_cap( 'edit_dosen' ); 
        $madingcap->add_cap( 'edit_dosens' );
	    $madingcap->add_cap( 'edit_other_dosens' );
    	$madingcap->add_cap( 'edit_private_dosens' );
	    $madingcap->add_cap( 'edit_published_dosens' );
    	$madingcap->add_cap( 'read_dosen' ); 
    	$madingcap->add_cap( 'read_private_dosens' );
    	$madingcap->add_cap( 'publish_dosens' );
    	$madingcap->add_cap( 'delete_dosen' ); 
        $madingcap->add_cap( 'delete_dosens' );
    	$madingcap->add_cap( 'delete_private_dosens' );
    	$madingcap->add_cap( 'delete_others_dosens' );
    	$madingcap->add_cap( 'delete_published_dosens' ); 
	} else if ( get_theme_mod('sekolah_type') == "pesantren" ) {
        $madingcap->add_cap( 'edit_ustadz' ); 
        $madingcap->add_cap( 'edit_ustadzs' );
	    $madingcap->add_cap( 'edit_other_ustadzs' );
    	$madingcap->add_cap( 'edit_private_ustadzs' );
	    $madingcap->add_cap( 'edit_published_ustadzs' );
    	$madingcap->add_cap( 'read_ustadz' ); 
    	$madingcap->add_cap( 'read_private_ustadzs' );
    	$madingcap->add_cap( 'publish_ustadzs' );
    	$madingcap->add_cap( 'delete_ustadz' ); 
        $madingcap->add_cap( 'delete_ustadzs' );
    	$madingcap->add_cap( 'delete_private_ustadzs' );
    	$madingcap->add_cap( 'delete_others_ustadzs' );
    	$madingcap->add_cap( 'delete_published_ustadzs' ); 
	} else {
        $madingcap->add_cap( 'edit_guru' ); 
        $madingcap->add_cap( 'edit_gurus' );
	    $madingcap->add_cap( 'edit_other_gurus' );
    	$madingcap->add_cap( 'edit_private_gurus' );
	    $madingcap->add_cap( 'edit_published_gurus' );
    	$madingcap->add_cap( 'read_guru' ); 
    	$madingcap->add_cap( 'read_private_gurus' );
    	$madingcap->add_cap( 'publish_gurus' );
    	$madingcap->add_cap( 'delete_guru' ); 
        $madingcap->add_cap( 'delete_gurus' );
    	$madingcap->add_cap( 'delete_private_gurus' );
    	$madingcap->add_cap( 'delete_others_gurus' );
    	$madingcap->add_cap( 'delete_published_gurus' ); 
	}
	
	$madingcap->add_cap( 'manage_jab' ); 
	$madingcap->add_cap( 'assign_jab' ); 
	$madingcap->add_cap( 'edit_jab' ); 
	$madingcap->add_cap( 'delete_jab' ); 
	
	$madingcap->add_cap( 'manage_stts' ); 
	$madingcap->add_cap( 'assign_stts' ); 
	$madingcap->add_cap( 'edit_stts' ); 
	$madingcap->add_cap( 'detele_stts' ); 
	
	$madingcap->add_cap( 'manage_structure' ); 
	$madingcap->add_cap( 'assign_structure' ); 
	$madingcap->add_cap( 'edit_structure' ); 
	$madingcap->add_cap( 'detele_structure' ); 
		
        $madingcap->add_cap( 'edit_editorial' ); 
        $madingcap->add_cap( 'edit_editorials' );
	    $madingcap->add_cap( 'edit_other_editorials' );
    	$madingcap->add_cap( 'edit_private_editorials' );
	    $madingcap->add_cap( 'edit_published_editorials' );
    	$madingcap->add_cap( 'read_editorial' ); 
    	$madingcap->add_cap( 'read_private_editorials' );
    	$madingcap->add_cap( 'publish_editorials' );
    	$madingcap->add_cap( 'delete_editorial' ); 
        $madingcap->add_cap( 'delete_editorials' );
    	$madingcap->add_cap( 'delete_private_editorials' );
    	$madingcap->add_cap( 'delete_others_editorials' );
    	$madingcap->add_cap( 'delete_published_editorials' ); 
		
	if ( get_theme_mod('sekolah_type') != "akademi" ) {
        $madingcap->add_cap( 'edit_extra' ); 
        $madingcap->add_cap( 'edit_extras' );
	    $madingcap->add_cap( 'edit_other_extras' );
    	$madingcap->add_cap( 'edit_private_extras' );
	    $madingcap->add_cap( 'edit_published_extras' );
    	$madingcap->add_cap( 'read_extra' ); 
    	$madingcap->add_cap( 'read_private_extras' );
    	$madingcap->add_cap( 'publish_extras' );
    	$madingcap->add_cap( 'delete_extra' ); 
        $madingcap->add_cap( 'delete_extras' );
    	$madingcap->add_cap( 'delete_private_extras' );
    	$madingcap->add_cap( 'delete_others_extras' );
    	$madingcap->add_cap( 'delete_published_extras' ); 
	} else {
        $madingcap->add_cap( 'edit_kegiatan' ); 
        $madingcap->add_cap( 'edit_kegiatans' );
	    $madingcap->add_cap( 'edit_other_kegiatans' );
    	$madingcap->add_cap( 'edit_private_kegiatans' );
	    $madingcap->add_cap( 'edit_published_kegiatans' );
    	$madingcap->add_cap( 'read_kegiatan' ); 
    	$madingcap->add_cap( 'read_private_kegiatans' );
    	$madingcap->add_cap( 'publish_kegiatans' );
    	$madingcap->add_cap( 'delete_kegiatan' ); 
        $madingcap->add_cap( 'delete_kegiatans' );
    	$madingcap->add_cap( 'delete_private_kegiatans' );
    	$madingcap->add_cap( 'delete_others_kegiatans' );
    	$madingcap->add_cap( 'delete_published_kegiatans' ); 
	}
        $madingcap->add_cap( 'edit_fasil' ); 
        $madingcap->add_cap( 'edit_fasils' );
	    $madingcap->add_cap( 'edit_other_fasils' );
    	$madingcap->add_cap( 'edit_private_fasils' );
	    $madingcap->add_cap( 'edit_published_fasils' );
    	$madingcap->add_cap( 'read_fasil' ); 
    	$madingcap->add_cap( 'read_private_fasils' );
    	$madingcap->add_cap( 'publish_fasils' );
    	$madingcap->add_cap( 'delete_fasil' ); 
        $madingcap->add_cap( 'delete_fasils' );
    	$madingcap->add_cap( 'delete_private_fasils' );
    	$madingcap->add_cap( 'delete_others_fasils' );
    	$madingcap->add_cap( 'delete_published_fasils' ); 
		
        $madingcap->add_cap( 'edit_galer' ); 
        $madingcap->add_cap( 'edit_galers' );
	    $madingcap->add_cap( 'edit_other_galers' );
    	$madingcap->add_cap( 'edit_private_galers' );
	    $madingcap->add_cap( 'edit_published_galers' );
    	$madingcap->add_cap( 'read_galer' ); 
    	$madingcap->add_cap( 'read_private_galers' );
    	$madingcap->add_cap( 'publish_galers' );
    	$madingcap->add_cap( 'delete_galer' ); 
        $madingcap->add_cap( 'delete_galers' );
    	$madingcap->add_cap( 'delete_private_galers' );
    	$madingcap->add_cap( 'delete_others_galers' );
    	$madingcap->add_cap( 'delete_published_galers' ); 
		
	if ( get_theme_mod('sekolah_type') == "akademi" ) {
        $madingcap->add_cap( 'edit_maha' ); 
        $madingcap->add_cap( 'edit_mahas' );
	    $madingcap->add_cap( 'edit_other_mahas' );
    	$madingcap->add_cap( 'edit_private_mahas' );
	    $madingcap->add_cap( 'edit_published_mahas' );
    	$madingcap->add_cap( 'read_maha' ); 
    	$madingcap->add_cap( 'read_private_mahas' );
    	$madingcap->add_cap( 'publish_mahas' );
    	$madingcap->add_cap( 'delete_maha' ); 
        $madingcap->add_cap( 'delete_mahas' );
    	$madingcap->add_cap( 'delete_private_mahas' );
    	$madingcap->add_cap( 'delete_others_mahas' );
    	$madingcap->add_cap( 'delete_published_mahas' ); 
		
	} else if ( get_theme_mod('sekolah_type') == "pesantren" ) {
        $madingcap->add_cap( 'edit_santri' ); 
        $madingcap->add_cap( 'edit_santris' );
	    $madingcap->add_cap( 'edit_other_santris' );
    	$madingcap->add_cap( 'edit_private_santris' );
	    $madingcap->add_cap( 'edit_published_santris' );
    	$madingcap->add_cap( 'read_santri' ); 
    	$madingcap->add_cap( 'read_private_santris' );
    	$madingcap->add_cap( 'publish_santris' );
    	$madingcap->add_cap( 'delete_santri' ); 
        $madingcap->add_cap( 'delete_santris' );
    	$madingcap->add_cap( 'delete_private_santris' );
    	$madingcap->add_cap( 'delete_others_santris' );
    	$madingcap->add_cap( 'delete_published_santris' ); 
		
	} else {
        $madingcap->add_cap( 'edit_siswa' ); 
        $madingcap->add_cap( 'edit_siswas' );
	    $madingcap->add_cap( 'edit_other_siswas' );
    	$madingcap->add_cap( 'edit_private_siswas' );
	    $madingcap->add_cap( 'edit_published_siswas' );
    	$madingcap->add_cap( 'read_siswa' ); 
    	$madingcap->add_cap( 'read_private_siswas' );
    	$madingcap->add_cap( 'publish_siswas' );
    	$madingcap->add_cap( 'delete_siswa' ); 
        $madingcap->add_cap( 'delete_siswas' );
    	$madingcap->add_cap( 'delete_private_siswas' );
    	$madingcap->add_cap( 'delete_others_siswas' );
    	$madingcap->add_cap( 'delete_published_siswas' ); 
		
	}
	
	    $madingcap->add_cap( 'manage_fak' ); 
     	$madingcap->add_cap( 'assign_fak' ); 
     	$madingcap->add_cap( 'edit_fak' );
    	$madingcap->add_cap( 'delete_fak' );
		
		$madingcap->add_cap( 'manage_kel' ); 
     	$madingcap->add_cap( 'assign_kel' ); 
     	$madingcap->add_cap( 'edit_kel' );
    	$madingcap->add_cap( 'delete_kel' );
	
        $madingcap->add_cap( 'edit_peng' ); 
        $madingcap->add_cap( 'edit_pengs' );
	    $madingcap->add_cap( 'edit_other_pengs' );
    	$madingcap->add_cap( 'edit_private_pengs' );
	    $madingcap->add_cap( 'edit_published_pengs' );
    	$madingcap->add_cap( 'read_peng' ); 
    	$madingcap->add_cap( 'read_private_pengs' );
    	$madingcap->add_cap( 'publish_pengs' );
    	$madingcap->add_cap( 'delete_peng' ); 
        $madingcap->add_cap( 'delete_pengs' );
    	$madingcap->add_cap( 'delete_private_pengs' );
    	$madingcap->add_cap( 'delete_others_pengs' );
    	$madingcap->add_cap( 'delete_published_pengs' ); 
		
		$madingcap->add_cap( 'edit_prest' ); 
        $madingcap->add_cap( 'edit_prests' );
	    $madingcap->add_cap( 'edit_other_prests' );
    	$madingcap->add_cap( 'edit_private_prests' );
	    $madingcap->add_cap( 'edit_published_prests' );
    	$madingcap->add_cap( 'read_prest' ); 
    	$madingcap->add_cap( 'read_private_prests' );
    	$madingcap->add_cap( 'publish_prests' );
    	$madingcap->add_cap( 'delete_prest' ); 
        $madingcap->add_cap( 'delete_prests' );
    	$madingcap->add_cap( 'delete_private_prests' );
    	$madingcap->add_cap( 'delete_others_prests' );
    	$madingcap->add_cap( 'delete_published_prests' ); 
		
        $madingcap->add_cap( 'edit_quot' ); 
        $madingcap->add_cap( 'edit_quots' );
	    $madingcap->add_cap( 'edit_other_quots' );
    	$madingcap->add_cap( 'edit_private_quots' );
	    $madingcap->add_cap( 'edit_published_quots' );
    	$madingcap->add_cap( 'read_quot' ); 
    	$madingcap->add_cap( 'read_private_quots' );
    	$madingcap->add_cap( 'publish_quots' );
    	$madingcap->add_cap( 'delete_quot' ); 
        $madingcap->add_cap( 'delete_quots' );
    	$madingcap->add_cap( 'delete_private_quots' );
    	$madingcap->add_cap( 'delete_others_quots' );
    	$madingcap->add_cap( 'delete_published_quots' ); 
		
        $madingcap->add_cap( 'edit_slide' ); 
        $madingcap->add_cap( 'edit_slides' );
	    $madingcap->add_cap( 'edit_other_slides' );
    	$madingcap->add_cap( 'edit_private_slides' );
	    $madingcap->add_cap( 'edit_published_slides' );
    	$madingcap->add_cap( 'read_slide' ); 
    	$madingcap->add_cap( 'read_private_slides' );
    	$madingcap->add_cap( 'publish_slides' );
    	$madingcap->add_cap( 'delete_slide' ); 
        $madingcap->add_cap( 'delete_slides' );
    	$madingcap->add_cap( 'delete_private_slides' );
    	$madingcap->add_cap( 'delete_others_slides' );
    	$madingcap->add_cap( 'delete_published_slides' ); 
		
        $madingcap->add_cap( 'edit_vidio' ); 
        $madingcap->add_cap( 'edit_vidios' );
	    $madingcap->add_cap( 'edit_other_vidios' );
    	$madingcap->add_cap( 'edit_private_vidios' );
	    $madingcap->add_cap( 'edit_published_vidios' );
    	$madingcap->add_cap( 'read_vidio' ); 
    	$madingcap->add_cap( 'read_private_vidios' );
    	$madingcap->add_cap( 'publish_vidios' );
    	$madingcap->add_cap( 'delete_vidio' ); 
        $madingcap->add_cap( 'delete_vidios' );
    	$madingcap->add_cap( 'delete_private_vidios' );
    	$madingcap->add_cap( 'delete_others_vidios' );
    	$madingcap->add_cap( 'delete_published_vidios' ); 
		
		$madingcap->add_cap( 'edit_tugas' ); 
        $madingcap->add_cap( 'edit_tugass' );
	    $madingcap->add_cap( 'edit_other_tugass' );
    	$madingcap->add_cap( 'edit_private_tugass' );
	    $madingcap->add_cap( 'edit_published_tugass' );
    	$madingcap->add_cap( 'read_tugas' ); 
    	$madingcap->add_cap( 'read_private_tugass' );
    	$madingcap->add_cap( 'publish_tugass' );
    	$madingcap->add_cap( 'delete_tugas' ); 
        $madingcap->add_cap( 'delete_tugass' );
    	$madingcap->add_cap( 'delete_private_tugass' );
    	$madingcap->add_cap( 'delete_others_tugass' );
    	$madingcap->add_cap( 'delete_published_tugass' );
		
	$madingcap->add_cap( 'manage_level' ); 
   	$madingcap->add_cap( 'assign_level' ); 
	$madingcap->add_cap( 'edit_level' );
	$madingcap->add_cap( 'delete_level' );
	
	$madingcap->add_cap( 'manage_mapel' ); 
   	$madingcap->add_cap( 'assign_mapel' ); 
	$madingcap->add_cap( 'edit_mapel' );
	$madingcap->add_cap( 'delete_mapel' );
	
	if ( post_type_exists( 'alumni' ) ) {
		$madingcap->add_cap( 'edit_alumni' ); 
        $madingcap->add_cap( 'edit_alumnis' );
	    $madingcap->add_cap( 'edit_other_alumnis' );
    	$madingcap->add_cap( 'edit_private_alumnis' );
	    $madingcap->add_cap( 'edit_published_alumnis' );
    	$madingcap->add_cap( 'read_alumni' ); 
    	$madingcap->add_cap( 'read_private_alumnis' );
    	$madingcap->add_cap( 'publish_alumnis' );
    	$madingcap->add_cap( 'delete_alumni' ); 
        $madingcap->add_cap( 'delete_alumnis' );
    	$madingcap->add_cap( 'delete_private_alumnis' );
    	$madingcap->add_cap( 'delete_others_alumnis' );
    	$madingcap->add_cap( 'delete_published_alumnis' );
	}
	
	    $madingcap->add_cap( 'edit_ppdb' ); 
        $madingcap->add_cap( 'edit_ppdbs' );
	    $madingcap->add_cap( 'edit_other_ppdbs' );
    	$madingcap->add_cap( 'edit_private_ppdbs' );
	    $madingcap->add_cap( 'edit_published_ppdbs' );
    	$madingcap->add_cap( 'read_ppdb' ); 
    	$madingcap->add_cap( 'read_private_ppdbs' );
    	$madingcap->add_cap( 'publish_ppdbs' );
    	$madingcap->add_cap( 'delete_ppdb' ); 
        $madingcap->add_cap( 'delete_ppdbs' );
    	$madingcap->add_cap( 'delete_private_ppdbs' );
    	$madingcap->add_cap( 'delete_others_ppdbs' );
    	$madingcap->add_cap( 'delete_published_ppdbs' ); 
	
}
add_action( 'admin_init', 'add_ngadimin_caps');

?>