<?php
// Tambahkan widget ke dashboard admin
add_action('wp_dashboard_setup', 'add_custom_rss_dashboard_widget');
function add_custom_rss_dashboard_widget() {
    wp_add_dashboard_widget(
        'dealer_rss_widget',        // ID widget
        'Update Changelog',         // Judul widget
        'dealer_get_rss_widget' // Fungsi callback
    );
}

// Fungsi untuk menampilkan isi widget
function dealer_get_rss_widget() {
    // URL RSS feed
    $ciusstheme_feed  = 'https://update.ciuss.com/mading/feed/';
    $ciussplugin_feed = 'https://update.ciuss.com/sekolah-pro/feed/';
    $ciusstheme       = wp_get_theme();
	$ciussplugin      = WP_PLUGIN_DIR . '/sekolahpro/sekolahpro.php';

    if ( file_exists( $ciussplugin ) ) {
        include_once ABSPATH . 'wp-admin/includes/plugin.php'; // Pastikan file plugin.php dimuat
        $plugin_data = get_plugin_data($ciussplugin, false, false); // Ambil data plugin
        $plugin_name = $plugin_data['Name'];
        $plugin_version = $plugin_data['Version'];
		$plugin_show  = 'aktif versi ' . esc_html($plugin_version);
    } else {
		$plugin_show  = '(tidak aktif)';
	}
	?>
		
		<div class="feed_widget">
		    <div class="top_feed">
			    <a target="_blank" href="<?php echo esc_url( 'https://update.ciuss.com/mading' ); ?>"><img class="rss-image" src="<?php echo esc_url( get_template_directory_uri() );?>/images/awesome.jpg" /></a>
			</div>
			<div class="bot_feed ciuss_clear">
			    <span>Website ini menggunakan tema <?php echo esc_html( $ciusstheme->get( 'Name' ) ); ?></span>
				<a href="<?php echo esc_url('https://ciuss.com/video-tuts/tema-sekolah/'); ?>" target="_blank" class="button button-primary"><?php echo 'Tutorial'; ?></a>
			</div>
			<div class="after_feed ciuss_clear">
			    <span>Bagi pelanggan yang kode Lisensi-nya masih aktif, silahkan untuk mengupdate tema dan plugin ke versi terbaru yang dirilis oleh <strong>Ciuss Creative</strong></span>
			</div>
			<div class="half__feed ciuss_clear">
			    <div class="half__update">
				    <h3>Tema <?php echo esc_html( $ciusstheme->get( 'Name' ) ) . ' aktif versi ' .esc_html( $ciusstheme->get( 'Version' ) ); ?></h3>
			        <?php
                        wp_widget_rss_output([
                            'url'          => $ciusstheme_feed,
                            'title'        => 'Mading',
                            'items'        => 2, // Jumlah item
                            'show_summary' => true, // Tampilkan ringkasan
                            'show_author'  => false,
                            'show_date'    => true,
                        ]);
					?>
				</div>
				<div class="half__update">
				    <h3>Plugin Sekolah Pro <?php echo esc_html($plugin_show); ?></h3>
			        <?php
						wp_widget_rss_output([
                            'url'          => $ciussplugin_feed,
                            'title'        => 'Sekolah Pro',
                            'items'        => 2, // Jumlah item
                            'show_summary' => true, // Tampilkan ringkasan
                            'show_author'  => false,
                            'show_date'    => true,
                        ]);
					?>
				</div>
			</div>
		</div>
				
	<?php
}


