<?php
/**
 * Custom WP Mading template tags
 * Fungsi pendukung tema WP Mading
 */

// Sudah
if ( ! function_exists( 'custom_logo_mading' ) ) :
    function custom_logo_mading() {
    	if ( function_exists( 'the_custom_logo' ) ) {
			    the_custom_logo();
	    }
    }
endif;
// Sudah
if ( ! function_exists( 'preload_web_font_mading' ) ) :
    function preload_web_font_mading() {
        get_template_part('header/meta-preload');
	}
endif;
// Sudah
if ( ! function_exists( 'head_meta_property_mading' ) ) :
    function head_meta_property_mading() {
        get_template_part('header/meta');
	}
endif;
// Sudah
if ( ! function_exists( 'head_meta_desc_mading' ) ) :
    function head_meta_desc_mading() {
		if (is_front_page()) {
			bloginfo('description');
		} else if (is_singular()) {
			if (function_exists('smart_excerpt')) smart_excerpt(get_the_excerpt(), 60);
		} else {
			echo '';
		}
	}
endif;
// Sudah
if ( ! function_exists( 'mading_home_slider' ) ) :
    function mading_home_slider() {
		if (is_front_page()) {  
	        get_template_part('header/slider');
		}
	}
endif;
// Sudah
if ( ! function_exists( 'slide_time_out' ) ) :
    function slide_time_out() {
		$permile = 1000;
		$perslide = get_theme_mod('slide_timer');
		$time_out_slide = $permile * $perslide;
		if ( get_theme_mod('slide_timer') != "" ) {
	    	echo esc_html( $time_out_slide ); 
		} else {
			echo 6000;
		}
	}
endif;
// Sudah
if ( ! function_exists( 'mading_get_beranda_after_slider' ) ) :
	function mading_get_beranda_after_slider() {
		get_template_part('beranda/after-slider');
	}
endif;
// Sudah
if ( ! function_exists( 'mading_get_beranda_quotes' ) ) :
	function mading_get_beranda_quotes() {
		get_template_part('beranda/quotes');
	}
endif;
// Sudah
if ( ! function_exists( 'mading_get_beranda_school_teams' ) ) :
	function mading_get_beranda_school_teams() {
		get_template_part('beranda/personel');
	}
endif;
// Sudah
if ( ! function_exists( 'mading_get_beranda_blog_guru' ) ) :
	function mading_get_beranda_blog_guru() {
		get_template_part('beranda/blog');
	}
endif;
// Sudah
if ( ! function_exists( 'mading_get_beranda_bot_blocks' ) ) :
	function mading_get_beranda_bot_blocks() {
		get_template_part('beranda/bot-block');
	}
endif;

// Sudah
function mading_customize_partial_namasekolah() {
	mading_mad__schoolname();
}
if ( ! function_exists( 'mading_mad__schoolname' ) ) :
	function mading_mad__schoolname() {
		if ( get_theme_mod('mad__schoolname') != "" ) {
	    	echo esc_html( get_theme_mod( 'mad__schoolname') ); 
		} else {
			esc_html_e('SMA Negeri 1 Comal - Pemalang', 'mading');
		}
	}
endif;
// Sudah
function mading_customize_partial_address() {
	mading_address();
}
if ( ! function_exists( 'mading_address' ) ) :
	function mading_address() {
		if ( get_theme_mod('address_data') != "" ) {
	        echo esc_html( get_theme_mod( 'address_data') ); 
		} else {
			esc_html_e('Jln. Jend A Yani No. 77 Comal, Pemalang, Jawa Tengah', 'mading');
		}
	}
endif;
// sudah
function mading_customize_partial_nspn() {
	mading_nspn();
}
if ( ! function_exists( 'mading_nspn' ) ) :
	function mading_nspn() {
		if ( get_theme_mod('nspn_data') != "" ) {
	        echo esc_html( get_theme_mod( 'nspn_data') ); 
		} else {
			esc_html_e('20404xxx', 'mading');
		}
	}
endif;


		
function mading_customize_partial_kepalasekolah() {
	mading_kepala_sekolah();
}
if ( ! function_exists( 'mading_kepala_sekolah' ) ) :
	function mading_kepala_sekolah() {
		if ( get_theme_mod('kepala_sekolah') != "" ) {
	    	echo esc_html( get_theme_mod( 'kepala_sekolah') ); 
		} else {
			esc_html_e( 'Yayun Ciuss', 'mading' ); 
		}
	}
endif;

function mading_customize_partial_fotokepala() {
	mading_get_photos();
}
if ( ! function_exists( 'mading_get_photos' ) ) :
	function mading_get_photos() {
		if ( get_theme_mod('foto_kepala') != "" ) {
	    	echo '<img src="'.esc_url( get_theme_mod( 'foto_kepala') ).'" />'; 
		} else {
			echo '<img src="'.esc_url( get_theme_file_uri('images/master.jpg') ).'" />'; 
		}
	}
endif;

function mading_customize_partial_number() {
	mading_school_number();
}
if ( ! function_exists( 'mading_school_number' ) ) :
	function mading_school_number() {
		if ( get_theme_mod('telpon_data') != "" ) {
			$tel = get_theme_mod('telpon_data'); 
			$new_tel = preg_replace("/[^A-Za-z0-9?!]/",'',$tel);
	    	echo '<a target="_blank" href="tel:'. esc_html( $new_tel ).'">';
			if ( get_theme_mod('mode_tema') == "awesome" ) {
				echo '<i class="icon-mad-phone"></i>';
				echo '<span>'.__('Hotline', 'mading').'</span>';
			} else {
		    	echo esc_html( get_theme_mod( 'telpon_data' ) );
			}
			echo '</a>';
		} else {
			if ( get_theme_mod('mode_tema') == "awesome" ) {
				echo '<a target="_blank" href="tel:000000000"><span>'.__('Hotline', 'mading').'</span></a>';
			} else {
		    	echo '<a target="_blank" href="tel:000000000">'. esc_html_e( '62 8000 xxx', 'mading' ) .'</a>';
			}
		}
	}
endif;
function mading_customize_partial_mailing() {
	mading_school_mailing();
}
if ( ! function_exists( 'mading_school_mailing' ) ) :
	function mading_school_mailing() {
		if ( get_theme_mod('email_data') != "" ) {
	    	echo '<a target="_blank" href="mailto:'. esc_html( get_theme_mod('email_data') ).'">'. esc_html( get_theme_mod('email_data') ).'</a>';
		} else {
			echo '<a target="_blank" href="mailto:mading@mading.ciuss">mading@mading.ciuss</a>';
		}
	}
endif;	

function mading_customize_partial_email() {
	mading_social_icon();
}
function mading_customize_partial_wanumber() {
	mading_social_icon();
}
function mading_customize_partial_facebook() {
	mading_social_icon();
}
function mading_customize_partial_twitter() {
	mading_social_icon();
}
function mading_customize_partial_instagram() {
	mading_social_icon();
}
function mading_customize_partial_youtube() {
	mading_social_icon();
}
function mading_customize_partial_tiktok() {
	mading_social_icon();
}
if ( ! function_exists( 'mading_social_icon' ) ) :
	function mading_social_icon() {
		if ( get_theme_mod('facebook_data') != "" ) {
	        echo '<a target="_blank" href="'. esc_url( get_theme_mod( 'facebook_data' ) ).'" target="_blank"><i class="icon-mad-facebook"></i></a>';
	    }
		if ( get_theme_mod('twitter_data') != "" ) {
	        echo '<a target="_blank" href="'. esc_url( get_theme_mod( 'twitter_data' ) ).'" target="_blank"><i class="icofont-x"></i></a>';
	    }
		if ( get_theme_mod('instagram_data') != "" ) {
	        echo '<a target="_blank" href="'. esc_url( get_theme_mod( 'instagram_data' ) ).'" target="_blank"><i class="icon-mad-instagram"></i></a>';
	    }
		if ( get_theme_mod('youtube_data') != "" ) {
	        echo '<a target="_blank" href="'. esc_url( get_theme_mod( 'youtube_data' ) ).'" target="_blank"><i class="icon-mad-youtube"></i></a>';
	    }
		if ( get_theme_mod('tiktok_data') != "" ) {
	        echo '<a target="_blank" href="'. esc_url( get_theme_mod( 'tiktok_data' ) ).'" target="_blank"><i class="icofont-tiktok"></i></a>';
	    }
		if ( get_theme_mod('email_data') != "" ) {
	    	echo '<a target="_blank" href="mailto:'. esc_html( get_theme_mod('email_data') ).'"><i class="icon-mad-mail"></i></a>';
		}
		
		if ( get_theme_mod('chat_sekolah') != "" ) {
		     $wa_mess = get_theme_mod('chat_sekolah'); 
	    } else {
	        $wa_mess = 'Saya ingin bertanya seputar sekolah ini..'; 
	    }
		if ( get_theme_mod('wa_data') != "" ) {
			$was = get_theme_mod('wa_data'); 
			$new_was = preg_replace("/[^A-Za-z0-9?!]/",'',$was);
	    	echo '<a target="_blank" href="https://wa.me/'. esc_html( $new_was ).'/?text='. esc_html( $wa_mess ).'"><i class="icon-mad-whatsapp"></i></a>';
		}
	}
endif;

if ( ! function_exists( 'awesome_social_icon' ) ) :
	function awesome_social_icon() {
		if ( get_theme_mod('facebook_data') != "" ) {
	        echo '<a target="_blank" href="'. esc_url( get_theme_mod( 'facebook_data' ) ).'" target="_blank"><i class="icon-mad-facebook"></i></a>';
	    }
		if ( get_theme_mod('twitter_data') != "" ) {
	        echo '<a target="_blank" href="'. esc_url( get_theme_mod( 'twitter_data' ) ).'" target="_blank"><i class="icofont-x"></i></a>';
	    }
		if ( get_theme_mod('instagram_data') != "" ) {
	        echo '<a target="_blank" href="'. esc_url( get_theme_mod( 'instagram_data' ) ).'" target="_blank"><i class="icon-mad-instagram"></i></a>';
	    }
		if ( get_theme_mod('youtube_data') != "" ) {
	        echo '<a target="_blank" href="'. esc_url( get_theme_mod( 'youtube_data' ) ).'" target="_blank"><i class="icon-mad-youtube"></i></a>';
	    }
		if ( get_theme_mod('tiktok_data') != "" ) {
	        echo '<a target="_blank" href="'. esc_url( get_theme_mod( 'tiktok_data' ) ).'" target="_blank"><i class="icofont-tiktok"></i></a>';
	    }
		if ( get_theme_mod('chat_sekolah') != "" ) {
		     $wa_mess = get_theme_mod('chat_sekolah'); 
	    } else {
	        $wa_mess = 'Saya ingin bertanya seputar sekolah ini..'; 
	    }
		if ( get_theme_mod('wa_data') != "" ) {
			$was = get_theme_mod('wa_data'); 
			$new_was = preg_replace("/[^A-Za-z0-9?!]/",'',$was);
	    	echo '<a target="_blank" href="https://wa.me/'. esc_html( $new_was ).'/?text='. esc_html( $wa_mess ).'"><i class="icon-mad-whatsapp"></i></a>';
		}
	}
endif;

/* Replace Text
------------------------------- */





function mading_customize_partial_repress() {
	mading_re_press();
}
if ( ! function_exists( 'mading_re_press' ) ) :
	function mading_re_press() {
		if ( get_theme_mod('re_press') != "" ) { 
		    echo esc_html( get_theme_mod('re_press') );
		} else {
			esc_html_e( 'Achievement', 'mading' );
		}
	}
endif;
function mading_customize_partial_represstext() {
	mading_re_presstext();
}
if ( ! function_exists( 'mading_re_presstext' ) ) :
	function mading_re_presstext() {
		if ( get_theme_mod('re_presstext') != "" ) { 
		    echo esc_html( get_theme_mod('re_presstext') );
		} else {
			esc_html_e( 'An potest, inquit ille, quicquam esse suavius quam nihil dolere? Contemnit enim disserendi elegantiam, confuse loquitur. An est aliquid per se ipsum flagitiosum, etiamsi nulla comitetur infamia? Ab hoc autem quaedam non melius quam veteres', 'mading' );
		}
	}
endif;


function mading_customize_partial_renoagenda() {
	mading_re_no_agenda();
}
if ( ! function_exists( 'mading_re_no_agenda' ) ) :
	function mading_re_no_agenda() {
		if ( get_theme_mod('re_noagenda') != "" ) { 
		    echo esc_html( get_theme_mod('re_noagenda') );
		} else {
			esc_html_e( 'There is no agenda will be implemented in the near', 'mading' );
		}
	}
endif;



function mading_customize_partial_footcopy() {
	mading_text_footer();
}
if ( ! function_exists( 'mading_text_footer' ) ) :
	function mading_text_footer() {
		if ( get_theme_mod('copy_foot') != "" ) {
			echo get_theme_mod('copy_foot'); 
		} else {
	    	get_template_part('footer/copyright');
		}
	}
endif;

function mading_customize_partial_running() {
	running_text_mading();
}
if ( ! function_exists( 'running_text_mading' ) ) :
	function running_text_mading() {
	    if ( get_theme_mod('running_text') != "" ) {
	        echo '<li>'. do_shortcode( get_theme_mod( 'running_text' ) ) .'</li>'; 
	    } else {
		    echo '<li>';
			echo 'Tema Mading dapat menampilkan informasi dalam text berjalan';
			echo '</li>'; 
	    }
	}
endif;	


function mading_need_plugin(){
        $user = wp_get_current_user();
		if ( in_array( 'administrator', (array) $user->roles ) ) {
			if ( is_plugin_active( 'mading-plus/mading-addons.php' ) ) {
				echo '<div class="notice notice-error"><p>';
				echo __('IMPORTANT : Since Mading v 4.0, plugin Mading Extention must be deleted. Please Deactivate and then Delete', 'mading');
				echo '</p></div>';
			} else {
				if ( ! is_plugin_active( 'sekolahpro/sekolahpro.php' ) ) {
			    	echo '<div class="notice notice-error"><p>';
			    	echo sprintf('%s <a href="https://ciuss.com/dashboard/" target="__blank">%s</a><br/> %s', __('This theme need plugin Sekolah Pro. Please download it from', 'mading'), __('Member Area', 'mading'), __('Install and activate License', 'mading'));
			    	echo '</p></div>';
		     	}
			}
		}
}
add_action('admin_notices', 'mading_need_plugin');

function head_opacity_value() {
	echo '<style type="text/css">'; 
	?>
	
	.overlay {
		opacity: 0.<?php if ( get_theme_mod('opacity_agenda') != "" ) {
	    	echo esc_html( get_theme_mod( 'opacity_agenda') ); 
		} else {
			echo 75;
		} ?>
	}
	.parallax {
        background-image: url(<?php if ( get_theme_mod('agenda_overlay') != "" ) {
	    	echo esc_html( get_theme_mod( 'agenda_overlay') ); 
		} else {
			echo esc_html( get_theme_file_uri('images/agenda.jpg')  );
		} ?>);
	}
	.to_top {
		margin-right: <?php if ( get_theme_mod('scrolltop_position') != "" ) {
	    	echo esc_html( get_theme_mod( 'scrolltop_position') ); 
		} else {
			echo 0;
		} ?>px;
	}
	<?php
	echo '</style>';
}
add_action( 'wp_head', 'head_opacity_value' );

// Select Theme Mode
if ( ! function_exists( 'mading_header_mode' ) ) :
	function mading_header_mode() {
		if ( get_theme_mod('mode_tema') != "" ) {
	    	get_template_part( get_theme_mod('mode_tema') .'/header');
    	} else {
			get_template_part('mading/header');
		}
	}
endif;
if ( ! function_exists( 'mading_home_mode' ) ) :
	function mading_home_mode() {
		if ( get_theme_mod('mode_tema') != "" ) {
	    	get_template_part( get_theme_mod('mode_tema') .'/home');
    	} else {
			get_template_part('mading/home');
		}
	}
endif;

if ( ! function_exists( 'mading_archive_mode' ) ) :
	function mading_archive_mode() {
		if ( get_theme_mod('mode_tema') != "" ) {
	    	get_template_part( get_theme_mod('mode_tema') .'/post');
    	} else {
			get_template_part('mading/post');
		}
	}
endif;

if ( ! function_exists( 'mading_index_mode' ) ) :
	function mading_index_mode() {
		if ( get_theme_mod('mode_tema') != "" ) {
	    	get_template_part( get_theme_mod('mode_tema') .'/index');
    	} else {
			get_template_part('mading/index');
		}
	}
endif;

if ( ! function_exists( 'mading_sidebar_mode' ) ) :
	function mading_sidebar_mode() {
		if ( get_theme_mod('mode_tema') != "" ) {
	    	get_template_part( get_theme_mod('mode_tema') .'/sidebar');
    	} else {
			get_template_part('mading/sidebar');
		}
	}
endif;

// Single Related Post Type
if ( ! function_exists( 'post_related_by_category' ) ) :
	function post_related_by_category() {
		if ( get_theme_mod('mode_tema') != "" ) {
	    	get_template_part(get_theme_mod('mode_tema').'/single/related-post');
    	} else {
	    	get_template_part('mading/single/related-post');
    	}
	}
endif;
if ( ! function_exists( 'post_another_agendas' ) ) :
	function post_another_agendas() {
		if ( get_theme_mod('mode_tema') != "" ) {
	    	get_template_part(get_theme_mod('mode_tema').'/single/another-agendas');
    	} else {
	    	get_template_part('mading/single/another-agendas');
    	}
	}
endif;
if ( ! function_exists( 'post_another_blogs' ) ) :
	function post_another_blogs() {
		if ( get_theme_mod('mode_tema') != "" ) {
	    	get_template_part(get_theme_mod('mode_tema').'/single/another-blogs');
    	} else {
	    	get_template_part('mading/single/another-blogs');
    	}
	}
endif;
if ( ! function_exists( 'post_another_editorials' ) ) :
	function post_another_editorials() {
		if ( get_theme_mod('mode_tema') != "" ) {
	    	get_template_part(get_theme_mod('mode_tema').'/single/another-editorials');
    	} else {
	    	get_template_part('mading/single/another-editorials');
    	}
	}
endif;
if ( ! function_exists( 'post_another_ekskul' ) ) :
	function post_another_ekskul() {
		if ( get_theme_mod('mode_tema') != "" ) {
	    	get_template_part(get_theme_mod('mode_tema').'/single/another-ekskul');
    	} else {
	    	get_template_part('mading/single/another-ekskul');
    	}
	}
endif;
if ( ! function_exists( 'post_another_fasilitas' ) ) :
	function post_another_fasilitas() {
		if ( get_theme_mod('mode_tema') != "" ) {
	    	get_template_part(get_theme_mod('mode_tema').'/single/another-fasilitas');
    	} else {
	    	get_template_part('mading/single/another-fasilitas');
    	}
	}
endif;
if ( ! function_exists( 'post_another_galeri' ) ) :
	function post_another_galeri() {
		if ( get_theme_mod('mode_tema') != "" ) {
	    	get_template_part(get_theme_mod('mode_tema').'/single/another-galeri');
    	} else {
	    	get_template_part('mading/single/another-galeri');
    	}
	}
endif;
if ( ! function_exists( 'post_another_pengumuman' ) ) :
	function post_another_pengumuman() {
		if ( get_theme_mod('mode_tema') != "" ) {
	    	get_template_part(get_theme_mod('mode_tema').'/single/another-pengumuman');
    	} else {
	    	get_template_part('mading/single/another-pengumuman');
    	}
	}
endif;
if ( ! function_exists( 'post_another_prestasi' ) ) :
	function post_another_prestasi() {
		if ( get_theme_mod('mode_tema') != "" ) {
	    	get_template_part(get_theme_mod('mode_tema').'/single/another-prestasi');
    	} else {
	    	get_template_part('mading/single/another-prestasi');
    	}
	}
endif;
if ( ! function_exists( 'post_another_slider' ) ) :
	function post_another_slider() {
		if ( get_theme_mod('mode_tema') != "" ) {
	    	get_template_part(get_theme_mod('mode_tema').'/single/another-slider');
    	} else {
	    	get_template_part('mading/single/another-slider');
    	}
	}
endif;
if ( ! function_exists( 'post_another_ukm' ) ) :
	function post_another_ukm() {
		if ( get_theme_mod('mode_tema') != "" ) {
	    	get_template_part(get_theme_mod('mode_tema').'/single/another-ukm');
    	} else {
	    	get_template_part('mading/single/another-ukm');
    	}
	}
endif;
if ( ! function_exists( 'post_another_video' ) ) :
	function post_another_video() {
		if ( get_theme_mod('mode_tema') != "" ) {
	    	get_template_part(get_theme_mod('mode_tema').'/single/another-video');
    	} else {
	    	get_template_part('mading/single/another-video');
    	}
	}
endif;

// Mading Template Tags
if ( ! function_exists( 'top_news_editorial' ) ) :
	function top_news_editorial() {
		get_template_part('mading/homepage/news-editorial');
	}
endif;
if ( ! function_exists( 'four_block_mad_content' ) ) :
	function four_block_mad_content() {
		get_template_part('mading/homepage/four-block-post');
	}
endif;
if ( ! function_exists( 'press_mad_content' ) ) :
	function press_mad_content() {
		get_template_part('mading/homepage/prestasi');
	}
endif;
if ( ! function_exists( 'call_pengumuman_post' ) ) :
	function call_pengumuman_post() {
		get_template_part('mading/homepage/pengumuman');
	}
endif;
if ( ! function_exists( 'call_blog_post' ) ) :
	function call_blog_post() {
		get_template_part('mading/homepage/blogguru');
	}
endif;
if ( ! function_exists( 'call_fasilitas_post' ) ) :
	function call_fasilitas_post() {
		get_template_part('mading/homepage/fasilitas');
	}
endif;
if ( ! function_exists( 'call_ekskul_post' ) ) :
	function call_ekskul_post() {
		get_template_part('mading/homepage/ekskul');
	}
endif;
if ( ! function_exists( 'agenda_on_parallax' ) ) :
	function agenda_on_parallax() {
		get_template_part('mading/homepage/agenda');
	}
endif;
if ( ! function_exists( 'mading_thumb_gallery' ) ) :
	function mading_thumb_gallery() {
		get_template_part('mading/homepage/galeri');
	}
endif;
if ( ! function_exists( 'mading_slide_quotes' ) ) :
	function mading_slide_quotes() {
		get_template_part('mading/homepage/quotes');
	}
endif;
if ( ! function_exists( 'mading_slide_guru' ) ) :
	function mading_slide_guru() {
		get_template_part('mading/homepage/slideguru');
	}
endif;
if ( ! function_exists( 'mading_home_video' ) ) :
	function mading_home_video() {
		get_template_part('mading/homepage/videos');
	}
endif;


// Akademi Template Tags
if ( ! function_exists( 'aka_top_content' ) ) :
	function aka_top_content() {
		get_template_part('akademi/top-content');
	}
endif;