<?php
    $args = array(
		'post_type' => 'alumni', 
		'posts_per_page' => 3, 
		'orderby' => 'rand',
		'ignore_sticky_posts' => 1,		
	);
	query_posts($args);
	if (have_posts()) {
		echo '<div class="mag_alumni">';
		echo __('Alumni', 'mading');
		echo '<a href="' . get_post_type_archive_link('alumni') . '" class="al_link"><i class="icon-mad-right"></i></a>';
		echo '</div>';
		while (have_posts()): the_post();
		global $post;
		$kelasjurusan = get_post_meta($post->ID, 'kelasjurusan', true);
		$tahunlulus   = get_post_meta($post->ID, 'tahunlulus', true);
        ?>

            <div class="mag_alumni">
                <div class="alumni_loop madclear">
                    <div class="alumni_pic">
                        <?php
                            if (has_post_thumbnail()) { 	
			                	the_post_thumbnail('photo'); 
		                	} else {
	                			echo '<img src="'. esc_url( get_theme_file_uri('images/guru.jpg') ) .'" />';
	                		}
                        ?>
                    </div>
                    <div class="alumni_info">
                        <div class="alumni_year"><span><?php echo esc_html($tahunlulus); ?></span></div>
                        <?php 
                            the_title('<h5>','</h5>');
                            if ( $kelasjurusan != '' ) { 
                                ?>
				                <div class="alumni_class"><?php echo esc_html_e( 'Class / Study', 'mading'); ?> : <?php echo esc_html($kelasjurusan); ?></div>
			                    <?php 
                            } 
                        ?>
                    </div>
                    <a href="<?php the_permalink(); ?>" class="alumni_pro"><?php echo __('Lihat', 'mading'); ?> <i class="icon-mad-right"></i></a>
                </div>
            </div>
        <?php
		endwhile;	
	}
	wp_reset_query();