<?php 
    $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
	query_posts( array( 
		'post_type' => 'agenda', 
		'paged' => $paged, 
		'meta_key' => '_minus',
		'ignore_sticky_posts'   => 1,
		'meta_query' => array(
			array(
				'key' => '_minus',
				'compare' => '>='
				)
			),
		'orderby' => 'meta_value',
		'order' => 'DESC'
		) 
	); 
	
	$offset      = get_option( 'gmt_offset' );
	if ( $offset = 7 ) {
		$localtime = 'UTC+0700';
	} elseif ( $offset = 8 ) {
		$localtime = 'UTC+0800';
	} elseif ( $offset = 9 ) {
		$localtime ='UTC+0900';
	}
	$today       = strtotime(date('Y-m-d H:i:s', strtotime('+'.$offset.' hours')));
	
    if (have_posts()):
	    $loops = 0;
	    while (have_posts()): the_post(); 
		$minus       = strtotime(get_post_meta($post->ID, '_tevent', true).' '.get_post_meta($post->ID, '_jam', true));
		$tevent      = get_post_meta($post->ID, '_tevent', true);
		$jam         = get_post_meta($post->ID, '_jam', true);
						
		$pack24      = date( "H:i:s", strtotime( $jam ) );		
		$sisa        = $minus-$today;
        $end         = $tevent . ' ' . $pack24;	
						
		$lokasi      = get_post_meta( $post->ID, '_lokasi', true );
		$koordinator = get_post_meta( $post->ID, '_koordinator', true );
		$telepon     = get_post_meta( $post->ID, '_telepon', true );
		$acara       = date_i18n( "d F Y", strtotime( $tevent ) );
		$loops++;
		    ?>
		
		    <div class="press_loop madclear">
			    <div class="press_in">
				    <div class="press_inthumb">
				    	<a href="<?php the_permalink() ?>">
						    <?php // Featured Image
							    if (has_post_thumbnail()) { 
							    	the_post_thumbnail('news'); 
							    } else {
							    	if ( get_theme_mod('madingthumb_image') != "" ) {
							    		$normal = attachment_url_to_postid( get_theme_mod('madingthumb_image'));
							    		$shownormal = wp_get_attachment_image_url( $normal, 'news' );
							        	echo '<img src="'. esc_url( $shownormal ) .'"/>';
							    	} else {
							    		echo '<img src="'. esc_url( get_template_directory_uri() ).'/images/mading.jpg"/>';
							    	}
							    }
							?>
						</a>
				        <div class="press_inpublish <?php if ( $sisa < 0 ) { echo 'age_expired'; } else { echo 'age_active'; } ?>">
					    	<span>
						    	<?php if ( $sisa < 0 ) { 
							    	echo __( 'Agenda is expired', 'mading' ); 
								} else {
									echo '<span id="event'. esc_html( $loops ) .'"><span class="event_day'. esc_html( $loops ) .'"></span> H + <span class="event_hour'. esc_html( $loops ) .'"></span>:<span class="event_minutes'. esc_html( $loops ) .'"></span>:<span class="event_seconds'. esc_html( $loops ) .'"></span></span>';
							    } ?>
							</span>
						</div>
			        </div>
				
				    <div class="press_inmeta">
				    	<h2><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h2>
			        	<div class="press_inexcerpt">
			            	<?php echo smart_excerpt(get_the_excerpt(), 20); ?>
			        	</div>
			    	</div>
				</div>
			</div>
			<div class="loops<?php echo $loops; ?> madclear"></div>
			<?php if ( $sisa > 0 ) { ?>
			    <script>

						function getTimeRemaining(endtime){
  						    var t = Date.parse(endtime) - Date.parse(new Date());
  					    	var seconds = Math.floor( (t/1000) % 60 );
  					    	var minutes = Math.floor( (t/1000/60) % 60 );
  					    	var hours = Math.floor( (t/(1000*60*60)) % 24 );
  					    	var days = Math.floor( t/(1000*60*60*24) );
  					    	return {
  						        'total': t,
  						        'days': days,
  						        'hours': hours,
  						        'minutes': minutes,
  						        'seconds': seconds
 						    };
						}

						function initializeClock(id, endtime){
  					    	var clock = document.getElementById(id);
  					    	var daysSpan = clock.querySelector('.event_day<?php echo esc_html( $loops ); ?>');
  					    	var hoursSpan = clock.querySelector('.event_hour<?php echo esc_html( $loops ); ?>');
  					    	var minutesSpan = clock.querySelector('.event_minutes<?php echo esc_html( $loops ); ?>');
  					    	var secondsSpan = clock.querySelector('.event_seconds<?php echo esc_html( $loops ); ?>');

  						function updateClock(){
   						    var t = getTimeRemaining(endtime);

    						daysSpan.innerHTML = t.days;
    						hoursSpan.innerHTML = ('0' + t.hours).slice(-2);
    						minutesSpan.innerHTML = ('0' + t.minutes).slice(-2);
    						secondsSpan.innerHTML = ('0' + t.seconds).slice(-2);

    						if(t.total<=0){
     						    clearInterval(timeinterval);
    						}
  						}

  						updateClock();
  						var timeinterval = setInterval(updateClock,1000);
						}

						var deadline = '<?php echo date( "F j Y H:i:s", strtotime( $end ) ); ?> <?php echo esc_html( $localtime ); ?>';
						initializeClock('event<?php echo esc_html( $loops ); ?>', deadline);

				</script>
			<?php } ?>
			
		<?php endwhile; 
    endif; 
?>
