<?php
class Recentposts extends WP_Widget {
	function __construct() {
		parent::__construct(
			'recentposts',
			esc_html__( 'Mading : Latest Post', 'mading' ),
			array( 'description' => esc_html__( 'Use widget to show latest post', 'mading' ), 'customize_selective_refresh' => true, )
		);
	}

	public function widget( $args, $instance ) {
		if ( ! isset( $args['widget_id'] ) ) {
			$args['widget_id'] = $this->id;
		}

		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : __( 'Latest Post', 'mading' );

		/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );
		
		$post_baru = ( ! empty( $instance['post_baru'] ) ) ? absint( $instance['post_baru'] ) : 3;
		if ( ! $post_baru ) {
			$post_baru = 3;
		}
		
		$q_args = array( 
			'post_type' => 'post', 
			'ignore_sticky_posts' => 1,
			'numberposts' => $post_baru,
			); 
			
		global $post;
		$rpthumb_posts = get_posts($q_args);
		
		echo $args['before_widget']; 
		
		if ( $title ) {
			echo $args['before_title'] . $title . $args['after_title'];
		}
		
		foreach ($rpthumb_posts as $post):
			setup_postdata($post);
		?>
        <div class="post_widget madclear">
	    	<div class="widget_thumb">
		        <?php 
				    if (has_post_thumbnail()) {
			            the_post_thumbnail('small');
		            } else {
						if ( get_theme_mod('madingthumb_image') != "" ) {
					    	$mini = attachment_url_to_postid( get_theme_mod('madingthumb_image'));
							$showmini = wp_get_attachment_image_url( $mini, 'small' );
							echo '<img src="'. esc_url( $showmini ) .'"/>';
						} else {
							echo '<img src="'. esc_url( get_template_directory_uri() ) .'/images/small.jpg"/>';
						}
					}
		        ?>
		    </div>
		    <div class="post_widinfo">
		        <div class="post_wtitle"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></div>
		        <div class="post_widspan"><?php the_time(); ?></div>
			</div>
        </div>
	<?php	endforeach;
		
		echo $args['after_widget'];
	}


	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = sanitize_text_field( $new_instance['title'] );
		$instance['post_baru'] = sanitize_text_field( $new_instance['post_baru'] );
		return $instance;
	}
		
		
	public function form( $instance ) {
		$title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : __( 'Latest Post', 'mading' );
		$post_baru     = isset( $instance['post_baru'] ) ? esc_attr( $instance['post_baru'] ) : 3; ?>
		<p><?php _e( 'Use widget to show latest post', 'mading' ); ?><br/></p>
		<p><label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php _e( 'Widget Title :', 'mading' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" /></p>
		
		<p><label for="<?php echo esc_attr( $this->get_field_id( 'post_baru' ) ); ?>"><?php _e( 'Count post :', 'mading' ); ?></label>
		<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'post_baru' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'post_baru' ) ); ?>" type="number" value="<?php echo esc_attr( $post_baru ); ?>" /></p>

    <?php
	}
}