<?php
class SchoolInfo extends WP_Widget {
	function __construct() {
		parent::__construct(
			'infosekolah',
			esc_html__( 'Mading : School Info', 'mading' ),
			array( 'description' => esc_html__( 'Use widget to show school info', 'mading' ), 'customize_selective_refresh' => true, )
		);
	}

	public function widget( $args, $instance ) {
		if ( ! isset( $args['widget_id'] ) ) {
			$args['widget_id'] = $this->id;
		}

		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : __( 'School Info', 'mading' );
		$schmaps = ( ! empty( $instance['mapsembed'] ) ) ? '<div class="embed_found">'.$instance['mapsembed'].'</div>' : '';

		/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );
		
		echo $args['before_widget']; 
		
		if ( $title ) {
			echo $args['before_title'] . $title . $args['after_title'];
		}
		
		?>
		    <div class="widget_sekolah madclear">
			    <div class="sch_maps"><?php echo $schmaps; ?></div>
			    <h4 class="mad__schoolname"><?php mading_mad__schoolname(); ?></h4>
				<div class="wid_num">
				    <?php echo esc_html__('NPSN', 'mading'); ?> <span class="nspn"><?php mading_nspn(); ?></span>
				</div>
				<table class="widget_contact">
				    <?php if ( get_theme_mod('address_data') != "" ) { ?>
				    <tr>
				        <td colspan="2"><span class="address"><?php mading_address(); ?></span></td>
					</tr>
					<?php } ?>
					<?php if ( get_theme_mod('telpon_data') != "" ) { ?>
					<tr>
					    <td><?php echo esc_html__('PHONE', 'mading'); ?></td>
						<td class="schright"><?php echo esc_html( get_theme_mod('telpon_data') ); ?></td>
					</tr>
					<?php } ?>
					<?php if ( get_theme_mod('email_data') != "" ) { ?>
					<tr>
					    <td><?php echo esc_html__('EMAIL', 'mading'); ?></td>
						<td class="schright"><?php echo esc_html( get_theme_mod('email_data') ); ?></td>
					</tr>
					<?php } ?>
					<?php if ( get_theme_mod('wa_data') != "" ) { ?>
					<tr>
					    <td><?php echo esc_html__('WHATSAPP', 'mading'); ?></td>
						<td class="schright"><?php echo esc_html( get_theme_mod('wa_data') ); ?></td>
					</tr>
					<?php } ?>
				</table>
			</div>
    	<?php	
		
		echo $args['after_widget'];
	}


	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = sanitize_text_field( $new_instance['title'] );
		$instance['mapsembed'] = $new_instance['mapsembed'];
		return $instance;
	}
		
		
	public function form( $instance ) {
		$title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : __( 'School Info', 'mading' ); 
		$schmaps   = isset( $instance['mapsembed'] ) ? '<div class="embed_found">'.esc_attr( $instance['mapsembed'] ).'</div>' : ''; 
		?>
		<p><?php _e( 'Show Maps on sidebar', 'mading' ); ?><br/></p>
		<p><label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Widget Title :', 'mading' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" /></p>
		<p><label for="embedmaps"><?php _e( 'Insert embed Maps code', 'mading' ); ?></label>
		<textarea class="widefat" id="<?php echo $this->get_field_id( 'mapsembed' ); ?>" name="<?php echo $this->get_field_name( 'mapsembed' ); ?>"><?php echo $schmaps; ?></textarea></p>
	
    <?php
	}
}