<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Register List Widget.
 *
 * Include widget file and register widget class.
 *
 * @since 1.0
 * @param \Elementor\Widgets_Manager $widgets_manager Elementor widgets manager.
 * @return void
 */
function register_ciuss_sekolahpro_widget( $widgets_manager ) {
	require_once( __DIR__ . '/widgets/mading/mading-header.php' );
	$widgets_manager->register( new \Elementor_Mading_Header_Widget() );
	require_once( __DIR__ . '/widgets/mading/mading-slider.php' );
	$widgets_manager->register( new \Elementor_Mading_Slider_Widget() );
	require_once( __DIR__ . '/widgets/mading/mading-newsticker.php' );
	$widgets_manager->register( new \Elementor_Mading_Newsticker_Widget() );
	require_once( __DIR__ . '/widgets/mading/mading-newseditorial.php' );
	$widgets_manager->register( new \Elementor_Mading_NewsEditorial_Widget() );
	require_once( __DIR__ . '/widgets/mading/mading-four-block.php' );
	$widgets_manager->register( new \Elementor_Mading_FourBlock_Widget() );
	require_once( __DIR__ . '/widgets/mading/mading-agenda.php' );
	$widgets_manager->register( new \Elementor_Mading_Agenda_Widget() );
	require_once( __DIR__ . '/widgets/mading/mading-galeri.php' );
	$widgets_manager->register( new \Elementor_Mading_Galeri_Widget() );
	require_once( __DIR__ . '/widgets/mading/mading-quotes.php' );
	$widgets_manager->register( new \Elementor_Mading_Quotes_Widget() );
	require_once( __DIR__ . '/widgets/mading/mading-gtk.php' );
	$widgets_manager->register( new \Elementor_Mading_GTK_Widget() );
	require_once( __DIR__ . '/widgets/mading/mading-video.php' );
	$widgets_manager->register( new \Elementor_Mading_Video_Widget() );
	require_once( __DIR__ . '/widgets/mading/mading-footer.php' );
	$widgets_manager->register( new \Elementor_Mading_Footer_Widget() );
	
	require_once( __DIR__ . '/widgets/sekolah/school-header-one.php' );
	$widgets_manager->register( new \Elementor_Header_One_Widget() );
	require_once( __DIR__ . '/widgets/sekolah/school-header-two.php' );
	$widgets_manager->register( new \Elementor_Header_Two_Widget() );
	require_once( __DIR__ . '/widgets/sekolah/school-header-three.php' );
	$widgets_manager->register( new \Elementor_Header_Three_Widget() );
	
	require_once( __DIR__ . '/widgets/sekolah/school-guru-one.php' );
	$widgets_manager->register( new \Elementor_Guru_One_Widget() );
	require_once( __DIR__ . '/widgets/sekolah/school-guru-two.php' );
	$widgets_manager->register( new \Elementor_Guru_Two_Widget() );
	require_once( __DIR__ . '/widgets/sekolah/school-guru-three.php' );
	$widgets_manager->register( new \Elementor_Guru_Three_Widget() );
	
	require_once( __DIR__ . '/widgets/sekolah/school-agenda-one.php' );
	$widgets_manager->register( new \Elementor_FullEvent1_Widget() );
	require_once( __DIR__ . '/widgets/sekolah/school-agenda-two.php' );
	$widgets_manager->register( new \Elementor_FullEvent2_Widget() );
	
	require_once( __DIR__ . '/widgets/sekolah/school-editorial-blog.php' );
	$widgets_manager->register( new \Elementor_EditorialBlog_Widget() );
	require_once( __DIR__ . '/widgets/sekolah/school-blogguru-one.php' );
	$widgets_manager->register( new \Elementor_BlogGuru1_Widget() );
	
	require_once( __DIR__ . '/widgets/sekolah/school-prestasi-one.php' );
	$widgets_manager->register( new \Elementor_Prestasi1_Widget() );
	require_once( __DIR__ . '/widgets/sekolah/school-prestasi-two.php' );
	$widgets_manager->register( new \Elementor_Prestasi2_Widget() );
}
add_action( 'elementor/widgets/register', 'register_ciuss_sekolahpro_widget' );

function add_ciuss_sekolahpro_widget_categories( $elements_manager ) {

	$elements_manager->add_category(
		'mading-original',
		[
			'title' => esc_html__( 'Mading Original', 'sekolahpro' ),
			'icon' => 'fa fa-plug',
		]
	);
	$elements_manager->add_category(
		'mading-widget',
		[
			'title' => esc_html__( 'Mading Widget', 'sekolahpro' ),
			'icon' => 'fa fa-plug',
		]
	);

}
add_action( 'elementor/elements/categories_registered', 'add_ciuss_sekolahpro_widget_categories' );

show_admin_bar(false);



/* Add Dashicons in WordPress Front-end */
add_action( 'wp_enqueue_scripts', 'load_dashicons_front_end' );
function load_dashicons_front_end() {
   wp_enqueue_style( 'dashicons' );
}


if ( ! function_exists( 'get_wpsekolah_menu' ) ) {
	/**
	 * Get menu list using cache
	 *
	 * @return array
	 */
	function get_wpsekolah_menu() {
		$menus = wp_cache_get( 'menu', 'sekolahpro' );

		if ( ! $menus ) {
			$menus = wp_get_nav_menus();
			wp_cache_set( 'menu', $menus, 'sekolahpro' );
		}

		$menus = array_combine( wp_list_pluck( $menus, 'slug' ), wp_list_pluck( $menus, 'name' ) );

		return $menus;
	}
}

function custom_rest_request_timeout($timeout) {
    return 600; // Tingkatkan timeout menjadi 30 detik
}
add_filter('rest_request_timeout', 'custom_rest_request_timeout');