<?php


if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

/**
 * Current Classes
 */
class Current_SekolahPro
{
    /**
     * alias for current server url
     * 
     * @since 1.0
     * @var string
     */
    const SERVER = 'https://ciuss.com'; private $id = 'F8S7QETIQB'; private $api; private $host; private $code = ''; private $key; private $data = [];

    private static $instance = null;
	
	public static function instance(){
    	if(is_null( self::$instance )){
	    	self::$instance = new self();
    	}
    	return self::$instance;
	} 
	
    /**
     * construction
     *
     */
    public function __construct()
    {
        $this->api = self::SERVER . '/wp-json/salesloo/v1/file/license';
        $this->host = library_sekolahpro_this_host(); $this->key = '__tdcom7ddc'; $this->data();

        add_action( 'admin_menu', array( $this, 'register_menu' ), 20 );
        add_action( 'admin_init', array( $this, 'on_save_action' ), 10 );
        add_action( 'wp_update_plugins', array( $this, 'periodic_check' ) );
        add_action( 'plugins_loaded', array( $this, 'template_init' ) );
		add_action( 'wp_head', array( $this, 'mading_service' ), 20 );
		add_action( 'plugins_loaded', array( $this, 'school_init' ) );
		// add_action( 'admin_notices', array( $this, 'important' ), 20 );
    }
	
    public function template_init() {
        if ($this->status == 200) {
            if (did_action('elementor/loaded')) {
				$timezone  = +7; $gmt7 = gmdate("d-m-Y H:i:s", time() + 3600*($timezone+gmdate("I"))); 
				$cools = strtotime($gmt7); 
				if ( $this->expired_at != "" ) { $morecools = strtotime(wp_date('Y-m-d H:i:s', strtotime($this->expired_at)));
	            $happylib = $morecools-$cools; if ( $happylib > 0 ) { 
				    require SEKOLAHPRO_PATH . 'base.php'; \CL\Elementor\Base::instance();
				} }
                require(SEKOLAHPRO_PATH . 'classes/functions.php');
				require_once SEKOLAHPRO_PATH . 'includes/class-sekolahpro-extention.php';
            }
			require_once SEKOLAHPRO_PATH . 'includes/sekolah/post-type.php';
			require_once SEKOLAHPRO_PATH . 'includes/class-sekolahpro-init.php';
			add_action('customize_register', [$this, 'register_into_mading_settings']);
		} else if ($this->status == 402) {
			if (did_action('elementor/loaded')) {
                require(SEKOLAHPRO_PATH . 'classes/functions.php');
				require_once SEKOLAHPRO_PATH . 'includes/class-sekolahpro-extention.php';
            }
			require_once SEKOLAHPRO_PATH . 'includes/sekolah/post-type.php';
			add_action('customize_register', [$this, 'register_into_mading_settings']);
		} else {
			add_action('customize_register', [$this, 'unregister_into_mading_settings']);
		}
    }

    public function register_into_mading_settings($wp_customize) {
        $wp_customize->add_setting('mode_tema',array(
            'default'     => 'mading',
        	'transport'   => 'refresh',
        	'sanitize_callback' => 'wp_kses_post'
        ));
        $wp_customize->add_control('mode_tema',array(
            'label'        => __('Theme Mode', 'mading'),
            'type'         => 'select',
        	'choices'      => array(
	        	'mading'     => 'Mode Mading (Default)',
	        	'akademi'    => 'Mode Akademi',
	        	'prestasi'   => 'Mode Prestasi',
	        	'magazine'   => 'Mode Magazine',
	        	'awesome'    => 'Mode Awesome',
        	),
            'section'      => 'mading_layout',
            'settings'     => 'mode_tema',
        ));
    }

    public function unregister_into_mading_settings($wp_customize) {
        $wp_customize->add_setting('mode_tema',array(
            'default'     => 'mading',
        	'transport'   => 'refresh',
        	'sanitize_callback' => 'wp_kses_post'
        ));
        $wp_customize->add_control('mode_tema',array(
            'label'        => __('Theme Mode', 'mading'),
            'type'         => 'select',
        	'choices'      => array(
	        	'mading'     => 'Mode Mading (Default)',
        	),
            'section'      => 'mading_layout',
            'settings'     => 'mode_tema',
        ));
    }
	
    public function school_init() {
        if ($this->status == 200) {
			$timezone  = +7;
			$gmt7 = gmdate("d-m-Y H:i:s", time() + 3600*($timezone+gmdate("I"))); 
			$cools = strtotime($gmt7);
			
			if ( $this->expired_at != "" ) { 
		    	$morecools = strtotime(wp_date('Y-m-d H:i:s', strtotime($this->expired_at)));
	            $happylib = $morecools-$cools;
		    	if ( $happylib > 0 ) { 
					function theme_pre_set_transient_update_mading ( $transient ) {
				    	if ( empty( $transient->checked['mading'] ) ) {
    	    	            return $transient;
   	    	            }
						$response = wp_safe_remote_get( 'https://update.ciuss.com/wp-content/uploads/newmading.json', array(
    	    	            'timeout' => 10 // Setting timeout to 3 seconds
    	    	        ) );
						// Check if request was successful
     	    	        if ( ! is_wp_error( $response ) && wp_remote_retrieve_response_code( $response ) === 200 ) {
    	    	            $result = wp_remote_retrieve_body( $response );

     	    	            // Make sure that we received the data in the response and it's not empty
    	    	            if ( ! empty( $result ) ) {
    	    	                // Decode JSON data
    	    	                $data = json_decode( $result );
	    	
    	    	                // Check server version against current installed version
        	    	            if ( $data && version_compare( $transient->checked['mading'], $data->new_version, '<' ) ) {
        	    	                // Update transient with response data
        	    	                $transient->response['mading'] = (array) $data;
        	    	            }
        	    	        }
     	    	        }
						return $transient;
					}
					add_filter ( 'pre_set_site_transient_update_themes', 'theme_pre_set_transient_update_mading' );
			    }
			}
			
		}
    }
	
    /**
     * data
     * 
     * get data from database;
     * 
     * @since 1.0
     * @return mixed
     */
    public function data()
    {
        $option = get_option($this->key);

        if (empty($option)) return $this;

        $this->data = json_decode(library_sekolahpro_decrypt($option), true);

        return $this;
    }

    /**
     * getter
     * @param  string $name
     * @return mixed
     */
    public function __get($name)
    {
        $value = NULL;

        if (array_key_exists($name, (array)$this->data))
            $value = maybe_unserialize($this->data[$name]);

        return $name == 'status' ? intval($value) : $value;
    }

    /**
     * update_option
     *
     * @param  mixed $result
     * @return void
     */
    private function update_option($result)
    {
        wp_cache_delete($this->key, 'options');
        update_option($this->key, library_sekolahpro_encrypt(wp_json_encode($result)));
    }

    /**
     * Register Menu
     * 
     * register manage current menu
     */
	
    public function register_menu()
    {   
	    $timezone  = +7;
		$gmt7 = gmdate("d-m-Y H:i:s", time() + 3600*($timezone+gmdate("I"))); 
		$cools = strtotime($gmt7);
		if ($this->status == 200) {
			if ( $this->expired_at != "" ) {
				$morecools = strtotime(wp_date('Y-m-d H:i:s', strtotime($this->expired_at)));
				$countdown = $morecools-$cools;
		      	if ( $countdown < 585313 && $countdown > 0 ) {
		    		$notif = '<span class="lisensi_renew">'.__( 'Renew License', 'sekolahpro' ).'</span>';
		    	} else if ( $countdown < 0 ) {
		    		$notif = '<span class="lisensi_expired">'.__( 'License Expired', 'sekolahpro' ).'</span>';
		    	} else if ( $countdown > 585313 ) {
		    		$notif = '<span class="lisensi_activated">'.__( 'License Active', 'sekolahpro' ).'</span>';
				}
			}
		} else if ($this->status == 402) {
			$notif = '<span class="lisensi_renew">'.__( 'License Expired', 'sekolahpro' ).'</span>';
		} else {
			$notif = '<span class="lisensi_need">'.__( 'Activate License', 'sekolahpro' ).'</span>';
		}
        add_menu_page(
            __( 'Mading License', 'sekolahpro' ),
            $notif,
            'manage_options',
            'ciuss-sekolahpro-lisensi',
            array( $this, 'page' ),
            'dashicons-admin-network',
            '2'
        );
    }
	
	public function mading_service() {
		$timezone  = +7;
		$gmt7 = gmdate("d-m-Y H:i:s", time() + 3600*($timezone+gmdate("I"))); 
		$cools = strtotime($gmt7);
		$my_theme = wp_get_theme();
		if ( $my_theme->get( 'Name' ) == 'Mading' ) {
			if ($this->status == 200) {
		    	if ( $this->expired_at != "" ) {
					$morecools = strtotime(wp_date('Y-m-d H:i:s', strtotime($this->expired_at)));
					$countdown = $morecools-$cools;
	 	         	if ( $countdown < 585313 && $countdown > 0 ) {
				        echo '<!-- Mading Code : Grey'. wp_date( 'md', strtotime( $this->expired_at ) ) .' -->';
					} else if ( $countdown < 0 ) {
		    	        echo '<!-- Mading Code : Red'. wp_date( 'md', strtotime( $this->expired_at ) ) .' -->';
		        	} else if ( $countdown > 585313 ) {
						echo '<!-- Mading Code : Green'. wp_date( 'md', strtotime( $this->expired_at ) ) .' -->';
			    	}
	    		} 
			} else if ($this->status == 402) {
				echo '<!-- Mading Code : Red -->';
			} else {
				echo '<!-- Mading Code : Yellow -->';
			}
		}
		
    }
	
	public function important() {
		?>
	     
    		<div class="notice notice-error is-dismissible">
			    <p><strong>PENGGGUNA MADING !!! ADA FITUR YANG AKAN DIHAPUS</strong><br/>Kolom input baru ditambahkan pada pos Video<br/>untuk menggantikan kolom input ID Video Youtube pada plugin Sekolah Pro sejak versi 3.0</p>
				<p><a target="_blank" href="https://ciuss.com/hapus-kolom/" class="button button-primary">Lihat Detailnya</a></p>
			</div>
			
		<?php
	}
				

    /**
     * show menu page
     */
    public function page() {
		?>
	    
    		<div class="wrap">
		    	<h2><?php echo 'Lisensi iDealer'; ?></h2>
				<form class="ciuss__lisensi" action="" method="post" enctype="multipart/form-data">
					
					<?php
				    	wp_nonce_field('__sekolahpro_activate', '__activate');
						
						$readonly = '';
						$value = '';
						
						$this->data();
						
						if ($this->status == 200 && $this->purchase_code) {
							$readonly = 'readonly';
							$value = substr_replace($this->purchase_code, '************************', 0, 26);
						}
						
						ob_start();
				    	?>
					
				    	<div class="ciuss__section ciuss__clear">
				    	
							<div class="ciuss__left">
							    <div class="ciuss__insection ciuss__clear">
								    <div class="ciuss__logo">
							        	<img class="ciuss_logo" src="<?php echo esc_url( plugin_dir_url( dirname( __FILE__ ) ) .'admin/img/ciuss.png' ); ?>" />
							    	</div>
									<div class="ciuss__input ciuss__clear">
									    <input type="text" placeholder="masukan lisensi..." name="purchase_code" class="input__lisensi" value="<?php echo esc_attr( $value ); ?>" <?php echo esc_attr( $readonly ); ?>>
										<?php if ($this->status == 200) {  ?>
									    	<input type="submit" class="ciuss__button button__red" name="action" value="Deactivate">
										<?php } else if ($this->status == 402) { ?>
									    	<input type="submit" class="ciuss__button button__blue" placeholder="" name="action" value="Activate">
										<?php } else { ?>
									    	<input type="submit" class="ciuss__button button__blue" name="action" value="Activate">
										<?php } ?>
									</div>
								</div>
								<div class="ciuss__insection ciuss__clear">
								    <div class="ciuss__40">
									    <div class="inner__40 ciuss__timer">
										    <?php
											    echo '<div class="top__40">';
											    if ($this->status == 200) {    
								    		    	if ( $this->expired_at != "" ) {
								    			    	$timezone  = +7;
								    		        	$gmt7 = gmdate("d-m-Y H:i:s", time() + 3600*($timezone+gmdate("I"))); 
								    		            $cools = strtotime($gmt7);
								    		        	$morecools = strtotime(date_i18n($this->expired_at));
								    		        	$countdown = $morecools-$cools;
								    			    	if ( $countdown > 0 ) {
								    			    		echo 'Lisensi <span class="ciuss__active">Aktif</span>';
								    			    	} else if ( $countdown < 0 ) {
								    			    		echo 'Lisensi <span class="ciuss__inactive">Expired</span>';
								    			    	}
								    		    	} 
								    	    	} else if ($this->status == 402) {
								    		        echo 'Lisensi <span class="ciuss__inactive">Expired</span>';
								    	        } else {
								    	    	    echo 'Lisensi <span class="ciuss__inactive">Tidak Aktif</span>';
								    	        }
												echo '<br/><br/></div>';
												
									            if ($this->status == 200) {
										        	if ( $this->expired_at != "" ) {
														$timezone = +7;
														$gmt7 = gmdate("d-m-Y H:i:s", time() + 3600 * ($timezone + gmdate("I")));
														$cools = strtotime($gmt7);
														$morecools = strtotime(date_i18n($this->expired_at));
														$countdown = $morecools - $cools;
														$totalcount = 365 * 24 * 60 * 60;
														$progress = ($totalcount - $countdown) / $totalcount * 360;
														$daysRemaining = ceil($countdown / (24 * 60 * 60));
														echo '<script>
													    	document.addEventListener("DOMContentLoaded", function() {
																updateProgressCircle(' . round($progress, 2) . ', ' . $daysRemaining . ');
															});
														</script>';
														
											        	if ( $countdown < 585313 && $countdown > 0 ) {
															?>
														    	<div class="progress-circle">
															    	<div class="circle-background"></div>
																	<div class="circle-progress"></div>
																	<div class="circle-center">
																    	<span id="progress-percentage">0</span>
																	</div>
															    	<span class="ciuss__leave">Hari Tersisa</span>
														    	</div>
																<script>
															    	function updateProgressCircle(progress, daysRemaining) {
																		const progressCircle = document.querySelector('.progress-circle');
																		const progressText = document.getElementById('progress-percentage');
																		
																		const degrees = progress;
																		
																		progressCircle.style.background = `conic-gradient(
																	    	#f66 ${degrees}deg,
																			#222 ${degrees}deg
																		)`;
																		
																		progressText.textContent = `${daysRemaining}`;
																	}
																</script>
															<?php
												        } else if (  $countdown < 0 ) {
															
														} else if ( $countdown > 585313 ) {
												        	?>
														    	<div class="progress-circle">
															    	<div class="circle-background"></div>
																	<div class="circle-progress"></div>
																	<div class="circle-center">
																    	<span id="progress-percentage">0</span>
																	</div>
															    	<span class="ciuss__leave">Hari Tersisa</span>
														    	</div>
																<div class="ciuss__clear ciuss__alcenter">
															    	<span class="onactive">Aktif hingga</span>
																	<span class="onactive"><?php echo wp_date( 'd M', strtotime( $this->expired_at ) ); ?></span>
																	<span class="onactive"><?php echo wp_date( 'Y', strtotime( $this->expired_at ) ); ?></span>
															    </div>
																<script>
															    	function updateProgressCircle(progress, daysRemaining) {
																		const progressCircle = document.querySelector('.progress-circle');
																		const progressText = document.getElementById('progress-percentage');
																		
																		const degrees = progress;
																		
																		progressCircle.style.background = `conic-gradient(
																	    	#eee ${degrees}deg,
																			#74d774 ${degrees}deg
																		)`;
																		
																		progressText.textContent = `${daysRemaining}`;
																	}
																</script>
															<?php
												        }
													} 
												} else if ($this->status == 402) {
										         	echo 'Untuk tetap mendapatkan update fitur dan bantuan saat ada kendala, silahkan perbarui Lisensi dengan harga 150.000,- / tahun (opsional dan tidak wajib).<br/><br/>Masuk ke <a href="https://ciuss.com/dashboard/" target="__blank">Member Area</a> untuk melakukan pembaruan, lalu aktifkan kembali kode Lisensi';
									         	} else {
								         			echo 'Untuk dapat menggunakan fitur tema dan mendapat bantuan saat ada kendala, silahkan melakukan pembelian.<br/><br/>Masuk ke <a href="https://ciuss.com/dashboard/" target="__blank">Member Area</a> untuk melakukan pembelian, lalu masukan kode Lisensi pada kolom dibagian atas lalu tekan tombol Activate';
									         	}
									    	?>
										</div>
									</div>
									
									<div class="ciuss__60">
									    <div class="inner__60 ciuss__timer">
										    
											<div class="ciuss__life">
											    <div class="top__80">
											        <?php echo '08.00 - 20.00'; ?>
										    	</div>
										    	<div class="top__60">
											        <?php echo 'Support Pelanggan'; ?>
										    	</div>
										     	<div class="ciuss__move"><?php echo 'Support diberikan untuk pelanggan yang Lisensinya masih aktif'; ?></div>
											</div>
											
											<div class="work-progress-container">
										    	<div id="work-progress-bar"></div>
												<div id="work-tooltip">Tutup</div>
												<div class="online">
											    	<span class="ciuss__open">08:00</span> <?php echo esc_html( date_i18n('D') ); ?>, <?php echo esc_html( date_i18n('d M Y') ); ?> <span class="ciuss__close">20:00</span>
												</div>
											</div>
											<script>
										    	document.addEventListener("DOMContentLoaded", function () {
													const progressBar = document.getElementById("work-progress-bar");
													const tooltip = document.getElementById("work-tooltip");
													
													const startTime = new Date();
													startTime.setHours(8, 0, 0, 0); // Set waktu mulai 19:32:00
													const endTime = new Date();
													endTime.setHours(20, 0, 0, 0); // Set waktu selesai 20:00:00
													
													function updateProgress() {
														const now = new Date();
														const totalWorkTime = endTime - startTime;
														const elapsedWorkTime = now - startTime;
														
														if (now < startTime) {
															// Sebelum waktu mulai
															progressBar.style.width = "0%";
															tooltip.textContent = "Masih Offline";
															tooltip.style.left = "0";
															tooltip.classList.add("completed");
														} else if (now >= endTime) {
															// Setelah waktu selesai
															progressBar.style.width = "100%";
															tooltip.textContent = "Tutup";
															tooltip.style.left = "100%";
															tooltip.classList.add("completed");
														} else {
															// Dalam rentang waktu kerja
															const progressPercentage = (elapsedWorkTime / totalWorkTime) * 100;
															progressBar.style.width = `${progressPercentage}%`;
															// Menghitung countdown waktu yang tersisa
															const remainingTime = new Date(endTime - now);
															const hours = String(remainingTime.getUTCHours()).padStart(2, '0');
															const minutes = String(remainingTime.getUTCMinutes()).padStart(2, '0');
															const seconds = String(remainingTime.getUTCSeconds()).padStart(2, '0');
															
															tooltip.textContent = `${hours}:${minutes}:${seconds}`;
															tooltip.style.left = `${progressPercentage}%`;
															tooltip.classList.remove("completed");
														}
													}
													
													setInterval(updateProgress, 100);
													updateProgress();
												});
											</script>	
										</div>
									</div>
									
									<div class="ciuss__30">
									    <div class="inner__30 ciuss__lifetime">
									    	<h3 class="status_lisensi"><?php echo 'Pemakaian Lifetime'; ?></h3>
									    	<p class="description"><?php echo 'Fitur bawaan tema tetap berjalan jika lisensi Expired. Tetapi support akan dihentikan dan akses update akan terputus<br/><br/>Terdapat opsi melakukan perpanjangan lisensi agar kembali mendapatkan support dan update berlaku 1 tahun.'; ?></p>
								    	</div>
							    	</div>
									<div class="ciuss__30">
									    <div class="inner__30 ciuss__support">
										<div class="ciuss__lite">
									    	<h3 class="status_lisensi"><?php echo 'Gratis Support 1 Tahun'; ?></h3>
									    	<p class="description"><?php echo 'Pelanggan mendapatkan gratis support selama 1 tahun terhitung sejak tanggal pembelian'; ?></p><br/>
											<a class="ciuss__chat" href="https://wa.me/6281532744804/?text=Saya ingin bertanya seputar tema...">Chat Support</a>
								    	</div>
										</div>
							    	</div>
									<div class="ciuss__30">
									    <div class="inner__30 ciuss__update">
										<div class="ciuss__lite">
									    	<h3 class="status_lisensi"><?php echo 'Akses Update 1 Tahun'; ?></h3>
									    	<p class="description"><?php echo 'Akses update otomatis dan download tema dan plugin dari Member Area Ciuss'; ?></p><br/>
											<a class="ciuss__member" href="https://ciuss.com/dashboard">Member Area</a>
								    	</div>
										</div>
							    	</div>
						        </div>
						    </div>
							
							<div class="ciuss__right">
							    <img class="" src="<?php echo esc_url( plugin_dir_url( dirname( __FILE__ ) ) .'admin/img/backup.webp' ); ?>" />
								<p class="description"><?php echo 'Bahaya malware mengancam website, antisipasi lebih awal dengan hal berikut'; ?></p>
								<ul>
							    	<li>1. Hindari banyak web dalam 1 Hosting</li>
									<li>2. Hindari aplikasi bajakan di Komputer</li>
                                    <li>3. Hindari memakai plugin bajakan</li>
									<li>4. Segera update plugin, tema, dan Wordpress</li>
									<li><a href="https://ciuss.com/malware">Pelajari selengkapnya</a></li>

								</ul>
								<br/>
								<h2>Rutin Backup Website, Wajib Dilakukan</h2>
								<p>Sebagai pemilik website harus paham tentang resiko dari kerusakan website disebabkan faktor X seperti Malware dan kehilangan data website disebabkan kecerobohan dari pengelola (contohnya tidak sengaja menghapus website)<br/><br/>
								Backup berkala dapat membantu pemilik website mengembalikan website dari kerusakan atau konten yang terhapus. Termasuk backup juga dapat mengembalikan kode lisensi yang terpasang, baik itu Aktif maupun Expired. Segera backup website untuk solusi masalah tidak terduga
								</p>
							</div>
							
						</div>
						
						
				</form>
			</div>
	
	<?php
		
    }

    /**
     * action submit
     *
     * @return void
     */
    public function on_save_action()
    {

        if (isset($_POST['__activate']) && wp_verify_nonce($_POST['__activate'], '__sekolahpro_activate')) {
            if ($_POST['action'] == 'Activate') {
                $this->code = sanitize_text_field($_POST['purchase_code']);
                $this->activate();
            } else {
                $this->code = $this->purchase_code;
                $this->deactivate();
            }
        }
    }

    /**
     * api_response
     *
     * @param  mixed $response
     * @return mixed
     */
    private function api_response($response)
    {
        if (!is_wp_error($response)) {
            $result   = json_decode(wp_remote_retrieve_body($response), true);
            $code = intval(wp_remote_retrieve_response_code($response));
        } else {
            $result = [
                'status' => 999,
                'message' => $response->get_error_message()
            ];
        }

        return $result;
    }


    /**
     * activate 
     * 
     * activate the current
     *
     * @return mixed
     */
    private function activate()
    {
        $server = add_query_arg([
            'purchase_code' => $this->code,
            'id'            => $this->id,
            'host'          => $this->host
        ], $this->api);

        $result = $this->api_response(wp_remote_post($server));

        if (isset($result['message'])) {
            add_action('admin_notices', function () use ($result) {
                echo '<div id="message" class="notice notice-success"><p><strong>' . $result['message'] . '</strong></p></div>';
            });
        }

        if (isset($result['status']) && intval($result['status']) != 999) {
            $this->update_option($result);
        }

        return true;
    }

    /**
     * delete
     * 
     * delete the current
     *
     * @return void
     */
    private function deactivate()
    {
        $server = add_query_arg([
            'purchase_code' => $this->code,
            'id'            => $this->id,
            'host'          => $this->host
        ], $this->api);

        $result = $this->api_response(
            wp_remote_request(
                $server,
                ['method' => 'DELETE']
            )
        );

        if (isset($result['status']) && intval($result['status']) == 200) {

            unset($result['status']);
            $this->update_option($result);
        }

        if (isset($result['message'])) {
            add_action('admin_notices', function () use ($result) {
                echo '<div id="message" class="notice notice-error"><p><strong>' . $result['message'] . '</strong></p></div>';
            });
        }

        return true;
    }

    /**
     * check
     * 
     * checking the current
     * 
     * @return void
     */
    private function check()
    {
        $server = add_query_arg([
            'purchase_code' => $this->code,
            'id'            => $this->id,
            'host'          => $this->host
        ], $this->api);

        if ($this->data['id'] == $this->id) {
            $result = $this->api_response(wp_remote_get($server));

            if (isset($result['status']) && intval($result['status']) != 999) {
                $this->update_option($result);
            }
        } else {
            if (!empty($this->expired_at)) {
    $expired_at = strtotime($this->expired_at);
} else {
    $expired_at = false;
}


            $is_expired = $expired_at && $expired_at <= strtotime('now') ? true : false;

            if ($is_expired) {
                $result = [
                    'message' => sprintf(__('Your purchase code has an expired, please renew your purchase or use another active purchase code', 'salesloo'), $this->host),
                    'status' => 403
                ];

                $this->update_option($result);
            }
        }

        return true;
    }

    /**
     * periodic_check
     * 
     * on current periodic check
     *
     * @return void
     */
    public function periodic_check()
    {
        if ($this->purchase_code && $this->status == 200) {
            $this->code = $this->purchase_code;
            $this->check();
        }
    }
}

// new Current_SekolahPro();