<?php

     
		
	register_post_type( 'alumni',		
	array(			
	    'menu_icon' => 'dashicons-businessman',
	    'labels'          => array(				
	    'name'                => __( 'Alumni', 'sekolahpro' ),				
	    'singular_name'       => __( 'Alumni', 'sekolahpro' ),        
	    'add_new'             => __( 'Add New', 'sekolahpro'  ),	
	    'add_new_item'        => __( 'Add New Item', 'sekolahpro'  ),	
	    'edit'                => __( 'Edit', 'sekolahpro'  ),	 
	    'edit_item'           => __( 'Edit Item', 'sekolahpro'  ),	
	    'new_item'            => __( 'New Item', 'sekolahpro'  ),	
	    'view'                => __( 'View', 'sekolahpro'  ),	
	    'view_item'           => __( 'View Item', 'sekolahpro'  ),	
	    'search_items'        => __( 'Search Item', 'sekolahpro'  ),	
	    'not_found'           => __( 'Item not found', 'sekolahpro'  ),	
	    'not_found_in_trash'  => __( 'Item not found in Trash', 'sekolahpro'  ),	
	    'parent'              => __( 'Parent Super Duper', 'sekolahpro'  ),
        'featured_image'      => __( 'Photo 300 x 400', 'sekolahpro' ),		
	    ),		                	
	    	'public'               => true,           					            
	    	'has_archive'          => true,        			            
	    	'supports'             => array( 'title', 'thumbnail', 'editor', 'author'),        			            
	    	'exclude_from_search'  => false, 	 
	    	'show_in_rest'         => true,
			'capabilities' => array(
                'edit_post'                 => 'edit_alumni',
				'edit_posts'                => 'edit_alumnis',
                'edit_others_posts'         => 'edit_other_alumnis',
				'edit_private_posts'        => 'edit_private_alumnis',
				'edit_published_posts'      => 'edit_published_alumnis',
				'read_post'                 => 'read_alumni',
				'read_private_posts'        => 'read_private_alumnis',
				'publish_posts'             => 'publish_alumnis',
				'delete_post'               => 'delete_alumni',
                'delete_posts'              => 'delete_alumnis',
                'delete_private_posts'      => 'delete_private_alumnis',
				'delete_others_posts'       => 'delete_others_alumnis',
                'delete_published_posts'    => 'delete_published_alumnis',
            ),
			'map_meta_cap' => true
		 )	
    );
	
	add_action('admin_init', 'alumni', 1);
	
	function alumni() {
	    add_meta_box('alumni_data', __('Alumni Data', 'sekolahpro'), 'alumni_data', 'alumni', 'normal', 'default');
	}

	function alumni_data($post) {
	    global $post;
	    echo '<input type="hidden" name="alumni_noncename" id="alumni_noncename" value="' . esc_attr( wp_create_nonce( plugin_basename(__FILE__) ) ). '" />';

	    $nomerinduk     = get_post_meta($post->ID, 'nomerinduk', true);
		$kelasjurusan   = get_post_meta($post->ID, 'kelasjurusan', true);
		$tahunlulus     = get_post_meta($post->ID, 'tahunlulus', true);
		
		$smplanjut      = get_post_meta($post->ID, 'smplanjut', true);
		
	    $smalanjut      = get_post_meta($post->ID, 'smalanjut', true);
		$smajurusan     = get_post_meta($post->ID, 'smajurusan', true);
		
		$lanjutkuliah   = get_post_meta($post->ID, 'lanjutkuliah', true);
		$jurusankuliah  = get_post_meta($post->ID, 'jurusankuliah', true);
		$lanjutkerja    = get_post_meta($post->ID, 'lanjutkerja', true);
		$lokasikerja    = get_post_meta($post->ID, 'lokasikerja', true);
		
		$lanjutkuliah2  = get_post_meta($post->ID, 'lanjutkuliah2', true);
		$jurusankuliah2 = get_post_meta($post->ID, 'jurusankuliah2', true);
		$lanjutkerja2   = get_post_meta($post->ID, 'lanjutkerja2', true);
		$lokasikerja2   = get_post_meta($post->ID, 'lokasikerja2', true);
		
		$waalumni       = get_post_meta($post->ID, 'waalumni', true);
		$fbalumni       = get_post_meta($post->ID, 'fbalumni', true);
		$twalumni       = get_post_meta($post->ID, 'twalumni', true);
		$igalumni       = get_post_meta($post->ID, 'igalumni', true);
		
		?>

		<div class="mading_metabox">
		
		    <label><?php echo esc_html_e( 'NISN', 'sekolahpro' ); ?></label>
	        <input type="text" name="nomerinduk" value="<?php echo esc_attr( $nomerinduk ); ?>" class="widefat" />
			
			<label><?php echo esc_html_e( 'Class / Study', 'sekolahpro' ); ?></label>
	        <input type="text" name="kelasjurusan" value="<?php echo esc_attr( $kelasjurusan ); ?>" class="widefat" />
			
			<label><?php echo esc_html_e( 'Graduation Year', 'sekolahpro' ); ?></label>
			<input type="text" name="tahunlulus" value="<?php echo esc_attr( $tahunlulus ); ?>" class="widefat" />
			
			<div class="sd <?php echo get_theme_mod('type_alumni', 'sma'); ?>">
		    	<label><?php echo esc_html_e( 'Continue studying at SMP / MTS', 'sekolahpro' ); ?></label>
	            <input type="text" name="smplanjut" value="<?php echo esc_attr( $smplanjut ); ?>" class="widefat" />
			</div>
			<div class="smp <?php echo get_theme_mod('type_alumni', 'sma'); ?>">
		    	<label><?php echo esc_html_e( 'Continue studying at SMA / MA / SMK', 'sekolahpro' ); ?></label>
	            <input type="text" name="smalanjut" value="<?php echo esc_attr( $smalanjut ); ?>" class="widefat" />
				<label><?php echo esc_html_e( 'Study (Especially SMK)', 'sekolahpro' ); ?></label>
	            <input type="text" name="smajurusan" value="<?php echo esc_attr( $smajurusan ); ?>" class="widefat" />
			</div>
			<div class="sma <?php echo get_theme_mod('type_alumni', 'sma'); ?>">
			    <label><?php echo esc_html_e( 'Continue studying at College', 'sekolahpro' ); ?></label>
	            <input type="text" name="lanjutkuliah" value="<?php echo esc_attr( $lanjutkuliah ); ?>" class="widefat" />
				<label><?php echo esc_html_e( 'Study', 'sekolahpro' ); ?></label>
	            <input type="text" name="jurusankuliah" value="<?php echo esc_attr( $jurusankuliah ); ?>" class="widefat" />
				<label><?php echo esc_html_e( 'Work at', 'sekolahpro' ); ?></label>
	            <input type="text" name="lanjutkerja" value="<?php echo esc_attr( $lanjutkerja ); ?>" class="widefat" />
				<label><?php echo esc_html_e( 'Location / City', 'sekolahpro' ); ?></label>
	            <input type="text" name="lokasikerja" value="<?php echo esc_attr( $lokasikerja ); ?>" class="widefat" />
			</div>
			<div class="pt <?php echo get_theme_mod('type_alumni', 'sma'); ?>">
		    	<label><?php echo esc_html_e( 'Continue studying at College', 'sekolahpro' ); ?></label>
	            <input type="text" name="lanjutkuliah2" value="<?php echo esc_attr( $lanjutkuliah2 ); ?>" class="widefat" />
				<label><?php echo esc_html_e( 'Study', 'sekolahpro' ); ?></label>
	            <input type="text" name="jurusankuliah2" value="<?php echo esc_attr( $jurusankuliah2 ); ?>" class="widefat" />
				<label><?php echo esc_html_e( 'Work at', 'sekolahpro' ); ?></label>
	            <input type="text" name="lanjutkerja2" value="<?php echo esc_attr( $lanjutkerja2 ); ?>" class="widefat" />
				<label><?php echo esc_html_e( 'Location / City', 'sekolahpro' ); ?></label>
	            <input type="text" name="lokasikerja2" value="<?php echo esc_attr( $lokasikerja2 ); ?>" class="widefat" />
			</div>
			
			<h3><?php echo esc_html_e( 'Alumni Contact', 'sekolahpro' ); ?></h3>
			<label><?php echo esc_html_e( 'WhatsApp', 'sekolahpro' ); ?></label>
	        <input type="text" name="waalumni" value="<?php echo esc_attr( $waalumni ); ?>" placeholder="62..." class="widefat" />
			<label><?php echo esc_html_e( 'Facebook', 'sekolahpro' ); ?></label>
	        <input type="text" name="fbalumni" value="<?php echo esc_attr( $fbalumni ); ?>" placeholder="https://..." class="widefat" />
			<label><?php echo esc_html_e( 'Twitter', 'sekolahpro' ); ?></label>
	        <input type="text" name="twalumni" value="<?php echo esc_attr( $twalumni ); ?>" placeholder="https://..." class="widefat" />
			<label><?php echo esc_html_e( 'Instagram', 'sekolahpro' ); ?></label>
	        <input type="text" name="igalumni" value="<?php echo esc_attr( $igalumni ); ?>" placeholder="https://..." class="widefat" />
			
		</div>
	<?php }
	
	function alumni_data_meta($post_id, $post) {

	    if ( ! isset( $_POST['alumni_noncename'] ) || !wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['alumni_noncename'] ) ), plugin_basename(__FILE__) )) {
	        return $post_id;
	    }
	    if ( !current_user_can( 'edit_post', $post_id ))

	        return $post_id;

	    $madingalumni['nomerinduk']      = isset($_POST['nomerinduk']) ? sanitize_text_field(wp_unslash( $_POST['nomerinduk'] ) ) : '' ;
		$madingalumni['kelasjurusan']    = isset($_POST['kelasjurusan']) ? sanitize_text_field(wp_unslash( $_POST['kelasjurusan'] ) ) : '' ;
		$madingalumni['tahunlulus']      = isset($_POST['tahunlulus']) ? sanitize_text_field(wp_unslash( $_POST['tahunlulus'] ) ) : '' ;
		$madingalumni['smplanjut']       = isset($_POST['smplanjut']) ? sanitize_text_field(wp_unslash( $_POST['smplanjut'] ) ) : '' ;
		$madingalumni['smalanjut']       = isset($_POST['smalanjut']) ? sanitize_text_field(wp_unslash( $_POST['smalanjut'] ) ) : '' ;
		$madingalumni['smajurusan']      = isset($_POST['smajurusan']) ? sanitize_text_field(wp_unslash( $_POST['smajurusan'] ) ) : '' ;
		$madingalumni['lanjutkuliah']    = isset($_POST['lanjutkuliah']) ? sanitize_text_field(wp_unslash( $_POST['lanjutkuliah'] ) ) : '' ;
		$madingalumni['jurusankuliah']   = isset($_POST['jurusankuliah']) ? sanitize_text_field(wp_unslash( $_POST['jurusankuliah'] ) ) : '' ;
		$madingalumni['lanjutkerja']     = isset($_POST['lanjutkerja']) ? sanitize_text_field(wp_unslash( $_POST['lanjutkerja'] ) ) : '' ;
		$madingalumni['lokasikerja']     = isset($_POST['lokasikerja']) ? sanitize_text_field(wp_unslash( $_POST['lokasikerja'] ) ) : '' ;
		$madingalumni['lanjutkuliah2']   = isset($_POST['lanjutkuliah2']) ? sanitize_text_field(wp_unslash( $_POST['lanjutkuliah2'] ) ) : '' ;
		$madingalumni['jurusankuliah2']  = isset($_POST['jurusankuliah2']) ? sanitize_text_field(wp_unslash( $_POST['jurusankuliah2'] ) ) : '' ;
		$madingalumni['lanjutkerja2']    = isset($_POST['lanjutkerja2']) ? sanitize_text_field(wp_unslash( $_POST['lanjutkerja2'] ) ) : '' ;
		$madingalumni['lokasikerja2']    = isset($_POST['lokasikerja2']) ? sanitize_text_field(wp_unslash( $_POST['lokasikerja2'] ) ) : '' ;
		$madingalumni['waalumni']        = isset($_POST['waalumni']) ? sanitize_text_field(wp_unslash( $_POST['waalumni'] ) ) : '' ;
		$madingalumni['fbalumni']        = isset($_POST['fbalumni']) ? sanitize_text_field(wp_unslash( $_POST['fbalumni'] ) ) : '' ;
		$madingalumni['twalumni']        = isset($_POST['twalumni']) ? sanitize_text_field(wp_unslash( $_POST['twalumni'] ) ) : '' ;
		$madingalumni['igalumni']        = isset($_POST['igalumni']) ? sanitize_text_field(wp_unslash( $_POST['igalumni'] ) ) : '' ;
		
	    foreach ($madingalumni as $key => $value) {        
		    if( $post->post_type == 'revision' ) return; 
	        $value = implode(',', (array)$value); 
	        if(get_post_meta($post_id, $key, FALSE)) { 
	            update_post_meta($post_id, $key, $value);
	        } else { 
	            add_post_meta($post_id, $key, $value);
	        }
	        if(!$value) delete_post_meta($post_id, $key); // 
	    }

	}

	add_action('save_post', 'alumni_data_meta', 1, 2); 