<?php
    register_post_type( 'ppdb',		
	array(			
	    'menu_icon' => 'dashicons-businessman',
	    'labels'          => array(				
	    'name'                => __( 'PPDB', 'sekolahpro' ),				
	    'singular_name'       => __( 'PPDB', 'sekolahpro' ),        
	    'add_new'             => __( 'Add New', 'sekolahpro'  ),	
	    'add_new_item'        => __( 'Add New Item', 'sekolahpro'  ),	
	    'edit'                => __( 'Edit', 'sekolahpro'  ),	 
	    'edit_item'           => __( 'Edit Item', 'sekolahpro'  ),	
	    'new_item'            => __( 'New Item', 'sekolahpro'  ),	
	    'view'                => __( 'View', 'sekolahpro'  ),	
	    'view_item'           => __( 'View Item', 'sekolahpro'  ),	
	    'search_items'        => __( 'Search Item', 'sekolahpro'  ),	
	    'not_found'           => __( 'Item not found', 'sekolahpro'  ),	
	    'not_found_in_trash'  => __( 'Item not found in Trash', 'sekolahpro'  ),	
	    'parent'              => __( 'Parent Super Duper', 'sekolahpro'  ),
        'featured_image'      => __( 'Photo 300 x 400', 'sekolahpro' ),		
	    ),		                	
	    	'public'               => true,           					            
	    	'has_archive'          => true,        			            
	    	'supports'             => array( 'title', 'editor',),        			            
	    	'exclude_from_search'  => false, 	 
	    	'show_in_rest'         => true,
			'capabilities' => array(
                'edit_post'                 => 'edit_ppdb',
				'edit_posts'                => 'edit_ppdbs',
                'edit_others_posts'         => 'edit_other_ppdbs',
				'edit_private_posts'        => 'edit_private_ppdbs',
				'edit_published_posts'      => 'edit_published_ppdbs',
				'read_post'                 => 'read_ppdb',
				'read_private_posts'        => 'read_private_ppdbs',
				'publish_posts'             => 'publish_ppdbs',
				'delete_post'               => 'delete_ppdb',
                'delete_posts'              => 'delete_ppdbs',
                'delete_private_posts'      => 'delete_private_ppdbs',
				'delete_others_posts'       => 'delete_others_ppdbs',
                'delete_published_posts'    => 'delete_published_ppdbs',
            ),
			'map_meta_cap' => true
		)	
    );

    function ppdb_add_meta_boxes() {
        add_meta_box('ppdb_data', 'Data Pendaftaran PPDB', 'ppdb_meta_box_callback', 'ppdb', 'normal', 'high');
    }
    add_action('add_meta_boxes', 'ppdb_add_meta_boxes');

    function ppdb_meta_box_callback($post) {
	
    	global $post;
	    echo '<input type="hidden" name="ppdb_noncename" id="ppdb_noncename" value="' . esc_attr( wp_create_nonce( plugin_basename(__FILE__) ) ). '" />';

	    $nisn       = get_post_meta($post->ID, 'nisn', true);
		$nikkk      = get_post_meta($post->ID, 'nikkk', true);
		$temlahir   = get_post_meta($post->ID, 'temlahir', true);
		$tanglahir  = get_post_meta($post->ID, 'tanglahir', true);
		$sex        = get_post_meta($post->ID, 'sex', true);
	    $agama      = get_post_meta($post->ID, 'agama', true);
		$alamat     = get_post_meta($post->ID, 'alamat', true);
		$nohp       = get_post_meta($post->ID, 'nohp', true);
		$emailadd   = get_post_meta($post->ID, 'emailadd', true);
		
		$ayah       = get_post_meta($post->ID, 'ayah', true);
		$kerjaayah  = get_post_meta($post->ID, 'kerjaayah', true);
		$ibu        = get_post_meta($post->ID, 'ibu', true);
		$kerjaibu   = get_post_meta($post->ID, 'kerjaibu', true);
		
		$ortuhp     = get_post_meta($post->ID, 'ortuhp', true);
		$ortuadd    = get_post_meta($post->ID, 'ortuadd', true);
		
		$wali       = get_post_meta($post->ID, 'wali', true);
		$kerjawali  = get_post_meta($post->ID, 'kerjawali', true);
		$walihp     = get_post_meta($post->ID, 'walihp', true);
		$waliadd    = get_post_meta($post->ID, 'waliadd', true);
		
		$asalsek    = get_post_meta($post->ID, 'asalsek', true);
		$lulus      = get_post_meta($post->ID, 'lulus', true);
		
		$pres1      = get_post_meta($post->ID, 'pres1', true);
		$pres2      = get_post_meta($post->ID, 'pres2', true);
		$pres3      = get_post_meta($post->ID, 'pres3', true);
		$pres4      = get_post_meta($post->ID, 'pres4', true);
		
		$jalur      = get_post_meta($post->ID, 'jalur', true);
		?>
		
		<table class="form-table">
			<tr>
			    <th><label><?php echo esc_html_e( 'Jalur Pendaftaran', 'sekolahpro' ); ?></label></th>
	            <td>
			    	<input type="radio" name="jalur" <?php checked( esc_attr( $jalur ), 'Zonasi' ) ?> value="Zonasi"/><span class="stt"><?php echo 'Zonasi'; ?></span>
					<input type="radio" name="jalur" <?php checked( esc_attr( $jalur ), 'Prestasi' ) ?> value="Prestasi"/><span class="stt"><?php echo 'Prestasi'; ?></span>
					<input type="radio" name="jalur" <?php checked( esc_attr( $jalur ), 'Afirmasi' ) ?> value="Afirmasi"/><span class="stt"><?php echo 'Afirmasi'; ?></span>
					<input type="radio" name="jalur" <?php checked( esc_attr( $jalur ), 'Mutasi' ) ?> value="Mutasi"/><span class="stt"><?php echo 'Mutasi'; ?></span>
				</td>
			</tr>
			
		    <tr colspan="2">
			    <th><label><?php echo esc_html_e( 'Calon Siswa', 'sekolahpro' ); ?></label></th>
			</tr>
		    <tr>
			    <th><label><?php echo esc_html_e( 'NISN', 'sekolahpro' ); ?></label></th>
	            <td><input type="text" name="nisn" value="<?php echo esc_attr( $nisn ); ?>" class="widefat" /></td>
			</tr>
			<tr>
			    <th><label><?php echo esc_html_e( 'NIK', 'sekolahpro' ); ?></label></th>
	            <td><input type="text" name="nikkk" value="<?php echo esc_attr( $nikkk ); ?>" class="widefat" /></td>
			</tr>
			<tr>
			    <th><label><?php echo esc_html_e( 'Tempat Lahir', 'sekolahpro' ); ?></label></th>
	            <td><input type="text" name="temlahir" value="<?php echo esc_attr( $temlahir ); ?>" class="widefat" /></td>
			</tr>
			<tr>
			    <th><label><?php echo esc_html_e( 'Tanggal Lahir', 'sekolahpro' ); ?></label></th>
	            <td><input type="date" name="tanglahir" value="<?php echo esc_attr( $tanglahir ); ?>" class="widefat" /></td>
			</tr>
			<tr>
			    <th><label><?php echo esc_html_e( 'Jenis Kelamin', 'sekolahpro' ); ?></label></th>
	            <td>
			    	<input type="radio" name="sex" <?php checked( esc_attr( $sex ), 'Laki-Laki' ) ?> value="Laki-Laki"/><span class="stt"><?php echo 'Laki Laki'; ?></span>
					<input type="radio" name="sex" <?php checked( esc_attr( $sex ), 'Perempuan' ) ?> value="Perempuan"/><span class="stt"><?php echo 'Perempuan'; ?></span>
				</td>
			</tr>
			<tr>
			    <th><label><?php echo esc_html_e( 'Agama', 'sekolahpro' ); ?></label></th>
	            <td>
			    	<input type="radio" name="agama" <?php checked( esc_attr( $agama ), 'Islam' ) ?> value="Islam"/><span class="stt"><?php echo 'Islam'; ?></span>
					<input type="radio" name="agama" <?php checked( esc_attr( $agama ), 'Kristen' ) ?> value="Kristen"/><span class="stt"><?php echo 'Kristen'; ?></span>
					<input type="radio" name="agama" <?php checked( esc_attr( $agama ), 'Katolik' ) ?> value="Katolik"/><span class="stt"><?php echo 'Katolik'; ?></span>
					<input type="radio" name="agama" <?php checked( esc_attr( $agama ), 'Hindu' ) ?> value="Hindu"/><span class="stt"><?php echo 'Hindu'; ?></span>
					<input type="radio" name="agama" <?php checked( esc_attr( $agama ), 'Buddha' ) ?> value="Buddha"/><span class="stt"><?php echo 'Buddha'; ?></span>
					<input type="radio" name="agama" <?php checked( esc_attr( $agama ), 'Konghucu' ) ?> value="Konghucu"/><span class="stt"><?php echo 'Konghucu'; ?></span>
					<input type="radio" name="agama" <?php checked( esc_attr( $agama ), 'Lainnya' ) ?> value="Lainnya"/><span class="stt"><?php echo 'Lainnya'; ?></span>
				</td>
			</tr>
			<tr>
			    <th><label><?php echo esc_html_e( 'Alamat', 'sekolahpro' ); ?></label></th>
	            <td><textarea name="alamat" class="widefat"><?php echo esc_attr( $alamat ); ?></textarea></td>
			</tr>
			<tr>
			    <th><label><?php echo esc_html_e( 'Telepon', 'sekolahpro' ); ?></label></th>
	            <td><input type="number" name="nohp" value="<?php echo esc_attr( $nohp ); ?>" class="widefat" /></td>
			</tr>
			<tr>
			    <th><label><?php echo esc_html_e( 'Email', 'sekolahpro' ); ?></label></th>
	            <td><input type="email" name="emailadd" value="<?php echo esc_attr( $emailadd ); ?>" class="widefat" /></td>
			</tr>
			
		    <tr colspan="2">
			    <th><label><?php echo esc_html_e( 'Orang Tua', 'sekolahpro' ); ?></label></th>
			</tr>
			<tr>
			    <th><label><?php echo esc_html_e( 'Nama Ayah', 'sekolahpro' ); ?></label></th>
	            <td><input type="text" name="ayah" value="<?php echo esc_attr( $ayah ); ?>" class="widefat" /></td>
			</tr>
			<tr>
			    <th><label><?php echo esc_html_e( 'Pekerjaan Ayah', 'sekolahpro' ); ?></label></th>
	            <td><input type="text" name="kerjaayah" value="<?php echo esc_attr( $kerjaayah ); ?>" class="widefat" /></td>
			</tr>
			<tr>
			    <th><label><?php echo esc_html_e( 'Nama Ibu', 'sekolahpro' ); ?></label></th>
	            <td><input type="text" name="ibu" value="<?php echo esc_attr( $ibu ); ?>" class="widefat" /></td>
			</tr>
			<tr>
			    <th><label><?php echo esc_html_e( 'Pekerjaan Ibu', 'sekolahpro' ); ?></label></th>
	            <td><input type="text" name="kerjaibu" value="<?php echo esc_attr( $kerjaibu ); ?>" class="widefat" /></td>
			</tr>
			<tr>
			    <th><label><?php echo esc_html_e( 'Telepon', 'sekolahpro' ); ?></label></th>
	            <td><input type="number" name="ortuhp" value="<?php echo esc_attr( $ortuhp ); ?>" class="widefat" /></td>
			</tr>
			<tr>
			    <th><label><?php echo esc_html_e( 'Alamat', 'sekolahpro' ); ?></label></th>
	            <td><textarea name="ortuadd" class="widefat"><?php echo esc_attr( $ortuadd ); ?></textarea></td>
			</tr>
			
		    <tr colspan="2">
			    <th><label><?php echo esc_html_e( 'Wali', 'sekolahpro' ); ?></label></th>
			</tr>
			<tr>
			    <th><label><?php echo esc_html_e( 'Nama Wali', 'sekolahpro' ); ?></label></th>
	            <td><input type="text" name="wali" value="<?php echo esc_attr( $wali ); ?>" class="widefat" /></td>
			</tr>
			<tr>
			    <th><label><?php echo esc_html_e( 'Pekerjaan Wali', 'sekolahpro' ); ?></label></th>
	            <td><input type="text" name="kerjawali" value="<?php echo esc_attr( $kerjawali ); ?>" class="widefat" /></td>
			</tr>
			<tr>
			    <th><label><?php echo esc_html_e( 'Telepon', 'sekolahpro' ); ?></label></th>
	            <td><input type="number" name="walihp" value="<?php echo esc_attr( $walihp ); ?>" class="widefat" /></td>
			</tr>
			<tr>
			    <th><label><?php echo esc_html_e( 'Alamat', 'sekolahpro' ); ?></label></th>
	            <td><textarea name="waliadd" class="widefat"><?php echo esc_attr( $waliadd ); ?></textarea></td>
			</tr>
			
		    <tr colspan="2">
			    <th><label><?php echo esc_html_e( 'Sekolah Asal', 'sekolahpro' ); ?></label></th>
			</tr>
			<tr>
			    <th><label><?php echo esc_html_e( 'Asal Sekolah', 'sekolahpro' ); ?></label></th>
	            <td><input type="text" name="asalsek" value="<?php echo esc_attr( $asalsek ); ?>" class="widefat" /></td>
			</tr>
			<tr>
			    <th><label><?php echo esc_html_e( 'Tahun Kelulusan', 'sekolahpro' ); ?></label></th>
	            <td><input type="number" name="lulus" value="<?php echo esc_attr( $lulus ); ?>" class="widefat" /></td>
			</tr>
			
		    <tr colspan="2">
			    <th><label><?php echo esc_html_e( 'Prestasi', 'sekolahpro' ); ?></label></th>
			</tr>
			<tr>
			    <th><label><?php echo esc_html_e( 'Prestasi 1', 'sekolahpro' ); ?></label></th>
	            <td><input type="text" name="pres1" value="<?php echo esc_attr( $pres1 ); ?>" class="widefat" /></td>
			</tr>
			<tr>
			    <th><label><?php echo esc_html_e( 'Prestasi 2', 'sekolahpro' ); ?></label></th>
	            <td><input type="text" name="pres2" value="<?php echo esc_attr( $pres2 ); ?>" class="widefat" /></td>
			</tr>
			<tr>
			    <th><label><?php echo esc_html_e( 'Prestasi 3', 'sekolahpro' ); ?></label></th>
	            <td><input type="text" name="pres3" value="<?php echo esc_attr( $pres3 ); ?>" class="widefat" /></td>
			</tr>
			<tr>
			    <th><label><?php echo esc_html_e( 'Prestasi 4', 'sekolahpro' ); ?></label></th>
	            <td><input type="text" name="pres4" value="<?php echo esc_attr( $pres4 ); ?>" class="widefat" /></td>
			</tr>
		</table>
    
        <?php
    }

    function ppdb_save_meta_data($post_id) {
        if ( ! isset( $_POST['ppdb_noncename'] ) || !wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['ppdb_noncename'] ) ), plugin_basename(__FILE__) )) {
	        return $post_id;
	    }
	    if ( !current_user_can( 'edit_post', $post_id ))

	        return $post_id;
        
		
		$ppdb['jalur']      = isset($_POST['jalur']) ? sanitize_text_field(wp_unslash( $_POST['jalur'] ) ) : '' ;
	    $ppdb['nisn']       = isset($_POST['nisn']) ? sanitize_text_field(wp_unslash( $_POST['nisn'] ) ) : '' ;
		$ppdb['nikkk']      = isset($_POST['nikkk']) ? sanitize_text_field(wp_unslash( $_POST['nikkk'] ) ) : '' ;
		$ppdb['temlahir']   = isset($_POST['temlahir']) ? sanitize_text_field(wp_unslash( $_POST['temlahir'] ) ) : '' ;
		$ppdb['tanglahir']  = isset($_POST['tanglahir']) ? sanitize_text_field(wp_unslash( $_POST['tanglahir'] ) ) : '' ;
		$ppdb['sex']        = isset($_POST['sex']) ? sanitize_text_field(wp_unslash( $_POST['sex'] ) ) : '' ;
		$ppdb['agama']      = isset($_POST['agama']) ? sanitize_text_field(wp_unslash( $_POST['agama'] ) ) : '' ;
		$ppdb['alamat']     = isset($_POST['alamat']) ? sanitize_text_field(wp_unslash( $_POST['alamat'] ) ) : '' ;
		$ppdb['nohp']       = isset($_POST['nohp']) ? sanitize_text_field(wp_unslash( $_POST['nohp'] ) ) : '' ;
		$ppdb['emailadd']   = isset($_POST['emailadd']) ? sanitize_text_field(wp_unslash( $_POST['emailadd'] ) ) : '' ;
		
		$ppdb['ayah']       = isset($_POST['ayah']) ? sanitize_text_field(wp_unslash( $_POST['ayah'] ) ) : '' ;
		$ppdb['kerjaayah']  = isset($_POST['kerjaayah']) ? sanitize_text_field(wp_unslash( $_POST['kerjaayah'] ) ) : '' ;
		$ppdb['ibu']        = isset($_POST['ibu']) ? sanitize_text_field(wp_unslash( $_POST['ibu'] ) ) : '' ;
		$ppdb['kerjaibu']   = isset($_POST['kerjaibu']) ? sanitize_text_field(wp_unslash( $_POST['kerjaibu'] ) ) : '' ;
		$ppdb['ortuhp']     = isset($_POST['ortuhp']) ? sanitize_text_field(wp_unslash( $_POST['ortuhp'] ) ) : '' ;
		$ppdb['ortuadd']    = isset($_POST['ortuadd']) ? sanitize_text_field(wp_unslash( $_POST['ortuadd'] ) ) : '' ;
		
		
		$ppdb['wali']       = isset($_POST['wali']) ? sanitize_text_field(wp_unslash( $_POST['wali'] ) ) : '' ;
		$ppdb['kerjawali']  = isset($_POST['kerjawali']) ? sanitize_text_field(wp_unslash( $_POST['kerjawali'] ) ) : '' ;
		$ppdb['walihp']     = isset($_POST['walihp']) ? sanitize_text_field(wp_unslash( $_POST['walihp'] ) ) : '' ;
		$ppdb['waliadd']    = isset($_POST['waliadd']) ? sanitize_text_field(wp_unslash( $_POST['waliadd'] ) ) : '' ;
		
		$ppdb['asalsek']    = isset($_POST['asalsek']) ? sanitize_text_field(wp_unslash( $_POST['asalsek'] ) ) : '' ;
		$ppdb['lulus']      = isset($_POST['lulus']) ? sanitize_text_field(wp_unslash( $_POST['lulus'] ) ) : '' ;
		
		$ppdb['pres1']      = isset($_POST['pres1']) ? sanitize_text_field(wp_unslash( $_POST['pres1'] ) ) : '' ;
		$ppdb['pres2']      = isset($_POST['pres2']) ? sanitize_text_field(wp_unslash( $_POST['pres2'] ) ) : '' ;
		$ppdb['pres3']      = isset($_POST['pres3']) ? sanitize_text_field(wp_unslash( $_POST['pres3'] ) ) : '' ;
		$ppdb['pres4']      = isset($_POST['pres4']) ? sanitize_text_field(wp_unslash( $_POST['pres4'] ) ) : '' ;
		
	    foreach ($ppdb as $key => $value) {        
		    if( $post->post_type == 'revision' ) return; 
	        $value = implode(',', (array)$value); 
	        if(get_post_meta($post_id, $key, FALSE)) { 
	            update_post_meta($post_id, $key, $value);
	        } else { 
	            add_post_meta($post_id, $key, $value);
	        }
	        if(!$value) delete_post_meta($post_id, $key); // 
	    }

	}
    add_action('save_post', 'ppdb_save_meta_data');
