<?php
    
	 
	
	register_post_type( 'prestasi',		
	array(			
	    'menu_icon'       => 'dashicons-heart',
	    'labels'          => array(				
	    'name'                => __( 'Prestasi', 'sekolahpro' ),				
	    'singular_name'       => __( 'Prestasi', 'sekolahpro' ),        
	    'add_new'             => __( 'Add New', 'sekolahpro'  ),	
	    'add_new_item'        => __( 'Add New Item', 'sekolahpro'  ),	
	    'edit'                => __( 'Edit', 'sekolahpro'  ),	 
	    'edit_item'           => __( 'Edit Item', 'sekolahpro'  ),	
	    'new_item'            => __( 'New Item', 'sekolahpro'  ),	
	    'view'                => __( 'View', 'sekolahpro'  ),	
	    'view_item'           => __( 'View Item', 'sekolahpro'  ),	
	    'search_items'        => __( 'Search Item', 'sekolahpro'  ),	
	    'not_found'           => __( 'Item not found', 'sekolahpro'  ),	
	    'not_found_in_trash'  => __( 'Item not found in Trash', 'sekolahpro'  ),	
	    'parent'              => __( 'Parent Super Duper', 'sekolahpro'  ),
        'featured_image'      => __( 'Featured Image', 'sekolahpro' ),			
	    ),		                	
	    	'public'              => true,           					            
	    	'has_archive'         => true,        			            
	    	'supports'            => array( 'title', 'editor', 'thumbnail' ),        			            
	    	'exclude_from_search' => false,
			'show_in_rest'        => true,
			'capabilities' => array(
                'edit_post'                 => 'edit_prest',
				'edit_posts'                => 'edit_prests',
                'edit_others_posts'         => 'edit_other_prests',
				'edit_private_posts'        => 'edit_private_prests',
				'edit_published_posts'      => 'edit_published_prests',
				'read_post'                 => 'read_prest',
				'read_private_posts'        => 'read_private_prests',
				'publish_posts'             => 'publish_prests',
				'delete_post'               => 'delete_prest',
                'delete_posts'              => 'delete_prests',
                'delete_private_posts'      => 'delete_private_prests',
				'delete_others_posts'       => 'delete_others_prests',
                'delete_published_posts'    => 'delete_published_prests',
            ),
			'map_meta_cap' => true
		 )	
    );
	
	if ( get_theme_mod( 'hide_tutor' ) !== 'off' ) {
	add_action('admin_init', 'press_tutorial', 1);
	 
	function press_tutorial() {
	    add_meta_box('presstutorial', __('Tutorial', 'sekolahpro'), 'presstutorial', 'prestasi', 'normal', 'default');
	}

	function presstutorial() { ?>
		    
		<div class="mading_metabox">
		    <?php echo wp_oembed_get( 'https://www.youtube.com/watch?v=GEKph72CHPI' ); ?>
		</div>
    
	<?php }
	}
	
	add_action('admin_init', 'pres', 1);
	
	function pres() {
	    add_meta_box('sch_pres', __('Achiever', 'sekolahpro'), 'sch_pres', 'prestasi', 'normal', 'default');
	}

	function sch_pres($post) {
	    global $post;
	    echo '<input type="hidden" name="press_noncename" id="press_noncename" value="' . esc_attr( wp_create_nonce( plugin_basename(__FILE__) ) ) . '" />';

	    $peraih = get_post_meta($post->ID, '_peraih', true);
		$photo  = get_post_meta($post->ID, '_photo', true);
		?>
		
		<div class="mading_metabox">
		
			<label><?php echo esc_html_e('Name or group','sekolahpro' ); ?></label>
	        <input type="text" name="_peraih" value="<?php echo esc_attr( $peraih ); ?>" class="widefat" />
			
			<div class="madclear">
				<p><?php echo esc_html_e('Add photo','sekolahpro' ); ?></p>
				<img class="photox" style="width: 300px; height: auto;" src="<?php echo esc_url( $photo ); ?>" />
				<input type="hidden" name="_photo" id="_photo" value="<?php echo esc_url( $photo ); ?>" class="custom_media_url" />
				<input id ="upload_image_button" type="button" value="<?php echo esc_attr_e('Upload','sekolahpro' ); ?>" class="button button-primary button-large" />
			</div>
							
			<script type = "text/javascript">
            var file_frame;
			jQuery('#upload_image_button').on('click', function(podcast) {
		    	podcast.preventDefault();
				if (file_frame) {
			    	file_frame.open();
					return;
				}
				
				file_frame = wp.media.frames.file_frame = wp.media({
			    	title: jQuery(this).data('uploader_title'),
					button: {
				    	text: jQuery(this).data('uploader_button_text'),
					},
					multiple: false
				});
				
				file_frame.on('select', function(){
			    	attachment = file_frame.state().get('selection').first().toJSON();
					jQuery(".photox").attr('src', attachment.url);
					var all = JSON.stringify( attachment ); 
					var url = attachment.url;
					var namefile = document.getElementById("_photo");
					namefile.value = url; 
				});
				
				file_frame.open();
			});
		    </script>
		
		</div>
		
	<?php }

	function pres_meta($post_id, $post) {
	    if ( ! isset( $_POST['press_noncename'] ) || !wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['press_noncename'] ) ), plugin_basename(__FILE__) )) {
	    return $post_id;
	    }

	    if ( !current_user_can( 'edit_post', $post_id ))
	        return $post_id;
			
	    $events_meta['_peraih'] = sanitize_text_field( $_POST['_peraih'] );
		$events_meta['_photo']  = sanitize_text_field( $_POST['_photo'] );

	    foreach ($events_meta as $key => $value) {         
		    if( $post->post_type == 'revision' ) return;
	        $value = implode(',', (array)$value); 
	        if(get_post_meta($post_id, $key, FALSE)) { 
	            update_post_meta($post_id, $key, $value);
	        } else { 
	            add_post_meta($post_id, $key, $value);
	        }
	        if(!$value) delete_post_meta($post_id, $key);
	    }

	}

	add_action('save_post', 'pres_meta', 1, 2); 