<?php
    
	 
	
	register_post_type( 'santri',		
	array(			
	    'menu_icon' => 'dashicons-groups',
	    'labels'          => array(				
	    'name'                => __( 'Santri', 'sekolahpro' ),				
	    'singular_name'       => __( 'Santri', 'sekolahpro' ),        
	    'add_new'             => __( 'Add New', 'sekolahpro'  ),	
	    'add_new_item'        => __( 'Add New Item', 'sekolahpro'  ),	
	    'edit'                => __( 'Edit', 'sekolahpro'  ),	 
	    'edit_item'           => __( 'Edit Item', 'sekolahpro'  ),	
	    'new_item'            => __( 'New Item', 'sekolahpro'  ),	
	    'view'                => __( 'View', 'sekolahpro'  ),	
	    'view_item'           => __( 'View Item', 'sekolahpro'  ),	
	    'search_items'        => __( 'Search Item', 'sekolahpro'  ),	
	    'not_found'           => __( 'Item not found', 'sekolahpro'  ),	
	    'not_found_in_trash'  => __( 'Item not found in Trash', 'sekolahpro'  ),	
	    'parent'              => __( 'Parent Super Duper', 'sekolahpro'  ),
        'featured_image'      => __( 'Photo 300 x 400', 'sekolahpro' ),		
	    ),		                	
	    	'public'               => true,           					            
	    	'has_archive'          => true,        			            
	    	'supports'             => array( 'title', 'thumbnail', 'editor'),        			            
	    	'exclude_from_search'  => false, 	 
	    	'show_in_rest'         => true,
			'capabilities' => array(
                'edit_post'                 => 'edit_santri',
				'edit_posts'                => 'edit_santris',
                'edit_others_posts'         => 'edit_other_santris',
				'edit_private_posts'        => 'edit_private_santris',
				'edit_published_posts'      => 'edit_published_santris',
				'read_post'                 => 'read_santri',
				'read_private_posts'        => 'read_private_santris',
				'publish_posts'             => 'publish_santris',
				'delete_post'               => 'delete_santri',
                'delete_posts'              => 'delete_santris',
                'delete_private_posts'      => 'delete_private_santris',
				'delete_others_posts'       => 'delete_others_santris',
                'delete_published_posts'    => 'delete_published_santris',
            ),
			'map_meta_cap' => true
		 )	
    );
	
	if ( get_theme_mod( 'hide_tutor' ) !== 'off' ) {
	add_action('admin_init', 'santri_tutorial', 1);
	 
	function santri_tutorial() {
	    add_meta_box('santritutorial', __('Tutorial', 'sekolahpro'), 'santritutorial', 'santri', 'normal', 'default');
	}

	function santritutorial() { ?>
		    
		<div class="mading_metabox">
		    <?php echo wp_oembed_get( 'https://www.youtube.com/watch?v=tZPhBBgZNdU' ); ?>
		</div>
    
	<?php }
	}
	
	add_action('admin_init', 'san_meta', 1);
	function san_meta() {
	    add_meta_box('san_data', __('Biodata', 'sekolahpro'), 'san_data', 'santri', 'normal', 'default');
	}

	function san_data($post) {
	    global $post;
	    echo '<input type="hidden" name="santri_noncename" id="santri_noncename" value="' . esc_attr( wp_create_nonce( plugin_basename(__FILE__) ) ) . '" />';

	    $mas  = get_post_meta($post->ID, '_mas', true);
		$nisn = get_post_meta($post->ID, '_nisn', true);
	    $sex  = get_post_meta($post->ID, '_sex', true);
		$tmpt = get_post_meta($post->ID, '_tmpt', true);
		$tgl  = get_post_meta($post->ID, '_tgl', true);
		$rel  = get_post_meta($post->ID, '_rel', true);
		$add  = get_post_meta($post->ID, '_add', true);
		$telp = get_post_meta($post->ID, '_telp', true);
		$mail = get_post_meta($post->ID, '_mail', true);
		$anak = get_post_meta($post->ID, '_anak', true);
		$dari = get_post_meta($post->ID, '_dari', true);
		$ayah = get_post_meta($post->ID, '_ayah', true);
		$ibu  = get_post_meta($post->ID, '_ibu', true);
		$almt = get_post_meta($post->ID, '_almt', true);
		
		?>
		
		<div class="mading_metabox">
		
		    <label><?php echo esc_html_e( 'Start study', 'sekolahpro' ); ?></label>
	        <input type="date" name="_mas" value="<?php echo esc_attr( $mas ); ?>" class="widefat" />
		
		    <label><?php echo esc_html_e( 'NISN', 'sekolahpro' ); ?></label>
	        <input type="text" name="_nisn" value="<?php echo esc_attr( $nisn ); ?>" class="widefat" />
			
			<label><?php echo esc_html_e( 'Gender', 'sekolahpro' ); ?></label>
	        <input type="radio" name="_sex" <?php checked( esc_attr( $sex ), 'Laki-Laki' ) ?> value="Laki-Laki"/><span class="stt"><?php _e('Male', 'sekolahpro'); ?></span>
			<input type="radio" name="_sex" <?php checked( esc_attr( $sex ), 'Perempuan' ) ?> value="Perempuan"/><span class="stt"><?php _e('Female', 'sekolahpro'); ?></span>
			
			<label><?php echo esc_html_e( 'Birth Place', 'sekolahpro' ); ?></label>
	        <input type="text" name="_tmpt" value="<?php echo esc_attr( $tmpt ); ?>" class="widefat" />
			
			<label><?php echo esc_html_e( 'Birth Date', 'sekolahpro' ); ?></label>
	        <input type="date" name="_tgl" value="<?php echo esc_attr( $tgl ); ?>" class="widefat" />
			
			<label><?php echo esc_html_e( 'Religion : (Islam, Kristen, Katholik, Hindu, Budha, Konghucu, etc)', 'sekolahpro' ); ?></label>
	        <input type="text" name="_rel" value="<?php echo esc_attr( $rel ); ?>" class="widefat" />
			
			<label><?php echo esc_html_e( 'Address', 'sekolahpro' ); ?></label>
	        <input type="text" name="_add" value="<?php echo esc_attr( $add ); ?>" class="widefat" />
		
			<label><?php echo esc_html_e( 'Phone', 'sekolahpro' ); ?></label>
	        <input type="text" name="_telp" value="<?php echo esc_attr( $telp ); ?>" class="widefat" />
			
			<label><?php echo esc_html_e( 'Email', 'sekolahpro' ); ?></label>
	        <input type="text" name="_mail" value="<?php echo esc_attr( $mail ); ?>" class="widefat" />
			
			<div class="madclear">
			    <div class="family">
				    <div class="infam">
			            <label><?php echo esc_html_e( 'Child number', 'sekolahpro' ); ?></label>
	                    <input type="text" name="_anak" value="<?php echo esc_attr( $anak ); ?>" class="widefat" />
					</div>
				</div>
				<div class="family">
					<div class="infam">
			            <label><?php echo esc_html_e( 'how many siblings?', 'sekolahpro' ); ?></label>
	                    <input type="text" name="_dari" value="<?php echo esc_attr( $dari ); ?>" class="widefat" />
					</div>
				</div>
			</div>
			
			<div class="madclear">
			    <div class="family">
				    <div class="infam">
			            <label><?php echo esc_html_e( 'Father', 'sekolahpro' ); ?></label>
	                    <input type="text" name="_ayah" value="<?php echo esc_attr( $ayah ); ?>" class="widefat" />
					</div>
				</div>
				<div class="family">
					<div class="infam">
			            <label><?php echo esc_html_e( 'Mother', 'sekolahpro' ); ?></label>
	                    <input type="text" name="_ibu" value="<?php echo esc_attr( $ibu ); ?>" class="widefat" />
					</div>
				</div>
			</div>
		
		    <div class="madclear">
		        <label><?php echo esc_html_e( 'Address', 'sekolahpro' ); ?></label>
	            <input type="text" name="_almt" value="<?php echo esc_attr( $almt ); ?>" class="widefat" />
			</div>
			
		</div>
			
	<?php }
	
	function san_data_meta($post_id, $post) {

		if ( ! isset( $_POST['santri_noncename'] ) || !wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['santri_noncename'] ) ), plugin_basename(__FILE__) )) {
            return $post_id;
        }
	    if ( !current_user_can( 'edit_post', $post_id ))

	        return $post_id;

	    $santri['_mas']  = isset($_POST['_mas']) ? sanitize_text_field(wp_unslash( $_POST['_mas'] ) ) : '' ;
		$santri['_nisn'] = isset($_POST['_nisn']) ? sanitize_text_field(wp_unslash( $_POST['_nisn'] ) ) : '' ;
		$santri['_sex']  = isset($_POST['_sex']) ? sanitize_text_field(wp_unslash( $_POST['_sex'] ) ) : '' ;
		$santri['_tmpt'] = isset($_POST['_tmpt']) ? sanitize_text_field(wp_unslash( $_POST['_tmpt'] ) ) : '' ;
		$santri['_tgl']  = isset($_POST['_tgl']) ? sanitize_text_field(wp_unslash( $_POST['_tgl'] ) ) : '' ;
		$santri['_rel']  = isset($_POST['_rel']) ? sanitize_text_field(wp_unslash( $_POST['_rel'] ) ) : '' ;
		$santri['_add']  = isset($_POST['_add']) ? sanitize_text_field(wp_unslash( $_POST['_add'] ) ) : '' ;
		$santri['_telp'] = isset($_POST['_telp']) ? sanitize_text_field(wp_unslash( $_POST['_telp'] ) ) : '' ;
		$santri['_mail'] = isset($_POST['_mail']) ? sanitize_text_field(wp_unslash( $_POST['_mail'] ) ) : '' ;
		$santri['_anak'] = isset($_POST['_anak']) ? sanitize_text_field(wp_unslash( $_POST['_anak'] ) ) : '' ;
		$santri['_dari'] = isset($_POST['_dari']) ? sanitize_text_field(wp_unslash( $_POST['_dari'] ) ) : '' ;
		$santri['_ayah'] = isset($_POST['_ayah']) ? sanitize_text_field(wp_unslash( $_POST['_ayah'] ) ) : '' ;
		$santri['_ibu']  = isset($_POST['_ibu']) ? sanitize_text_field(wp_unslash( $_POST['_ibu'] ) ) : '' ;
		$santri['_almt'] = isset($_POST['_almt']) ? sanitize_text_field(wp_unslash( $_POST['_almt'] ) ) : '' ;
		
	    foreach ($santri as $key => $value) { 	        
		    if( $post->post_type == 'revision' ) return; 
	        $value = implode(',', (array)$value); 
	        if(get_post_meta($post_id, $key, FALSE)) { 
	            update_post_meta($post_id, $key, $value);
	        } else { 
	            add_post_meta($post_id, $key, $value);
	        }
	        if(!$value) delete_post_meta($post_id, $key); 
	    }

	}

	add_action('save_post', 'san_data_meta', 1, 2); 