<?php
    
	 
	
	register_post_type( 'siswa',		
	array(			
	    'menu_icon' => 'dashicons-groups',
	    'labels'          => array(				
	    'name'                => __( 'Siswa', 'sekolahpro' ),				
	    'singular_name'       => __( 'Siswa', 'sekolahpro' ),        
	    'add_new'             => __( 'Add New', 'sekolahpro'  ),	
	    'add_new_item'        => __( 'Add New Item', 'sekolahpro'  ),	
	    'edit'                => __( 'Edit', 'sekolahpro'  ),	 
	    'edit_item'           => __( 'Edit Item', 'sekolahpro'  ),	
	    'new_item'            => __( 'New Item', 'sekolahpro'  ),	
	    'view'                => __( 'View', 'sekolahpro'  ),	
	    'view_item'           => __( 'View Item', 'sekolahpro'  ),	
	    'search_items'        => __( 'Search Item', 'sekolahpro'  ),	
	    'not_found'           => __( 'Item not found', 'sekolahpro'  ),	
	    'not_found_in_trash'  => __( 'Item not found in Trash', 'sekolahpro'  ),	
	    'parent'              => __( 'Parent Super Duper', 'sekolahpro'  ),
        'featured_image'      => __( 'Photo 300 x 400', 'sekolahpro' ),		
	    ),		                	
	    	'public'               => true,           					            
	    	'has_archive'          => true,        			            
	    	'supports'             => array( 'title', 'thumbnail', 'editor'),        			            
	    	'exclude_from_search'  => false, 	 
	    	'show_in_rest'         => true,
			'capabilities' => array(
                'edit_post'                 => 'edit_siswa',
				'edit_posts'                => 'edit_siswas',
                'edit_others_posts'         => 'edit_other_siswas',
				'edit_private_posts'        => 'edit_private_siswas',
				'edit_published_posts'      => 'edit_published_siswas',
				'read_post'                 => 'read_siswa',
				'read_private_posts'        => 'read_private_siswas',
				'publish_posts'             => 'publish_siswas',
				'delete_post'               => 'delete_siswa',
                'delete_posts'              => 'delete_siswas',
                'delete_private_posts'      => 'delete_private_siswas',
				'delete_others_posts'       => 'delete_others_siswas',
                'delete_published_posts'    => 'delete_published_siswas',
            ),
			'map_meta_cap' => true
		 )	
    );
	
	if ( get_theme_mod( 'hide_tutor' ) !== 'off' ) {
	add_action('admin_init', 'siswa_tutorial', 1);
	 
	function siswa_tutorial() {
	    add_meta_box('siswatutorial', __('Tutorial', 'sekolahpro'), 'siswatutorial', 'siswa', 'normal', 'default');
	}

	function siswatutorial() { ?>
		    
		<div class="mading_metabox">
		    <?php echo wp_oembed_get( 'https://www.youtube.com/watch?v=tZPhBBgZNdU' ); ?>
		</div>
    
	<?php }
	}
	
	add_action('admin_init', 'sis_meta', 1);
	function sis_meta() {
	    add_meta_box('sis_data', __('Biodata', 'sekolahpro'), 'sis_data', 'siswa', 'normal', 'default');
	}

	function sis_data($post) {
	    global $post;
	    echo '<input type="hidden" name="siswa_noncename" id="siswa_noncename" value="' . esc_attr( wp_create_nonce( plugin_basename(__FILE__) ) ). '" />';

	    $mas  = get_post_meta($post->ID, '_mas', true);
		$nisn = get_post_meta($post->ID, '_nisn', true);
	    $sex  = get_post_meta($post->ID, '_sex', true);
		$tmpt = get_post_meta($post->ID, '_tmpt', true);
		$tgl  = get_post_meta($post->ID, '_tgl', true);
		$rel  = get_post_meta($post->ID, '_rel', true);
		$add  = get_post_meta($post->ID, '_add', true);
		$telp = get_post_meta($post->ID, '_telp', true);
		$mail = get_post_meta($post->ID, '_mail', true);
		$anak = get_post_meta($post->ID, '_anak', true);
		$dari = get_post_meta($post->ID, '_dari', true);
		$ayah = get_post_meta($post->ID, '_ayah', true);
		$ibu  = get_post_meta($post->ID, '_ibu', true);
		$almt = get_post_meta($post->ID, '_almt', true);
		
		?>
		
		<div class="mading_metabox">
		
		    <label><?php echo esc_html_e( 'Start study', 'sekolahpro' ); ?></label>
	        <input type="date" name="_mas" value="<?php echo esc_attr( $mas ); ?>" class="widefat" />
		
		    <label><?php echo esc_html_e( 'NISN', 'sekolahpro' ); ?></label>
	        <input type="text" name="_nisn" value="<?php echo esc_attr( $nisn ); ?>" class="widefat" />
			
			<label><?php echo esc_html_e( 'Gender', 'sekolahpro' ); ?></label>
	        <input type="radio" name="_sex" <?php checked( esc_attr( $sex ), 'Laki-Laki' ) ?> value="Laki-Laki"/><span class="stt"><?php _e('Male', 'sekolahpro'); ?></span>
			<input type="radio" name="_sex" <?php checked( esc_attr( $sex ), 'Perempuan' ) ?> value="Perempuan"/><span class="stt"><?php _e('Female', 'sekolahpro'); ?></span>
			
			<label><?php echo esc_html_e( 'Birth Place', 'sekolahpro' ); ?></label>
	        <input type="text" name="_tmpt" value="<?php echo esc_attr( $tmpt ); ?>" class="widefat" />
			
			<label><?php echo esc_html_e( 'Birth Date', 'sekolahpro' ); ?></label>
	        <input type="date" name="_tgl" value="<?php echo esc_attr( $tgl ); ?>" class="widefat" />
			
			<label><?php echo esc_html_e( 'Religion : (Islam, Kristen, Katholik, Hindu, Budha, Konghucu, etc)', 'sekolahpro' ); ?></label>
	        <input type="text" name="_rel" value="<?php echo esc_attr( $rel ); ?>" class="widefat" />
			
			<label><?php echo esc_html_e( 'Address', 'sekolahpro' ); ?></label>
	        <input type="text" name="_add" value="<?php echo esc_attr( $add ); ?>" class="widefat" />
		
			<label><?php echo esc_html_e( 'Phone', 'sekolahpro' ); ?></label>
	        <input type="text" name="_telp" value="<?php echo esc_attr( $telp ); ?>" class="widefat" />
			
			<label><?php echo esc_html_e( 'Email', 'sekolahpro' ); ?></label>
	        <input type="text" name="_mail" value="<?php echo esc_attr( $mail ); ?>" class="widefat" />
			
			<div class="madclear">
			    <div class="family">
				    <div class="infam">
			            <label><?php echo esc_html_e( 'Child number', 'sekolahpro' ); ?></label>
	                    <input type="text" name="_anak" value="<?php echo esc_attr( $anak ); ?>" class="widefat" />
					</div>
				</div>
				<div class="family">
					<div class="infam">
			            <label><?php echo esc_html_e( 'how many siblings?', 'sekolahpro' ); ?></label>
	                    <input type="text" name="_dari" value="<?php echo esc_attr( $dari ); ?>" class="widefat" />
					</div>
				</div>
			</div>
			
			<div class="madclear">
			    <div class="family">
				    <div class="infam">
			            <label><?php echo esc_html_e( 'Father', 'sekolahpro' ); ?></label>
	                    <input type="text" name="_ayah" value="<?php echo esc_attr( $ayah ); ?>" class="widefat" />
					</div>
				</div>
				<div class="family">
					<div class="infam">
			            <label><?php echo esc_html_e( 'Mother', 'sekolahpro' ); ?></label>
	                    <input type="text" name="_ibu" value="<?php echo esc_attr( $ibu ); ?>" class="widefat" />
					</div>
				</div>
			</div>
		
		    <div class="madclear">
		        <label><?php echo esc_html_e( 'Address', 'sekolahpro' ); ?></label>
	            <input type="text" name="_almt" value="<?php echo esc_attr( $almt ); ?>" class="widefat" />
			</div>
			
		</div>
			
	<?php }
	
	function sis_data_meta($post_id, $post) {

		if ( ! isset( $_POST['siswa_noncename'] ) || !wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['siswa_noncename'] ) ), plugin_basename(__FILE__) )) {
            return $post_id;
        }
	    if ( !current_user_can( 'edit_post', $post_id ))

	        return $post_id;

	    $siswa['_mas']  = isset($_POST['_mas']) ? sanitize_text_field(wp_unslash( $_POST['_mas'] ) ) : '' ;
		$siswa['_nisn'] = isset($_POST['_nisn']) ? sanitize_text_field(wp_unslash( $_POST['_nisn'] ) ) : '' ;
		$siswa['_sex']  = isset($_POST['_sex']) ? sanitize_text_field(wp_unslash( $_POST['_sex'] ) ) : '' ;
		$siswa['_tmpt'] = isset($_POST['_tmpt']) ? sanitize_text_field(wp_unslash( $_POST['_tmpt'] ) ) : '' ;
		$siswa['_tgl']  = isset($_POST['_tgl']) ? sanitize_text_field(wp_unslash( $_POST['_tgl'] ) ) : '' ;
		$siswa['_rel']  = isset($_POST['_rel']) ? sanitize_text_field(wp_unslash( $_POST['_rel'] ) ) : '' ;
		$siswa['_add']  = isset($_POST['_add']) ? sanitize_text_field(wp_unslash( $_POST['_add'] ) ) : '' ;
		$siswa['_telp'] = isset($_POST['_telp']) ? sanitize_text_field(wp_unslash( $_POST['_telp'] ) ) : '' ;
		$siswa['_mail'] = isset($_POST['_mail']) ? sanitize_text_field(wp_unslash( $_POST['_mail'] ) ) : '' ;
		$siswa['_anak'] = isset($_POST['_anak']) ? sanitize_text_field(wp_unslash( $_POST['_anak'] ) ) : '' ;
		$siswa['_dari'] = isset($_POST['_dari']) ? sanitize_text_field(wp_unslash( $_POST['_dari'] ) ) : '' ;
		$siswa['_ayah'] = isset($_POST['_ayah']) ? sanitize_text_field(wp_unslash( $_POST['_ayah'] ) ) : '' ;
		$siswa['_ibu']  = isset($_POST['_ibu']) ? sanitize_text_field(wp_unslash( $_POST['_ibu'] ) ) : '' ;
		$siswa['_almt'] = isset($_POST['_almt']) ? sanitize_text_field(wp_unslash( $_POST['_almt'] ) ) : '' ;
		
	    foreach ($siswa as $key => $value) { 	        
		    if( $post->post_type == 'revision' ) return; 
	        $value = implode(',', (array)$value); 
	        if(get_post_meta($post_id, $key, FALSE)) { 
	            update_post_meta($post_id, $key, $value);
	        } else { 
	            add_post_meta($post_id, $key, $value);
	        }
	        if(!$value) delete_post_meta($post_id, $key); 
	    }

	}

	add_action('save_post', 'sis_data_meta', 1, 2); 