<?php
    
	 
    if ( get_theme_mod('slide_width') != "" ) {
		$swidth = get_theme_mod('slide_width');
	} else {
		$swidth = 1200;
	}
	if ( get_theme_mod('slide_height') != "" ) {
		$sheight = get_theme_mod('slide_height');
	} else {
		$sheight = 600;
	}
	register_post_type( 'slider',		
	array(			
	    'menu_icon'       => 'dashicons-images-alt2',
		'labels'          => array(				
	    'name'                => __( 'Slide Gambar', 'sekolahpro' ),				
	    'singular_name'       => __( 'Slide Gambar', 'sekolahpro' ),        
	    'add_new'             => __( 'Add New', 'sekolahpro'  ),	
	    'add_new_item'        => __( 'Add New Item', 'sekolahpro'  ),	
	    'edit'                => __( 'Edit', 'sekolahpro'  ),	 
	    'edit_item'           => __( 'Edit Item', 'sekolahpro'  ),	
	    'new_item'            => __( 'New Item', 'sekolahpro'  ),	
	    'view'                => __( 'View', 'sekolahpro'  ),	
	    'view_item'           => __( 'View Item', 'sekolahpro'  ),	
	    'search_items'        => __( 'Search Item', 'sekolahpro'  ),	
	    'not_found'           => __( 'Item not found', 'sekolahpro'  ),	
	    'not_found_in_trash'  => __( 'Item not found in Trash', 'sekolahpro'  ),	
	    'parent'              => __( 'Parent Super Duper', 'sekolahpro'  ),
        'featured_image'      => sprintf(__( 'Image %s x %s', 'sekolahpro' ), $swidth, $sheight),			
	    ),		                	
	    	'public'              => true,           					            
	    	'has_archive'         => true,        			            
	    	'supports'            => array( 'title', 'editor', 'thumbnail' ),        			            
	    	'exclude_from_search' => false,
			'show_in_rest'        => true,
			'capabilities' => array(
                'edit_post'                 => 'edit_slide',
				'edit_posts'                => 'edit_slides',
                'edit_others_posts'         => 'edit_other_slides',
				'edit_private_posts'        => 'edit_private_slides',
				'edit_published_posts'      => 'edit_published_slides',
				'read_post'                 => 'read_slide',
				'read_private_posts'        => 'read_private_slides',
				'publish_posts'             => 'publish_slides',
				'delete_post'               => 'delete_slide',
                'delete_posts'              => 'delete_slides',
                'delete_private_posts'      => 'delete_private_slides',
				'delete_others_posts'       => 'delete_others_slides',
                'delete_published_posts'    => 'delete_published_slides',
            ),
			'map_meta_cap' => true
		 )	
    );
	
	if ( get_theme_mod( 'hide_tutor' ) !== 'off' ) {
	add_action('admin_init', 'mading_slide_tutorial', 1);
	
	function mading_slide_tutorial() {
	    add_meta_box('slidetutorial', __('Tutorial', 'sekolahpro'), 'mading_slidetutorial', 'slider', 'normal', 'default');
	}

	function mading_slidetutorial() { ?>
		    
		<div class="mading_metabox">
		    <?php echo wp_oembed_get( 'https://www.youtube.com/watch?v=8N3tIzoKe7Y' ); ?>
		</div>
    
	<?php }
	}
	
	// Link Slider Metabox
    add_action('admin_init', 'mading_slider_link', 1);
	
	function mading_slider_link() {
	    add_meta_box('extlink', __('External Link', 'sekolahpro'), 'mading_extlink', 'slider', 'normal', 'default');
	}

	function mading_extlink($post) {
	    global $post;
	    echo '<input type="hidden" name="slide_noncename" id="slide_noncename" value="' . esc_attr( wp_create_nonce( plugin_basename(__FILE__) ) ) . '" />';

	    $extlink = get_post_meta($post->ID, '_extlink', true);
		?>
		
		<div class="mading_metabox">
		    
			<label><?php echo esc_html_e( 'Add link to another page or external website', 'sekolahpro' ); ?></label>
			<input type="text" name="_extlink" value="<?php echo esc_attr( $extlink ); ?>" class="widefat" />
			
		</div>
		
	<?php }

	function mading_sliderlink_meta($post_id, $post) {
		
		if ( ! isset( $_POST['slide_noncename'] ) || !wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['slide_noncename'] ) ), plugin_basename(__FILE__) )) {
	        return $post_id;
	    }

	    if ( !current_user_can( 'edit_post', $post_id ))
	        return $post_id;
		
		$events_meta['_extlink'] = isset($_POST['_extlink']) ? sanitize_text_field(wp_unslash( $_POST['_extlink'] ) ) : '' ;

	    foreach ($events_meta as $key => $value) {      
		    if( $post->post_type == 'revision' ) return;
	        $value = implode(',', (array)$value); 
	        if(get_post_meta($post_id, $key, FALSE)) { 
	            update_post_meta($post_id, $key, $value);
	        } else { 
	            add_post_meta($post_id, $key, $value);
	        }
	        if(!$value) delete_post_meta($post_id, $key); 
	    }

	}
	add_action('save_post', 'mading_sliderlink_meta', 1, 2); 