<?php
    
	 
	
	register_post_type( 'video',		
	array(			
	    'menu_icon'       => 'dashicons-video-alt3',
		'labels'          => array(				
	    'name'                => __( 'Video', 'sekolahpro' ),				
	    'singular_name'       => __( 'Video', 'sekolahpro' ),        
	    'add_new'             => __( 'Add New', 'sekolahpro'  ),	
	    'add_new_item'        => __( 'Add New Item', 'sekolahpro'  ),	
	    'edit'                => __( 'Edit', 'sekolahpro'  ),	 
	    'edit_item'           => __( 'Edit Item', 'sekolahpro'  ),	
	    'new_item'            => __( 'New Item', 'sekolahpro'  ),	
	    'view'                => __( 'View', 'sekolahpro'  ),	
	    'view_item'           => __( 'View Item', 'sekolahpro'  ),	
	    'search_items'        => __( 'Search Item', 'sekolahpro'  ),	
	    'not_found'           => __( 'Item not found', 'sekolahpro'  ),	
	    'not_found_in_trash'  => __( 'Item not found in Trash', 'sekolahpro'  ),	
	    'parent'              => __( 'Parent Super Duper', 'sekolahpro'  ),
        'featured_image'      => __( 'Featured Image', 'sekolahpro' ),		
	    ),		                	
	    	'public'               => true,           					            
	    	'has_archive'          => true,        			            
	    	'supports'             => array( 'title', 'editor'),        			            
	    	'exclude_from_search'  => false, 	 
	    	'show_in_rest'         => true,
			'capabilities' => array(
                'edit_post'                 => 'edit_vidio',
				'edit_posts'                => 'edit_vidios',
                'edit_others_posts'         => 'edit_other_vidios',
				'edit_private_posts'        => 'edit_private_vidios',
				'edit_published_posts'      => 'edit_published_vidios',
				'read_post'                 => 'read_vidio',
				'read_private_posts'        => 'read_private_vidios',
				'publish_posts'             => 'publish_vidios',
				'delete_post'               => 'delete_vidio',
                'delete_posts'              => 'delete_vidios',
                'delete_private_posts'      => 'delete_private_vidios',
				'delete_others_posts'       => 'delete_others_vidios',
                'delete_published_posts'    => 'delete_published_vidios',
            ),
			'map_meta_cap' => true
		 )	
    );
	
	if ( get_theme_mod( 'hide_tutor' ) !== 'off' ) {
	add_action('admin_init', 'video_tutorial', 1);
	 
	function video_tutorial() {
	    add_meta_box('videotutorial', __('Tutorial', 'sekolahpro'), 'videotutorial', 'video', 'normal', 'default');
	}

	function videotutorial() { ?>
		    
		<div class="mading_metabox">
		    <?php echo wp_oembed_get( 'https://www.youtube.com/watch?v=-7NbEXHd_gA' ); ?>
		</div>
    
	<?php }
	}
	
	add_action('admin_init', 'vid', 1);
	
	function vid() {
	    add_meta_box('sch_vid', __('Video Embed', 'sekolahpro'), 'sch_vid', 'video', 'normal', 'default');
	}

	function sch_vid($post) {
	    global $post;
	    echo '<input type="hidden" name="video_noncename" id="video_noncename" value="' . esc_attr( wp_create_nonce( plugin_basename(__FILE__) ) ) . '" />';

		$video_embed = get_post_meta($post->ID, 'video_embed', true);
	    ?>
		
		<div class="mading_metabox">
			<label><?php echo esc_html_e( 'Paste link form video source like Youtube, Vimeo, etc', 'sekolahpro' ); ?></label>
			<input type="text" name="video_embed" value="<?php echo esc_attr( $video_embed ); ?>" class="widefat" />
			
		</div>
	<?php }

	function mading_vid_meta($post_id, $post) {
		
		if ( ! isset( $_POST['video_noncename'] ) || !wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['video_noncename'] ) ), plugin_basename(__FILE__) )) {
	    return $post_id;
	    }

	    if ( !current_user_can( 'edit_post', $post_id ))
	        return $post_id;
			
	    $events_meta['video_embed'] = isset($_POST['video_embed']) ? sanitize_text_field(wp_unslash( $_POST['video_embed'] ) ) : '' ;

	    foreach ($events_meta as $key => $value) {         
		    if( $post->post_type == 'revision' ) return;
	        $value = implode(',', (array)$value); 
	        if(get_post_meta($post_id, $key, FALSE)) { 
	            update_post_meta($post_id, $key, $value);
	        } else { 
	            add_post_meta($post_id, $key, $value);
	        }
	        if(!$value) delete_post_meta($post_id, $key);
	    }

	}

	add_action('save_post', 'mading_vid_meta', 1, 2); 