<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Elementor_Mading_Footer_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'madingfooter';
	}

	public function get_title() {
		return esc_html__( 'MAD : Mading Footer', 'sekolahpro' );
	}
	public function get_icon() {
		return 'eicon-columns';
	}

	public function get_custom_help_url() {
		return 'https://developers.elementor.com/docs/widgets/';
	}

	public function get_categories() {
		return [ 'mading-original' ];
	}

	public function get_keywords() {
		return [ 'post', 'carousel' ];
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		?>
		
	    	<div class="mad_widget madclear">
	    	   <div class="ext__container">
			       <div class="widget_area madclear">
				       <div class="widget_box">
		                 	<div class="widget_box-inner">
			    	            <?php if ( is_active_sidebar( 'sidebar-2' ) ) {
						            dynamic_sidebar( 'sidebar-2' ); 
	                            } ?>
							</div>
						</div>
						<div class="widget_box">
							<div class="widget_box-inner">
							    <?php if ( is_active_sidebar( 'sidebar-3' ) ) {
									dynamic_sidebar( 'sidebar-3' );
								} ?>
							</div>
						</div>
						<div class="widget_box">
						    <div class="widget_box-inner">
								<?php if ( is_active_sidebar( 'sidebar-4' ) ) {
									dynamic_sidebar( 'sidebar-4' );
								} ?>
							</div>
						</div>
					</div>
				</div>
		    </div>
					
            <div class="footer">
		    	<div class="ext__container">
			    	<div class="copyright">
					    <?php mading_text_footer(); ?>
			    	</div>
		    	</div>
			</div><!-- footer --> 
		
	    	<span class="to_top"><i class="icon-mad-chevron-up"></i></span>
		
		<?php
	}

}

