<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Elementor_Mading_Galeri_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'madinggaleri';
	}

	public function get_title() {
		return esc_html__( 'MAD : Galeri Gambar', 'sekolahpro' );
	}
	public function get_icon() {
		return 'eicon-image';
	}

	public function get_custom_help_url() {
		return 'https://developers.elementor.com/docs/widgets/';
	}

	public function get_categories() {
		return [ 'mading-original' ];
	}

	public function get_keywords() {
		return [ 'image', 'post' ];
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		?>
		
		<div class="mading_gallery madclear">
	        <?php mading_thumb_gallery(); ?>
    	</div>
		
		<?php
	}

}

