<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Elementor_Mading_Header_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'madingheader';
	}

	public function get_title() {
		return esc_html__( 'MAD : Mading Header', 'sekolahpro' );
	}

	public function get_icon() {
		return 'eicon-nav-menu';
	}

	public function get_custom_help_url() {
		return 'https://developers.elementor.com/docs/widgets/';
	}

	public function get_categories() {
		return [ 'mading-original' ];
	}

	public function get_keywords() {
		return [ 'menu', 'navigation' ];
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		?>
		
		<section class="mad__header madclear">
			<div class="mad__top">
				<div class="ext__container">
					<span id="hours">
						<span class="head_time"><i class="icon-mad-clock"></i></span>
						<span id="time"></span>:<span id="minu"></span>:<span id="secs"></span>
					</span>
					<span id="telp">
						<span class="head_phone"><i class="icon-mad-phone"></i></span>
						<span class="number"><?php mading_school_number(); ?></span>
					</span>
					<span id="imel">
				    	<span class="head_mail"><i class="icon-mad-mail"></i></span>
						<span class="mailing"><?php mading_school_mailing(); ?></span>
					</span>
				</div>
			</div>
			
			<div class="mad__nav">
		    	<div class="ext__container">
			    	<div class="mad__flex">
				    	<div class="mad__logo"><?php custom_logo_mading(); ?></div>
				    	<div id="site-header-menu" class="site-header-menu box_nav">
				        	<?php 
						    	if (has_nav_menu('navigation')) {
							        wp_nav_menu(array(
								    	'theme_location' => 'navigation', 
								    	'container' => 'div', 
								    	'container_class' => 'nav', 
								    	'menu_class' => 'dd desktop deskmenu', 
								    	'menu_id' => 'dd', 
								    	'fallback_cb' => false
							    		)
							    	);
					    		}
					    	?>
				    	</div>
			        	<span class="mad__menu"><i class="icon-mad-menu"></i></span>
				    	<span class="mad__search"><i class="icon-mad-search"></i></span>
				    	<?php get_search_form(); ?>
			    	</div>
		    	</div>
	    	</div>
		</section>
		
		<?php
		
	}

}

