<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Elementor_Mading_NewsEditorial_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'madingnewseditor';
	}

	public function get_title() {
		return esc_html__( 'MAD : News + Editorial', 'sekolahpro' );
	}
	public function get_icon() {
		return 'eicon-posts-group';
	}

	public function get_custom_help_url() {
		return 'https://developers.elementor.com/docs/widgets/';
	}

	public function get_categories() {
		return [ 'mading-original' ];
	}

	public function get_keywords() {
		return [ 'slider', 'carousel' ];
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		?>
		
		<div class="news_editorial">
		<div class="ext_container madclear">
	    	<div class="mad_news">
		    	<div class="title_news re_news"><?php echo __('Latest News', 'sekolahpro'); ?></div>
				<div class="news_before madclear">
			    	<?php
				    	$args = array(
					    	'post_type' => 'post', 
							'posts_per_page' => 4, 
							'ignore_sticky_posts' => 1,
						);
						query_posts($args);
						
						if (have_posts()) {
							while (have_posts()): the_post(); 
							global $post;
							?>
							
							<div class="news_home_loop">
						    	<div class="news_box">
							    	<?php 
								    	if (has_post_thumbnail()) { 
										?>
									    	<a href="<?php the_permalink() ?>" class="mad_news_thumb">
										    	<?php
											    	the_post_thumbnail('news', array(
												     	'alt' => trim(wp_strip_all_tags($post->post_title)),
														'title' => trim(wp_strip_all_tags($post->post_title)),
													)); 
												?>
											</a>
							 		   <?php } else { ?>
										    <a href="<?php the_permalink() ?>" class="mad_news_thumb">
			    	    				            <?php if ( get_theme_mod('madingthumb_image') != "" ) {
														$normal = attachment_url_to_postid( get_theme_mod('madingthumb_image'));
														$shownormal = wp_get_attachment_image_url( $normal, 'news' );
														echo '<img src="'. esc_url( $shownormal ) .'"/>';
													} else {
			    	        				            echo '<img src="'. esc_url( get_template_directory_uri() ).'/images/mading.jpg"/>';
													} ?>
			        					    </a>
									    <?php 
										} 
									?>
									<div class="news_meta">
									    <div class="news_auth"><span class="post-date"><?php echo esc_html( get_the_time('l, j F Y') ); ?></span></div>
								    	<h3><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h3>
									</div>
								</div>
							</div>
							
					    	<?php
					    	endwhile;
				    	}
					
			        	wp_reset_query(); 
					?>
				</div>
			</div>
			<div class="mad_editorial">
			    <div class="title_news re_editor"><?php echo __('Editorial', 'mading'); ?></div>
			    <div class="edit_before">
				    <div class="mad_master">
					    <div class="get_master">
					        <div class="get_photos"><?php mading_get_photos(); ?></div>
							<div class="get_names">
						    	<div class="head_name"><?php mading_kepala_sekolah(); ?></div>
								<div class="re_kepala"><?php echo __('Headmaster', 'mading'); ?></div>
							</div>
						</div>
					</div>
					<div class="edit_post">
				    	<?php // query
					    	$args = array(
					            'post_type' => 'editorial', 
					            'posts_per_page' => 5, 
		  		          );
		   		         query_posts($args);
					
							if (have_posts()) {
						    	while (have_posts()): the_post(); 
						    	?>
						
								<div class="edit_home_loop">
							    	<div class="edit_box">
								    	<h3><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h3>
									</div>
								</div>
						
								<?php 
						    	endwhile;
			   		 	} 
					
							wp_reset_query(); 
						?>
					</div>
				</div>
			</div>
		</div>
		</div>
		
		<?php
	}

}

