<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Elementor_Mading_Slider_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'madingslider';
	}

	public function get_title() {
		return esc_html__( 'MAD : Mading Slider', 'sekolahpro' );
	}

	public function get_icon() {
		return 'eicon-post-slider';
	}

	public function get_custom_help_url() {
		return 'https://developers.elementor.com/docs/widgets/';
	}

	public function get_categories() {
		return [ 'mading-original' ];
	}

	public function get_keywords() {
		return [ 'slider', 'carousel' ];
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		
		$args = array(
			    'post_type' => 'slider', 
			    'posts_per_page' => 5, 
		    );
		    query_posts($args);
			
			if (have_posts()) {
	        	?>
				<div class="madingbigslider owl-carousel owl-theme">
				<?php 
				    while (have_posts()): the_post(); 
					global $post;
					$extlink = get_post_meta($post->ID, '_extlink', true);
					?>
					
				    	<div class="item">
							<?php 
							    if ( $extlink != '' ) { 
								?>
							    <a href="<?php echo esc_url( $extlink ); ?>">
							    <?php 
								} 
							    if (has_post_thumbnail()) {
									the_post_thumbnail('slider'); 
								}
								if ( $extlink != '' ) { ?>
							    </a>
								<?php 
								} 
							?>
						</div>
					
					<?php
					endwhile;
				?>
	        	</div>
				<?php
			}
		wp_reset_query();
		?>
		<script>
			jQuery(document).ready(function($) {
              var owl = $('.madingbigslider');
              owl.owlCarousel({
                loop: true,
				margin: 0,
                responsiveClass:true,
				smartSpeed: 1500,
				autoplayTimeout: 5000,
                nav: false,
				dots: false,
                lazyLoad: true,
				autoplay: true,
				items:1  
              });
            });
		</script>
		<?php
	}


}

