<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Elementor_Mading_Video_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'madingvideo';
	}

	public function get_title() {
		return esc_html__( 'MAD : Galeri Video', 'sekolahpro' );
	}
	public function get_icon() {
		return 'eicon-youtube';
	}

	public function get_custom_help_url() {
		return 'https://developers.elementor.com/docs/widgets/';
	}

	public function get_categories() {
		return [ 'mading-original' ];
	}

	public function get_keywords() {
		return [ 'slider', 'carousel' ];
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		?>
		
		<div class="home_videos madclear">
    	    <?php mading_home_video(); ?>
	    </div>
		
		<?php
	}

}

