<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Elementor_BlogGuru1_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'blogguru1';
	}

	public function get_title() {
		return esc_html__( 'MAD : Blog Guru 1', 'sekolahpro' );
	}

	public function get_icon() {
		return 'eicon-image-rollover';
	}

	public function get_custom_help_url() {
		return 'https://developers.elementor.com/docs/widgets/';
	}

	public function get_categories() {
		return [ 'mading-widget' ];
	}

	public function get_keywords() {
		return [ 'post' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'block_section',
			[
				'label' => esc_html__( 'Block Setting', 'sekolahpro' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'block_image',
			[
				'label' => esc_html__( 'Background Image', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => plugin_dir_url( __FILE__ ).'img/agenda.jpg',
				],
			]
		);
		$this->add_control(
			'block_parallax',
			[
				'label' => esc_html__( 'Background Parallax', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'iscroll',
				'options' => [
					'iscroll' => esc_html__( 'Deactivate', 'sekolahpro' ),
					'ifixed' => esc_html__( 'Activate', 'sekolahpro' ),
				],
			]
		);
		
		$this->add_control(
			'block_bg',
			[
				'label' => esc_html__( 'Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .blog-guru-1:before' => 'background: {{VALUE}};'
				],
			]
		);
		$this->add_responsive_control(
			'block_opacity',
			[
				'label' => esc_html__( 'Opacity', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1,
						'step' => 0.1,
					],
				],
				'default' => [
					'size' => 0.8,
				],
				'selectors' => [
					'{{WRAPPER}} .blog-guru-1:before' => 'opacity: {{SIZE}};',
				],
			]
		);
		$this->add_responsive_control(
			'padding_top',
			[
				'label' => esc_html__( 'Inner Top Gap', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 10,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 100,
				],
				'tablet_default' => [
					'unit' => 'px',
					'size' => 100,
				],
				'mobile_default' => [
					'unit' => 'px',
					'size' => 60,
				],
				'selectors' => [
					'{{WRAPPER}} .blog-guru-1' => 'padding-top: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'padding_bot',
			[
				'label' => esc_html__( 'Inner Bottom Gap', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 10,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 100,
				],
				'tablet_default' => [
					'unit' => 'px',
					'size' => 100,
				],
				'mobile_default' => [
					'unit' => 'px',
					'size' => 60,
				],
				'selectors' => [
					'{{WRAPPER}} .blog-guru-1' => 'padding-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'blockacc_bg',
			[
				'label' => esc_html__( 'Accent Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#001188',
				'selectors' => [
					'{{WRAPPER}} .blog-guru-1:after' => 'background: {{VALUE}};'
				],
			]
		);
		$this->add_responsive_control(
			'blokacc_width',
			[
				'label' => esc_html__( 'Accent Width', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 30,
				],
				'tablet_default' => [
					'unit' => '%',
					'size' => 30,
				],
				'mobile_default' => [
					'unit' => '%',
					'size' => 30,
				],
				'selectors' => [
					'{{WRAPPER}} .blog-guru-1:after' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'blockacc_angle',
			[
				'label' => esc_html__( 'Accent Angle', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'%' => [
						'min' => 50,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 90,
				],
				'tablet_default' => [
					'unit' => '%',
					'size' => 90,
				],
				'mobile_default' => [
					'unit' => '%',
					'size' => 90,
				],
				'selectors' => [
					'{{WRAPPER}} .blog-guru-1:after' => 'clip-path: polygon(0 0%, 100% 0%, {{SIZE}}{{UNIT}} 100%, 0% 100%);',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'heading_section',
			[
				'label' => esc_html__( 'Heading Section', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'head_blog',
			[
				'label' => esc_html__( 'Heading', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Blog Guru', 'sekolahpro' ),
			]
		);
		$this->add_control(
			'blog_heading',
			[
				'label' => esc_html__( 'Heading Tag', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'h3',
				'options' => [
					'h1' => esc_html__( 'H1', 'sekolahpro' ),
					'h2' => esc_html__( 'H2', 'sekolahpro' ),
					'h3' => esc_html__( 'H3', 'sekolahpro' ),
					'h4' => esc_html__( 'H4', 'sekolahpro' ),
					'h5' => esc_html__( 'H5', 'sekolahpro' ),
					'h6' => esc_html__( 'H6', 'sekolahpro' ),
					'div' => esc_html__( 'div', 'sekolahpro' ),
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'head_typo',
				'label' => esc_html__( 'Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .blog_head',
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'fields_options' => [
			    	'font_family' => [
				    	'default' => 'Roboto',
					],
					'font_weight' => [
				    	'default' => 400,
					],
					'line_height' => [
				    	'default' =>  [
						    'unit' => 'em',
							'size' => 1.2,
						],
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 50,
						],
						'tablet_default' => [
						    'unit' => 'px',
							'size' => 50,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 34,
						],
					],
				],
			]
		);
		$this->add_control(
			'head_color',
			[
				'label' => esc_html__( 'Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#222222',
				'selectors' => [
					'{{WRAPPER}} .blog_head' => 'color: {{VALUE}};'
				],
			]
		);
		$this->add_control(
			'headlink_bg',
			[
				'label' => esc_html__( 'Link Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .blog_head a' => 'background: {{VALUE}};'
				],
			]
		);
		$this->add_control(
			'headlink_border',
			[
				'label' => esc_html__( 'Link Border Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .blog_head a' => 'border-color: {{VALUE}};'
				],
			]
		);
		$this->add_control(
			'headlink_color',
			[
				'label' => esc_html__( 'Link Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#222222',
				'selectors' => [
					'{{WRAPPER}} .blog_head a' => 'color: {{VALUE}};'
				],
			]
		);
		$this->add_responsive_control(
			'headlink_padding',
			[
				'label' => esc_html__( 'Padding', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 40,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 15,
				],
				'tablet_default' => [
					'unit' => 'px',
					'size' => 15,
				],
				'mobile_default' => [
					'unit' => 'px',
					'size' => 15,
				],
				'selectors' => [
					'{{WRAPPER}} .blog_head a' => 'padding: 0 {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'headlink_radius',
			[
				'label' => esc_html__( 'Border Radius', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 40,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 40,
				],
				'selectors' => [
					'{{WRAPPER}} .blog_head a' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'head_gap',
			[
				'label' => esc_html__( 'Bottom Gap', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 40,
				],
				'selectors' => [
					'{{WRAPPER}} .blog_head' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'image_section',
			[
				'label' => esc_html__( 'Image Section', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_responsive_control(
			'img_height',
			[
				'label' => esc_html__( 'Box Height', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 200,
						'max' => 400,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 400,
				],
				'tablet_default' => [
					'unit' => 'px',
					'size' => 400,
				],
				'mobile_default' => [
					'unit' => 'px',
					'size' => 300,
				],
				'selectors' => [
					'{{WRAPPER}} .blog1-loop' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .blog1-loop .blog1-img img' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'box_padding',
			[
				'label' => esc_html__( 'Box Padding', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .blog1-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'default' => [
					'top' => 150,
					'right' => 40,
					'bottom' => 40,
					'left' => 40,
					'unit' => 'px',
				],
				'tablet_default' => [
					'top' => 150,
					'right' => 40,
					'bottom' => 40,
					'left' => 40,
					'unit' => 'px',
				],
				'mobile_default' => [
					'top' => 150,
					'right' => 25,
					'bottom' => 40,
					'left' => 25,
					'unit' => 'px',
				],
			]
		);
		$this->add_control(
			'image1_bg',
			[
				'label' => esc_html__( 'Background 1', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#540c7c',
				'selectors' => [
					'{{WRAPPER}} .blog1-content' => 'background: linear-gradient(rgba(0,0,0,0), {{VALUE}});',
				],
			]
		);
		$this->add_control(
			'image2_bg',
			[
				'label' => esc_html__( 'Background 2', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#0c7c38',
				'selectors' => [
					'{{WRAPPER}} .blog1 .owl-item:not(.active) + .owl-item.active + .owl-item.active .blog1-content' => 'background: linear-gradient(rgba(0,0,0,0), {{VALUE}});',
				],
			]
		);
		$this->add_control(
			'image3_bg',
			[
				'label' => esc_html__( 'Background 3', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ad118d',
				'selectors' => [
					'{{WRAPPER}} .blog1 .owl-item:not(.active) + .owl-item.active + .owl-item.active + .owl-item.active .blog1-content' => 'background: linear-gradient(rgba(0,0,0,0), {{VALUE}});',
				],
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'cont_section',
			[
				'label' => esc_html__( 'Content Section', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'name_typo',
				'label' => esc_html__( 'Author Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .blog1-names',
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'fields_options' => [
			    	'font_family' => [
				    	'default' => 'Poppins',
					],
					'font_weight' => [
				    	'default' => 700,
					],
					'line_height' => [
				    	'default' =>  [
						    'unit' => 'em',
							'size' => 1.2,
						],
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 16,
						],
						'tablet_default' => [
						    'unit' => 'px',
							'size' => 16,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 16,
						],
					],
				],
			]
		);
		$this->add_control(
			'name_color',
			[
				'label' => esc_html__( 'Name Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .blog1-names' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'pub_typo',
				'label' => esc_html__( 'Publish Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .blog1-names',
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'fields_options' => [
			    	'font_family' => [
				    	'default' => 'Poppins',
					],
					'font_weight' => [
				    	'default' => 700,
					],
					'line_height' => [
				    	'default' =>  [
						    'unit' => 'em',
							'size' => 1.2,
						],
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 14,
						],
						'tablet_default' => [
						    'unit' => 'px',
							'size' => 14,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 14,
						],
					],
				],
			]
		);
		$this->add_control(
			'pub_color',
			[
				'label' => esc_html__( 'Publish Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .blog1-publish' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typo',
				'label' => esc_html__( 'Publish Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .blog1-title',
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'fields_options' => [
			    	'font_family' => [
				    	'default' => 'Poppins',
					],
					'font_weight' => [
				    	'default' => 700,
					],
					'line_height' => [
				    	'default' =>  [
						    'unit' => 'em',
							'size' => 1.4,
						],
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 22,
						],
						'tablet_default' => [
						    'unit' => 'px',
							'size' => 22,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 18,
						],
					],
				],
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Title Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .blog1-title a' => 'color: {{VALUE}};',
				],
			]
		);
		
		
		$this->add_control(
			'icon_bg',
			[
				'label' => esc_html__( 'Icon Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffcc00',
				'selectors' => [
					'{{WRAPPER}} .blog1-read' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__( 'Icon Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .blog1-read span:after' => 'border-left: 12px solid {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$unic = $this->get_unique_selector();
		$tophead = [
			'h1' => 'h1',
			'h2' => 'h2',
			'h3' => 'h3',
			'h4' => 'h4',
			'h5' => 'h5',
			'h6' => 'h6',
			'div' => 'div',
		];
		$bothead = [
			'h1' => 'h1',
			'h2' => 'h2',
			'h3' => 'h3',
			'h4' => 'h4',
			'h5' => 'h5',
			'h6' => 'h6',
			'div' => 'div',
		];
		?>
		    <div class="blog-guru-1 <?php echo $settings['block_parallax']; ?>" <?php if ( ! empty( $settings['block_image']['url'] ) ) { echo 'style="background-image: url( ' . $settings['block_image']['url'] . ' );"'; } ?>>
			    <div class="bg_block">
			    <?php // query
					query_posts( array( 
	                    'post_type' => 'blog', 
						'ignore_sticky_posts' => 1,
				    	'posts_per_page' => 10,
						'orderby' => 'rand',
			            ) 
	            	);
					
					echo '<'. $tophead[ $settings['blog_heading'] ] .' class="blog_head">'. $settings['head_blog'] .' <a href="'. get_post_type_archive_link( 'blog' ) .'">Lihat Semua</a></'. $tophead[ $settings['blog_heading'] ] .'>';
						
					if (have_posts()) {
						echo '<div class="bg1-block">';
						echo '<div class="blog1 owl-carousel owl-theme">';
				        while (have_posts()): the_post(); 
						    ?>
					        <div class="item blog1-loop">
								    <?php if (has_post_thumbnail()) { ?>
			    			        	<a class="blog1-img" href="<?php the_permalink() ?>">
				    				    	<?php the_post_thumbnail('news'); ?>
				    			    	</a>
				    		    	<?php } else { ?>
					     		    	<a class="blog1-img" href="<?php the_permalink() ?>">
											<?php if ( get_theme_mod('madingthumb_image') != "" ) {
												$normal = attachment_url_to_postid( get_theme_mod('madingthumb_image'));
												$shownormal = wp_get_attachment_image_url( $normal, 'news' );
												echo '<img src="'. esc_url( $shownormal ) .'"/>';
											} else {
			    	        		            echo '<img src="'. esc_url( get_template_directory_uri() ).'/images/mading.jpg"/>';
											} ?>
			            		    	</a>
					    	    	<?php } ?>
									<div class="blog1-content">
									    <div class="madclear blog1-author">
										    <?php echo get_avatar( get_the_author_meta( 'ID' ), 45 ); ?> 
											<div class="blog1-postauthor">
											    <div class="blog1-names"><?php echo get_the_author(); ?></div>
												<div class="blog1-publish">terbit <?php echo the_time(); ?></div>
											</div>
										</div>
							            <h3 class="blog1-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
									    <a class="blog1-read" href="<?php the_permalink(); ?>"><span></span></a>
									</div>
					    	</div>
							
							
							<?php 
						endwhile;
						echo '</div>';
						echo '</div>';
					}
					
			    	wp_reset_query(); 
			    ?>
			    </div>
			</div>
			<script>
            jQuery(document).ready(function($) {
                var owl = $('.blog1');
                owl.owlCarousel({
                    loop: true,
                    nav: true,
					navText: ["<span class='blog_arr'></span>","<i class='blog_arr'></span>"],
					dots: false,
                    lazyLoad: true,
			    	autoplay: true,
                    autoplayTimeout: 5000,
                    smartSpeed: 1500,
                    autoplayHoverPause: true,
					autoHeight:true,
                    margin: 30,
			    	responsive:{
                        0:{ 
				    	    items:2,
							margin: 20,
                        },
                        640:{
                            items:2
                        },
                        982:{
                            items:3
                        }
                    }    
                });
            });
            </script>
		<?php
	}

}