<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Elementor_Header_One_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'header-one';
	}

	public function get_title() {
		return esc_html__( 'MAD : Header 1', 'sekolahpro' );
	}

	public function get_icon() {
		return 'eicon-nav-menu';
	}

	public function get_custom_help_url() {
		return 'https://developers.elementor.com/docs/widgets/';
	}

	public function get_categories() {
		return [ 'mading-widget' ];
	}

	public function get_keywords() {
		return [ 'menu', 'navigation' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'header_section',
			[
				'label' => esc_html__( 'Header Setting', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'fixed_enable',
			[
				'label' => esc_html__( 'Header Fixed', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Fixed', 'sekolahpro' ),
				'label_off' => esc_html__( 'Scroll', 'sekolahpro' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
			'full_enable',
			[
				'label' => esc_html__( 'Header Layout', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Boxed', 'sekolahpro' ),
				'label_off' => esc_html__( 'Full', 'sekolahpro' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
			'boxed_enable',
			[
				'label' => esc_html__( 'Width', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1100,
						'max' => 2000,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 1280,
				],
				'selectors' => [
					'{{WRAPPER}} .header__onewidth' => 'max-width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
			    	'full_enable' => 'yes',
				],
			]
		);
		$this->add_control(
			'headone_background',
			[
				'label' => esc_html__( 'Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .header__one' => 'background: {{VALUE}};',
					'{{WRAPPER}} .call__one' => 'background: {{VALUE}};',
					'{{WRAPPER}} .call__one i' => 'color: {{VALUE}};',
					'.is_mobile {{WRAPPER}} .menu__one' => 'background: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'logo_section',
			[
				'label' => esc_html__( 'Logo Setting', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'logoimage',
			[
				'label' => esc_html__( 'Choose Logo', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => plugin_dir_url( __FILE__ ).'img/logo.png',
				],
			]
		);
		$this->add_responsive_control(
			'logoheight',
			[
				'label' => esc_html__( 'Logo Height', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 30,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 50,
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => [
					'size' => 50,
					'unit' => 'px',
				],
				'tablet_default' => [
					'size' => 50,
					'unit' => 'px',
				],
				'mobile_default' => [
					'size' => 30,
					'unit' => 'px',
				],
				'selectors' => [
				    '{{WRAPPER}} .before__one__fixed' => 'height: calc( {{SIZE}}{{UNIT}} + 50px );',
					'.is_small {{WRAPPER}} .before__one__fixed' => 'height: calc( {{SIZE}}{{UNIT}} + 36px );',
					'{{WRAPPER}} .logo__one img' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .mading__one li' => 'height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .icon__one' => 'height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .call__center' => 'padding-top: calc( {{SIZE}}{{UNIT}}/2 - 15px );',
					'{{WRAPPER}} .call__one .call__linkicon' => 'margin-top: calc( {{SIZE}}{{UNIT}}/2 - 23px );',
					'{{WRAPPER}} .clip1:before' => 'border-top-width: calc( {{SIZE}}{{UNIT}} + 50px );',
					'{{WRAPPER}} .clip2:before' => 'border-bottom-width: calc( {{SIZE}}{{UNIT}} + 50px );',
					'{{WRAPPER}} .clip3:before' => 'border-bottom-width: calc( {{SIZE}}{{UNIT}}/2 + 25px ); border-top-width: calc( {{SIZE}}{{UNIT}}/2 + 25px );',
					'.is_small {{WRAPPER}} .clip1:before' => 'border-top-width: calc( {{SIZE}}{{UNIT}} + 36px );',
					'.is_small {{WRAPPER}} .clip2:before' => 'border-bottom-width: calc( {{SIZE}}{{UNIT}} + 36px );',
					'.is_small {{WRAPPER}} .clip3:before' => 'border-bottom-width: calc( {{SIZE}}{{UNIT}}/2 + 18px ); border-top-width: calc( {{SIZE}}{{UNIT}}/2 + 18px );',
					
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'menu_section',
			[
				'label' => esc_html__( 'Menu Setting', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'menumading',
			[
				'label' => esc_html__( 'Menu Mading', 'sekolahpro' ),
				'description' => esc_html__( 'Choose which menu you want to show.', 'sekolahpro' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '',
				'options'     => get_wpsekolah_menu(),
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'menuone_typo',
				'label' => esc_html__( 'Typography Menu', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .header__one',
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'fields_options' => [
			    	'font_family' => [
				    	'default' => 'Poppins',
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 16,
						],
						'tablet_default' => [
						    'unit' => 'px',
							'size' => 18,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 18,
						],
					],
				],
			]
		);
		$this->add_control(
			'menu__onecolor',
			[
				'label' => esc_html__( 'Menu Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#222222',
				'selectors' => [
					'{{WRAPPER}} .mading__one li a' => 'color: {{VALUE}};',
					'{{WRAPPER}} .mading__one.desktop li.menu-item-has-children:after' => 'background: {{VALUE}};',
					'{{WRAPPER}} .nav__menu .mading__one.accord li.has-sub:after' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'menu__onehover',
			[
				'label' => esc_html__( 'Menu Hover', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffcc33',
				'selectors' => [
					'{{WRAPPER}} .mading__one li a:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} .mading__one li a span' => 'background: {{VALUE}};',
					'{{WRAPPER}} .mading__one li:before' => 'background: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'accent__onebg',
			[
				'label' => esc_html__( 'Accent Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffcc33',
				'selectors' => [
					'{{WRAPPER}} .mading__one li a span' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'accent__onecolor',
			[
				'label' => esc_html__( 'Accent Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#222222',
				'selectors' => [
					'{{WRAPPER}} .mading__one li a span' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'submenu__onebg',
			[
				'label' => esc_html__( 'Sub Menu Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffcc33',
				'selectors' => [
					'{{WRAPPER}} .mading__one li ul li' => 'background: {{VALUE}};',
					'{{WRAPPER}} .mading__one.desktop li ul' => 'border-top: 15px solid {{VALUE}}; border-bottom: 15px solid {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'submenu__onecolor',
			[
				'label' => esc_html__( 'Sub Menu Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#333333',
				'selectors' => [
					'{{WRAPPER}} .mading__one li ul li a' => 'color: {{VALUE}};',
					'{{WRAPPER}} .mading__one li ul li:hover a' => 'color: {{VALUE}};',
					'{{WRAPPER}} .mading__one li ul li.menu-item-has-children:after' => 'background: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'call_area',
			[
				'label' => esc_html__( 'Button Call', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'call_style',
			[
				'label' => esc_html__( 'Block Style', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'clip1',
				'options' => [
					'clip0'   => esc_html__( 'Default', 'sekolahpro' ),
					'clip1'   => esc_html__( 'Style 1', 'sekolahpro' ),
					'clip2'   => esc_html__( 'Style 2', 'sekolahpro' ),
					'clip3'   => esc_html__( 'Style 3', 'sekolahpro' ),
					'clip4'   => esc_html__( 'Style 4', 'sekolahpro' ),
				],
			]
		);
		$this->add_control(
			'call__bg',
			[
				'label' => esc_html__( 'Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#222222',
				'selectors' => [
					'{{WRAPPER}} .call__one' => 'background: {{VALUE}};',
					'{{WRAPPER}} .clip1:before' => 'border-right-color: {{VALUE}};',
					'{{WRAPPER}} .clip2:before' => 'border-right-color: {{VALUE}};',
					'{{WRAPPER}} .clip3:before' => 'border-right-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'iconphone',
			[
				'label' => esc_html__( 'Choose Icon', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-phone-alt',
					'library' => 'fa-solid',
				],
			]
		);
		$this->add_control(
			'icon_bg',
			[
				'label' => esc_html__( 'Icon Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffcc22',
				'selectors' => [
					'{{WRAPPER}} .call__one .call__linkicon' => 'background: {{VALUE}};',
					'{{WRAPPER}} .header__onewidth .icon-mad-menu' => 'background: {{VALUE}};',
					'{{WRAPPER}} .menu__one:after' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__( 'Icon Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#222222',
				'selectors' => [
					'{{WRAPPER}} .call__one .fa, .call__one .fas, .call__one .far, .call__one .fab' => 'color: {{VALUE}};',
					'{{WRAPPER}} .call__one i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .header__onewidth .icon-mad-menu' => 'color: {{VALUE}};',
					'{{WRAPPER}} .menu__one:after' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'call_onetext',
			[
				'label' => esc_html__( 'Text Prefix', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Call Us', 'sekolahpro' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'calltext_color',
			[
				'label' => esc_html__( 'Text Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .call__text' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'headphone',
			[
				'label' => esc_html__( 'Phone Number', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( '+62 8152 xxxx xxx', 'sekolahpro' ),
				'placeholder' => esc_html__( '+62 8152 xxxx xxx', 'sekolahpro' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'callphone_color',
			[
				'label' => esc_html__( 'Phone Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffcc22',
				'selectors' => [
					'{{WRAPPER}} .call__number a' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();
		
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$callstyle = [
			'clip0' => 'clip0',
			'clip1' => 'clip1',
			'clip2' => 'clip2',
			'clip3' => 'clip3',
			'clip4' => 'clip4',
		];
		$menu = wp_nav_menu(
			array(
				'menu'            => $settings['menumading'],
				'menu_class'      => 'mading__one desktop', 
				'container_class' => 'nav__menu',
				'container'       => 'div',
				'menu_id'         => 'menuone', 
				'echo'            => false,
				'fallback_cb'     => false
			)
		);
		if ( 'yes' === $settings['fixed_enable'] ) {
			echo '<div class="before__one__fixed"></div>';
			echo '<div class="header__one one__fixed">';
		} else {
			echo '<div class="header__one">';
		}
		?>
		    <div class="header__onewidth madclear">
			    <i class="ho__click icon-mad-menu"></i>
	        	<div class="logo__one">
		        	<a href="<?php echo home_url(); ?>">
			          	<img src="<?php echo $settings['logoimage']['url'];?>" />
		    		</a>
		    	</div>
				<div class="menu__one">
			    	<div class="madclear">
				    	<?php echo $menu; ?>
					</div>
				</div>
				<div class="call__one <?php echo $callstyle[ $settings['call_style'] ]; ?>">
			    	<div class="madclear">
				    	<?php 
					    	echo '<a class="call__linkicon" target="_blank" href="tel:' . $settings['headphone'] . '">';
					    	\Elementor\Icons_Manager::render_icon( $settings['iconphone'], [ 'aria-hidden' => 'true' ] );
							echo '</a>';
						?>
						<div class="call__center">
						    <div class="call__text"><?php echo $settings['call_onetext'] ?></div>
							<div class="call__number">
						    	<?php 
							    	 echo '<a target="_blank" href="tel:' . $settings['headphone'] . '">';
									 echo '<span class="headphone">' . $settings['headphone'] . '</span>';
									 echo '</a>';
								?>
							 </div>
						</div>
					</div>
				</div>
			</div>
		</div>
		
		<?php
		
	}

}

