<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Elementor_Header_Two_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'header-two';
	}

	public function get_title() {
		return esc_html__( 'MAD : Header 2', 'sekolahpro' );
	}

	public function get_icon() {
		return 'eicon-nav-menu';
	}

	public function get_custom_help_url() {
		return 'https://developers.elementor.com/docs/widgets/';
	}

	public function get_categories() {
		return [ 'mading-widget' ];
	}

	public function get_keywords() {
		return [ 'menu', 'navigation' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'header_section',
			[
				'label' => esc_html__( 'Header Setting', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'fixed_enable',
			[
				'label' => esc_html__( 'Header Fixed', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Fixed', 'sekolahpro' ),
				'label_off' => esc_html__( 'Scroll', 'sekolahpro' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
			'headtwo_background',
			[
				'label' => esc_html__( 'Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .header__two' => 'background: {{VALUE}};',
					'{{WRAPPER}} .mading__two li.menu-item-has-children:hover a' => 'color: {{VALUE}};',
					'{{WRAPPER}} .mading__two.desktop li.menu-item-has-children:hover:after' => 'background: {{VALUE}};',
					'.is_mobile {{WRAPPER}} .header__two .nav__menu' => 'background: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'logo_section',
			[
				'label' => esc_html__( 'Logo Setting', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'logoimage',
			[
				'label' => esc_html__( 'Choose Logo', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => plugin_dir_url( __FILE__ ).'img/logo.png',
				],
			]
		);
		$this->add_responsive_control(
			'logoheight',
			[
				'label' => esc_html__( 'Logo Height', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 30,
						'max' => 90,
						'step' => 2,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 30,
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => [
					'size' => 30,
					'unit' => 'px',
				],
				'tablet_default' => [
					'size' => 30,
					'unit' => 'px',
				],
				'mobile_default' => [
					'size' => 30,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .logo__two img' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .logo__two' => 'padding-top: calc( calc( 110px - {{SIZE}}{{UNIT}} )/2 ); padding-bottom: calc( calc( 110px - {{SIZE}}{{UNIT}} )/2 );',
					'.is_small {{WRAPPER}} .logo__two' => 'padding-top: calc( calc( 80px - {{SIZE}}{{UNIT}} )/2 ); padding-bottom: calc( calc( 80px - {{SIZE}}{{UNIT}} )/2 );',
				],
			]
		);
		$this->add_control(
			'logotwo_background',
			[
				'label' => esc_html__( 'Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#374DE5',
				'selectors' => [
					'{{WRAPPER}} .logo__two' => 'background: {{VALUE}};',
					'{{WRAPPER}} .logo__two:before' => 'border-left-color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'call_area',
			[
				'label' => esc_html__( 'Header Contact', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'call__bg',
			[
				'label' => esc_html__( 'Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#374DE5',
				'selectors' => [
					'{{WRAPPER}} .header__twowidth:before' => 'background: {{VALUE}};',
					'{{WRAPPER}} .icon__menutwo' => 'color: {{VALUE}};',
					'.is_mobile {{WRAPPER}} .call__two' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'iconphone',
			[
				'label' => esc_html__( 'Choose Icon', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-phone-alt',
					'library' => 'fa-solid',
				],
			]
		);
		$this->add_control(
			'headphone',
			[
				'label' => esc_html__( 'Phone Number', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( '+62 8152 xxxx xxx', 'sekolahpro' ),
				'placeholder' => esc_html__( '+62 8152 xxxx xxx', 'sekolahpro' ),
				'label_block' => true,
			]
		);
		
		$this->add_control(
			'iconwhatsapp',
			[
				'label' => esc_html__( 'Choose Icon', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fab fa-whatsapp',
					'library' => 'fa-brands',
				],
			]
		);
		$this->add_control(
			'headwhatsapp',
			[
				'label' => esc_html__( 'WhatsApp Number', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( '+62 8152 xxxx xxx', 'sekolahpro' ),
				'placeholder' => esc_html__( '62...', 'sekolahpro' ),
				'label_block' => true,
			]
		);
		
		$this->add_control(
			'iconaddress',
			[
				'label' => esc_html__( 'Choose Icon', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fa fa-map-marker-alt',
					'library' => 'fa-solid',
				],
			]
		);
		$this->add_control(
			'headaddress',
			[
				'label' => esc_html__( 'School Address', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Jl. Kerikil Tajam No. 123 Kota Metropolitan Jakarta Raya', 'sekolahpro' ),
				'placeholder' => esc_html__( 'Jl. Kerikil Tajam...', 'sekolahpro' ),
				'label_block' => true,
			]
		);
	
		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__( 'Icon Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .call__two .fa, .call__two .fas, .call__two .far, .call__two .fab' => 'color: {{VALUE}};',
					'{{WRAPPER}} .call__two i' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'calltext_color',
			[
				'label' => esc_html__( 'Text Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .call__two' => 'color: {{VALUE}};',
					'{{WRAPPER}} .call__two a' => 'color: {{VALUE}};',
					'{{WRAPPER}} .icon__menutwo' => 'background: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'menu_section',
			[
				'label' => esc_html__( 'Menu Setting', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'menumading',
			[
				'label' => esc_html__( 'Menu Mading', 'sekolahpro' ),
				'description' => esc_html__( 'Choose which menu you want to show.', 'sekolahpro' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '',
				'options'     => get_wpsekolah_menu(),
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'menutwo_typo',
				'label' => esc_html__( 'Typography Menu', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .mading__two, {{WRAPPER}} .calendar__two',
				
			]
		);
		$this->add_control(
			'menu__twocolor',
			[
				'label' => esc_html__( 'Menu Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#333333',
				'selectors' => [
					'{{WRAPPER}} .mading__two li a' => 'color: {{VALUE}};',
					'{{WRAPPER}} .mading__two.desktop li.menu-item-has-children:after' => 'background: {{VALUE}};',
					'.is_mobile {{WRAPPER}} .mading__two li.menu-item-has-children:hover a' => 'color: {{VALUE}};',
					'{{WRAPPER}} .nav__menu .mading__two.accord li.has-sub:after' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'menu__twohover',
			[
				'label' => esc_html__( 'Menu Hover', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#374DE5',
				'selectors' => [
					'{{WRAPPER}} .mading__two li a span' => 'background: {{VALUE}};',
					'{{WRAPPER}} .mading__two li a:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} .mading__two li.menu-item-has-children:before' => 'background: {{VALUE}};',
					'{{WRAPPER}} .calendar__two' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'span__twobg',
			[
				'label' => esc_html__( 'Accent Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#333333',
				'selectors' => [
					'{{WRAPPER}} .mading__two li a span' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'span__twocolor',
			[
				'label' => esc_html__( 'Accent Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .mading__two li a span' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'submenu__twobg',
			[
				'label' => esc_html__( 'Sub Menu Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#333333',
				'selectors' => [
					'{{WRAPPER}} .mading__two li ul li' => 'background: {{VALUE}};',
					'{{WRAPPER}} .mading__two li ul' => 'border-bottom: 10px solid {{VALUE}}; border-top: 10px solid {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'submenu__twocolor',
			[
				'label' => esc_html__( 'Sub Menu Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .mading__two li ul li a' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .mading__two li ul li:hover a' => 'color: {{VALUE}};',
					'{{WRAPPER}} .mading__two li ul li.menu-item-has-children:after' => 'background: {{VALUE}} !important;',
				],
			]
		);
		$this->end_controls_section();
		
		
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$nowas      = $settings['headwhatsapp']; 
		$new_nowas   = preg_replace("/[^A-Za-z0-9?!]/",'',$nowas);
		$menu = wp_nav_menu(
			array(
				'menu'            => $settings['menumading'],
				'menu_class'      => 'mading__two desktop', 
				'container_class' => 'nav__menu',
				'container'       => 'div',
				'menu_id'         => 'menutwo', 
				'echo'            => false,
				'fallback_cb'     => false
			)
		);
		
		if ( 'yes' === $settings['fixed_enable'] ) {
			echo '<div class="before__two__fixed"></div>';
			echo '<div class="header__two two__fixed">';
		} else {
			echo '<div class="header__two">';
		}
		?>
		    <div class="header__twowidth madclear">
	        	<div class="logo__two">
		        	<a href="<?php echo home_url(); ?>">
			          	<img src="<?php echo $settings['logoimage']['url'];?>" />
		    		</a>
		    	</div>
				<div class="menu__two">
				    <div class="inner__menu__two">
				    	<div class="call__two">
							<div class="call__left">
								<div class="calltwo__number">
								    <span class="two__icon"><?php \Elementor\Icons_Manager::render_icon( $settings['iconphone'], [ 'aria-hidden' => 'true' ] ); ?></span>
						    	    <?php 
										echo '<a target="_blank" href="tel:' . $settings['headphone'] . '">';
										echo '<span class="head__icon">' . $settings['headphone'] . '</span>';
										echo '</a>';
									?>
								</div>
								<div class="calltwo__number">
								    <span class="two__icon"><?php \Elementor\Icons_Manager::render_icon( $settings['iconwhatsapp'], [ 'aria-hidden' => 'true' ] ); ?></span>
							    	<?php 
										echo '<a target="_blank" href="https://wa.me/send?phone=' . $new_nowas . '">';
										echo '<span class="head__icon">' . $settings['headwhatsapp'] . '</span>';
										echo '</a>';
									?>
								</div>
								<div class="calltwo__number call__address">
								    <span class="two__icon"><?php \Elementor\Icons_Manager::render_icon( $settings['iconaddress'], [ 'aria-hidden' => 'true' ] ); ?></span>
						    		<?php 
								    	 echo '<span class="head__icon">' . $settings['headaddress'] . '</span>';
									?>
								</div>
							</div>
						</div>
			        	<div class="madclear">
				        	<?php echo $menu; ?>
				    	</div>
					</div>
				</div>
				<i class="icon-mad-menu icon__menutwo"></i>
				<div class="calendar__two">						
					<?php 
						$offset = get_option( 'gmt_offset' );
						$ciusstime = strtotime(gmdate('Y-m-d H:i:s', strtotime('+'.$offset.' hours')));
						echo esc_html(wp_date('l, d M Y', strtotime($ciusstime))); 
					?>
				</div>
			</div>
		</div>
		
		<?php
		
	}

	

}

