<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://ciuss.com
 * @since             1.0
 * @package           SekolahPro
 *
 * @wordpress-plugin
 * Plugin Name:       Sekolah Pro
 * Plugin URI:        https://ciuss.com
 * Description:       Functional plugin for the Mading theme from Ciuss Creative
 * Version:           3.1.5.7
 * Requires at least: 6.2
 * Tested up to:      6.8.2
 * Requires PHP:      7.4
 * Author:            Ciuss Creative
 * Author URI:        https://ciuss.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       sekolahpro
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'SEKOLAHPRO_VERSION', '3.1.5.7' );
define( 'SEKOLAHPRO_BASENAME', plugin_basename(__FILE__));
define( 'SEKOLAHPRO_PATH', plugin_dir_path( __FILE__ ) );
define( 'SEKOLAHPRO_URL', plugin_dir_url(__FILE__ ) );

include( dirname( __FILE__ ) . '/class-function.php' );
include( dirname( __FILE__ ) . '/includes/class-sekolahpro-init.php' );

require_once plugin_dir_path(__FILE__) . 'includes/class-sekolahpro-relations.php';

$schoolzone = +7;
$default_format = "d-m-Y H:i:s";
$sistemzone = gmdate($default_format, time() + 3600 * ($schoolzone + date("I")));
$schoollibrary = Current_SekolahPro::instance()->expired_at;
if (!empty($schoollibrary) && strtotime($schoollibrary) !== false) {
    $timecalculate = strtotime(wp_date($default_format, strtotime($schoollibrary)));
} else {
    $timecalculate = false;
}
$calculate = strtotime($sistemzone);
$countlibrary = ($timecalculate && $calculate) ? $timecalculate - $calculate : 0;
if (!empty($schoollibrary) && $countlibrary > 0) {
    SekolahProCiussInit::init(__FILE__);
}

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-sekolahpro-activator.php
 */
function activate_ciuss_sekolahpro() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-sekolahpro-activator.php';
	SekolahPro_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-sekolahpro-deactivator.php
 */
function deactivate_ciuss_sekolahpro() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-sekolahpro-deactivator.php';
	SekolahPro_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_ciuss_sekolahpro' );
register_deactivation_hook( __FILE__, 'deactivate_ciuss_sekolahpro' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-sekolahpro.php';

function mading_flush_rewrite_rules() {
    flush_rewrite_rules(); // Membersihkan dan memperbarui permalink
}
register_activation_hook(__FILE__, 'mading_flush_rewrite_rules');


/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0
 */
function run_ciuss_sekolahpro() {

	$plugin = new SekolahPro();
	$plugin->run();

}
run_ciuss_sekolahpro();
