<?php

defined( 'ABSPATH' ) || exit;

?>
<script type="text/template" id="tmpl-clTemplateLibrary__header-logo">
<!-- 	<span class="clTemplateLibrary__logo-wrap">
		<img src="<?php echo SEKOLAHPRO_URL ?>" style="height: 30px;">
	</span> -->
    <span class="clTemplateLibrary__logo-title">{{{ title }}}</span>
</script>

<script type="text/template" id="tmpl-clTemplateLibrary__header-back">
	<i class="eicon-" aria-hidden="true"></i>
	<span><?php echo __( 'Back to Library', 'sekolahpro' ); ?></span>
</script>

<script type="text/template" id="tmpl-clTemplateLibrary__header-menu">
	<# _.each( tabs, function( args, tab ) { var activeClass = args.active ? 'elementor-active' : ''; #>
		<div class="elementor-component-tab elementor-template-library-menu-item-cl {{activeClass}}" data-tab="{{{ tab }}}">{{{ args.title }}}</div>
	<# } ); #>
</script>

<script type="text/template" id="tmpl-clTemplateLibrary__header-menu-responsive">
</script>

<script type="text/template" id="tmpl-clTemplateLibrary__header-actions">
	<div id="clTemplateLibrary__header-sync" class="elementor-templates-modal__header__item">
		<i class="eicon-sync" aria-hidden="true" title="<?php esc_attr_e( 'Sync Library', 'sekolahpro' ); ?>"></i>
		<span class="elementor-screen-only"><?php esc_html_e( 'Sync Library', 'sekolahpro' ); ?></span>
	</div>
</script>

<script type="text/template" id="tmpl-clTemplateLibrary__preview">
    <iframe></iframe>
</script>

<script type="text/template" id="tmpl-clTemplateLibrary__header-insert">
	<div id="elementor-template-library-header-preview-insert-wrapper" class="elementor-templates-modal__header__item">
		{{{ cl.library.getModal().getTemplateActionButton( obj ) }}}
	</div>
</script>

<script type="text/template" id="tmpl-clTemplateLibrary__insert-button">
	<a class="elementor-template-library-template-action elementor-button clTemplateLibrary__insert-button">
		<i class="eicon-file-download" aria-hidden="true"></i>
		<span class="elementor-button-title"><?php esc_html_e( 'Insert', 'sekolahpro' ); ?></span>
	</a>
</script>

<script type="text/template" id="tmpl-clTemplateLibrary__pro-button"></script>

<script type="text/template" id="tmpl-clTemplateLibrary__loading">
	<div class="elementor-loader-wrapper">
		<div class="elementor-loader">
			<div class="elementor-loader-boxes">
				<div class="elementor-loader-box"></div>
				<div class="elementor-loader-box"></div>
				<div class="elementor-loader-box"></div>
				<div class="elementor-loader-box"></div>
			</div>
		</div>
		<div class="elementor-loading-title"><?php esc_html_e( 'Loading', 'sekolahpro' ); ?></div>
	</div>
</script>

<script type="text/template" id="tmpl-clTemplateLibrary__templates">
	<div id="clTemplateLibrary__toolbar">
		<div id="clTemplateLibrary__toolbar-filter" class="clTemplateLibrary__toolbar-filter">
			<# if (cl.library.getTypeTags()) { var selectedTag = cl.library.getFilter( 'tags' ); #>
				<span class="clTemplateLibrary__filter-btn">Category <i class="eicon-caret-right"></i></span>
				<ul id="clElementorLibrary-filter-tags" class="clElementorLibrary-filter-tags">
					<li data-tag="">All</li>
					<# _.each(cl.library.getTypeTags(), function(slug) {
						var selected = selectedTag === slug ? 'active' : '';
						#>
						<li data-tag="{{ slug }}" class="{{ selected }}">{{{ cl.library.getTags()[slug] }}}</li>
					<# } ); #>
				</ul>
			<# } #>
		</div>
		
		<div id="clTemplateLibrary__toolbar-search">
			<label for="clTemplateLibrary__search" class="elementor-screen-only"><?php esc_html_e( 'Search Templates:', 'sekolahpro' ); ?></label>
			<input id="clTemplateLibrary__search" placeholder="<?php esc_attr_e( 'Search', 'sekolahpro' ); ?>">
			<i class="eicon-search"></i>
		</div>
	</div>

	<div class="clTemplateLibrary__templates-window">
		<div id="clTemplateLibrary__templates-list"></div>
	</div>
</script>

<script type="text/template" id="tmpl-clTemplateLibrary__template">
	<div class="clTemplateLibrary__template-body" id="clTemplate-{{ template_id }}">
		<div class="clTemplateLibrary__template-preview">
			<i class="eicon-zoom-in-bold" aria-hidden="true"></i>
		</div>
		<img class="clTemplateLibrary__template-thumbnail" src="{{ thumbnail }}">
		<div class="clElementorlibrary-template-name">{{{ title }}}</div>
	</div>
	<div class="clTemplateLibrary__template-footer">
		{{{ cl.library.getModal().getTemplateActionButton( obj ) }}}
		<!-- <a href="#" class="elementor-button clTemplateLibrary__preview-button">
			<i class="eicon-device-desktop" aria-hidden="true"></i>
			<?php esc_html_e( 'Preview', 'sekolahpro' ); ?>
		</a> -->
	</div>
</script>

<script type="text/template" id="tmpl-clTemplateLibrary__empty">
	<div class="elementor-template-library-blank-icon">
		<img src="<?php echo ELEMENTOR_ASSETS_URL . 'images/no-search-results.svg'; ?>" class="elementor-template-library-no-results" />
	</div>
	<div class="elementor-template-library-blank-title"></div>
	<div class="elementor-template-library-blank-message"></div>
	<div class="elementor-template-library-blank-footer">
		<?php esc_html_e( 'Want to learn more about the Library?', 'sekolahpro' ); ?>
		
	</div>
</script>
