	    <?php 
		    $today = strtotime(date('d-m-Y'));
			$args_upcoming = array(
				'post_type' => 'agenda',
				'posts_per_page' => 4, // Maksimal yang dibutuhkan
				'ignore_sticky_posts' => 1,
				'meta_key' => '_minus',
				'orderby' => 'meta_value',
				'order' => 'ASC',
				'meta_query' => array(
					array(
						'key' => '_minus',
						'value' => $today,
						'compare' => '>='
					),
				),
			);

			$upcoming_query = new WP_Query($args_upcoming);
			
			$total_found = $upcoming_query->found_posts;

			// Jika post kurang dari 5, buat query kedua
			if ($total_found < 4) {
				$remaining_posts = 4 - $total_found;

				$args_past = array(
					'post_type' => 'agenda',
					'posts_per_page' => $remaining_posts,
					'ignore_sticky_posts' => 1,
					'meta_key' => '_minus',
					'orderby' => 'meta_value',
					'order' => 'DESC',
					'meta_query' => array(
						array(
						    'key' => '_minus',
						    'value' => $today,
						    'compare' => '<'
						 ),
					),
				);

				$past_query = new WP_Query($args_past);
			}

			// Gabungkan hasil kedua query
			$all_posts = array_merge(
				$upcoming_query->posts,
				isset($past_query) ? $past_query->posts : array()
			);
			
			?>
			<div class="op_ev_home">
				<?php
		        	global $post;
					if (!empty($all_posts)) :
						foreach ($all_posts as $index => $post) :
						setup_postdata($post);
				    	$minus       = strtotime(get_post_meta($post->ID, '_tevent', true).' '.get_post_meta($post->ID, '_jam', true));
						$tevent      = get_post_meta($post->ID, '_tevent', true);
						$jam         = get_post_meta($post->ID, '_jam', true);
						$sisa        = $minus - $today;
						$end         = $tevent . ' ' . $jam;	
						
						$lokasi      = get_post_meta( $post->ID, '_lokasi', true );
						$koordinator = get_post_meta( $post->ID, '_contper', true );
						$telepon     = get_post_meta( $post->ID, '_contwa', true );
						$acara       = date_i18n( "d F Y", strtotime( $tevent ) );
				    	
						if ( $sisa > 0 ) {
						    echo '<div class="op_event op_next">';
							echo '<div class="op_ev_title fm"><a href="'. get_the_permalink() .'">'. get_the_title() .' <span></span></a></div>';
							echo '<div class="op_ev_box madclear">';
								echo '<div class="op_ev_date">';
							    	echo '<span>'. date_i18n("d", strtotime($tevent)) .'</span>';
							    	echo '<span class="fs">'. date_i18n("M", strtotime($tevent)) .'</span>';
								echo '</div>';
								echo '<div class="op_ev_time fn">';
								    echo '<span class="fs">'.__('Event Time', 'mading') .'</span>';
									echo '<span>'. date_i18n("l", strtotime($tevent)) .' - <i class="icon-mad-clock"></i> '. esc_html( $jam ) .'</span>';
								echo '</div>';
							echo '</div>';
							echo '</div>';
						} else {
					     	echo '<div class="op_event op_prev">';
							echo '<div class="op_ev_title fm"><a href="'. get_the_permalink() .'">'. get_the_title() .' <span></span></a></div>';
							echo '<div class="op_ev_box madclear">';
								echo '<div class="op_ev_date">';
							    	echo '<span>'. date_i18n("d", strtotime($tevent)) .'</span>';
							    	echo '<span class="fs">'. date_i18n("M", strtotime($tevent)) .'</span>';
								echo '</div>';
								echo '<div class="op_ev_time fn">';
								    echo '<span class="fs">'.__('Event Time', 'mading') .'</span>';
									echo '<span>'. __('Event is expired', 'mading') .'</span>';
								echo '</div>';
							echo '</div>';
							echo '</div>';
						}
				    	endforeach;
    					wp_reset_postdata();
			     	endif;
				?>
			</div>
