<?php
/**
 * Tema WP Mading menambahkan beberapa fungsi hook
 * Memanggil beberapa fungsi lain, dibawah ini
 */

if ( version_compare( $GLOBALS['wp_version'], '6.2', '<' ) ) {
	// WP mading baiknya dijalankan pada WordPress 6.2 atau lebih tinggi.
	require get_template_directory() . '/include/back-compat.php';
}

if ( ! function_exists( 'mading_setup' ) ) :
    function mading_setup() {
		$color_scheme             = mading_get_color_scheme();
		$default_background_color = trim( $color_scheme[0], '#' );
		add_theme_support(
		'custom-background',
		apply_filters(
			'mading_custom_background_args',
			array(
				'default-color' => $default_background_color,
			)
		)
    	);
    	add_theme_support( 'title-tag' );
		// custom logo
		add_theme_support( 'custom-logo', array(
	    	'height'      => 240,
	    	'width'       => 600,
	    	'flex-height' => true,
    	) );
		
		// custom ukuran slide
		if ( get_theme_mod('slide_width') != "" ) {
			$swidth = get_theme_mod('slide_width');
	    } else {
			$swidth = 1400;
		}
		if ( get_theme_mod('slide_height') != "" ) {
			$sheight = get_theme_mod('slide_height');
		} else {
		    $sheight = 510;
	    }
	    add_theme_support('post-thumbnails');
	    add_image_size('slider', $swidth, $sheight, true);
    	add_image_size('news', 600, 450, true);
    	add_image_size('photo', 300, 400, true);
    	add_image_size('plite', 110, 147, true);
    	add_image_size('gall', 160, 120, true);
    	add_image_size('small', 90, 67, true);
		
		// menambahkan menu navigasi
		register_nav_menus(array(
	    	'navigation' => __('Show Menu in Navigation Header', 'mading'),
    	));
		add_theme_support('html5', array(
	    	'search-form', 'comment-form', 'comment-list',
    	));
		
		add_theme_support( 'customize-selective-refresh-widgets' );
		add_theme_support( 'responsive-embeds' );
	    add_theme_support( 'automatic-feed-links' );
	    
    }

endif; // mading_setup
add_action( 'after_setup_theme', 'mading_setup' );

load_theme_textdomain( 'mading', get_template_directory() . '/languages' );

function mading_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'mading_content_width', 840 );
}
add_action( 'after_setup_theme', 'mading_content_width', 0 );

/*
 * Register widget (sidebar).
 */
function mading_widgets_init() {
	require get_template_directory().'/widgets/posts.php';
	register_widget('Recentposts');
	require get_template_directory().'/widgets/school.php';
	register_widget('SchoolInfo');
	require get_template_directory().'/widgets/agenda.php';
	register_widget('RecentAgenda');
	require get_template_directory().'/widgets/pengumuman.php';
	register_widget('RecentPengumuman');
	require get_template_directory().'/widgets/blog.php';
	register_widget('RecentBlog');
	require get_template_directory().'/widgets/videos.php';
	register_widget('Videos');

	register_sidebar(array(
		'name' => __('Sidebar', 'mading'),
		'id'   => 'sidebar-1',
		'before_widget' => '<div id="%1$s" class="%2$s widget_block">',
		'after_widget' => '</div>',
		'before_title' => '<h2>',
		'after_title' => '</h2>'
	));
	
	register_sidebar(array(
		'name' => __('Footer Left', 'mading'),
		'id'   => 'sidebar-2',
		'before_widget' => '<div id="%1$s" class="%2$s widget_block">',
		'after_widget' => '</div>',
		'before_title' => '<h2>',
		'after_title' => '</h2>'
	));

	register_sidebar(array(
		'name' => __('Footer Center', 'mading'),
		'id'   => 'sidebar-3',
		'before_widget' => '<div id="%1$s" class="%2$s widget_block">',
		'after_widget' => '</div>',
		'before_title' => '<h2>',
		'after_title' => '</h2>'
	));
	
	register_sidebar(array(
		'name' => __('Footer Right', 'mading'),
		'id'   => 'sidebar-4',
		'before_widget' => '<div id="%1$s" class="%2$s widget_block">',
		'after_widget' => '</div>',
		'before_title' => '<h2>',
		'after_title' => '</h2>'
	));
	
}
add_action('widgets_init', 'mading_widgets_init');


function return_30( $seconds ) {
  // change the default feed cache recreation period to 30 seconds;
  return 120;
}
add_filter( 'wp_feed_cache_transient_lifetime' , 'return_30' ); 
 
/**
 * Register script
 */
 
function mading_stylescripts() {
	$theme_version = wp_get_theme()->get( 'Version' );
	// panggil css
	$refresh = date_i18n("His");
	// panggil css
	wp_enqueue_style('mading-style', get_stylesheet_uri(), array(), $refresh );
	if ( get_theme_mod('mode_tema') != "" ) {
		wp_enqueue_style('mading-css', get_template_directory_uri().'/'.get_theme_mod('mode_tema').'/style.css', array(), $refresh );
	} else {
		wp_enqueue_style('mading-css', get_template_directory_uri().'/mading/style.css', array(), $refresh );
	}
	wp_enqueue_style('splide-css', get_template_directory_uri().'/stylesheet/splide.min.css', array(), $theme_version );
	wp_enqueue_style('mading-font', get_template_directory_uri().'/stylesheet/mading-font.css', array(), $theme_version );
	wp_enqueue_style('icon-font', get_template_directory_uri().'/stylesheet/icofont.css', array(), $theme_version );
}
add_action('wp_enqueue_scripts', 'mading_stylescripts');

function admin_customizercss() {
	$theme_version = wp_get_theme()->get( 'Version' );
    wp_register_style( 'customizer_css', get_template_directory_uri() . '/stylesheet/customizer.css', false, $theme_version );
    wp_enqueue_style( 'customizer_css' );
}
add_action( 'admin_enqueue_scripts', 'admin_customizercss' );

function mading_scripts() {
	// panggil script
	if (is_singular() && comments_open() && get_option('thread_comments')) {
		wp_enqueue_script('comment-reply');
	}
	wp_enqueue_script( 'jquery' );
	wp_enqueue_script( 'splide-js', get_template_directory_uri() . '/javascript/splide.min.js', array(), false, true );
	wp_enqueue_script( 'mading-footer', get_template_directory_uri() . '/javascript/mading.min.js', array(), false, true );
	if ( get_theme_mod('mode_tema') == 'awesome' ) {
		wp_enqueue_script( 'mading-awesome', get_template_directory_uri() . '/javascript/awesome.min.js', array(), false, true );
	}
}
add_action('wp_enqueue_scripts', 'mading_scripts');

/**
 * Custom template untuk tema WP mading.
 */
require get_template_directory() . '/include/template-tags.php';

/**
 * Panel untuk Customizer.
 */
require get_template_directory() . '/include/customizer.php';
require get_template_directory() . '/include/partialrefresh.php';
require get_template_directory() . '/include/custom-fonts.php';
/**
 * Panel untuk Customizer.
 */
require get_template_directory() . '/include/coloring.php';
require get_template_directory() . '/include/color-option.php';
require get_template_directory() . '/include/color-enqueue.php';
require get_template_directory() . '/include/color-print.php';
require get_template_directory() . '/include/color-print-footer.php';
require get_template_directory() . '/include/color-inline-css.php';

require get_template_directory() . '/include/custom-ajax-auth.php';
require get_template_directory() . '/include/func/breadcrumb.php';
require get_template_directory() . '/include/func/ciuss-news.php';
require get_template_directory() . '/include/func/post-count.php';

if (is_admin() && isset($_GET['activated']) && $pagenow == 'themes.php') {
	update_option('posts_per_page', 12);
}

function reading_time() {
	global $post;
	$content = get_post_field( 'post_content', $post->ID );
	$word_count = str_word_count( strip_tags( $content ) );
	$readingtime = ceil($word_count / 200);
	
	$timer = __( 'minutes', 'mading' );
	
	$totalreadingtime = $readingtime . ' ' . $timer;

    return $totalreadingtime;
}

function mading_numeric_pagination() {

	if( is_singular() )
		return;
	global $wp_query;

	if( $wp_query->max_num_pages <= 1 )
		return;

	$paged = get_query_var( 'paged' ) ? absint( get_query_var( 'paged' ) ) : 1;
	$max   = intval( $wp_query->max_num_pages );
	if ( $paged >= 1 )
		$links[] = $paged;
	if ( $paged >= 3 ) {
		$links[] = $paged - 1;
		$links[] = $paged - 2;
	}

	if ( ( $paged + 2 ) <= $max ) {
		$links[] = $paged + 2;
		$links[] = $paged + 1;
	}

	if ( ! in_array( 1, $links ) ) {
		$class = 1 == $paged ? 'active' : 'normal';
		printf( '<a%s href="%s">%s</a>' . "\n", ' class="'. esc_attr( $class ) .'"', esc_url( get_pagenum_link( 1 ) ), '1' );
		if ( ! in_array( 2, $links ) )
			echo ' … ';
	}

	sort( $links );
	foreach ( (array) $links as $link ) {
		$class = $paged == $link ? 'active' : 'normal';
		printf( '<a%s href="%s">%s</a>' . "\n", ' class="'. esc_attr( $class ) .'"', esc_url( get_pagenum_link( $link ) ), esc_html( $link ) );
	}

	if ( ! in_array( $max, $links ) ) {
		if ( ! in_array( $max - 1, $links ) )
			echo ' … ' . "\n";
		$class = $paged == $max ? 'active' : 'normal';
		printf( '<a%s href="%s">%s</a>' . "\n", ' class="'. esc_attr( $class ) .'"', esc_url( get_pagenum_link( $max ) ), esc_html( $max ) );
	}

}



function mading_event_expired($post_ID) {
	    global $post;
        $post_event_date = get_post_meta($post_ID, '_tevent', true);
		$end = get_post_meta($post_ID, '_tevent', true).' '.get_post_meta($post_ID, '_jam', true);
		$exp = strtotime(date_i18n($end));
		$dday = strtotime(date_i18n('d-m-Y H:i'));
		$sisa = $exp-$dday;
		$event_date = date("d F Y", strtotime($post_event_date));
        if ($post_event_date != "" ) {
            echo esc_html( $event_date );
			if ( $sisa < 0 ) { 
			    echo '<br/><strong class="expired">';
				echo esc_html_e( 'Agenda is expired', 'mading' );
				echo '</strong>'; 
			} else {
				echo '<br/><strong class="next">';
				echo esc_html_e( 'Agenda in progress', 'mading' );
				echo '</strong>';
			}
        }
}

function mading_event_columns($defaults) {
        $defaults['mading_expired'] = __( 'Implementation', 'mading' );
        return $defaults;
}
	
function event_columns_content($column_name, $post_ID) {
        if ($column_name == 'mading_expired') {
			global $post;
            $post_expired_event = mading_event_expired($post_ID);
			$end = get_post_meta($post_ID, '_tevent', true).' '.get_post_meta($post_ID, '_jam', true);
	    	$exp = strtotime(date_i18n($end));
	    	$dday = strtotime(date_i18n('d-m-Y H:i'));
	    	$sisa = $exp-$dday;
			if ($post_expired_event != "" ) {
                echo esc_html( $post_expired_event );
				if ( $sisa < 0 ) { 
				echo '<br/><strong>';
				esc_html_e( 'Agenda is expired', 'mading' );
				echo '</strong>';
				}
            }
        }
}
	
add_filter('manage_agenda_posts_columns', 'mading_event_columns', 10);
add_action('manage_agenda_posts_custom_column', 'event_columns_content', 10, 2);

function new_excerpt_length($length) {
	return 200;
}
add_filter('excerpt_length', 'new_excerpt_length');

function smart_excerpt($string, $limit) {
	$words = explode(" ", $string);
	if (count($words) >= $limit) $dots = '..';
	else $dots = '';
	echo implode(" ", array_splice($words, 0, $limit)).esc_html($dots);
}

function comments_link_attributes() {
	return 'class="comments_popup_link"';
}
add_filter('comments_popup_link_attributes', 'comments_link_attributes');

function next_posts_attributes() {
	return 'class="nextpostslink"';
}
add_filter('next_posts_link_attributes', 'next_posts_attributes');

function prev_posts_attributes() {
	return 'class="previouspostslink"';
}
add_filter('previous_posts_link_attributes', 'prev_posts_attributes');

$exl_posts = array();

add_action('admin_head', 'mading_admin_styles');

function mading_admin_styles() { ?>
	<style>
	    <?php 
		    $user = wp_get_current_user();
            $allowed_roles = array( 'guru', 'master', 'operator', 'siswa' );
            if ( array_intersect( $allowed_roles, $user->roles ) ) { ?>
            
			.user-rich-editing-wrap,
			.user-admin-color-wrap,
			.show-admin-bar,
			.user-comment-shortcuts-wrap,
			.show-admin-bar user-admin-bar-front-wrap,
			.user-language-wrap,
			.user-profile-picture,
			#application-passwords-section {
				display: none;
		    }
			<?php 
			} 
		?>
		.mading_metabox label {
			display: block;
			margin: 8px 0;
		}
		.clear:after,
		.clearing:after {
            content: ".";
			display: block;
			height: 0;
			clear: both;
			visibility: hidden;
		}
		.mading_metabox table {
			width: 100%;
		}
		.mading_metabox iframe {
			padding-top: 10px;
		}
		.half {
			width: calc( 50% - 40px );
			float: left;
		}
		.halfclose {
			width: 80px;
			float: left;
		}
		.halfin {
			padding: 0 12px 8px 0;
		}
		.mading_hidden {
			position: relative;
		}
		.mading_hidden:after {
			content: "";
			position: absolute;
			left: 0;
			top: 0;
			width: 100%;
			height: 100%;
			z-index: 10;
			background: #fff;
			opacity: 0.4;
		}
		#podcast_file {
			float: left;
			width: calc( 100% - 100px );
		}
		#size_file {
			float: right;
			width: 90px;
		}
		.family {
			width: 50%; float: left;
		}
		.infam {
			padding: 0 15px 0 0;
		}
		.rss-box {
			margin: -12px -12px 12px;
		}
		.rss-box img {
			width: 100%;
			height: auto;
		}
		.rss-footer {
			margin: 12px -13px -13px;
			padding: 12px;
			border-top: 1px solid #ddd; 
			background: #035;
			color: #fff;
		}
		.rss-footer a {
			color: #fc0;
			text-decoration: none;
			font-weight: bold;
		}
		.mading_metabox .full {
			width: 100%;
		}
		.mading_metabox .abcd {
			width: 25%;
			float: left;
		}
		.button-move {
			background: #f33;
		}
		.rss-web {
			display: inline-block;
		}
		.rss-mob {
			display: none;
		}
		.image-preview {
			width: 150px; 
			margin: 0 20px 0 0; 
			float: left;
		}
		
		@media screen and (max-width:800px) {
		.rss-web {
			display: none;
		}
		.rss-mob {
			display: inline-block;
		}
		} 
		
	</style>
<?php }


// Pencarian Siswa Ajax
add_action('wp_ajax_siswa_fetch' , 'siswa_fetch');
add_action('wp_ajax_nopriv_siswa_fetch','siswa_fetch');

function siswa_fetch(){

    if ( ! isset ($_POST['student']) ) {
		$poststudent = sanitize_text_field( wp_unslash( $_POST['student'] ) );
	} else {
		$poststudent = '';
	}
	if ( get_theme_mod('sekolah_type') == "akademi" ) {
		$typesiswa = 'mahasiswa';
	} else if ( get_theme_mod('sekolah_type') == "pesantren" ) {
		$typesiswa = 'santri';
	} else {
		$typesiswa = 'siswa';
	}
    $the_query = new WP_Query( 
        array( 
            'posts_per_page' => 50, 
            's' => $poststudent, 
            'post_type' => $typesiswa, 
        ) 
    );

    if( $the_query->have_posts() ) :
	    echo '<table class="result_siswa">';
		echo '<tr><td>'.__('Name', 'mading').'</td><td>'.__('Class', 'mading').'</td></tr>';
        while( $the_query->have_posts() ): $the_query->the_post();
		    global $post;
			$nisn = get_post_meta($post->ID, '_nisn', true);
			
		    $myquery = sanitize_text_field( wp_unslash( $_POST['student'] ) );
			$a = $myquery;
			$search = get_the_title();
			if( stripos("/{$search}/", $a) !== false) { ?>
			
			    <tr>
                    <td><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></td>
					<td>
					    <?php 
					        $terms = get_the_terms( $post->ID , 'kelas' );
							if ( $terms != null ){
								foreach( $terms as $term ) {
									echo esc_html( $term->name );
									unset($term); 
								} 
							} 
						?>
					</td>
				</tr>
				
            <?php }
		endwhile;
		echo '</table>';
        wp_reset_postdata();  
    endif;

    die();
}


// the ajax function
add_action('wp_ajax_data_fetch' , 'data_fetch');
add_action('wp_ajax_nopriv_data_fetch','data_fetch');
function data_fetch(){
    
	if ( ! isset ($_POST['keyword']) ) {
		$postkeyword = sanitize_text_field( wp_unslash( $_POST['keyword'] ) );
	} else {
		$postkeyword = '';
	}
    $the_query = new WP_Query( 
        array( 
            'posts_per_page' => 50, 
            's' => $postkeyword, 
            'post_type' => 'download' 
        ) 
    );

    if( $the_query->have_posts() ) :
        while( $the_query->have_posts() ): $the_query->the_post();
		    global $post;
			$strFile = get_post_meta($post -> ID, $key = 'podcast_file', true);
			$sizeFile = get_post_meta($post -> ID, $key = 'size_file', true);
			
            $myquery = sanitize_text_field( wp_unslash( $_POST['keyword'] ) );
			$a = $myquery;
			$search = get_the_title();
			if( stripos("/{$search}/", $a) !== false) { ?>
			
			    <div class="ajax_down madclear">
				    <div class="ajax_box">
                    <h4><?php the_title();?></h4>
					<?php 
					    esc_html_e('File:&nbsp;', 'mading');
						$terms = get_the_terms( $post->ID , 'type-file' );
						if ( $terms != null ){
							foreach( $terms as $term ) {
								$term_link = get_term_link( $term, 'type-file');
								echo esc_html( $term->name );
								unset($term); 
							} 
						} 
						echo esc_html_e('&nbsp;size:&nbsp;', 'mading').' ';
						echo esc_html( $sizeFile ); 
					?>
				</div>
				
				<a class="down_down" download="" href="<?php echo esc_attr( $strFile ); ?>"><i class="icon-mad-download"></i></a>
				</div>
            <?php }
		endwhile;
        wp_reset_postdata();  
    endif;

    die();
}

function custom_post_author_archive($query) {
    if ($query->is_author)
        $query->set( 'post_type', array('blog') );
    remove_action( 'pre_get_posts', 'custom_post_author_archive' );
}
add_action('pre_get_posts', 'custom_post_author_archive'); 

/**
 * Role User.
 */
require get_template_directory() . '/include/func/capabilities.php';

function only_show_user_images( $query ) {
	$current_userID = get_current_user_id();
	if ( $current_userID && !current_user_can('manage_options')) {
		$query['author'] = $current_userID;
	}
	return $query; 
}

add_filter( 'ajax_query_attachments_args', 'only_show_user_images' ); 

function mading_rest_change_media_context( $result, $server, $request ) {
		// apply only to GET method
		$method = $request->get_method();
		if ( 'GET' !== $method ) {
			return $result;
		}

		$url = $request->get_route();
		if ( ! is_user_logged_in() || ( false === strpos( $url, '/wp/v2/media/' ) ) ) {
			return $result;
		}

		if ( 'edit' === $request->get_param( 'context' ) ) {
			$request->set_param( 'context', 'view' );
		}

		return $result;
	}

add_filter( 'rest_pre_dispatch', 'mading_rest_change_media_context', 10, 3 );

function post_publish_after() {
	
	global $post;
	
	$date = get_post_time('G', true, $post);
	
	
	// Array of time period chunks
	$chunks = array(
		array( 60 * 60 * 24 * 365 , __( 'year', 'mading' ), __( 'year', 'mading' ) ),
		array( 60 * 60 * 24 * 30 , __( 'month', 'mading' ), __( 'month', 'mading' ) ),
		array( 60 * 60 * 24 * 7, __( 'week', 'mading' ), __( 'week', 'mading' ) ),
		array( 60 * 60 * 24 , __( 'day', 'mading' ), __( 'day', 'mading' ) ),
		array( 60 * 60 , __( 'hour', 'mading' ), __( 'hour', 'mading' ) ),
		array( 60 , __( 'minute', 'mading' ), __( 'minute', 'mading' ) ),
		array( 1, __( 'second', 'mading' ), __( 'second', 'mading' ) )
	);

	if ( !is_numeric( $date ) ) {
		$time_chunks = explode( ':', str_replace( ' ', ':', $date ) );
		$date_chunks = explode( '-', str_replace( ' ', '-', $date ) );
		$date = gmmktime( (int)$time_chunks[1], (int)$time_chunks[2], (int)$time_chunks[3], (int)$date_chunks[1], (int)$date_chunks[2], (int)$date_chunks[0] );
	}
	
	$current_time = current_time( 'mysql', $gmt = 7 ); // waktu Indonesia GMT + 7
	$newer_date = strtotime( $current_time );

	// Jeda waktu dalam detik
	$since = $newer_date - $date;

	// Perhitungan waktu tak tentu.
	if ( 0 > $since )
		return __( 'a', 'mading' );

	//Step one
	for ( $i = 0, $j = count($chunks); $i < $j; $i++) {
		$seconds = $chunks[$i][0];

		if ( ( $count = floor($since / $seconds) ) != 0 )
			break;
	}

	// Set output var
	$output = ( 1 == $count ) ? '1 '. $chunks[$i][1] : $count . ' ' . $chunks[$i][2];
	

	if ( !(int)trim($output) ){
		$output = '0 ' . __( 'second', 'mading' );
	}
	
	$output .= __('&nbsp;ago', 'mading');
	
	return $output;
}

add_filter('the_time', 'post_publish_after');

add_shortcode( 'mading_frontend_post', 'mading_frontend_post' );
function mading_frontend_post() {
	ciuss_post_submit(); 
	global $current_user; 
	$args = array(
	    'author'       => $current_user->ID, 
		'post_type'    => 'alumni',
        'post_status'  => array( 'publish', 'draft' ),
	);
	$current_total_posts = get_posts( $args );
	$totalpost = count($current_total_posts);
	if ( is_user_logged_in() ) {
		if ( $totalpost < 1 ) {
		?>
        <form class="frontend__post" id="new_post" name="new_post" method="post"  enctype="multipart/form-data">
		    <div class="front_input">
		    	<label><?php echo esc_html_e('Full Name','mading'); ?></label>
                <input type="text" id="title" value="" name="title" />
            </div>
			<div class="front_input">
			    <label><?php echo esc_html_e( 'Number Register', 'mading' ); ?></label>
	            <input type="text" name="nomerinduk" value="" class="widefat" />
			</div>
			<div class="front_input">
		    	<label><?php echo esc_html_e( 'Class / Study', 'mading' ); ?></label>
	            <input type="text" name="kelasjurusan" value="" class="widefat" />
			</div>
			<div class="front_input">
		    	<label><?php echo esc_html_e( 'Graduation Year', 'mading' ); ?></label>
		    	<input type="text" name="tahunlulus" value="" class="widefat" />
			</div>
			<div class="sd <?php echo get_theme_mod('type_alumni', 'sma'); ?>">
		    	<label><?php echo esc_html_e( 'Continue studying at SMP / MTS', 'mading' ); ?></label>
	            <input type="text" name="smplanjut" value="" placeholder="<?php echo esc_attr__('school name...','mading'); ?>" class="widefat" />
			</div>
			<div class="smp <?php echo get_theme_mod('type_alumni', 'sma'); ?>">
		    	<label><?php echo esc_html_e( 'Continue studying at SMA / MA / SMK', 'mading' ); ?></label>
	            <input type="text" name="smalanjut" value="" placeholder="<?php echo esc_attr__('school name...','mading'); ?>" cclass="widefat" />
				<label><?php echo esc_html_e( 'Study (Especially SMK)', 'mading' ); ?></label>
	            <input type="text" name="smajurusan" value="" placeholder="<?php echo esc_attr__('study name...','mading'); ?>" cclass="widefat" />
			</div>
			<div class="sma <?php echo get_theme_mod('type_alumni', 'sma'); ?>">
			    <label><?php echo esc_html_e( 'Continue studying at College', 'mading' ); ?></label>
	            <input type="text" name="lanjutkuliah" value="" placeholder="<?php echo esc_attr__('university name...','mading'); ?>" cclass="widefat" />
				<label><?php echo esc_html_e( 'Study', 'mading' ); ?></label>
	            <input type="text" name="jurusankuliah" value="" placeholder="<?php echo esc_attr__('faculty name...','mading'); ?>" cclass="widefat" />
				<label><?php echo esc_html_e( 'Work at', 'mading' ); ?></label>
	            <input type="text" name="lanjutkerja" value="" placeholder="<?php echo esc_attr__('company name...','mading'); ?>" cclass="widefat" />
				<label><?php echo esc_html_e( 'Location / City', 'mading' ); ?></label>
	            <input type="text" name="lokasikerja" value="" placeholder="<?php echo esc_attr__('company location...','mading'); ?>" cclass="widefat" />
			</div>
			<div class="pt <?php echo get_theme_mod('type_alumni', 'sma'); ?>">
		    	<label><?php echo esc_html_e( 'Continue studying at College', 'mading' ); ?></label>
	            <input type="text" name="lanjutkuliah2" value="" placeholder="<?php echo esc_attr__('university name...','mading'); ?>" class="widefat" />
				<label><?php echo esc_html_e( 'Study', 'mading' ); ?></label>
	            <input type="text" name="jurusankuliah2" value="" placeholder="<?php echo esc_attr__('faculty name...','mading'); ?>" class="widefat" />
				<label><?php echo esc_html_e( 'Work at', 'mading' ); ?></label>
	            <input type="text" name="lanjutkerja2" value="" placeholder="<?php echo esc_attr__('company name...','mading'); ?>" class="widefat" />
				<label><?php echo esc_html_e( 'Location / City', 'mading' ); ?></label>
	            <input type="text" name="lokasikerja2" value="" placeholder="<?php echo esc_attr__('company location...','mading'); ?>" class="widefat" />
			</div>
			<div class="front_input">
		    	<label><?php echo esc_html_e( 'Kesan / Pesan', 'mading' ); ?></label>
	            <?php wp_editor( '', 'content' ); ?>
			</div>
			<div class="front_input">
		    	<label><?php echo esc_html_e( 'WhatsApp', 'mading' ); ?></label>
	            <input type="text" name="waalumni" value="" class="widefat" />
			</div>
			<div class="front_input">
		    	<label><?php echo esc_html_e( 'Facebook', 'mading' ); ?></label>
	            <input type="text" name="fbalumni" value="" class="widefat" />
			</div>
			<div class="front_input">
		    	<label><?php echo esc_html_e( 'Twitter', 'mading' ); ?></label>
	            <input type="text" name="twalumni" value="" class="widefat" />
			</div>
			<div class="front_input">
		    	<label><?php echo esc_html_e( 'Instagram', 'mading' ); ?></label>
	            <input type="text" name="igalumni" value="" class="widefat" />
			</div>
			<div class="front_input">
		    	<label><?php echo esc_html__('Upload Photo','mading'); ?></label>
				<input type="file" name="post_image" id="post_image" aria-required="true">
			</div>
            <div class="bold__clear"><input type="submit" value="<?php echo esc_attr__('Send Data','mading'); ?>" tabindex="6" id="submit" name="submit" class="front__submit"/></div>
        
        </form>
        <?php
		} else {
		?>
	    	<div class="alumni_head"><?php echo esc_html__('You have submitted data. Each alumni can only send data once', 'mading'); ?></div>
		<?php
		}
	} 
}
	
function ciuss_post_submit() {
    // Stop running function if form wasn't submitted
    if ( !isset($_POST['title']) ) {
        return;
    }

    // Add the content of the form to $post as an array
    $postarr = array(
        'post_title'    => $_POST['title'],
		'post_content'  => $_POST['content'],
        'post_status'   => 'draft',   // Could be: publish
        'post_type' 	=> 'alumni', // Could be: 'page' or your CPT
		'meta_input'    => array(
	    	'nomerinduk'     => $_POST['nomerinduk'],
			'kelasjurusan'   => $_POST['kelasjurusan'],
			'tahunlulus'     => $_POST['tahunlulus'],
			'smplanjut'      => $_POST['smplanjut'],
			'smalanjut'      => $_POST['smalanjut'],
			'smajurusan'     => $_POST['smajurusan'],
			'lanjutkuliah'   => $_POST['lanjutkuliah'],
			'jurusankuliah'  => $_POST['jurusankuliah'],
			'lanjutkerja'    => $_POST['lanjutkerja'],
			'lokasikerja'    => $_POST['lokasikerja'],
			'lanjutkuliah2'  => $_POST['lanjutkuliah2'],
			'jurusankuliah2' => $_POST['jurusankuliah2'],
			'lanjutkerja2'   => $_POST['lanjutkerja2'],
			'lokasikerja2'   => $_POST['lokasikerja2'],
			'waalumni'       => $_POST['waalumni'],
			'fbalumni'       => $_POST['fbalumni'],
			'twalumni'       => $_POST['twalumni'],
			'igalumni'       => $_POST['igalumni'],
    	),
    );
	$post_id = wp_insert_post($postarr);
	
	// For Featured Image
	if( !function_exists('wp_generate_attachment_metadata')){
		require_once(ABSPATH . "wp-admin" . '/includes/image.php');
		require_once(ABSPATH . "wp-admin" . '/includes/file.php');
		require_once(ABSPATH . "wp-admin" . '/includes/media.php');
	}
	if($_FILES) {
		foreach( $_FILES as $file => $array ) {
			if($_FILES[$file]['error'] !== UPLOAD_ERR_OK){
				return "upload error : " . $_FILES[$file]['error'];
			}
			$attach_id = media_handle_upload( $file, $post_id );
		}
	}
	if($attach_id > 0) {
		update_post_meta( $post_id,'_thumbnail_id', $attach_id );
	}
	if ( ! empty( $postarr['meta_input'] ) ) {
		foreach ( $postarr['meta_input'] as $field => $value ) {
			update_post_meta( $post_id, $field, $value );
		}
	}
    echo '<div class="input_success">';
	esc_html__('Your data has been successfully saved, Admin will check data before publishing. Thank You', 'mading');
	echo '</div>';
} 


function custom_ppdb_registration() {
    if (isset($_POST['submit_registration'])) {
        $username   = sanitize_user($_POST['username']);
        $email      = sanitize_email($_POST['email']);
        $password   = $_POST['password'];
        $role       = 'pendaftar';

        if (username_exists($username) || email_exists($email)) {
            echo '<p style="color: red;">Username atau Email sudah terdaftar.</p>';
        } else {
            $user_id = wp_create_user($username, $password, $email);

            if (!is_wp_error($user_id)) {
                wp_update_user(array('ID' => $user_id, 'role' => $role));
                echo '<p style="color: green;">Pendaftaran berhasil! Silakan login.</p>';
            } else {
                echo '<p style="color: red;">Terjadi kesalahan, coba lagi.</p>';
            }
        }
    }
}

function ppdb_registration_form() {
    ob_start();
    ?>
    <form method="post">
        <label for="username">Username:</label>
        <input type="text" name="username" required><br>

        <label for="email">Email:</label>
        <input type="email" name="email" required><br>

        <label for="password">Password:</label>
        <input type="password" name="password" required><br>

        <input type="submit" name="submit_registration" value="Daftar">
    </form>
    <?php
    return ob_get_clean();
}
add_shortcode('ppdb_register', 'ppdb_registration_form');

add_action('init', 'custom_ppdb_registration');

function restrict_pendaftar_wp_admin() {
    if (is_admin() && !defined('DOING_AJAX')) {
        $current_user = wp_get_current_user();
        if (in_array('pendaftar', (array) $current_user->roles)) {
            wp_redirect(home_url());
            exit;
        }
    }
}

function modify_document_title_parts($title) {
    unset($title['tagline']); // Hapus tagline
	if (is_single()) {
        unset($title['site']); // Hapus nama situs
    }
    return $title;
}
add_filter('document_title_parts', 'modify_document_title_parts');