<?php
/**
 * Jika pengguna mengganti WordPress ke versi lebih rendah.
 * Kembalikan tema ke default theme.
 */
function mading_switch_theme() {
	switch_theme( WP_DEFAULT_THEME, WP_DEFAULT_THEME );
	unset( $_GET['activated'] );
	add_action( 'admin_notices', 'mading_upgrade_notice' );
}
add_action( 'after_switch_theme', 'mading_switch_theme' );

function mading_upgrade_notice() {
	$message = sprintf( 
	    /* translators: %s: WordPress version. */
	    __( 'Mading need WordPress version 6.2. Update your WordPress', 'mading' ), $GLOBALS['wp_version'] 
	);
	printf( '<div class="error"><p>%s</p></div>', esc_html( $message ) );
}

function mading_customize() {
	wp_die( sprintf( 
	    /* translators: %s: WordPress version. */
	    esc_html( 'Mading need WordPress version 6.2. Update your WordPress', 'mading' ), esc_html( $GLOBALS['wp_version'] ) 
		), '', array(
		'back_link' => true,
	) );
}
add_action( 'load-customize.php', 'mading_customize' );

function mading_preview() {
	if ( isset( $_GET['preview'] ) ) {
		wp_die( sprintf( 
		    /* translators: %s: WordPress version. */
	    	esc_html( 'Mading need WordPress version 6.2. Update your WordPress', 'mading' ), esc_html( $GLOBALS['wp_version'] ) ) 
		);
	}
}
add_action( 'template_redirect', 'mading_preview' );