<?php

function mading_theme_color1_css() {
	$color_scheme          = mading_get_color_scheme();
	$default_color         = $color_scheme[1];
	$mading_color1 = get_theme_mod( 'mading_color1', $default_color );

	if ( $mading_color1 === $default_color ) {
		return;
	}

	$css = '
	.mading,
	.magazine,
	.awesome,
	.op_pg_head,
	.op_pg_head:before,
	.op_pg_head span:before,
	.op_tea_head,
	.op_footer {
		background: %1$s;
	}
	.comment__avatar img {
		border: 7px solid %1$s;
	}
	.post-category a,
	.akapost-category a,
	.madtags a,
	.agenda_dt,
	.a_time span,
	.waktu span,
	.comment-form #submit,
	.down_down,
	.kelas_head,
	.mat_count,
	.log_close a,
	.submit_button,
	.per_materi,
	.det_mapel,
    .det_kelas,
	.wp-block-search.wp-block-search__button-inside .wp-block-search__inside-wrapper .wp-block-search__button,
	.wp-block-search.wp-block-search__button-outside .wp-block-search__inside-wrapper .wp-block-search__button,
	.front__submit {
		color: %1$s;
	}
	.publish_date {
		color: %1$s;
		border: 8px solid %1$s;
	}
	.share i {
		border: 8px solid %1$s;
	}
	.wp-block-tag-cloud a,
	.press_eventmonth {
		color: %1$s;
	}
	
	.aka_pagination a.active {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color1 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color1_css', 11 );

function mading_theme_color2_css() {
	$color_scheme  = mading_get_color_scheme();
	$default_color = $color_scheme[2];
	$mading_color2  = get_theme_mod( 'mading_color2', $default_color );

	if ( $mading_color2 === $default_color ) {
		return;
	}

	$css = '
	body,
	#comment,
	.inncom input,
	.post_inpublish, 
	.after_title,
	.awesome #hours span {
		color: %1$s;
	}
	.press_eventmonth {
		color: %1$s;
	}
	.aka_pagination a {
		color: %1$s;
		border: 1px solid %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color2 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color2_css', 11 );

function mading_theme_color3_css() {
	$color_scheme    = mading_get_color_scheme();
	$default_color   = $color_scheme[3];
	$mading_color3 = get_theme_mod( 'mading_color3', $default_color );

	if ( $mading_color3 === $default_color ) {
		return;
	}

	$css = '
	.aka_pagination a.active {
		background: %1$s;
		border: 1px solid %1$s;
	}
	a,
	.awesome #hours span#secs {
		color: %1$s;
	}
	.img_link {
		background: %1$s;
	}
	.post-category a,
	.akapost-category a,
	.madtags a,
	.publish_date,
	.agenda_dt,
	.a_time span,
	.waktu span,
	.comment-form #submit,
	.down_down,
	.kelas_head,
	.mat_count,
	.log_close a,
	.submit_button,
	.per_materi,
	.det_mapel,
    .det_kelas,
	.art_title span,
	.table_inakademi td i,
	.akademi__comment i,
	.wp-block-search.wp-block-search__button-inside .wp-block-search__inside-wrapper .wp-block-search__button,
	.wp-block-search.wp-block-search__button-outside .wp-block-search__inside-wrapper .wp-block-search__button,
	.front__submit {
		background: %1$s;
	}
	.wp-block-search.wp-block-search__button-inside .wp-block-search__inside-wrapper,
	.wp-block-search.wp-block-search__no-button .wp-block-search__inside-wrapper,
	.wp-block-search.wp-block-search__button-outside .wp-block-search__inside-wrapper .wp-block-search__input {
		border: 1px solid %1$s;
	}
	.a_time span:before {
        border-right: 8px solid %1$s;
	}
	.a_time span:after {
        border-left: 8px solid %1$s;
	}
	.wp-block-tag-cloud a {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color3) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color3_css', 11 );

function mading_theme_color4_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[4];
	$mading_color4 = get_theme_mod( 'mading_color4', $default_color );

	if ( $mading_color4 === $default_color ) {
		return;
	}

	$css = '
	.mad__top {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color4 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color4_css', 11 );

function mading_theme_color5_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[5];
	$mading_color5 = get_theme_mod( 'mading_color5', $default_color );

	if ( $mading_color5 === $default_color ) {
		return;
	}

	$css = '
	.mad__top,
	.mad__top a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color5 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color5_css', 11 );

function mading_theme_color6_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[6];
	$mading_color6 = get_theme_mod( 'mading_color6', $default_color );

	if ( $mading_color6 === $default_color ) {
		return;
	}

	$css = '
	.head_time,
    .head_phone,
    .head_mail,
	.mad__nav .newnav .accordion li a span {
	    background: %1$s;
    }
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color6 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color6_css', 11 );

function mading_theme_color7_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[7];
	$mading_color7 = get_theme_mod( 'mading_color7', $default_color );

	if ( $mading_color7 === $default_color ) {
		return;
	}

	$css = '
	.head_time,
    .head_phone,
    .head_mail,
	.mad__nav .newnav .accordion li a span {
	    color: %1$s;
    }
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color7 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color7_css', 11 );

function mading_theme_color8_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[8];
	$mading_color8 = get_theme_mod( 'mading_color8', $default_color );

	if ( $mading_color8 === $default_color ) {
		return;
	}

	$css = '
	.mad__nav:after,
	.layout_mading .site-header-menu,
	#madingslider {
		background: %1$s;
	}
	.mad__search i,
    .mad__menu i,
	.aka__search {
		color: %1$s;
	}
	@media screen and (max-width: 982px) {
    	.aka_sos_in {
	    	background: %1$s;
    	}
    }
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color8 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color8_css', 11 );

function mading_theme_color9_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[9];
	$mading_color9 = get_theme_mod( 'mading_color9', $default_color );

	if ( $mading_color9 === $default_color ) {
		return;
	}

	$css = '
	.newnav .accordion li a,
	.mad__nav .newnav .accordion li a,
	.mad__nav .newnav .accordion li.menu-item-has-children:after {
		color: %1$s;
	}
	.mad__search i,
    .mad__menu i {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color9 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color9_css', 11 );

function mading_theme_color10_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[10];
	$mading_color10 = get_theme_mod( 'mading_color10', $default_color );

	if ( $mading_color10 === $default_color ) {
		return;
	}

	$css = '
    .mad__nav .newnav .accordion li ul {
		background: %1$s;
	}
	.mad__nav .newnav .accordion li.menu-item-has-children:before {
		border-bottom: 12px solid %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color10 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color10_css', 11 );


function mading_theme_color11_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[11];
	$mading_color11 = get_theme_mod( 'mading_color11', $default_color );

	if ( $mading_color11 === $default_color ) {
		return;
	}

	$css = '
	.mad__nav .newnav .accordion li ul a,
	.mad__nav .newnav .accordion li ul li.menu-item-has-children:after {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color11 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color11_css', 11 );

function mading_theme_color12_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[12];
	$mading_color12 = get_theme_mod( 'mading_color12', $default_color );

	if ( $mading_color12 === $default_color ) {
		return;
	}

	$css = '
	.mad__nav .newnav.nav-desktop .accordion li ul a:hover {
        background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color12 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color12_css', 11 );

function mading_theme_color13_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[13];
	$mading_color13 = get_theme_mod( 'mading_color13', $default_color );

	if ( $mading_color13 === $default_color ) {
		return;
	}

	$css = '
	.mad__nav .newnav.nav-desktop .accordion li ul a:hover,
	.mad__nav .newnav .accordion li ul li.menu-item-has-children:hover:after {
		color: %1$s;
	}	
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color13 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color13_css', 11 );

function mading_theme_color14_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[14];
	$mading_color14 = get_theme_mod( 'mading_color14', $default_color );

	if ( $mading_color14 === $default_color ) {
		return;
	}

	$css = '
	.form__search {
		background: %1$s;
	}
	#searchform:before {
		border-bottom: 10px solid %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color14 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color14_css', 11 );

function mading_theme_color15_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[15];
	$mading_color15 = get_theme_mod( 'mading_color15', $default_color );

	if ( $mading_color15 === $default_color ) {
		return;
	}

	$css = '
	.mad__select,
	.mad__input {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color15 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color15_css', 11 );

function mading_theme_color16_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[16];
	$mading_color16 = get_theme_mod( 'mading_color16', $default_color );

	if ( $mading_color16 === $default_color ) {
		return;
	}

	$css = '
	.mad__select select,
	.mad__input input {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color16 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color16_css', 11 );

function mading_theme_color17_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[17];
	$mading_color17 = get_theme_mod( 'mading_color17', $default_color );

	if ( $mading_color17 === $default_color ) {
		return;
	}

	$css = '
	.mad__button button {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color17 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color17_css', 11 );

function mading_theme_color18_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[18];
	$mading_color18 = get_theme_mod( 'mading_color18', $default_color );

	if ( $mading_color18 === $default_color ) {
		return;
	}

	$css = '
	.mad__button button {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color18 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color18_css', 11 );

function mading_theme_color19_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[19];
	$mading_color19 = get_theme_mod( 'mading_color19', $default_color );

	if ( $mading_color19 === $default_color ) {
		return;
	}

	$css = '
	.mad__school {
			background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color19 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color19_css', 11 );

function mading_theme_color20_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[20];
	$mading_color20 = get_theme_mod( 'mading_color20', $default_color );

	if ( $mading_color20 === $default_color ) {
		return;
	}

	$css = '
    .mad__school {
		color : %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color20 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color20_css', 11 );

function mading_theme_color21_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[21];
	$mading_color21 = get_theme_mod( 'mading_color21', $default_color );

	if ( $mading_color21 === $default_color ) {
		return;
	}

	$css = '
	.mad__sos .icon-mad-facebook {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color21 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color21_css', 11 );

function mading_theme_color22_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[22];
	$mading_color22 = get_theme_mod( 'mading_color22', $default_color );

	if ( $mading_color22 === $default_color ) {
		return;
	}

	$css = '
	.mad__sos .icon-mad-facebook {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color22 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color22_css', 11 );

function mading_theme_color23_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[23];
	$mading_color23 = get_theme_mod( 'mading_color23', $default_color );

	if ( $mading_color23 === $default_color ) {
		return;
	}

	$css = '
	.mad__sos .icofont-x,
	.mad__sos .icofont-tiktok {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color23 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color23_css', 11 );

function mading_theme_color24_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[24];
	$mading_color24 = get_theme_mod( 'mading_color24', $default_color );

	if ( $mading_color24 === $default_color ) {
		return;
	}

	$css = '
	.mad__sos .icofont-x,
	.mad__sos .icofont-tiktok {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color24 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color24_css', 11 );

function mading_theme_color25_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[25];
	$mading_color25 = get_theme_mod( 'mading_color25', $default_color );

	if ( $mading_color25 === $default_color ) {
		return;
	}

	$css = '
	.mad__sos .icon-mad-instagram {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color25 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color25_css', 11 );

function mading_theme_color26_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[26];
	$mading_color26 = get_theme_mod( 'mading_color26', $default_color );

	if ( $mading_color26 === $default_color ) {
		return;
	}

	$css = '
	.mad__sos .icon-mad-instagram {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color26 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color26_css', 11 );

function mading_theme_color27_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[27];
	$mading_color27 = get_theme_mod( 'mading_color27', $default_color );

	if ( $mading_color27 === $default_color ) {
		return;
	}

	$css = '
	.mad__sos .icon-mad-youtube {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color27 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color27_css', 11 );

function mading_theme_color28_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[28];
	$mading_color28 = get_theme_mod( 'mading_color28', $default_color );

	if ( $mading_color28 === $default_color ) {
		return;
	}

	$css = '
	.mad__sos .icon-mad-youtube {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color28 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color28_css', 11 );

function mading_theme_color29_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[29];
	$mading_color29 = get_theme_mod( 'mading_color29', $default_color );

	if ( $mading_color29 === $default_color ) {
		return;
	}

	$css = '
	.mad__sos .icon-mad-mail {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color29 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color29_css', 11 );

function mading_theme_color30_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[30];
	$mading_color30 = get_theme_mod( 'mading_color30', $default_color );

	if ( $mading_color30 === $default_color ) {
		return;
	}

	$css = '
	.mad__sos .icon-mad-mail {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color30 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color30_css', 11 );

function mading_theme_color31_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[31];
	$mading_color31 = get_theme_mod( 'mading_color31', $default_color );

	if ( $mading_color31 === $default_color ) {
		return;
	}

	$css = '
	.mad__sos .icon-mad-whatsapp {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color31 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color31_css', 11 );

function mading_theme_color32_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[32];
	$mading_color32 = get_theme_mod( 'mading_color32', $default_color );

	if ( $mading_color32 === $default_color ) {
		return;
	}

	$css = '
	.mad__sos .icon-mad-whatsapp {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color32 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color32_css', 11 );

function mading_theme_color33_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[33];
	$mading_color33 = get_theme_mod( 'mading_color33', $default_color );

	if ( $mading_color33 === $default_color ) {
		return;
	}

	$css = '
	.mad_ticker {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color33 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color33_css', 11 );

function mading_theme_color34_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[34];
	$mading_color34 = get_theme_mod( 'mading_color34', $default_color );

	if ( $mading_color34 === $default_color ) {
		return;
	}

	$css = '
	.mad_ticker {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color34 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color34_css', 11 );

function mading_theme_color35_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[35];
	$mading_color35 = get_theme_mod( 'mading_color35', $default_color );

	if ( $mading_color35 === $default_color ) {
		return;
	}

	$css = '
	.mad_ticker a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color35 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color35_css', 11 );

function mading_theme_color36_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[36];
	$mading_color36 = get_theme_mod( 'mading_color36', $default_color );

	if ( $mading_color36 === $default_color ) {
		return;
	}

	$css = '
	.sekilas,
	.mad_today {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color36 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color36_css', 11 );

function mading_theme_color37_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[37];
	$mading_color37 = get_theme_mod( 'mading_color37', $default_color );

	if ( $mading_color37 === $default_color ) {
		return;
	}

	$css = '
	.sekilas,
	.mad_today {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color37 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color37_css', 11 );

function mading_theme_color38_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[38];
	$mading_color38 = get_theme_mod( 'mading_color38', $default_color );

	if ( $mading_color38 === $default_color ) {
		return;
	}

	$css = '
	.news_editorial {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color38 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color38_css', 11 );

function mading_theme_color39_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[39];
	$mading_color39 = get_theme_mod( 'mading_color39', $default_color );

	if ( $mading_color39 === $default_color ) {
		return;
	}

	$css = '
	.title_news {
	    background: %1$s;
    }
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color39 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color39_css', 11 );

function mading_theme_color40_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[40];
	$mading_color40 = get_theme_mod( 'mading_color40', $default_color );

	if ( $mading_color40 === $default_color ) {
		return;
	}

	$css = '
	.title_news {
	    color: %1$s;
    }
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color40 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color40_css', 11 );

function mading_theme_color41_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[41];
	$mading_color41 = get_theme_mod( 'mading_color41', $default_color );

	if ( $mading_color41 === $default_color ) {
		return;
	}

	$css = '
    .news_meta,
	.get_names {
        background: linear-gradient(rgba(0, 0, 0, 0), %1$s);
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color41 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color41_css', 11 );

function mading_theme_color42_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[42];
	$mading_color42 = get_theme_mod( 'mading_color42', $default_color );

	if ( $mading_color42 === $default_color ) {
		return;
	}

	$css = '
	.news_meta {
        color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color42 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color42_css', 11 );

function mading_theme_color43_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[43];
	$mading_color43 = get_theme_mod( 'mading_color43', $default_color );

	if ( $mading_color43 === $default_color ) {
		return;
	}

	$css = '
	.news_meta a,
	.get_names {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color43 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color43_css', 11 );

function mading_theme_color44_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[44];
	$mading_color44 = get_theme_mod( 'mading_color44', $default_color );

	if ( $mading_color44 === $default_color ) {
		return;
	}

	$css = '
	.edit_before {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color44 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color44_css', 11 );

function mading_theme_color45_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[45];
	$mading_color45 = get_theme_mod( 'mading_color45', $default_color );

	if ( $mading_color45 === $default_color ) {
		return;
	}

	$css = '
    .edit_box a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color45 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color45_css', 11 );

function mading_theme_color46_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[46];
	$mading_color46 = get_theme_mod( 'mading_color46', $default_color );

	if ( $mading_color46 === $default_color ) {
		return;
	}

	$css = '
    .edit_box:after {
		border-right: 10px solid %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color46 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color46_css', 11 );

function mading_theme_color47_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[47];
	$mading_color47 = get_theme_mod( 'mading_color47', $default_color );

	if ( $mading_color47 === $default_color ) {
		return;
	}

	$css = '
    .four_block_post {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color47 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color47_css', 11 );

function mading_theme_color48_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[48];
	$mading_color48 = get_theme_mod( 'mading_color48', $default_color );

	if ( $mading_color48 === $default_color ) {
		return;
	}

	$css = '
    .title_four.re_peng {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color48 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color48_css', 11 );

function mading_theme_color49_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[49];
	$mading_color49 = get_theme_mod( 'mading_color49', $default_color );

	if ( $mading_color49 === $default_color ) {
		return;
	}

	$css = '
    .title_four.re_peng:before {
		border-top: 3px solid %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color49 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color49_css', 11 );

function mading_theme_color50_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[50];
	$mading_color50 = get_theme_mod( 'mading_color50', $default_color );

	if ( $mading_color50 === $default_color ) {
		return;
	}

	$css = '
    .pengbox .first_layer {
		background: linear-gradient(rgba(0, 0, 0, 0), %1$s);
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color50 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color50_css', 11 );

function mading_theme_color51_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[51];
	$mading_color51 = get_theme_mod( 'mading_color51', $default_color );

	if ( $mading_color51 === $default_color ) {
		return;
	}

	$css = '
	.pengbox .first_layer {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color51 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color51_css', 11 );

function mading_theme_color52_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[52];
	$mading_color52 = get_theme_mod( 'mading_color52', $default_color );

	if ( $mading_color52 === $default_color ) {
		return;
	}

	$css = '
	.pengbox .first_layer a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color52 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color52_css', 11 );

function mading_theme_color53_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[53];
	$mading_color53 = get_theme_mod( 'mading_color53', $default_color );

	if ( $mading_color53 === $default_color ) {
		return;
	}

	$css = '
	.pengbox {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color53 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color53_css', 11 );

function mading_theme_color54_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[54];
	$mading_color54 = get_theme_mod( 'mading_color54', $default_color );

	if ( $mading_color54 === $default_color ) {
		return;
	}

	$css = '
	.pengbox {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color54 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color54_css', 11 );

function mading_theme_color55_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[55];
	$mading_color55 = get_theme_mod( 'mading_color55', $default_color );

	if ( $mading_color55 === $default_color ) {
		return;
	}

	$css = '
	.pengbox a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color55 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color55_css', 11 );

function mading_theme_color56_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[56];
	$mading_color56 = get_theme_mod( 'mading_color56', $default_color );

	if ( $mading_color56 === $default_color ) {
		return;
	}

	$css = '
	.pengbox .four_bottom a {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color56 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color56_css', 11 );

function mading_theme_color57_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[57];
	$mading_color57 = get_theme_mod( 'mading_color57', $default_color );

	if ( $mading_color57 === $default_color ) {
		return;
	}

	$css = '
    .pengbox .four_bottom a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color57 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color57_css', 11 );

function mading_theme_color58_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[58];
	$mading_color58 = get_theme_mod( 'mading_color58', $default_color );

	if ( $mading_color58 === $default_color ) {
		return;
	}

	$css = '
	.title_four.re_blog {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color58 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color58_css', 11 );

function mading_theme_color59_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[59];
	$mading_color59 = get_theme_mod( 'mading_color59', $default_color );

	if ( $mading_color59 === $default_color ) {
		return;
	}

	$css = '
	.title_four.re_blog:before {
		border-top: 3px solid %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color59 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color59_css', 11 );

function mading_theme_color60_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[60];
	$mading_color60 = get_theme_mod( 'mading_color60', $default_color );

	if ( $mading_color60 === $default_color ) {
		return;
	}

	$css = '
	.madblogguru .first_layer {
		background: linear-gradient(rgba(0, 0, 0, 0), %1$s);
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color60 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color60_css', 11 );

function mading_theme_color61_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[61];
	$mading_color61 = get_theme_mod( 'mading_color61', $default_color );

	if ( $mading_color61 === $default_color ) {
		return;
	}

	$css = '
	.madblogguru .first_layer {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color61 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color61_css', 11 );

function mading_theme_color62_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[62];
	$mading_color62 = get_theme_mod( 'mading_color62', $default_color );

	if ( $mading_color62 === $default_color ) {
		return;
	}

	$css = '
	.madblogguru .first_layer a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color62 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color62_css', 11 );

function mading_theme_color63_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[63];
	$mading_color63 = get_theme_mod( 'mading_color63', $default_color );

	if ( $mading_color63 === $default_color ) {
		return;
	}

	$css = '
	.madblogguru {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color63 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color63_css', 11 );

function mading_theme_color64_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[64];
	$mading_color64 = get_theme_mod( 'mading_color64', $default_color );

	if ( $mading_color64 === $default_color ) {
		return;
	}

	$css = '
	.madblogguru {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color64 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color64_css', 11 );

function mading_theme_color65_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[65];
	$mading_color65 = get_theme_mod( 'mading_color65', $default_color );

	if ( $mading_color65 === $default_color ) {
		return;
	}

	$css = '
	.madblogguru a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color65 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color65_css', 11 );

function mading_theme_color66_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[66];
	$mading_color66 = get_theme_mod( 'mading_color66', $default_color );

	if ( $mading_color66 === $default_color ) {
		return;
	}

	$css = '
	.madblogguru .four_bottom a {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color66 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color66_css', 11 );

function mading_theme_color67_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[67];
	$mading_color67 = get_theme_mod( 'mading_color67', $default_color );

	if ( $mading_color67 === $default_color ) {
		return;
	}

	$css = '
	.madblogguru .four_bottom a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color67 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color67_css', 11 );

function mading_theme_color68_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[68];
	$mading_color68 = get_theme_mod( 'mading_color68', $default_color );

	if ( $mading_color68 === $default_color ) {
		return;
	}

	$css = '
	.title_four.re_fasilitas {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color68 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color68_css', 11 );

function mading_theme_color69_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[69];
	$mading_color69 = get_theme_mod( 'mading_color69', $default_color );

	if ( $mading_color69 === $default_color ) {
		return;
	}

	$css = '
	.title_four.re_fasilitas:before {
		border-top: 3px solid %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color69 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color69_css', 11 );

function mading_theme_color70_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[70];
	$mading_color70 = get_theme_mod( 'mading_color70', $default_color );

	if ( $mading_color70 === $default_color ) {
		return;
	}

	$css = '
    .sarana .first_layer {
		background: linear-gradient(rgba(0, 0, 0, 0), %1$s);
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color70 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color70_css', 11 );

function mading_theme_color71_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[71];
	$mading_color71 = get_theme_mod( 'mading_color71', $default_color );

	if ( $mading_color71 === $default_color ) {
		return;
	}

	$css = '
	.sarana .first_layer {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color71 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color71_css', 11 );

function mading_theme_color72_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[72];
	$mading_color72 = get_theme_mod( 'mading_color72', $default_color );

	if ( $mading_color72 === $default_color ) {
		return;
	}

	$css = '
	.sarana .first_layer a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color72 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color72_css', 11 );

function mading_theme_color73_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[73];
	$mading_color73 = get_theme_mod( 'mading_color73', $default_color );

	if ( $mading_color73 === $default_color ) {
		return;
	}

	$css = '
	.sarana {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color73 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color73_css', 11 );

function mading_theme_color74_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[74];
	$mading_color74 = get_theme_mod( 'mading_color74', $default_color );

	if ( $mading_color74 === $default_color ) {
		return;
	}

	$css = '
	.sarana {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color74 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color74_css', 11 );

function mading_theme_color75_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[75];
	$mading_color75 = get_theme_mod( 'mading_color75', $default_color );

	if ( $mading_color75 === $default_color ) {
		return;
	}

	$css = '
	.sarana a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color75 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color75_css', 11 );

function mading_theme_color76_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[76];
	$mading_color76 = get_theme_mod( 'mading_color76', $default_color );

	if ( $mading_color76 === $default_color ) {
		return;
	}

	$css = '
	.sarana .four_bottom a {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color76 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color76_css', 11 );

function mading_theme_color77_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[77];
	$mading_color77 = get_theme_mod( 'mading_color77', $default_color );

	if ( $mading_color77 === $default_color ) {
		return;
	}

	$css = '
	.sarana .four_bottom a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color77 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color77_css', 11 );

function mading_theme_color78_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[78];
	$mading_color78 = get_theme_mod( 'mading_color78', $default_color );

	if ( $mading_color78 === $default_color ) {
		return;
	}

	$css = '
	.title_four.re_kegiatan {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color78 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color78_css', 11 );

function mading_theme_color79_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[79];
	$mading_color79 = get_theme_mod( 'mading_color79', $default_color );

	if ( $mading_color79 === $default_color ) {
		return;
	}

	$css = '
	.title_four.re_kegiatan:before {
		border-top: 3px solid %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color79 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color79_css', 11 );

function mading_theme_color80_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[80];
	$mading_color80 = get_theme_mod( 'mading_color80', $default_color );

	if ( $mading_color80 === $default_color ) {
		return;
	}

	$css = '
	.kegiatan .first_layer {
		background: linear-gradient(rgba(0, 0, 0, 0), %1$s);
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color80 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color80_css', 11 );

function mading_theme_color81_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[81];
	$mading_color81 = get_theme_mod( 'mading_color81', $default_color );

	if ( $mading_color81 === $default_color ) {
		return;
	}

	$css = '
	.kegiatan .first_layer {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color81 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color81_css', 11 );

function mading_theme_color82_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[82];
	$mading_color82 = get_theme_mod( 'mading_color82', $default_color );

	if ( $mading_color82 === $default_color ) {
		return;
	}

	$css = '
	.kegiatan .first_layer a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color82 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color82_css', 11 );

function mading_theme_color83_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[83];
	$mading_color83 = get_theme_mod( 'mading_color83', $default_color );

	if ( $mading_color83 === $default_color ) {
		return;
	}

	$css = '
	.kegiatan {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color83 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color83_css', 11 );

function mading_theme_color84_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[84];
	$mading_color84 = get_theme_mod( 'mading_color84', $default_color );

	if ( $mading_color84 === $default_color ) {
		return;
	}

	$css = '
	.kegiatan {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color84 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color84_css', 11 );

function mading_theme_color85_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[85];
	$mading_color85 = get_theme_mod( 'mading_color85', $default_color );

	if ( $mading_color85 === $default_color ) {
		return;
	}

	$css = '
	.kegiatan a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color85 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color85_css', 11 );

function mading_theme_color86_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[86];
	$mading_color86 = get_theme_mod( 'mading_color86', $default_color );

	if ( $mading_color86 === $default_color ) {
		return;
	}

	$css = '
	.kegiatan .four_bottom a {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color86 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color86_css', 11 );

function mading_theme_color87_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[87];
	$mading_color87 = get_theme_mod( 'mading_color87', $default_color );

	if ( $mading_color87 === $default_color ) {
		return;
	}

	$css = '
	.kegiatan .four_bottom a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color87 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color87_css', 11 );

function mading_theme_color88_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[88];
	$mading_color88 = get_theme_mod( 'mading_color88', $default_color );

	if ( $mading_color88 === $default_color ) {
		return;
	}

	$css = '
    .overlay {
	    background: %1$s;
    }
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color88 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color88_css', 11 );

function mading_theme_color89_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[89];
	$mading_color89 = get_theme_mod( 'mading_color89', $default_color );

	if ( $mading_color89 === $default_color ) {
		return;
	}

	$css = '
	.event_block {
	     color: %1$s;
    }
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color89 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color89_css', 11 );

function mading_theme_color90_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[90];
	$mading_color90 = get_theme_mod( 'mading_color90', $default_color );

	if ( $mading_color90 === $default_color ) {
		return;
	}

	$css = '
	.age_date {
	    color: %1$s;
    }
	.day,
	.hour,
	.minute {
        color: %1$s;
        border-bottom: 1px solid %1$s;
    }
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color90 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color90_css', 11 );

function mading_theme_color91_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[91];
	$mading_color91 = get_theme_mod( 'mading_color91', $default_color );

	if ( $mading_color91 === $default_color ) {
		return;
	}

	$css = '
	.age_title h3 a {
	    color: %1$s;
    }
	.second {
        color: %1$s;
        border-bottom: 1px solid %1$s;
    }
	.un span {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color91 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color91_css', 11 );

function mading_theme_color92_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[92];
	$mading_color92 = get_theme_mod( 'mading_color92', $default_color );

	if ( $mading_color92 === $default_color ) {
		return;
	}

	$css = '
	.mading_gallery {
	     background: %1$s;
    }
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color92 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color92_css', 11 );

function mading_theme_color93_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[93];
	$mading_color93 = get_theme_mod( 'mading_color93', $default_color );

	if ( $mading_color93 === $default_color ) {
		return;
	}

	$css = '
	.gal_layer:after {
	     background: %1$s;
    }
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color93 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color93_css', 11 );

function mading_theme_color94_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[94];
	$mading_color94 = get_theme_mod( 'mading_color94', $default_color );

	if ( $mading_color94 === $default_color ) {
		return;
	}

	$css = '
	.mading_gallery,
	.mading_gallery a {
	     color: %1$s;
    }
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color94 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color94_css', 11 );

function mading_theme_color95_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[95];
	$mading_color95 = get_theme_mod( 'mading_color95', $default_color );

	if ( $mading_color95 === $default_color ) {
		return;
	}

	$css = '
    .home_quotes {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color95 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color95_css', 11 );

function mading_theme_color96_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[96];
	$mading_color96 = get_theme_mod( 'mading_color96', $default_color );

	if ( $mading_color96 === $default_color ) {
		return;
	}

	$css = '
	.home_quotes {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color96 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color96_css', 11 );

function mading_theme_color97_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[97];
	$mading_color97 = get_theme_mod( 'mading_color97', $default_color );

	if ( $mading_color97 === $default_color ) {
		return;
	}

	$css = '
	.home_quotes span {
        color: %1$s;
    }
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color97 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color97_css', 11 );

function mading_theme_color98_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[98];
	$mading_color98 = get_theme_mod( 'mading_color98', $default_color );

	if ( $mading_color98 === $default_color ) {
		return;
	}

	$css = '
	.mading_guru  {
		background: %1$s;
	}
	.guru_info,
	.guru_info a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color98 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color98_css', 11 );

function mading_theme_color99_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[99];
	$mading_color99 = get_theme_mod( 'mading_color99', $default_color );

	if ( $mading_color99 === $default_color ) {
		return;
	}

	$css = '
	.mading_guru  {
		color: %1$s;
	}
	.guru_info {
		background: linear-gradient(rgba(0, 0, 0, 0), %1$s);
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color99 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color99_css', 11 );

function mading_theme_color100_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[100];
	$mading_color100 = get_theme_mod( 'mading_color100', $default_color );

	if ( $mading_color100 === $default_color ) {
		return;
	}

	$css = '
	.mading_guru .title_guru:after {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color100 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color100_css', 11 );

function mading_theme_color101_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[101];
	$mading_color101 = get_theme_mod( 'mading_color101', $default_color );

	if ( $mading_color101 === $default_color ) {
		return;
	}

	$css = '
    .home_videos  {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color101 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color101_css', 11 );

function mading_theme_color102_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[102];
	$mading_color102 = get_theme_mod( 'mading_color102', $default_color );

	if ( $mading_color102 === $default_color ) {
		return;
	}

	$css = '
	.home_videos  {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color102 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color102_css', 11 );

function mading_theme_color103_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[103];
	$mading_color103 = get_theme_mod( 'mading_color103', $default_color );

	if ( $mading_color103 === $default_color ) {
		return;
	}

	$css = '
	.home_videos .title_guru:after {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color103 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color103_css', 11 );

function mading_theme_color104_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[104];
	$mading_color104 = get_theme_mod( 'mading_color104', $default_color );

	if ( $mading_color104 === $default_color ) {
		return;
	}

	$css = '
	.mading_heading,
	.mading_heads,
	.comment_heads,
	.akademi_heading {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color104 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color104_css', 11 );

function mading_theme_color105_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[105];
	$mading_color105 = get_theme_mod( 'mading_color105', $default_color );

	if ( $mading_color105 === $default_color ) {
		return;
	}

	$css = '
	.guru_fullname {
		background: linear-gradient(rgba(0, 0, 0, 0), %1$s);
	}
	.agenda_single:after {
		background: linear-gradient(%1$s, rgba(0, 0, 0, 0));
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color105 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color105_css', 11 );

function mading_theme_color106_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[106];
	$mading_color106 = get_theme_mod( 'mading_color106', $default_color );

	if ( $mading_color106 === $default_color ) {
		return;
	}

	$css = '
	.guru_fullname,
	.guru_info {
		color: %1$s;
	}
	.atime {
		border-left: 1px solid %1$s;
	}
	#event span {
		border-bottom: 1px solid %1$s;
        color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color106 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color106_css', 11 );

function mading_theme_color107_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[107];
	$mading_color107 = get_theme_mod( 'mading_color107', $default_color );

	if ( $mading_color107 === $default_color ) {
		return;
	}

	$css = '
	.agloop,
	.guru_fullname a,
	.guru_info a {
		color: %1$s;
	}
	#event span.event_seconds {
        color: %1$s;
        border-bottom: 1px solid %1$s;
    }
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color107 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color107_css', 11 );

function mading_theme_color108_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[108];
	$mading_color108 = get_theme_mod( 'mading_color108', $default_color );

	if ( $mading_color108 === $default_color ) {
		return;
	}

	$css = '
	.pagination a {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color108 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color108_css', 11 );

function mading_theme_color109_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[109];
	$mading_color109 = get_theme_mod( 'mading_color109', $default_color );

	if ( $mading_color109 === $default_color ) {
		return;
	}

	$css = '
	.pagination a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color109 ) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color109_css', 11 );

function mading_theme_color110_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[110];
	$mading_color110 = get_theme_mod( 'mading_color110', $default_color );

	if ( $mading_color110 === $default_color ) {
		return;
	}

	$css = '
	.pagination a.active {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color110) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color110_css', 11 );

function mading_theme_color111_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[111];
	$mading_color111 = get_theme_mod( 'mading_color111', $default_color );

	if ( $mading_color111 === $default_color ) {
		return;
	}

	$css = '
	.pagination a.active {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color111) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color111_css', 11 );

function mading_theme_color112_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[112];
	$mading_color112 = get_theme_mod( 'mading_color112', $default_color );

	if ( $mading_color112 === $default_color ) {
		return;
	}

	$css = '
	.mad_widget {
        background: %1$s;
    }
	.mad_widget .a_time span,
	.mad_widget .agenda_dt,
	.mad_widget .wp-block-tag-cloud a {
        color: %1$s;
    }
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color112) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color112_css', 11 );

function mading_theme_color113_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[113];
	$mading_color113 = get_theme_mod( 'mading_color113', $default_color );

	if ( $mading_color113 === $default_color ) {
		return;
	}

	$css = '
	.mad_widget {
        color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color113) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color113_css', 11 );

function mading_theme_color114_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[114];
	$mading_color114 = get_theme_mod( 'mading_color114', $default_color );

	if ( $mading_color114 === $default_color ) {
		return;
	}

	$css = '
	.mad_widget a {
        color: %1$s;
	}
	.mad_widget .a_time span,
	.mad_widget .agenda_dt,
	.mad_widget .wp-block-tag-cloud a {
        background: %1$s;
    }
	.mad_widget .a_time span:before {
        border-right: 8px solid %1$s;
	}
	.mad_widget .a_time span:after {
        border-left: 8px solid %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color114) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color114_css', 11 );

function mading_theme_color115_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[115];
	$mading_color115 = get_theme_mod( 'mading_color115', $default_color );

	if ( $mading_color115 === $default_color ) {
		return;
	}

	$css = '
	.layout_mading .to_top,
	.footer {
        background: %1$s;
    }
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color115) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color115_css', 11 );

function mading_theme_color116_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[116];
	$mading_color116 = get_theme_mod( 'mading_color116', $default_color );

	if ( $mading_color116 === $default_color ) {
		return;
	}

	$css = '
	.layout_mading .to_top,
	.footer,
	.footer a {
        color: %1$s;
    }
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color116) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color116_css', 11 );






function mading_theme_color117_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[117];
	$mading_color117 = get_theme_mod( 'mading_color117', $default_color );

	if ( $mading_color117 === $default_color ) {
		return;
	}

	$css = '
	.aka__nav,
	.aka__header,
	.form__akasearch,
	.form__akasearch #searchform,
	.aka__select select,
	.aka__input input,
	.aka__logoblock,
	.aka__nav .newnav.nav-mobile {
        background: %1$s;
    }
	.aka__button button,
	.aka__menu,
	.aka__menusearch {
		color: %1$s;
	}
	.aka__nav .newnav.nav-desktop .accordion li:first-child a  {
		color: %1$s;
	}
	.aka__nav .newnav.nav-desktop .accordion li:nth-child(2) a  {
		background: %1$s;
	}
	.aka__nav .newnav.nav-desktop .accordion li.menu-item-has-children:first-child:after {
		color: %1$s;
	}
	@media screen and (max-width: 982px) {
		.aka__header,
		.aka__menu:after {
            background:  %1$s;
        }
    }
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color117) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color117_css', 11 );

function mading_theme_color118_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[118];
	$mading_color118 = get_theme_mod( 'mading_color118', $default_color );

	if ( $mading_color118 === $default_color ) {
		return;
	}

	$css = '
	.aka__menu,
	.aka__search,
	.aka__menu:before,
	.aka__menusearch {
		background: %1$s;
	}
	.form__akasearch {
		border: 1px solid %1$s;
	}
	.aka__button button,
	.aka__nav .newnav.nav-desktop .accordion li:first-child a  {
		background: %1$s;
	}
	.aka__nav .newnav.nav-desktop .accordion li:nth-child(2) {
		background: %1$s;
	}
	.aka__nav .newnav.nav-desktop .accordion li:nth-child(2) a  {
		color: %1$s;
	}
	.aka__nav {
		border-color: %1$s;
	}
	.aka__nav .newnav.nav-desktop .accordion li.menu-item-has-children:after {
		color: %1$s;
	}
	.aka__select select,
	.aka__input input,
	.aka__sos .number a,
	.aka__nav .newnav.nav-desktop .accordion li a {
		color: %1$s;
	}
	@media screen and (max-width: 982px) {
		.aka_ticker .mad_today {
            color:  %1$s !important;
        }
		.form__akasearch:before {
            background: %1$s !important;
        }
    }
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color118) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color118_css', 11 );

function mading_theme_color119_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[119];
	$mading_color119 = get_theme_mod( 'mading_color119', $default_color );

	if ( $mading_color119 === $default_color ) {
		return;
	}

	$css = '
	.aka__nav .newnav.nav-desktop .accordion li .sub-menu {
		background: %1$s !important;
	}
	.aka__nav .newnav.nav-desktop .accordion li a span {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color119) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color119_css', 11 );

function mading_theme_color120_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[120];
	$mading_color120 = get_theme_mod( 'mading_color120', $default_color );

	if ( $mading_color120 === $default_color ) {
		return;
	}

	$css = '
	.aka__nav .newnav.nav-desktop .accordion li .sub-menu li a,
	.aka__nav .newnav.nav-desktop .accordion li .sub-menu li.menu-item-has-children:after {
		color: %1$s !important;
	}
	.aka__nav .newnav.nav-desktop .accordion li a span {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color120) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color120_css', 11 );


function mading_theme_color121_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[121];
	$mading_color121 = get_theme_mod( 'mading_color121', $default_color );

	if ( $mading_color121 === $default_color ) {
		return;
	}

	$css = '
	.aka_ticker,
	.aka_ticker .re_info,
	.aka_ticker .mad_today {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color121) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color121_css', 11 );

function mading_theme_color122_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[122];
	$mading_color122 = get_theme_mod( 'mading_color122', $default_color );

	if ( $mading_color122 === $default_color ) {
		return;
	}

	$css = '
	.aka_ticker,
	.aka_ticker .mad_today {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color122) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color122_css', 11 );

function mading_theme_color123_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[123];
	$mading_color123 = get_theme_mod( 'mading_color123', $default_color );

	if ( $mading_color123 === $default_color ) {
		return;
	}

	$css = '
	.aka_ticker a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color123) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color123_css', 11 );

function mading_theme_color124_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[124];
	$mading_color124 = get_theme_mod( 'mading_color124', $default_color );

	if ( $mading_color124 === $default_color ) {
		return;
	}

	$css = '
	.aka__school {
		background: %1$s;
	}
	.aka__school #hours {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color124) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color124_css', 11 );

function mading_theme_color125_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[125];
	$mading_color125 = get_theme_mod( 'mading_color125', $default_color );

	if ( $mading_color125 === $default_color ) {
		return;
	}

	$css = '
	.aka__school {
		color: %1$s;
	}
	.aka__school #hours {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color125) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color125_css', 11 );

function mading_theme_color126_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[126];
	$mading_color126 = get_theme_mod( 'mading_color126', $default_color );

	if ( $mading_color126 === $default_color ) {
		return;
	}

	$css = '
	.aka__top {
		background: %1$s;
	}
	.edit__torial {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color126) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color126_css', 11 );

function mading_theme_color127_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[127];
	$mading_color127 = get_theme_mod( 'mading_color127', $default_color );

	if ( $mading_color127 === $default_color ) {
		return;
	}

	$css = '
	.aka__top,
	.aka__top a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color127) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color127_css', 11 );

function mading_theme_color128_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[128];
	$mading_color128 = get_theme_mod( 'mading_color128', $default_color );

	if ( $mading_color128 === $default_color ) {
		return;
	}

	$css = '
	.edit__torial {
		background: %1$s;
	}
	.quotes__post i {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color128) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color128_css', 11 );

function mading_theme_color129_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[129];
	$mading_color129 = get_theme_mod( 'mading_color129', $default_color );

	if ( $mading_color129 === $default_color ) {
		return;
	}

	$css = '
	.news_overlay {
		background-image: linear-gradient(rgba(0, 0, 0, 0), %1$s);
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color129) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color129_css', 11 );

function mading_theme_color130_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[130];
	$mading_color130 = get_theme_mod( 'mading_color130', $default_color );

	if ( $mading_color130 === $default_color ) {
		return;
	}

	$css = '
	.news_overlay {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color130) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color130_css', 11 );

function mading_theme_color131_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[131];
	$mading_color131 = get_theme_mod( 'mading_color131', $default_color );

	if ( $mading_color131 === $default_color ) {
		return;
	}

	$css = '
	.news h4 a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color131) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color131_css', 11 );

function mading_theme_color132_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[132];
	$mading_color132 = get_theme_mod( 'mading_color132', $default_color );

	if ( $mading_color132 === $default_color ) {
		return;
	}

	$css = '
	.top_news {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color132) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color132_css', 11 );

function mading_theme_color133_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[133];
	$mading_color133 = get_theme_mod( 'mading_color133', $default_color );

	if ( $mading_color133 === $default_color ) {
		return;
	}

	$css = '
	.top_news {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color133) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color133_css', 11 );

function mading_theme_color134_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[134];
	$mading_color134 = get_theme_mod( 'mading_color134', $default_color );

	if ( $mading_color134 === $default_color ) {
		return;
	}

	$css = '
	.agenda_box,
	.agenda_box .instar {
		background: %1$s;
	}
	.agenda_box .star,
	.agenda_box .eventdate,
	.agenda_box .eventmonth {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color134) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color134_css', 11 );

function mading_theme_color135_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[135];
	$mading_color135 = get_theme_mod( 'mading_color135', $default_color );

	if ( $mading_color135 === $default_color ) {
		return;
	}

	$css = '
	.agenda_box,
	.agenda_box .age_inner a {
		color: %1$s;
	}
	.agenda_box .eventmonth {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color135) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color135_css', 11 );

function mading_theme_color136_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[136];
	$mading_color136 = get_theme_mod( 'mading_color136', $default_color );

	if ( $mading_color136 === $default_color ) {
		return;
	}

	$css = '
	.agenda_box {
		border-top: 4px solid %1$s;
	}
	.agenda_box .star,
	.agenda_box .eventdate,
	.agenda_box .afstar {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color136) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color136_css', 11 );

function mading_theme_color137_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[137];
	$mading_color137 = get_theme_mod( 'mading_color137', $default_color );

	if ( $mading_color137 === $default_color ) {
		return;
	}

	$css = '
	.guru_block {
		background: %1$s;
	}
	.guru_block .guru_pro a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color137) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color137_css', 11 );

function mading_theme_color138_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[138];
	$mading_color138 = get_theme_mod( 'mading_color138', $default_color );

	if ( $mading_color138 === $default_color ) {
		return;
	}

	$css = '
	.guru_block {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color138) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color138_css', 11 );

function mading_theme_color139_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[139];
	$mading_color139 = get_theme_mod( 'mading_color139', $default_color );

	if ( $mading_color139 === $default_color ) {
		return;
	}

	$css = '
	.guru_block span a {
		color: %1$s;
	}
	.guru_block .guru_pro a {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color139) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color139_css', 11 );

function mading_theme_color140_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[140];
	$mading_color140 = get_theme_mod( 'mading_color140', $default_color );

	if ( $mading_color140 === $default_color ) {
		return;
	}

	$css = '
	.fasilitas_box {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color140) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color140_css', 11 );

function mading_theme_color141_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[141];
	$mading_color141 = get_theme_mod( 'mading_color141', $default_color );

	if ( $mading_color141 === $default_color ) {
		return;
	}

	$css = '
	.fas_head {
		background: %1$s;
	}
	.fasilitas_box {
		border-bottom: 4px solid %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color141) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color141_css', 11 );

function mading_theme_color142_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[142];
	$mading_color142 = get_theme_mod( 'mading_color142', $default_color );

	if ( $mading_color142 === $default_color ) {
		return;
	}

	$css = '
	.fas_head {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color142) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color142_css', 11 );

function mading_theme_color143_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[143];
	$mading_color143 = get_theme_mod( 'mading_color143', $default_color );

	if ( $mading_color143 === $default_color ) {
		return;
	}

	$css = '
	.peng_box {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color143) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color143_css', 11 );

function mading_theme_color144_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[144];
	$mading_color144 = get_theme_mod( 'mading_color144', $default_color );

	if ( $mading_color144 === $default_color ) {
		return;
	}

	$css = '
	.peng_box {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color144) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color144_css', 11 );

function mading_theme_color145_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[145];
	$mading_color145 = get_theme_mod( 'mading_color145', $default_color );

	if ( $mading_color145 === $default_color ) {
		return;
	}

	$css = '
	.peng_box a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color145) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color145_css', 11 );

function mading_theme_color146_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[146];
	$mading_color146 = get_theme_mod( 'mading_color146', $default_color );

	if ( $mading_color146 === $default_color ) {
		return;
	}

	$css = '
	.peng_post h3 {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color146) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color146_css', 11 );

function mading_theme_color147_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[147];
	$mading_color147 = get_theme_mod( 'mading_color147', $default_color );

	if ( $mading_color147 === $default_color ) {
		return;
	}

	$css = '
	.peng_post h3 {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color147) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color147_css', 11 );

function mading_theme_color148_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[148];
	$mading_color148 = get_theme_mod( 'mading_color148', $default_color );

	if ( $mading_color148 === $default_color ) {
		return;
	}

	$css = '
	.blog_gurus {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color148) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color148_css', 11 );

function mading_theme_color149_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[149];
	$mading_color149 = get_theme_mod( 'mading_color149', $default_color );

	if ( $mading_color149 === $default_color ) {
		return;
	}

	$css = '
	.blog_gurus {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color149) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color149_css', 11 );

function mading_theme_color150_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[150];
	$mading_color150 = get_theme_mod( 'mading_color150', $default_color );

	if ( $mading_color150 === $default_color ) {
		return;
	}

	$css = '
	.blog_gurus a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color150) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color150_css', 11 );

function mading_theme_color151_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[151];
	$mading_color151 = get_theme_mod( 'mading_color151', $default_color );

	if ( $mading_color151 === $default_color ) {
		return;
	}

	$css = '
	.blog_gurus h4 {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color151) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color151_css', 11 );

function mading_theme_color152_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[152];
	$mading_color152 = get_theme_mod( 'mading_color152', $default_color );

	if ( $mading_color152 === $default_color ) {
		return;
	}

	$css = '
	.blog_gurus h4 {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color152) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color152_css', 11 );

function mading_theme_color153_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[153];
	$mading_color153 = get_theme_mod( 'mading_color153', $default_color );

	if ( $mading_color153 === $default_color ) {
		return;
	}

	$css = '
	.prestasi_box {
		background: %1$s;
	}
	.prestasi_box .star {
		color: %1$s;
	}
	.prestasi_box .instar {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color153) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color153_css', 11 );

function mading_theme_color154_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[154];
	$mading_color154 = get_theme_mod( 'mading_color154', $default_color );

	if ( $mading_color154 === $default_color ) {
		return;
	}

	$css = '
	.prestasi_box {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color154) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color154_css', 11 );

function mading_theme_color155_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[155];
	$mading_color155 = get_theme_mod( 'mading_color155', $default_color );

	if ( $mading_color155 === $default_color ) {
		return;
	}

	$css = '
	.prestasi_box {
		border-top: 4px solid %1$s;
		border-bottom: 4px solid %1$s;
	}
	.prestasi_box .star,
	.prestasi_box .afstar {
		background: %1$s;
	}
	.prestasi_box a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color155) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color155_css', 11 );

function mading_theme_color156_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[156];
	$mading_color156 = get_theme_mod( 'mading_color156', $default_color );

	if ( $mading_color156 === $default_color ) {
		return;
	}

	$css = '
	.ekskul_box {
		background: %1$s;
	}
	.ekskul_box .star {
		color: %1$s;
	}
	.ekskul_box .instar {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color156) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color156_css', 11 );

function mading_theme_color157_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[157];
	$mading_color157 = get_theme_mod( 'mading_color157', $default_color );

	if ( $mading_color157 === $default_color ) {
		return;
	}

	$css = '
	.ekskul_box,
	.ekskul_box span a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color157) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color157_css', 11 );

function mading_theme_color158_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[158];
	$mading_color158 = get_theme_mod( 'mading_color158', $default_color );

	if ( $mading_color158 === $default_color ) {
		return;
	}

	$css = '
	.ekskul_box {
		border-top: 4px solid %1$s;
		border-bottom: 4px solid %1$s;
	}
	.ekskul_box .star,
	.ekskul_box .afstar {
		background: %1$s;
	}
	.ekskul_box a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color158) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color158_css', 11 );

function mading_theme_color159_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[159];
	$mading_color159 = get_theme_mod( 'mading_color159', $default_color );

	if ( $mading_color159 === $default_color ) {
		return;
	}

	$css = '
	.gall_box {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color159) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color159_css', 11 );

function mading_theme_color160_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[160];
	$mading_color160 = get_theme_mod( 'mading_color160', $default_color );

	if ( $mading_color160 === $default_color ) {
		return;
	}

	$css = '
	.gall_head {
		background: %1$s;
	}
	.gall_box {
		border-bottom: 4px solid %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color160) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color160_css', 11 );

function mading_theme_color161_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[161];
	$mading_color161 = get_theme_mod( 'mading_color161', $default_color );

	if ( $mading_color161 === $default_color ) {
		return;
	}

	$css = '
	.gall_head {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color161) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color161_css', 11 );

function mading_theme_color162_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[162];
	$mading_color162 = get_theme_mod( 'mading_color162', $default_color );

	if ( $mading_color162 === $default_color ) {
		return;
	}

	$css = '
	.akavideo_box {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color162) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color162_css', 11 );

function mading_theme_color163_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[163];
	$mading_color163 = get_theme_mod( 'mading_color163', $default_color );

	if ( $mading_color163 === $default_color ) {
		return;
	}

	$css = '
	.vid_gall {
		background: %1$s;
	}
	.akavideo_box {
		border-bottom: 4px solid %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color163) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color163_css', 11 );

function mading_theme_color164_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[164];
	$mading_color164 = get_theme_mod( 'mading_color164', $default_color );

	if ( $mading_color164 === $default_color ) {
		return;
	}

	$css = '
	.vid_gall {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color164) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color164_css', 11 );

function mading_theme_color165_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[165];
	$mading_color165 = get_theme_mod( 'mading_color165', $default_color );

	if ( $mading_color165 === $default_color ) {
		return;
	}

	$css = '
	.akademi_bread {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color165) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color165_css', 11 );

function mading_theme_color166_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[166];
	$mading_color166 = get_theme_mod( 'mading_color166', $default_color );

	if ( $mading_color166 === $default_color ) {
		return;
	}

	$css = '
	.akademi_bread {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color166) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color166_css', 11 );

function mading_theme_color167_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[167];
	$mading_color167 = get_theme_mod( 'mading_color167', $default_color );

	if ( $mading_color167 === $default_color ) {
		return;
	}

	$css = '
	.akademi_bread a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color167) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color167_css', 11 );

function mading_theme_color168_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[168];
	$mading_color168 = get_theme_mod( 'mading_color168', $default_color );

	if ( $mading_color168 === $default_color ) {
		return;
	}

	$css = '
	#sidebar .widget_block {
		background:  %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color168) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color168_css', 11 );

function mading_theme_color169_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[169];
	$mading_color169 = get_theme_mod( 'mading_color169', $default_color );

	if ( $mading_color169 === $default_color ) {
		return;
	}

	$css = '
	#sidebar .widget_block {
		color:  %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color169) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color169_css', 11 );


function mading_theme_color170_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[170];
	$mading_color170 = get_theme_mod( 'mading_color170', $default_color );

	if ( $mading_color170 === $default_color ) {
		return;
	}

	$css = '
	#sidebar .widget_block a {
		color:  %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color170) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color170_css', 11 );

function mading_theme_color171_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[171];
	$mading_color171 = get_theme_mod( 'mading_color171', $default_color );

	if ( $mading_color171 === $default_color ) {
		return;
	}

	$css = '
	.press_top {
		background:  %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color171) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color171_css', 11 );

function mading_theme_color172_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[172];
	$mading_color172 = get_theme_mod( 'mading_color172', $default_color );

	if ( $mading_color172 === $default_color ) {
		return;
	}

	$css = '
	.press_top {
		color:  %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color172) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color172_css', 11 );

function mading_theme_color173_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[173];
	$mading_color173 = get_theme_mod( 'mading_color173', $default_color );

	if ( $mading_color173 === $default_color ) {
		return;
	}

	$css = '
	.press_search,
	.ps_input input,
	.ps_select select {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color173) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color173_css', 11 );

function mading_theme_color174_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[174];
	$mading_color174 = get_theme_mod( 'mading_color174', $default_color );

	if ( $mading_color174 === $default_color ) {
		return;
	}

	$css = '
	.press_search,
	.ps_input input,
	.ps_select select {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color174) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color174_css', 11 );

function mading_theme_color175_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[175];
	$mading_color175 = get_theme_mod( 'mading_color175', $default_color );

	if ( $mading_color175 === $default_color ) {
		return;
	}

	$css = '
	.ps_button button {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color175) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color175_css', 11 );

function mading_theme_color176_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[176];
	$mading_color176 = get_theme_mod( 'mading_color176', $default_color );

	if ( $mading_color176 === $default_color ) {
		return;
	}

	$css = '
	.ps_button button {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color176) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color176_css', 11 );

function mading_theme_color177_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[177];
	$mading_color177 = get_theme_mod( 'mading_color177', $default_color );

	if ( $mading_color177 === $default_color ) {
		return;
	}

	$css = '
	.press_head,
	.press_head .site-header-menu {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color177) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color177_css', 11 );

function mading_theme_color178_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[178];
	$mading_color178 = get_theme_mod( 'mading_color178', $default_color );

	if ( $mading_color178 === $default_color ) {
		return;
	}

	$css = '
	.press_head .newnav .accordion li a,
	.press_head .newnav .accordion li.menu-item-has-children:after {
		color:  %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color178) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color178_css', 11 );

function mading_theme_color179_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[179];
	$mading_color179 = get_theme_mod( 'mading_color179', $default_color );

	if ( $mading_color179 === $default_color ) {
		return;
	}

	$css = '
	.press_head .newnav .accordion li a span {
		background:  %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color179) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color179_css', 11 );

function mading_theme_color180_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[180];
	$mading_color180 = get_theme_mod( 'mading_color180', $default_color );

	if ( $mading_color180 === $default_color ) {
		return;
	}

	$css = '
	.press_head .newnav .accordion li a span,
	.closemenu {
		color:  %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color180) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color180_css', 11 );

function mading_theme_color181_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[181];
	$mading_color181 = get_theme_mod( 'mading_color181', $default_color );

	if ( $mading_color181 === $default_color ) {
		return;
	}

	$css = '
	.press_head .newnav .accordion li ul {
		background:  %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color181) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color181_css', 11 );

function mading_theme_color182_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[182];
	$mading_color182 = get_theme_mod( 'mading_color182', $default_color );

	if ( $mading_color182 === $default_color ) {
		return;
	}

	$css = '
	.press_head .newnav .accordion li ul li a,
	.press_head .newnav .accordion li ul li.menu-item-has-children:after {
		color:  %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color182) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color182_css', 11 );

function mading_theme_color183_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[183];
	$mading_color183 = get_theme_mod( 'mading_color183', $default_color );

	if ( $mading_color183 === $default_color ) {
		return;
	}

	$css = '
	.press_head .newnav .accordion li ul a:hover {
        background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color183) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color183_css', 11 );

function mading_theme_color184_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[184];
	$mading_color184 = get_theme_mod( 'mading_color184', $default_color );

	if ( $mading_color184 === $default_color ) {
		return;
	}

	$css = '
	.press_head .newnav .accordion li ul a:hover,
	.press_head .newnav .accordion li ul li.menu-item-has-children:hover:after {
        color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color184) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color184_css', 11 );

function mading_theme_color185_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[185];
	$mading_color185 = get_theme_mod( 'mading_color185', $default_color );

	if ( $mading_color185 === $default_color ) {
		return;
	}

	$css = '
	.press_content {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color185) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color185_css', 11 );

function mading_theme_color186_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[186];
	$mading_color186 = get_theme_mod( 'mading_color186', $default_color );

	if ( $mading_color186 === $default_color ) {
		return;
	}

	$css = '
	.press_infosekolah,
	.info_box h3 span.re_info {
		background: %1$s;
	}
	.opentoggle:before {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color186) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color186_css', 11 );

function mading_theme_color187_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[187];
	$mading_color187 = get_theme_mod( 'mading_color187', $default_color );

	if ( $mading_color187 === $default_color ) {
		return;
	}

	$css = '
	.press_infosekolah,
	.layout_prestasi .con_box .phone,
	.press_infosekolah .number a {
		color: %1$s;
	}
	.info_box h3 span.re_info {
		color: %1$s;
		border: 2px solid %1$s;
	}
	.info_box h1:after,
	.opentoggle:before,
	.school_box:after,
	.press_infosekolah:after {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color187) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color187_css', 11 );

function mading_theme_color188_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[188];
	$mading_color188 = get_theme_mod( 'mading_color188', $default_color );

	if ( $mading_color188 === $default_color ) {
		return;
	}

	$css = '
	.press_sosial i {
		background:  %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color188) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color188_css', 11 );

function mading_theme_color189_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[189];
	$mading_color189 = get_theme_mod( 'mading_color189', $default_color );

	if ( $mading_color189 === $default_color ) {
		return;
	}

	$css = '
	.press_sosial i {
		color:  %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color189) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color189_css', 11 );

function mading_theme_color190_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[190];
	$mading_color190 = get_theme_mod( 'mading_color190', $default_color );

	if ( $mading_color190 === $default_color ) {
		return;
	}

	$css = '
	.presshome_agenda {
		background:  %1$s;
	}
	.near_agenda h3 span.re_agenda {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color190) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color190_css', 11 );

function mading_theme_color191_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[191];
	$mading_color191 = get_theme_mod( 'mading_color191', $default_color );

	if ( $mading_color191 === $default_color ) {
		return;
	}

	$css = '
	.presshome_agenda {
		color:  %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color191) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color191_css', 11 );

function mading_theme_color192_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[192];
	$mading_color192 = get_theme_mod( 'mading_color192', $default_color );

	if ( $mading_color192 === $default_color ) {
		return;
	}

	$css = '
	.presshome_agenda a {
		color:  %1$s;
	}
	.foot_agenda a:after {
		background:  %1$s;
	}
	.near_agenda h3 span.re_agenda {
		background: %1$s;
		border: solid 2px %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color192) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color192_css', 11 );

function mading_theme_color193_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[193];
	$mading_color193 = get_theme_mod( 'mading_color193', $default_color );

	if ( $mading_color193 === $default_color ) {
		return;
	}

	$css = '
	.post_meta {
        background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color193) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color193_css', 11 );

function mading_theme_color194_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[194];
	$mading_color194 = get_theme_mod( 'mading_color194', $default_color );

	if ( $mading_color194 === $default_color ) {
		return;
	}

	$css = '
	.post_meta,
	.post_meta h4 a {
        color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color194) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color194_css', 11 );

function mading_theme_color195_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[195];
	$mading_color195 = get_theme_mod( 'mading_color195', $default_color );

	if ( $mading_color195 === $default_color ) {
		return;
	}

	$css = '
	.post_meta span {
        color: %1$s;
        border: solid 2px %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color195) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color195_css', 11 );

function mading_theme_color196_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[196];
	$mading_color196 = get_theme_mod( 'mading_color196', $default_color );

	if ( $mading_color196 === $default_color ) {
		return;
	}

	$css = '
	.announ_home {
		background: %1$s;
	}
	.announ_post h3 span {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color196) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color196_css', 11 );

function mading_theme_color197_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[197];
	$mading_color197 = get_theme_mod( 'mading_color197', $default_color );

	if ( $mading_color197 === $default_color ) {
		return;
	}

	$css = '
	.announ_home {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color197) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color197_css', 11 );

function mading_theme_color198_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[198];
	$mading_color198 = get_theme_mod( 'mading_color198', $default_color );

	if ( $mading_color198 === $default_color ) {
		return;
	}

	$css = '
	.announ_home a {
		color:  %1$s;
	}
	.announ_post h3 span {
		background: %1$s;
        border: solid 2px %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color198) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color198_css', 11 );

function mading_theme_color199_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[199];
	$mading_color199 = get_theme_mod( 'mading_color199', $default_color );

	if ( $mading_color199 === $default_color ) {
		return;
	}

	$css = '
	.press_boxquote {
		background:  %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color199) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color199_css', 11 );

function mading_theme_color200_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[200];
	$mading_color200 = get_theme_mod( 'mading_color200', $default_color );

	if ( $mading_color200 === $default_color ) {
		return;
	}

	$css = '
	.press_boxquote {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color200) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color200_css', 11 );

function mading_theme_color201_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[201];
	$mading_color201 = get_theme_mod( 'mading_color201', $default_color );

	if ( $mading_color201 === $default_color ) {
		return;
	}

	$css = '
	#personelblock {
		background:  %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color201) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color201_css', 11 );

function mading_theme_color202_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[202];
	$mading_color202 = get_theme_mod( 'mading_color202', $default_color );

	if ( $mading_color202 === $default_color ) {
		return;
	}

	$css = '
	.head_datas {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color202) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color202_css', 11 );

function mading_theme_color203_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[203];
	$mading_color203 = get_theme_mod( 'mading_color203', $default_color );

	if ( $mading_color203 === $default_color ) {
		return;
	}

	$css = '
	.head_datas {
        color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color203) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color203_css', 11 );

function mading_theme_color204_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[204];
	$mading_color204 = get_theme_mod( 'mading_color204', $default_color );

	if ( $mading_color204 === $default_color ) {
		return;
	}

	$css = '
	.editorial_more a {
        color: %1$s;
        border: solid 2px %1$s;
	}
	.head_datas .re_kepala {
        color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color204) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color204_css', 11 );

function mading_theme_color205_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[205];
	$mading_color205 = get_theme_mod( 'mading_color205', $default_color );

	if ( $mading_color205 === $default_color ) {
		return;
	}

	$css = '
	.pressguru_info {
        background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color205) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color205_css', 11 );

function mading_theme_color206_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[206];
	$mading_color206 = get_theme_mod( 'mading_color206', $default_color );

	if ( $mading_color206 === $default_color ) {
		return;
	}

	$css = '
	.pressguru_info {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color206) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color206_css', 11 );

function mading_theme_color207_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[207];
	$mading_color207 = get_theme_mod( 'mading_color207', $default_color );

	if ( $mading_color207 === $default_color ) {
		return;
	}

	$css = '
	.pressguru_info a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color207) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color207_css', 11 );

function mading_theme_color208_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[208];
	$mading_color208 = get_theme_mod( 'mading_color208', $default_color );

	if ( $mading_color208 === $default_color ) {
		return;
	}

	$css = '
	#anotherblock {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color208) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color208_css', 11 );

function mading_theme_color209_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[209];
	$mading_color209 = get_theme_mod( 'mading_color209', $default_color );

	if ( $mading_color209 === $default_color ) {
		return;
	}

	$css = '
	.blog_box h3 span.re_blog {
        color: %1$s;
		border: solid 2px %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color209) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color209_css', 11 );

function mading_theme_color210_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[210];
	$mading_color210 = get_theme_mod( 'mading_color210', $default_color );

	if ( $mading_color210 === $default_color ) {
		return;
	}

	$css = '
	.blog_in {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color210) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color210_css', 11 );

function mading_theme_color211_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[211];
	$mading_color211 = get_theme_mod( 'mading_color211', $default_color );

	if ( $mading_color211 === $default_color ) {
		return;
	}

	$css = '
	.blog_in {
		color:  %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color211) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color211_css', 11 );

function mading_theme_color212_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[212];
	$mading_color212 = get_theme_mod( 'mading_color212', $default_color );

	if ( $mading_color212 === $default_color ) {
		return;
	}

	$css = '
	.blog_in a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color212) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color212_css', 11 );

function mading_theme_color213_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[213];
	$mading_color213 = get_theme_mod( 'mading_color213', $default_color );

	if ( $mading_color213 === $default_color ) {
		return;
	}

	$css = '
	.bot_head {
        color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color213) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color213_css', 11 );

function mading_theme_color214_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[214];
	$mading_color214 = get_theme_mod( 'mading_color214', $default_color );

	if ( $mading_color214 === $default_color ) {
		return;
	}

	$css = '
	.box_extra {
        background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color214) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color214_css', 11 );

function mading_theme_color215_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[215];
	$mading_color215 = get_theme_mod( 'mading_color215', $default_color );

	if ( $mading_color215 === $default_color ) {
		return;
	}

	$css = '
	.box_extra {
        color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color215) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color215_css', 11 );

function mading_theme_color216_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[216];
	$mading_color216 = get_theme_mod( 'mading_color216', $default_color );

	if ( $mading_color216 === $default_color ) {
		return;
	}

	$css = '
	.extra_text span.re_lihat {
		color: %1$s;
		border:  2px solid %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color216) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color216_css', 11 );

function mading_theme_color217_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[217];
	$mading_color217 = get_theme_mod( 'mading_color217', $default_color );

	if ( $mading_color217 === $default_color ) {
		return;
	}

	$css = '
	#lastblock {
		background: %1$s;
	}
	.pressvideo.owl-theme .owl-nav [class*="owl-"] {
        color: %1$s !important;
    }
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color217) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color217_css', 11 );

function mading_theme_color218_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[218];
	$mading_color218 = get_theme_mod( 'mading_color218', $default_color );

	if ( $mading_color218 === $default_color ) {
		return;
	}

	$css = '
	#lastblock {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color218) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color218_css', 11 );

function mading_theme_color219_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[219];
	$mading_color219 = get_theme_mod( 'mading_color219', $default_color );

	if ( $mading_color219 === $default_color ) {
		return;
	}

	$css = '
	.pressvideo.owl-theme .owl-nav,
	.pressvideo.owl-theme .owl-nav [class*="owl-"] {
        background: %1$s !important;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color219) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color219_css', 11 );

function mading_theme_color220_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[220];
	$mading_color220 = get_theme_mod( 'mading_color220', $default_color );

	if ( $mading_color220 === $default_color ) {
		return;
	}

	$css = '
	.press_page:before,
	.press_eventdate,
	.press_cat a {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color220) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color220_css', 11 );

function mading_theme_color221_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[221];
	$mading_color221 = get_theme_mod( 'mading_color221', $default_color );

	if ( $mading_color221 === $default_color ) {
		return;
	}

	$css = '
	.press_page h1,
	.press_eventdate,
	.press_cat a,
	.bread_in .press_sub {
		color:  %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color221) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color221_css', 11 );

function mading_theme_color222_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[222];
	$mading_color222 = get_theme_mod( 'mading_color222', $default_color );

	if ( $mading_color222 === $default_color ) {
		return;
	}

	$css = '
	.press_in,
	.press_inpublish {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color222) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color222_css', 11 );

function mading_theme_color223_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[223];
	$mading_color223 = get_theme_mod( 'mading_color223', $default_color );

	if ( $mading_color223 === $default_color ) {
		return;
	}

	$css = '
	.press_inmeta h2 a {
        color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color223) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color223_css', 11 );

function mading_theme_color224_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[224];
	$mading_color224 = get_theme_mod( 'mading_color224', $default_color );

	if ( $mading_color224 === $default_color ) {
		return;
	}

	$css = '
	.press_inexcerpt,
	.press_inpublish {
        color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color224) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color224_css', 11 );

function mading_theme_color225_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[225];
	$mading_color225 = get_theme_mod( 'mading_color225', $default_color );

	if ( $mading_color225 === $default_color ) {
		return;
	}

	$css = '
	.ntext,
	.five_block i {
        color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color225) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color225_css', 11 );

function mading_theme_color226_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[226];
	$mading_color226 = get_theme_mod( 'mading_color226', $default_color );

	if ( $mading_color226 === $default_color ) {
		return;
	}

	$css = '
	.nhome {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color226) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color226_css', 11 );

function mading_theme_color227_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[227];
	$mading_color227 = get_theme_mod( 'mading_color227', $default_color );

	if ( $mading_color227 === $default_color ) {
		return;
	}

	$css = '
	.nphone {
        background: %1$s;
    }
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color227) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color227_css', 11 );

function mading_theme_color228_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[228];
	$mading_color228 = get_theme_mod( 'mading_color228', $default_color );

	if ( $mading_color228 === $default_color ) {
		return;
	}

	$css = '
	.nemail {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color228) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color228_css', 11 );

function mading_theme_color229_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[229];
	$mading_color229 = get_theme_mod( 'mading_color229', $default_color );

	if ( $mading_color229 === $default_color ) {
		return;
	}

	$css = '
	.nwa {
        background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color229) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color229_css', 11 );

function mading_theme_color230_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[230];
	$mading_color230 = get_theme_mod( 'mading_color230', $default_color );

	if ( $mading_color230 === $default_color ) {
		return;
	}

	$css = '
	.nreturn {
        background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color230) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color230_css', 11 );

function mading_theme_color231_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[231];
	$mading_color231 = get_theme_mod( 'mading_color231', $default_color );

	if ( $mading_color231 === $default_color ) {
		return;
	}

	$css = '
	.mad_presblock {
        background: %1$s;
	}
	.mad_presblock .pres_button a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color231) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color231_css', 11 );

function mading_theme_color232_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[232];
	$mading_color232 = get_theme_mod( 'mading_color232', $default_color );

	if ( $mading_color232 === $default_color ) {
		return;
	}

	$css = '
	.mad_presblock {
        color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color232) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color232_css', 11 );

function mading_theme_color233_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[233];
	$mading_color233 = get_theme_mod( 'mading_color233', $default_color );

	if ( $mading_color233 === $default_color ) {
		return;
	}

	$css = '
	.mad_presblock a {
        color: %1$s;
	}
	.mad_presblock .pres_button a {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mading_color233) );
}
add_action( 'wp_enqueue_scripts', 'mading_theme_color233_css', 11 );

require get_template_directory() . '/include/magazine/color-inline-css.php';
require get_template_directory() . '/include/awesome/color-inline-css.php';