<?php

function mading_customize_register( $wp_customize ) {
include("google-font.php");
$wp_customize->add_panel('mading_profile',array(
    'title'       => __('Mading : Setting', 'mading'),
    'description' => __('Setting for Mading theme', 'mading'),
    'priority'    => 40,
));

$wp_customize->add_section('mading_editor',array(
    'title'       => __('Default Editor', 'mading'),
    'description' => __('choose editor that comfortable for writing', 'mading'),
    'priority'    => 10,
    'panel'       => 'mading_profile',
));

// Nama Usaha
$wp_customize->add_setting('opsi_editor',array(
    'default'     => 'true',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('opsi_editor',array(
    'label'        => __('Select Editor', 'mading'),
    'type'         => 'select',
	'choices'     => array(
		'true'      => __( 'Gutenberg (Editor Block)', 'mading' ),
		'false'     => __( 'Classic Editor (Mode WYSIWYG)', 'mading' ),
	),
    'section'      => 'mading_editor',
    'settings'     => 'opsi_editor',
));

$wp_customize->add_section('profile_sekolah',array(
    'title'       => __('School Profile', 'mading'),
    'description' => __('complete data for school profile', 'mading'),
    'priority'    => 10,
    'panel'       => 'mading_profile',
));

// Nama Usaha
$wp_customize->add_setting('sekolah_type',array(
    'default'     => 'sekolah',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('sekolah_type',array(
    'label'        => __('Category of School', 'mading'),
	'description'  => __('IMPORTANT : Update Permalink after change category of school to fix 404 error' ,'mading'),
    'type'         => 'select',
	'choices'     => array(
		'sekolah'      => __( 'Umum, Madrasah, Kejuruan', 'mading' ),
		'pesantren'    => __( 'Pesantren', 'mading' ),
		'akademi'      => __( 'Sekolah Tinggi', 'mading' ),
	),
    'section'      => 'profile_sekolah',
    'settings'     => 'sekolah_type',
));
$wp_customize->add_setting('mad__schoolname',array(
    'default'     => 'SMA Negeri 1 Comal',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('mad__schoolname',array(
    'label'        => __('School Name', 'mading'),
    'type'         => 'text',
    'section'      => 'profile_sekolah',
    'settings'     => 'mad__schoolname',
));
$wp_customize->add_setting('kepala_sekolah',array(
    'default'     => 'Yayun Ciuss',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('kepala_sekolah',array(
    'label'        => __('Headmaster Name', 'mading'),
    'type'         => 'text',
    'section'      => 'profile_sekolah',
    'settings'     => 'kepala_sekolah',
));
// Foto Kepala
$wp_customize->add_setting( 'foto_kepala', array(
    'default' => get_theme_file_uri('images/photo.jpg'), // Add Default Image URL 
    'sanitize_callback' => 'esc_url_raw'
));
 
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'foto_kepala', array(
    'label'         => __('Headmaster Photo', 'mading'),
	'description'   => __('Photo 300 x 400', 'mading'),
    'section'       => 'profile_sekolah',
    'settings'      => 'foto_kepala',
    'button_labels' => array(// All These labels are optional
                    'select' => __('Choose', 'mading'),
                    'remove' => __('Remove', 'mading'),
                    'change' => __('Change', 'mading'),
                    )
)));
// NSPN
$wp_customize->add_setting('nspn_data',array(
    'default'     => '20404xxx',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('nspn_data',array(
    'label'        => __('NPSN', 'mading'),
    'type'         => 'text',
    'section'      => 'profile_sekolah',
    'settings'     => 'nspn_data',
));
// Alamat
$wp_customize->add_setting('address_data',array(
    'default'     => 'Jl Jend A Yani no. 77 Comal, Pemalang, Jawa Tengah',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('address_data',array(
    'label'        => __('Address', 'mading'),
    'type'         => 'text',
    'section'      => 'profile_sekolah',
    'settings'     => 'address_data',
));

// Nomer Telepon
$wp_customize->add_setting('telpon_data',array(
    'default'     => '',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('telpon_data',array(
    'label'        => __('Phone', 'mading'),
    'type'         => 'text',
    'section'      => 'profile_sekolah',
    'settings'     => 'telpon_data',
));
// Alamat Email
$wp_customize->add_setting('email_data',array(
    'default'     => '',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'sanitize_email'
));
$wp_customize->add_control('email_data',array(
    'label'        => __('Email', 'mading'),
    'type'         => 'email',
    'section'      => 'profile_sekolah',
    'settings'     => 'email_data',
));
// WhatsApp
$wp_customize->add_setting('wa_data',array(
    'default'     => '',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('wa_data',array(
    'label'        => __('WhatsApp', 'mading'),
    'type'         => 'text',
    'section'      => 'profile_sekolah',
    'settings'     => 'wa_data',
));

// Facebook
$wp_customize->add_setting('facebook_data',array(
    'default'     => '',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'esc_url_raw'
));
$wp_customize->add_control('facebook_data',array(
    'label'        => 'Facebook',
    'type'         => 'url',
    'section'      => 'profile_sekolah',
    'settings'     => 'facebook_data',
	'input_attrs' => array(
        'placeholder' => __( 'https://...', 'mading' ),
    )
));
// Twitter
$wp_customize->add_setting('twitter_data',array(
    'default'     => '',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'esc_url_raw'
));
$wp_customize->add_control('twitter_data',array(
    'label'        => 'Twitter',
    'type'         => 'url',
    'section'      => 'profile_sekolah',
    'settings'     => 'twitter_data',
	'input_attrs' => array(
        'placeholder' => __( 'https://...', 'mading' ),
    )
));
// Tiktok
$wp_customize->add_setting('tiktok_data',array(
    'default'     => '',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'esc_url_raw'
));
$wp_customize->add_control('tiktok_data',array(
    'label'        => 'Tiktok',
    'type'         => 'url',
    'section'      => 'profile_sekolah',
    'settings'     => 'tiktok_data',
	'input_attrs' => array(
        'placeholder' => __( 'https://...', 'mading' ),
    )
));
// Instagram
$wp_customize->add_setting('instagram_data',array(
    'default'     => '',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'esc_url_raw'
));
$wp_customize->add_control('instagram_data',array(
    'label'       => 'Instagram',
    'type'        => 'url',
    'section'     => 'profile_sekolah',
    'settings'    => 'instagram_data',
	'input_attrs' => array(
        'placeholder' => __( 'https://...', 'mading' ),
    )
));
// Youtube
$wp_customize->add_setting('youtube_data',array(
    'default'     => '',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'esc_url_raw'
));
$wp_customize->add_control('youtube_data',array(
    'label'       => 'Youtube',
    'type'        => 'url',
    'section'     => 'profile_sekolah',
    'settings'    => 'youtube_data',
	'input_attrs' => array(
        'placeholder' => __( 'https://...', 'mading' ),
    )
));
	
// Layout Setting
$wp_customize->add_section('mading_layout',array(
    'title'       => __('Layout Setting', 'mading'),
    'description' => __('Setting theme layout', 'mading'),
    'priority'    => 15,
    'panel'       => 'mading_profile',
));

$wp_customize->add_setting('share_hide',array(
    'default'     => 'waktu',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('share_hide',array(
	'description'  => '<div class="color_akademi">'.__('Default Share Image', 'mading') .'</div>',
    'type'         => 'hidden',
    'section'      => 'mading_layout',
    'settings'     => 'share_hide',
));

// Foto Share
$wp_customize->add_setting( 'share_image', array(
    'default' => get_theme_file_uri('images/share.jpg'), // Add Default Image URL 
    'sanitize_callback' => 'esc_url_raw'
));
 
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'share_image', array(
    'description' => __('Set default image when link is shared on Facebook, Twitter, and WhatsApp', 'mading'),
    'section' => 'mading_layout',
    'settings' => 'share_image',
    'button_labels' => array(// All These labels are optional
                    'select' => __('Choose', 'mading'),
                    'remove' => __('Remove', 'mading'),
                    'change' => __('Change', 'mading'),
                    )
)));

$wp_customize->add_setting('mading_hide',array(
    'default'     => 'waktu',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('mading_hide',array(
	'description'  => '<div class="color_akademi">'.__('Default Thumbnail Image', 'mading') .'</div>',
    'type'         => 'hidden',
    'section'      => 'mading_layout',
    'settings'     => 'mading_hide',
));
// Thumbnail
$wp_customize->add_setting( 'madingthumb_image', array(
    'default' => get_theme_file_uri('images/mading.jpg'), // Add Default Image URL 
    'sanitize_callback' => 'esc_url_raw'
));
 
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'madingthumb_image', array(
    'description' => __('Set default image for Featured Image', 'mading'),
    'section' => 'mading_layout',
    'settings' => 'madingthumb_image',
    'button_labels' => array(// All These labels are optional
                    'select' => __('Choose', 'mading'),
                    'remove' => __('Remove', 'mading'),
                    'change' => __('Change', 'mading'),
                    )
)));

$wp_customize->add_setting('thumbnail_hide',array(
    'default'     => 'thumbon',
	'transport'   => 'refresh',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('thumbnail_hide',array(
    'label'        => __('Hide Thumbnail', 'mading'),
    'type'         => 'select',
	'choices'      => array(
		'thumbon'     => __( 'Show', 'mading' ),
		'thumboff'    => __( 'Hide', 'mading' ),
	),
    'section'      => 'mading_layout',
    'settings'     => 'thumbnail_hide',
));





$wp_customize->add_setting('guru_hide',array(
    'default'     => 'waktu',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('guru_hide',array(
	'description'  => '<div class="color_akademi">'. __('Default Teacher Photo', 'mading') .'</div>',
    'type'         => 'hidden',
    'section'      => 'mading_layout',
    'settings'     => 'guru_hide',
));

// Thumbnail
$wp_customize->add_setting( 'madingphoto_image', array(
    'default' => get_theme_file_uri('images/photo.jpg'), // Add Default Image URL 
    'sanitize_callback' => 'esc_url_raw'
));
 
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'madingphoto_image', array(
    'description' => __('Photo 300 x 400', 'mading'),
    'section' => 'mading_layout',
    'settings' => 'madingphoto_image',
    'button_labels' => array(// All These labels are optional
                    'select' => __('Choose', 'mading'),
                    'remove' => __('Remove', 'mading'),
                    'change' => __('Change', 'mading'),
                    )
)));
// Slide
$wp_customize->add_setting('slide_width',array(
    'default'     => 1200,
	'transport'   => 'postMessage',
	'sanitize_callback' => 'absint'
));
$wp_customize->add_control('slide_width',array(
    'label'        => __('Change Slider Dimension', 'mading'),
	'description'  => __('IMPORTANT : After change dimension. You need <a target="_blank" href="https://ciuss.com/regenerate">Re-generate Thumbnail</a> to apply new dimension work to all image', 'mading'),
    'type'         => 'number',
    'section'      => 'mading_layout',
    'settings'     => 'slide_width',
));
$wp_customize->add_setting('slide_height',array(
    'default'     => 600,
	'transport'   => 'postMessage',
	'sanitize_callback' => 'absint'
));
$wp_customize->add_control('slide_height',array(
    'type'         => 'number',
    'section'      => 'mading_layout',
    'settings'     => 'slide_height',
));

$wp_customize->add_setting('slide_timer',array(
    'default'     => 6,
	'transport'   => 'postMessage',
	'sanitize_callback' => 'theme_slug_sanitize_select'
));
$wp_customize->add_control('slide_timer',array(
    'label'        => __('Change Slider Duration', 'mading'),
    'type'         => 'select',
	'choices'     => array(
		'3'      => __( '3 Second', 'mading' ),
		'4'      => __( '4 Second', 'mading' ),
		'5'      => __( '5 Second', 'mading' ),
		'6'      => __( '6 Second', 'mading' ),
		'7'      => __( '7 Second', 'mading' ),
		'8'      => __( '8 Second', 'mading' ),
		'9'      => __( '9 Second', 'mading' ),
		'10'     => __( '10 Second', 'mading' ),
	),
    'section'      => 'mading_layout',
    'settings'     => 'slide_timer',
));
$wp_customize->add_setting('opacity_agenda',array(
    'default'     => 75,
	'sanitize_callback' => 'absint'
));
$wp_customize->add_control('opacity_agenda',array(
    'label'        => __('Agenda Opacity', 'mading'),
    'type'         => 'number',
    'section'      => 'mading_layout',
    'settings'     => 'opacity_agenda',
	'input_attrs' => array(
        'min'     => 1,
		'max'     => 99,
    )
));
$wp_customize->add_setting( 'agenda_overlay', array(
    'default' => get_theme_file_uri('images/agenda.jpg'), // Add Default Image URL 
    'sanitize_callback' => 'esc_url_raw'
));
 
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'agenda_overlay', array(
    'label'         => __('Agenda Background Image', 'mading'),
    'section'       => 'mading_layout',
    'settings'      => 'agenda_overlay',
    'button_labels' => array(// All These labels are optional
                    'select' => __('Choose', 'mading'),
                    'remove' => __('Remove', 'mading'),
                    'change' => __('Change', 'mading'),
                    )
)));
$wp_customize->add_setting('scrolltop_position',array(
    'default'     => 75,
	'sanitize_callback' => 'absint'
));
$wp_customize->add_control('scrolltop_position',array(
    'label'        => __('Scroll To Top', 'mading'),
    'type'         => 'number',
    'section'      => 'mading_layout',
    'settings'     => 'scrolltop_position',
	'input_attrs' => array(
        'min'     => 0,
		'max'     => 100,
    )
));
	
	
$wp_customize->add_section('replace_text',array(
    'title'       => __('Replace Text', 'mading'),
    'description' => __('Use to change default text from theme', 'mading'),
    'priority'    => 20,
    'panel'       => 'mading_profile',
));






$wp_customize->add_setting('re_press',array(
    'default'     => 'Prestasi Sekolah',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_press',array(
    'label'        => __('School Achievement', 'mading'),
	'description'  => __('Location on Homepage', 'mading'),
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_press',
));
$wp_customize->add_setting('re_presstext',array(
    'default'     => 'An potest, inquit ille, quicquam esse suavius quam nihil dolere? Contemnit enim disserendi elegantiam, confuse loquitur. An est aliquid per se ipsum flagitiosum, etiamsi nulla comitetur infamia? Ab hoc autem quaedam non melius quam veteres',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_presstext',array(
    'label'        => __('Description', 'mading'),
    'type'         => 'textarea',
    'section'      => 'replace_text',
    'settings'     => 're_presstext',
));


$wp_customize->add_setting('re_noagenda',array(
    'default'     => 'Tidak ada Agenda baru dalam waktu dekat ini',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('re_noagenda',array(
    'label'        => __('No Agenda Found', 'mading'),
	'description'  => __('Location on Homepage', 'mading'),
    'type'         => 'text',
    'section'      => 'replace_text',
    'settings'     => 're_noagenda',
));

$wp_customize->add_setting('copy_foot',array(
    'default'     => '',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('copy_foot',array(
    'label'        => __('Footer Copyright', 'mading'),
	'description'  => __('Location on Footer', 'mading'),
    'type'         => 'textarea',
    'section'      => 'replace_text',
    'settings'     => 'copy_foot',
));


$wp_customize->add_section('mading_runing',array(
    'title'       => __('Running Text', 'mading'),
    'description' => __('HTML tags allowed', 'mading'),
    'priority'    => 30,
    'panel'       => 'mading_profile',
));
// Run
$wp_customize->add_setting('running_text',array(
    'default'     => 'Tema Mading dapat menampilkan informasi dalam text berjalan',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('running_text',array(
    'label'        => __('Running Text Content', 'mading'),
    'type'         => 'textarea',
    'section'      => 'mading_runing',
    'settings'     => 'running_text',
));

// Font Setting
$wp_customize->add_section('mading_font',array(
    'title'       => __('Font Setting', 'mading'),
    'priority'    => 35,
    'panel'       => 'mading_profile',
));
$wp_customize->add_setting('global_fonts',array(
    'default'     => '',
	'transport'   => 'refresh',
	'sanitize_callback' => 'web_sanitize_fonts'
));
$wp_customize->add_control('global_fonts',array(
	'description'  => __( 'Global Font', 'mading' ),
    'type'         => 'select',
	'choices'      => $font_choices,
    'section'      => 'mading_font',
    'settings'     => 'global_fonts',
));
$wp_customize->add_setting('global_fontsize',array(
    'default'     => 14,
	'transport'   => 'refresh',
	'sanitize_callback' => 'absint'
));
$wp_customize->add_control('global_fontsize',array(
	'description'  => __( 'Font Size', 'mading' ),
    'type'         => 'number',
	'input_attrs' => array(
        'min'     => 13,
		'max'     => 16,
    ),
    'section'      => 'mading_font',
    'settings'     => 'global_fontsize',
));
$wp_customize->add_setting('header_fonts',array(
    'default'     => '',
	'transport'   => 'refresh',
	'sanitize_callback' => 'web_sanitize_fonts'
));
$wp_customize->add_control('header_fonts',array(
	'description'  => __( 'Header Font', 'mading' ),
    'type'         => 'select',
	'choices'      => $font_choices,
    'section'      => 'mading_font',
    'settings'     => 'header_fonts',
));
$wp_customize->add_setting('menu_fonts',array(
    'default'     => '',
	'transport'   => 'refresh',
	'sanitize_callback' => 'web_sanitize_fonts'
));
$wp_customize->add_control('menu_fonts',array(
	'description'  => __( 'Menu Font', 'mading' ),
    'type'         => 'select',
	'choices'      => $font_choices,
    'section'      => 'mading_font',
    'settings'     => 'menu_fonts',
));



// WhatsApp Section
$wp_customize->add_section('wa_section',array(
    'title'       => __( 'Setting WhatsApp', 'mading' ),
    'description' => __( 'Use to change default text for WhatsApp', 'mading' ),
    'priority'    => 80,
    'panel'       => 'mading_profile',
));

$wp_customize->add_setting('chat_sekolah',array(
    'default'     => 'Saya ingin informasi seputar sekolah...',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('chat_sekolah',array(
    'title'       => __( 'General Message', 'mading' ),
    'type'         => 'textarea',
    'section'      => 'wa_section',
    'settings'     => 'chat_sekolah',
));

// Operator Setting
$wp_customize->add_section('mading_operator',array(
    'title'       => __( 'Operator Setting', 'mading' ),
    'description' => __( 'Setting for Operator capability', 'mading' ),
    'priority'    => 85,
    'panel'       => 'mading_profile',
));
$wp_customize->add_setting('operator_cap',array(
    'default'     => 'on',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('operator_cap',array(
    'description'        => __( 'Enable or Disable Blog, Download, Siswa, GTK and Materi from Operator', 'mading' ),
    'type'         => 'select',
	'choices'      => array(
		'on'     => __( 'Open for Operator', 'mading' ),
		'off'    => __( 'Close for Operator', 'mading' ),
	),
    'section'      => 'mading_operator',
    'settings'     => 'operator_cap',
));


// GTK Setting
$wp_customize->add_section('mading_struktur',array(
    'title'       => __( 'Structure Setting', 'mading' ),
    'description' => __( 'Setting for GTK structure', 'mading' ),
    'priority'    => 85,
    'panel'       => 'mading_profile',
));
// Tutorial
$wp_customize->add_setting('hide_structure',array(
    'default'     => 'normal',
	'transport'   => 'refresh',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('hide_structure',array(
    'label'        => __( 'GTK Archive Page', 'mading' ),
    'type'         => 'select',
	'choices'      => array(
		'normal'     => __( 'Show Normal List', 'mading' ),
		'struc'  => __( 'Show Structure', 'mading' ),
	),
    'section'      => 'mading_struktur',
    'settings'     => 'hide_structure',
));

$wp_customize->add_setting('gtk_order',array(
    'default'     => 'date',
	'transport'   => 'refresh',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('gtk_order',array(
    'label'        => __( 'Sort by', 'mading' ),
    'type'         => 'select',
	'choices'      => array(
		'date'       => __( 'Post Date', 'mading' ),
		'title'      => __( 'Alphabet', 'mading' ),
		'rand'       => __( 'Random', 'mading' ),
	),
    'section'      => 'mading_struktur',
    'settings'     => 'gtk_order',
));

    // Ambil daftar taxonomy 'jabatan'
    $terms = get_terms(array(
        'taxonomy'   => 'structure',
        'hide_empty' => false,
    ));

    $choices = array();
    if (!empty($terms) && !is_wp_error($terms)) {
        foreach ($terms as $term) {
            $choices[$term->slug] = $term->name;
        }
    }

    $wp_customize->add_setting('first_line', array(
        'default'           => '',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control(new Multiple_Checkbox_Custom_Control($wp_customize, 'first_line', array(
        'label'    => __('First Line', 'mading'),
        'section'  => 'mading_struktur', 
        'settings' => 'first_line',
        'choices'  => $choices,
		'active_callback'   => 'structure_show',
    )));
	
	$wp_customize->add_setting('second_line', array(
        'default'           => '',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control(new Multiple_Checkbox_Custom_Control($wp_customize, 'second_line', array(
        'label'    => __('Second Line', 'mading'),
        'section'  => 'mading_struktur', 
        'settings' => 'second_line',
        'choices'  => $choices,
		'active_callback'   => 'structure_show',
    )));
	
	$wp_customize->add_setting('third_line', array(
        'default'           => '',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control(new Multiple_Checkbox_Custom_Control($wp_customize, 'third_line', array(
        'label'    => __('Third Line', 'mading'),
        'section'  => 'mading_struktur', 
        'settings' => 'third_line',
        'choices'  => $choices,
		'active_callback'   => 'structure_show',
    )));
	
	$wp_customize->add_setting('fourth_line', array(
        'default'           => '',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control(new Multiple_Checkbox_Custom_Control($wp_customize, 'fourth_line', array(
        'label'    => __('Fourth Line', 'mading'),
        'section'  => 'mading_struktur', 
        'settings' => 'fourth_line',
        'choices'  => $choices,
		'active_callback'   => 'structure_show',
    )));
	
	$wp_customize->add_setting('fifth_line', array(
        'default'           => '',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control(new Multiple_Checkbox_Custom_Control($wp_customize, 'fifth_line', array(
        'label'    => __('Fifth Line', 'mading'),
        'section'  => 'mading_struktur', 
        'settings' => 'fifth_line',
        'choices'  => $choices,
		'active_callback'   => 'structure_show',
    )));
	
	$wp_customize->add_setting('sixth_line', array(
        'default'           => '',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control(new Multiple_Checkbox_Custom_Control($wp_customize, 'sixth_line', array(
        'label'    => __('Sixth Line', 'mading'),
        'section'  => 'mading_struktur', 
        'settings' => 'sixth_line',
        'choices'  => $choices,
		'active_callback'   => 'structure_show',
    )));
	
	$wp_customize->add_setting('seventh_line', array(
        'default'           => '',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control(new Multiple_Checkbox_Custom_Control($wp_customize, 'seventh_line', array(
        'label'    => __('Seventh Line', 'mading'),
        'section'  => 'mading_struktur', 
        'settings' => 'seventh_line',
        'choices'  => $choices,
		'active_callback'   => 'structure_show',
    )));

// Alumni Setting
$wp_customize->add_section('mading_alumni',array(
    'title'       => __( 'Alumni Setting', 'mading' ),
    'description' => __( 'Setting for alumni feature', 'mading' ),
    'priority'    => 85,
    'panel'       => 'mading_profile',
));
$wp_customize->add_setting('type_alumni',array(
    'default'     => '',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('type_alumni',array(
    'label'        => __( 'Alumni Type', 'mading' ),
    'type'         => 'select',
	'choices'      => array(
		'sd'     => __( 'SD / MI', 'mading' ),
		'smp'    => __( 'SMP / MTS', 'mading' ),
		'sma'    => __( 'SMA / MA / SMK', 'mading' ),
		'pt'     => __( 'Perguruan', 'mading' ),
	),
    'section'      => 'mading_alumni',
    'settings'     => 'type_alumni',
));

// Layout Setting
$wp_customize->add_section('mading_tutor',array(
    'title'       => __( 'Tutorial Setting', 'mading' ),
    'description' => __( 'Setting for tutorial in post editor', 'mading' ),
    'priority'    => 85,
    'panel'       => 'mading_profile',
));
// Tutorial
$wp_customize->add_setting('hide_tutor',array(
    'default'     => 'on',
	'transport'   => 'postMessage',
	'sanitize_callback' => 'wp_kses_post'
));
$wp_customize->add_control('hide_tutor',array(
    'label'        => __( 'Post Tutorial', 'mading' ),
    'type'         => 'select',
	'choices'      => array(
		'on'     => __( 'Show', 'mading' ),
		'off'    => __( 'Hide', 'mading' ),
	),
    'section'      => 'mading_tutor',
    'settings'     => 'hide_tutor',
));

}
add_action( 'customize_register', 'mading_customize_register', 11 );


function structure_show( $control ) {
    $show_structure = $control->manager->get_setting('hide_structure')->value();
    if ( in_array( $show_structure, array( 'struc' ) ) ) {
        return true;
    } else {
        return false;
    }
}
function structure_hide( $control ) {
    $show_structure = $control->manager->get_setting('hide_structure')->value();
    if ( in_array( $show_structure, array( 'normal' ) ) ) {
        return true;
    } else {
        return false;
    }
}

function running_mading( $control ) {
    $mode_mading = $control->manager->get_setting('mode_tema')->value();
    if ( in_array( $mode_mading, array( 'mading' ) ) ) {
        return true;
    } else {
        return false;
    }
}

function running_akademi( $control ) {
    $mode_akademi = $control->manager->get_setting('mode_tema')->value();
    if ( in_array( $mode_akademi, array( 'akademi' ) ) ) {
        return true;
    } else {
        return false;
    }
}
function running_prestasi( $control ) {
	$mode_prestasi = $control->manager->get_setting('mode_tema')->value();
    if ( in_array( $mode_prestasi, array( 'prestasi' ) ) ) {
        return true;
    } else {
        return false;
    }
}
function running_magazine( $control ) {
    $mode_magazine = $control->manager->get_setting('mode_tema')->value();
    if ( in_array( $mode_magazine, array( 'magazine' ) ) ) {
        return true;
    } else {
        return false;
    }
}

function running_awesome( $control ) {
    $mode_awesome = $control->manager->get_setting('mode_tema')->value();
    if ( in_array( $mode_awesome, array( 'awesome' ) ) ) {
        return true;
    } else {
        return false;
    }
}

if (class_exists('WP_Customize_Control')) {
    class Multiple_Checkbox_Custom_Control extends WP_Customize_Control {
        public $type = 'multiple_checkbox';

        public function render_content() {
            if (empty($this->choices)) {
                return;
            }

            $saved_values = explode(',', $this->value());

            ?>
            <label>
                <span class="customize-control-title"><?php echo esc_html($this->label); ?></span>
                <div>
                    <?php foreach ($this->choices as $value => $label) : ?>
                        <label style="display: block; margin-bottom: 5px;">
                            <input type="checkbox" value="<?php echo esc_attr($value); ?>"
                                <?php checked(in_array($value, $saved_values)); ?>
                                onchange="updateCheckboxes_<?php echo esc_attr($this->id); ?>()" />
                            <?php echo esc_html($label); ?>
                        </label>
                    <?php endforeach; ?>
                </div>
                <input type="hidden" <?php $this->link(); ?> id="<?php echo esc_attr($this->id); ?>" value="<?php echo esc_attr($this->value()); ?>" />
            </label>

            <script>
                function updateCheckboxes_<?php echo esc_attr($this->id); ?>() {
                    var checkboxes = document.querySelectorAll('input[type="checkbox"][onchange="updateCheckboxes_<?php echo esc_attr($this->id); ?>()"]');
                    var values = [];
                    checkboxes.forEach(function (checkbox) {
                        if (checkbox.checked) {
                            values.push(checkbox.value);
                        }
                    });
                    document.getElementById('<?php echo esc_attr($this->id); ?>').value = values.join(',');
                    document.getElementById('<?php echo esc_attr($this->id); ?>').dispatchEvent(new Event('change'));
                }
            </script>
            <?php
        }
    }
}
