<?php
function mag_top_head_bg_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[234];
	$mag_top_head_bg = get_theme_mod( 'mag_top_head_bg', $default_color );

	if ( $mag_top_head_bg === $default_color ) {
		return;
	}

	$css = '
	.mag_top {
        background: %1$s;
	}
	.magazine .newnav .accordion li a span {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_top_head_bg) );
}
add_action( 'wp_enqueue_scripts', 'mag_top_head_bg_css', 11 );

function mag_top_head_col_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[235];
	$mag_top_head_col = get_theme_mod( 'mag_top_head_col', $default_color );

	if ( $mag_top_head_col === $default_color ) {
		return;
	}

	$css = '
	.mag_top,
	.mag_top  a {
        color: %1$s;
	}
	.magazine .newnav .accordion li a span {
		background: %1$s;
	}
	.magazine .newnav .accordion li.menu-item-has-children:after {
		border-top: 6px solid %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_top_head_col) );
}
add_action( 'wp_enqueue_scripts', 'mag_top_head_col_css', 11 );

function mag_sub_menu_bg_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[236];
	$mag_sub_menu_bg = get_theme_mod( 'mag_sub_menu_bg', $default_color );

	if ( $mag_sub_menu_bg === $default_color ) {
		return;
	}

	$css = '
	.magazine .newnav .accordion li ul {
		background: %1$s;
	}
	@media screen and (max-width: 982px) {
		.mag_menu {
	    	background: %1$s;
    	}
		.mag_top .newnav.nav-mobile .accordion li a span {
	    	color: %1$s;
    	}
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_sub_menu_bg) );
}
add_action( 'wp_enqueue_scripts', 'mag_sub_menu_bg_css', 11 );

function mag_sub_menu_col_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[237];
	$mag_sub_menu_col = get_theme_mod( 'mag_sub_menu_col', $default_color );

	if ( $mag_sub_menu_col === $default_color ) {
		return;
	}

	$css = '
	.magazine .newnav .accordion li ul li a {
		color: %1$s;
	}
	@media screen and (max-width: 982px) {
		.mag_top .newnav.nav-mobile .accordion li a {
	    	color: %1$s;
    	}
		.mag_top .newnav.nav-mobile .accordion li.menu-item-has-children:after  {
			border-top: 6px solid %1$s;
		}
		.mag_top .newnav.nav-mobile .accordion li a span {
	    	background: %1$s;
    	}
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_sub_menu_col) );
}
add_action( 'wp_enqueue_scripts', 'mag_sub_menu_col_css', 11 );

function mag_head_bg_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[238];
	$mag_head_bg = get_theme_mod( 'mag_head_bg', $default_color );

	if ( $mag_head_bg === $default_color ) {
		return;
	}

	$css = '
	.mag_bot,
	.bot_right {
		background: %1$s;
	}
	.mgz_button button,
	.botclose {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_head_bg) );
}
add_action( 'wp_enqueue_scripts', 'mag_head_bg_css', 11 );

function mag_head_col_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[239];
	$mag_head_col = get_theme_mod( 'mag_head_col', $default_color );

	if ( $mag_head_col === $default_color ) {
		return;
	}

	$css = '
	.mag_bot,
	.mgz_input input,
	.mgz_select select,
	.bot_right {
		color: %1$s;
	}
	
	.open_menu:before {
		border-top: 2px solid %1$s;
	}
	.open_menu:after {
		border-bottom: 2px solid %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_head_col) );
}
add_action( 'wp_enqueue_scripts', 'mag_head_col_css', 11 );

function mag_head_acc_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[240];
	$mag_head_acc = get_theme_mod( 'mag_head_acc', $default_color );

	if ( $mag_head_acc === $default_color ) {
		return;
	}

	$css = '
	.mgz_button button,
	.botclose {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_head_acc) );
}
add_action( 'wp_enqueue_scripts', 'mag_head_acc_css', 11 );

function mag_ticker_bg_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[241];
	$mag_ticker_bg = get_theme_mod( 'mag_ticker_bg', $default_color );

	if ( $mag_ticker_bg === $default_color ) {
		return;
	}

	$css = '
	.mag_run:before {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_ticker_bg) );
}
add_action( 'wp_enqueue_scripts', 'mag_ticker_bg_css', 11 );

function mag_ticker_col_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[242];
	$mag_ticker_col = get_theme_mod( 'mag_ticker_col', $default_color );

	if ( $mag_ticker_col === $default_color ) {
		return;
	}

	$css = '
	.mag_run {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_ticker_col) );
}
add_action( 'wp_enqueue_scripts', 'mag_ticker_col_css', 11 );

function mag_info_bg_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[243];
	$mag_info_bg = get_theme_mod( 'mag_info_bg', $default_color );

	if ( $mag_info_bg === $default_color ) {
		return;
	}

	$css = '
	.sch_infosekolah {
		background: %1$s;
	}
	.sch_info {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_info_bg) );
}
add_action( 'wp_enqueue_scripts', 'mag_info_bg_css', 11 );

function mag_info_col_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[244];
	$mag_info_col = get_theme_mod( 'mag_info_col', $default_color );

	if ( $mag_info_col === $default_color ) {
		return;
	}

	$css = '
	.sch_infosekolah {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_info_col) );
}
add_action( 'wp_enqueue_scripts', 'mag_info_col_css', 11 );

function mag_info_acc_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[245];
	$mag_info_acc = get_theme_mod( 'mag_info_acc', $default_color );

	if ( $mag_info_acc === $default_color ) {
		return;
	}

	$css = '
	.sch_info {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_info_acc) );
}
add_action( 'wp_enqueue_scripts', 'mag_info_acc_css', 11 );

function mag_master_bg_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[246];
	$mag_master_bg = get_theme_mod( 'mag_master_bg', $default_color );

	if ( $mag_master_bg === $default_color ) {
		return;
	}

	$css = '
	.mag_master,
	.mas_loop {
		background: %1$s;
	}
	.mas_title {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_master_bg) );
}
add_action( 'wp_enqueue_scripts', 'mag_master_bg_css', 11 );

function mag_master_col_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[247];
	$mag_master_col = get_theme_mod( 'mag_master_col', $default_color );

	if ( $mag_master_col === $default_color ) {
		return;
	}

	$css = '
	.mag_master,
	.mas_post h3 a,
	.mas_loop {
		color: %1$s;
	}
	.mas_get:before {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_master_col) );
}
add_action( 'wp_enqueue_scripts', 'mag_master_col_css', 11 );

function mag_master_acc_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[248];
	$mag_master_acc = get_theme_mod( 'mag_master_acc', $default_color );

	if ( $mag_master_acc === $default_color ) {
		return;
	}

	$css = '
	.mas_title {
		background: %1$s;
	}
	.mas_loop {
		border-bottom-color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_master_acc) );
}
add_action( 'wp_enqueue_scripts', 'mag_master_acc_css', 11 );

function mag_news_bg_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[249];
	$mag_news_bg = get_theme_mod( 'mag_news_bg', $default_color );

	if ( $mag_news_bg === $default_color ) {
		return;
	}

	$css = '
	.mag_news,
	.news_loop {
		background: %1$s;
	}
	.news_title,
	.news_all {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_news_bg) );
}
add_action( 'wp_enqueue_scripts', 'mag_news_bg_css', 11 );

function mag_news_col_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[250];
	$mag_news_col = get_theme_mod( 'mag_news_col', $default_color );

	if ( $mag_news_col === $default_color ) {
		return;
	}

	$css = '
	.news_post h3 a {
		color: %1$s;
	}
	.news_title {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_news_col) );
}
add_action( 'wp_enqueue_scripts', 'mag_news_col_css', 11 );

function mag_news_acc_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[251];
	$mag_news_acc = get_theme_mod( 'mag_news_acc', $default_color );

	if ( $mag_news_acc === $default_color ) {
		return;
	}

	$css = '
	.news_all {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_news_acc) );
}
add_action( 'wp_enqueue_scripts', 'mag_news_acc_css', 11 );

function mag_blog_bg_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[252];
	$mag_blog_bg = get_theme_mod( 'mag_blog_bg', $default_color );

	if ( $mag_blog_bg === $default_color ) {
		return;
	}

	$css = '
	.blog_news.mag_news,
	.blog_news .news_loop {
		background: %1$s;
	}
	.blog_news .news_title,
	.blog_news .news_all {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_blog_bg) );
}
add_action( 'wp_enqueue_scripts', 'mag_blog_bg_css', 11 );

function mag_blog_col_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[253];
	$mag_blog_col = get_theme_mod( 'mag_blog_col', $default_color );

	if ( $mag_blog_col === $default_color ) {
		return;
	}

	$css = '
	.blog_news .news_post h3 a {
		color: %1$s;
	}
	.blog_news .news_title {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_blog_col) );
}
add_action( 'wp_enqueue_scripts', 'mag_blog_col_css', 11 );

function mag_blog_acc_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[254];
	$mag_blog_acc = get_theme_mod( 'mag_blog_acc', $default_color );

	if ( $mag_blog_acc === $default_color ) {
		return;
	}

	$css = '
	.blog_news .news_all {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_blog_acc) );
}
add_action( 'wp_enqueue_scripts', 'mag_blog_acc_css', 11 );

function mag_event_bg_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[255];
	$mag_event_bg = get_theme_mod( 'mag_event_bg', $default_color );

	if ( $mag_event_bg === $default_color ) {
		return;
	}

	$css = '
	.mag_event {
		background: %1$s;
	}
	.eve_near h4 span {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_event_bg) );
}
add_action( 'wp_enqueue_scripts', 'mag_event_bg_css', 11 );

function mag_event_col_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[256];
	$mag_event_col = get_theme_mod( 'mag_event_col', $default_color );

	if ( $mag_event_col === $default_color ) {
		return;
	}

	$css = '
	.mag_event,
	.table_agenda .btn a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_event_col) );
}
add_action( 'wp_enqueue_scripts', 'mag_event_col_css', 11 );

function mag_event_acc_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[257];
	$mag_event_acc = get_theme_mod( 'mag_event_acc', $default_color );

	if ( $mag_event_acc === $default_color ) {
		return;
	}

	$css = '
	.eve_near h4 span {
		background: %1$s;
	}
	.eve_near h4 a {
		border: 1px solid %1$s;
        color: %1$s;
	}
	.table_agenda span:first-child {
		color: %1$s;
	}
	.table_agenda .btn a {
		border: 1px solid %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_event_acc) );
}
add_action( 'wp_enqueue_scripts', 'mag_event_acc_css', 11 );

function mag_umum_bg_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[258];
	$mag_umum_bg = get_theme_mod( 'mag_umum_bg', $default_color );

	if ( $mag_umum_bg === $default_color ) {
		return;
	}

	$css = '
	.mag_umum {
		background: %1$s;
	}
	.peng_link {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_umum_bg) );
}
add_action( 'wp_enqueue_scripts', 'mag_umum_bg_css', 11 );

function mag_umum_col_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[259];
	$mag_umum_col = get_theme_mod( 'mag_umum_col', $default_color );

	if ( $mag_umum_col === $default_color ) {
		return;
	}

	$css = '
	.mag_umum {
		color: %1$s;
	}
	.peng_loop:before {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_umum_col) );
}
add_action( 'wp_enqueue_scripts', 'mag_umum_col_css', 11 );

function mag_umum_acc_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[260];
	$mag_umum_acc = get_theme_mod( 'mag_umum_acc', $default_color );

	if ( $mag_umum_acc === $default_color ) {
		return;
	}

	$css = '
	.peng_time {
		border: 2px solid %1$s;
		color: %1$s;
	}
	.peng_link {
		border: 2px solid %1$s;
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_umum_acc) );
}
add_action( 'wp_enqueue_scripts', 'mag_umum_acc_css', 11 );

function mag_quotes_bg_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[261];
	$mag_quotes_bg = get_theme_mod( 'mag_quotes_bg', $default_color );

	if ( $mag_quotes_bg === $default_color ) {
		return;
	}

	$css = '
	.mag_quotes {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_quotes_bg) );
}
add_action( 'wp_enqueue_scripts', 'mag_quotes_bg_css', 11 );

function mag_quotes_col_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[262];
	$mag_quotes_col = get_theme_mod( 'mag_quotes_col', $default_color );

	if ( $mag_quotes_col === $default_color ) {
		return;
	}

	$css = '
	.mag_quotes {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_quotes_col) );
}
add_action( 'wp_enqueue_scripts', 'mag_quotes_col_css', 11 );

function mag_quotes_acc_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[263];
	$mag_quotes_acc = get_theme_mod( 'mag_quotes_acc', $default_color );

	if ( $mag_quotes_acc === $default_color ) {
		return;
	}

	$css = '
	.quoteslide .splide__slide span {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_quotes_acc) );
}
add_action( 'wp_enqueue_scripts', 'mag_quotes_acc_css', 11 );

function mag_guru_bg_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[264];
	$mag_guru_bg = get_theme_mod( 'mag_guru_bg', $default_color );

	if ( $mag_guru_bg === $default_color ) {
		return;
	}

	$css = '
	.mag_guru {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_guru_bg) );
}
add_action( 'wp_enqueue_scripts', 'mag_guru_bg_css', 11 );

function mag_guru_box_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[265];
	$mag_guru_box = get_theme_mod( 'mag_guru_box', $default_color );

	if ( $mag_guru_box === $default_color ) {
		return;
	}

	$css = '
	.mgz_guru {
		background: linear-gradient(rgba(0, 0, 0, 0), %1$s);
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_guru_box) );
}
add_action( 'wp_enqueue_scripts', 'mag_guru_box_css', 11 );

function mag_guru_col_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[266];
	$mag_guru_col = get_theme_mod( 'mag_guru_col', $default_color );

	if ( $mag_guru_col === $default_color ) {
		return;
	}

	$css = '
	.mgz_guru,
	.mgz_guru a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_guru_col) );
}
add_action( 'wp_enqueue_scripts', 'mag_guru_col_css', 11 );

function mag_three_bg_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[267];
	$mag_three_bg = get_theme_mod( 'mag_three_bg', $default_color );

	if ( $mag_three_bg === $default_color ) {
		return;
	}

	$css = '
	.mag_fas,
	.tablinks {
		background: %1$s;
	}
	.tablinks.fas.active,
	.tablinks.ext.active,
	.tablinks.pres.active {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_three_bg) );
}
add_action( 'wp_enqueue_scripts', 'mag_three_bg_css', 11 );

function mag_three_col_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[268];
	$mag_three_col = get_theme_mod( 'mag_three_col', $default_color );

	if ( $mag_three_col === $default_color ) {
		return;
	}

	$css = '
	.other_pres h4 a {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_three_col) );
}
add_action( 'wp_enqueue_scripts', 'mag_three_col_css', 11 );

function mag_three_acc1_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[269];
	$mag_three_acc1 = get_theme_mod( 'mag_three_acc1', $default_color );

	if ( $mag_three_acc1 === $default_color ) {
		return;
	}

	$css = '
	.tablinks.ext {
		border: 1px solid %1$s;
		color: %1$s;
	}
	.tablinks.ext.active {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_three_acc1) );
}
add_action( 'wp_enqueue_scripts', 'mag_three_acc1_css', 11 );

function mag_three_acc2_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[270];
	$mag_three_acc2 = get_theme_mod( 'mag_three_acc2', $default_color );

	if ( $mag_three_acc2 === $default_color ) {
		return;
	}

	$css = '
	.tablinks.fas {
		border: 1px solid %1$s;
		color: %1$s;
	}
	.tablinks.fas.active {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_three_acc2) );
}
add_action( 'wp_enqueue_scripts', 'mag_three_acc2_css', 11 );

function mag_three_acc3_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[271];
	$mag_three_acc3 = get_theme_mod( 'mag_three_acc3', $default_color );

	if ( $mag_three_acc3 === $default_color ) {
		return;
	}

	$css = '
	.tablinks.pres {
		border: 1px solid %1$s;
		color: %1$s;
	}
	.tablinks.pres.active {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_three_acc3) );
}
add_action( 'wp_enqueue_scripts', 'mag_three_acc3_css', 11 );

function mag_gal_bg_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[272];
	$mag_gal_bg = get_theme_mod( 'mag_gal_bg', $default_color );

	if ( $mag_gal_bg === $default_color ) {
		return;
	}

	$css = '
	.mag_gal {
		background: %1$s;
	}
	.gal_loop span {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_gal_bg) );
}
add_action( 'wp_enqueue_scripts', 'mag_gal_bg_css', 11 );

function mag_gal_acc_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[273];
	$mag_gal_acc = get_theme_mod( 'mag_gal_acc', $default_color );

	if ( $mag_gal_acc === $default_color ) {
		return;
	}

	$css = '
	.gal_loop span {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_gal_acc) );
}
add_action( 'wp_enqueue_scripts', 'mag_gal_acc_css', 11 );

function mag_video_bg_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[274];
	$mag_video_bg = get_theme_mod( 'mag_video_bg', $default_color );

	if ( $mag_video_bg === $default_color ) {
		return;
	}

	$css = '
	.mag_vid {
		background: %1$s;
	}
	.vid_title span,
	.vid_all {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_video_bg) );
}
add_action( 'wp_enqueue_scripts', 'mag_video_bg_css', 11 );

function mag_video_col_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[275];
	$mag_video_col = get_theme_mod( 'mag_video_col', $default_color );

	if ( $mag_video_col === $default_color ) {
		return;
	}

	$css = '
	.vid_title span {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_video_col) );
}
add_action( 'wp_enqueue_scripts', 'mag_video_col_css', 11 );

function mag_video_acc_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[276];
	$mag_video_acc = get_theme_mod( 'mag_video_acc', $default_color );

	if ( $mag_video_acc === $default_color ) {
		return;
	}

	$css = '
	.vid_all {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_video_acc) );
}
add_action( 'wp_enqueue_scripts', 'mag_video_acc_css', 11 );


function mag_alumni_bg_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[277];
	$mag_alumni_bg = get_theme_mod( 'mag_alumni_bg', $default_color );

	if ( $mag_alumni_bg === $default_color ) {
		return;
	}

	$css = '
	.mag_alumni,
	.alumni_pro i {
		background: %1$s;
	}
	.al_link,
	.alumni_year span,
	.alumni_pro {
		color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_alumni_bg) );
}
add_action( 'wp_enqueue_scripts', 'mag_alumni_bg_css', 11 );

function mag_alumni_col_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[278];
	$mag_alumni_col = get_theme_mod( 'mag_alumni_col', $default_color );

	if ( $mag_alumni_col === $default_color ) {
		return;
	}

	$css = '
	.mag_alumni,
	.alumni_pro i {
		color: %1$s;
	}
	.alumni_pro {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_alumni_col) );
}
add_action( 'wp_enqueue_scripts', 'mag_alumni_col_css', 11 );

function mag_alumni_acc_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[279];
	$mag_alumni_acc = get_theme_mod( 'mag_alumni_acc', $default_color );

	if ( $mag_alumni_acc === $default_color ) {
		return;
	}

	$css = '
	.al_link,
	.alumni_year span {
		background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_alumni_acc) );
}
add_action( 'wp_enqueue_scripts', 'mag_alumni_acc_css', 11 );

function mag_content_bg_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[280];
	$mag_content_bg = get_theme_mod( 'mag_content_bg', $default_color );

	if ( $mag_content_bg === $default_color ) {
		return;
	}

	$css = '
	.magazine .mag_box,
	.magazine .login_in,
	.magazine .right__thecontent input,
	.magazine .logajax input,
	.magazine .search_something,
	.magazine .search_something input,
	.magazine .mag_rside .widget_block,
	.single .mag_news,
	.single .news_loop {
		background: %1$s;
	}
	.right__thecontent input.front__submit,
	.magazine .submit_button,
	.sos_alumni a,
	.sing_extra a,
	.comment-reply-link,
	.mading_table td.tdcol a,
	.mat_class a.det_more,
	.mat_back,
	.single .news_title,
	.single .news_all,
	.single .news_title,
	.single .news_all {
        color: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_content_bg) );
}
add_action( 'wp_enqueue_scripts', 'mag_content_bg_css', 11 );

function mag_content_col_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[281];
	$mag_content_col = get_theme_mod( 'mag_content_col', $default_color );

	if ( $mag_content_col === $default_color ) {
		return;
	}

	$css = '
	.mag_box,
	.login_in,
	.right__thecontent input,
	.logajax input,
	.single .no_img .breadcrumbs,
	.search_something,
	.search_something input,
	.mag_rside .widget_block,
	.single .news_loop,
	.single .news_post h3 a {
		color: %1$s;
	}
	.single .news_title {
		background: %1$s;
	}
	.mag_loc {
		border-left: 1px solid %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_content_col) );
}
add_action( 'wp_enqueue_scripts', 'mag_content_col_css', 11 );

function mag_content_link_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[282];
	$mag_content_link = get_theme_mod( 'mag_content_link', $default_color );

	if ( $mag_content_link === $default_color ) {
		return;
	}

	$css = '
	.art_meta h2 a,
	.single .no_img .breadcrumbs a,
	.mag_tag a {
        color: %1$s;
	}
	.right__thecontent input.front__submit,
	.magazine .submit_button,
	.sos_alumni a {
        background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_content_link) );
}
add_action( 'wp_enqueue_scripts', 'mag_content_link_css', 11 );

function mag_content_acc_css() {
	$color_scheme         = mading_get_color_scheme();
	$default_color        = $color_scheme[283];
	$mag_content_acc = get_theme_mod( 'mag_content_acc', $default_color );

	if ( $mag_content_acc === $default_color ) {
		return;
	}

	$css = '
	.sing_extra a,
	.comment-reply-link,
	.mading_table td.tdcol a,
	.mat_class a.det_more,
	.mat_back,
	.single .news_all {
        background: %1$s;
	}
	';

	wp_add_inline_style( 'mading-style', sprintf( $css, $mag_content_acc) );
}
add_action( 'wp_enqueue_scripts', 'mag_content_acc_css', 11 );