<div class="mag_loop madclear">
    <?php 
	$pagemad = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
	query_posts( array( 
		'post_type' => 'agenda', 
		'ignore_sticky_posts' => 1,
		'paged' => $pagemad, 
		'meta_key' => '_minus',
		'meta_query' => array(
			array(
				'key' => '_minus',
				'compare' => '>='
				)
			),
		'orderby' => 'meta_value',
		'order' => 'DESC'
		) 
	); 
	
	$offset      = get_option( 'gmt_offset' );
	if ( $offset = 7 ) {
		$localtime = 'UTC+0700';
	} elseif ( $offset = 8 ) {
		$localtime = 'UTC+0800';
	} elseif ( $offset = 9 ) {
		$localtime ='UTC+0900';
	}
	$today       = strtotime(date('Y-m-d H:i:s', strtotime('+'.$offset.' hours')));
	$noagenda = 0;
        if (have_posts()):
	        while (have_posts()): the_post(); 
			$noagenda++;
			$minus       = strtotime(get_post_meta($post->ID, '_tevent', true).' '.get_post_meta($post->ID, '_jam', true));
			$tevent      = get_post_meta($post->ID, '_tevent', true);
			$jam         = get_post_meta($post->ID, '_jam', true);
						
			$pack24      = date( "H:i:s", strtotime( $jam ) );		
			$sisa        = $minus-$today;
            $end         = $tevent . ' ' . $jam;	
						
			$lokasi      = get_post_meta( $post->ID, '_lokasi', true );
			$koordinator = get_post_meta( $post->ID, '_koordinator', true );
			$telepon     = get_post_meta( $post->ID, '_telepon', true );
			$acara       = date_i18n( "d F Y", strtotime( $tevent ) );
			?>
		
			    <div class="mag_art">
				    <div class="art_in">
				    	<div class="art_link">
						    <a href="<?php the_permalink() ?>"><?php // Featured Image
							    if (has_post_thumbnail()) { 
									the_post_thumbnail('news'); 
								} else {
									if ( get_theme_mod('madingthumb_image') != "" ) {
										$normal = attachment_url_to_postid( get_theme_mod('madingthumb_image'));
										$shownormal = wp_get_attachment_image_url( $normal, 'news' );
										echo '<img src="'. esc_url( $shownormal ) .'"/>';
									} else {
			    	        		    echo '<img src="'. esc_url( get_template_directory_uri() ).'/images/mading.jpg"/>';
									}
								}
						    	?>
							    <div class="art_pub">
								    <span class="art_date"><?php echo date_i18n('d', strtotime(esc_html($tevent))); ?></span>
									<span class="art_month">
									    <span><?php echo date_i18n('M', strtotime(esc_html($tevent))); ?></span>
										<span><?php echo date_i18n('Y', strtotime(esc_html($tevent))); ?></span>
									</span>
								</div>
							</a>
						</div>
						<div class="art_meta">
						    <div class="is_float">
							<?php 
						    	if ( $sisa < 0 ) { 
								    echo '<ul><li>';
									echo '<span class="is_event is_exp">';
						            echo __( 'Agenda is expired', 'mading' ); 
									echo '</span>';
									echo '</li></ul>';
								} else {
									echo '<ul><li>';
									echo '<span class="is_event is_on" id="event'. esc_attr( $noagenda ) .'">';
								    echo '<span class="event_day'. esc_attr( $noagenda ) .'"></span> '. __( 'Day + ', 'mading' ) .'
									<span class="like_link">
									    <span class="event_hour'. esc_attr( $noagenda ) .'"></span> : <span class="event_minutes'. esc_attr( $noagenda ) .'"></span> : <span class="event_seconds'. esc_attr( $noagenda ) .'"></span>
									</span>';
								    echo '</span>';
									echo '</li></ul>';
								} 
							?>
							</div>
				        	<h2><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h2>
							
			            </div>
			    	</div>
					<?php if ( $sisa > 0 ) { ?>
					<script>

						function getTimeRemaining(endtime){
  						    var t = Date.parse(endtime) - Date.parse(new Date());
  					    	var seconds = Math.floor( (t/1000) % 60 );
  					    	var minutes = Math.floor( (t/1000/60) % 60 );
  					    	var hours = Math.floor( (t/(1000*60*60)) % 24 );
  					    	var days = Math.floor( t/(1000*60*60*24) );
  					    	return {
  						        'total': t,
  						        'days': days,
  						        'hours': hours,
  						        'minutes': minutes,
  						        'seconds': seconds
 						    };
						}

						function initializeClock(id, endtime){
  					    	var clock = document.getElementById(id);
  					    	var daysSpan = clock.querySelector('.event_day<?php echo esc_html( $noagenda ); ?>');
  					    	var hoursSpan = clock.querySelector('.event_hour<?php echo esc_html( $noagenda ); ?>');
  					    	var minutesSpan = clock.querySelector('.event_minutes<?php echo esc_html( $noagenda ); ?>');
  					    	var secondsSpan = clock.querySelector('.event_seconds<?php echo esc_html( $noagenda ); ?>');

  						function updateClock(){
   						    var t = getTimeRemaining(endtime);

    						daysSpan.innerHTML = t.days;
    						hoursSpan.innerHTML = ('0' + t.hours).slice(-2);
    						minutesSpan.innerHTML = ('0' + t.minutes).slice(-2);
    						secondsSpan.innerHTML = ('0' + t.seconds).slice(-2);

    						if(t.total<=0){
     						    clearInterval(timeinterval);
    						}
  						}

  						updateClock();
  						var timeinterval = setInterval(updateClock,1000);
						}

						var deadline = <?php echo "'"; echo esc_html(date("F j Y", strtotime($tevent))); ?> <?php echo esc_html($jam); ?> <?php echo esc_html($localtime); ?>';
						initializeClock('event<?php echo esc_html( $noagenda ); ?>', deadline);

					</script>
                    <?php } ?>
				</div>
				<div class="madclear"></div>
			<?php 
			endwhile; 
        endif; 
	?>
</div>
