<?php 
$termkel = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );
$class = $termkel->slug;

$pagesiswa = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
$posts_per_page = 100;
$counter = ($pagesiswa - 1) * $posts_per_page;

query_posts( array( 
    'post_type' => 'mahasiswa', 
    'ignore_sticky_posts' => 1,
    'posts_per_page' => $posts_per_page, 
    'paged' => $pagesiswa, 
    'orderby' => 'title',
    'order' => 'ASC',
	'tax_query' => array(
		array(
		'taxonomy' => 'kelas',
		'terms' => $class,
		'field' => 'slug'
		)
	)
)); 

if (have_posts()): ?>
    <div class="madclear">
        <table class="mag_siswa">
            <tr class="top_tab">
                <td><?php echo esc_html_e( 'No.', 'mading'); ?></td>
                <td><?php echo esc_html_e( 'Name', 'mading'); ?></td>
                <td><?php echo esc_html_e( 'NIM', 'mading'); ?></td>
                <td><?php echo esc_html_e( 'Study', 'mading'); ?></td>
            </tr>
            <?php while (have_posts()): the_post(); 
                global $post;
                $counter++;
                $nisn = get_post_meta($post->ID, '_nisn', true);
                ?>
                <tr>
                    <td><?php echo $counter; ?></td>
                    <td><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></td>
                    <td><?php echo esc_html( $nisn ); ?></td>
                    <td>
                        <?php 
                            $terms = get_the_terms( $post->ID , 'fakultas' );
                            if ( $terms != null ){
                                foreach( $terms as $termkelas ) {
                                    $term_link = get_term_link( $termkelas, 'fakultas');
                                    echo '<a href="' . esc_url( $term_link ) . '">' . esc_html( $termkelas->name ) . '</a> ';
                                    unset($termkelas); 
                                } 
                            } 
                        ?>
                    </td>
                </tr>
            <?php endwhile; ?>
        </table>
    </div>
<?php 
endif; 
?>
