	<div class="mag_event">
	    <?php // query Agenda  
		    $today = current_time('timestamp');
	        $args_upcoming = array(
				'post_type' => 'agenda',
				'posts_per_page' => 1, // Maksimal yang dibutuhkan
				'ignore_sticky_posts' => 1,
				'meta_key' => '_minus',
				'orderby' => 'meta_value',
				'order' => 'ASC',
				'meta_query' => array(
					array(
						'key' => '_minus',
						'value' => $today,
						'compare' => '>='
					),
				),
			);

			$upcoming_query = new WP_Query($args_upcoming);
			
			$total_found = $upcoming_query->found_posts;

			// Jika post kurang dari 5, buat query kedua
			if ($total_found < 1) {
				$remaining_posts = 1 - $total_found;

				$args_past = array(
					'post_type' => 'agenda',
					'posts_per_page' => $remaining_posts,
					'ignore_sticky_posts' => 1,
					'meta_key' => '_minus',
					'orderby' => 'meta_value',
					'order' => 'DESC',
					'meta_query' => array(
						array(
						    'key' => '_minus',
						    'value' => $today,
						    'compare' => '<'
						 ),
					),
				);

				$past_query = new WP_Query($args_past);
			}

			// Gabungkan hasil kedua query
			$all_posts = array_merge(
				$upcoming_query->posts,
				isset($past_query) ? $past_query->posts : array()
			);
			?>
			<div class="eve_near">
				<h4><span class="re_agenda"><?php echo __('Agenda', 'mading'); ?></span><a href="<?php echo get_post_type_archive_link('agenda'); ?>"><i class="icon-mad-right"></i></a></h4>
		    	<?php
		        	global $post;
					if (!empty($all_posts)) :
						foreach ($all_posts as $index => $post) :
						setup_postdata($post);
				    	$minus       = strtotime(get_post_meta($post->ID, '_tevent', true).' '.get_post_meta($post->ID, '_jam', true));
						$tevent      = get_post_meta($post->ID, '_tevent', true);
						$jam         = get_post_meta($post->ID, '_jam', true);
						$sisa        = $minus - $today;
						$end         = $tevent . ' ' . $jam;	
						
						$lokasi      = get_post_meta( $post->ID, '_lokasi', true );
						$koordinator = get_post_meta( $post->ID, '_contper', true );
						$telepon     = get_post_meta( $post->ID, '_contwa', true );
						$acara       = date_i18n( "d F Y", strtotime( $tevent ) );
				    	?>
						    <div class="latest_agenda">
						    	<h4><?php the_title(); ?></h4>
			    				<div class="table_agenda madclear">
				    		    	<div class="span">
					    		    	<span><?php echo date_i18n("d", strtotime($tevent)); ?></span>
						    	    	<span><?php echo date_i18n("M", strtotime($tevent)); ?></span>
							    	</div>
		    				    	<div>
									    <?php if ( $sisa > 0 ) { ?>
			    			            	<span><?php echo __('Event Time', 'mading'); ?></span>
										<?php } else { ?>
								    		<span><?php echo __('Event is expired', 'mading'); ?></span>
										<?php } ?>
				    		        	<span><?php echo date_i18n("l", strtotime($tevent)) .' - <i class="icon-mad-clock"></i> '. esc_html( $jam ); ?></span>
					    			</div>
						    		<div class="btn"><a href="<?php the_permalink(); ?>"><i class="icon-mad-calendar"></i></a></div>
		    					</div>
			    			</div>
						<?php
						endforeach;
    					wp_reset_postdata();
			     	endif;
				?>
			</div>
    </div>