<?php
class RecentAgenda extends WP_Widget {
	function __construct() {
		parent::__construct(
			'recentagenda',
			esc_html__( 'Mading : Agenda', 'mading' ),
			array( 'description' => esc_html__( 'Use widget to show agenda', 'mading' ), 'customize_selective_refresh' => true, )
		);
	}

	public function widget( $args, $instance ) {
		if ( ! isset( $args['widget_id'] ) ) {
			$args['widget_id'] = $this->id;
		}

		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : __( 'Agenda', 'mading' );

		/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );
		
		$agenda_total = ( ! empty( $instance['agenda_total'] ) ) ? absint( $instance['agenda_total'] ) : 3;
		if ( ! $agenda_total ) {
			$agenda_total = 3;
		}
		
		$offset      = get_option( 'gmt_offset' );
    	if ( $offset = 7 ) {
	    	$localtime = 'UTC+0700';
        } elseif ( $offset = 8 ) {
	    	$localtime = 'UTC+0800';
     	} elseif ( $offset = 9 ) {
	    	$localtime ='UTC+0900';
    	}
    	$today       = strtotime(date('Y-m-d H:i:s', strtotime('+'.$offset.' hours')));
		
		$q_args = array( 
			'post_type' => 'agenda', 
			'ignore_sticky_posts' => 1,
			'numberposts' => $agenda_total,
			'meta_key' => '_minus',
	    	'meta_query' => array(
			array(
				'key' => '_minus',
				'compare' => '>='
				)
			),
	    	'orderby' => 'meta_value',
	    	'order' => 'DESC'
	    	); 
			
		global $post;
		$rpthumb_posts = get_posts($q_args);
		
		echo $args['before_widget']; 
		
		if ( $title ) {
			echo $args['before_title'] . $title . $args['after_title'];
		}
		
		foreach ($rpthumb_posts as $post):
			setup_postdata($post);
			$minus       = strtotime(get_post_meta($post->ID, '_tevent', true).' '.get_post_meta($post->ID, '_jam', true));
	    	$tevent      = get_post_meta($post->ID, '_tevent', true);
	    	$jam         = get_post_meta($post->ID, '_jam', true);
						
	    	$pack24      = date( "H:i:s", strtotime( $jam ) );		
	    	$sisa        = $minus-$today;
            $end         = $tevent . ' ' . $pack24;	
		
	    	?>
		
            <div class="agenda_widget madclear">
				<div class="agenda_dt">
			    	<div class="a_date"><?php echo date_i18n('d', strtotime(esc_html($tevent))); ?></div>
					<div class="a_month"><?php echo date_i18n('M Y', strtotime(esc_html($tevent))); ?></div>
				</div>
				<div class="agenda_info">
				    <div class="a_time"><span><?php echo __( 'time :', 'mading' ); ?> <?php echo esc_html($jam); ?></span></div>
					<div><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></div>
					<div>
					    <?php 
						    if ( $sisa < 0 ) { 
						        esc_html_e( 'Agenda is expired', 'mading' ); 
							} 
						?>
					</div>
				</div>
	    	</div>   

	<?php	endforeach;
		
		echo $args['after_widget'];
	}


	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = sanitize_text_field( $new_instance['title'] );
		$instance['agenda_total'] = sanitize_text_field( $new_instance['agenda_total'] );
		return $instance;
	}
		
		
	public function form( $instance ) {
		$title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : __( 'Agenda', 'mading' );
		$agenda_total     = isset( $instance['agenda_total'] ) ? esc_attr( $instance['agenda_total'] ) : 3; ?>
		<p><?php echo __( 'Use widget to show agenda', 'mading' ); ?><br/></p>
		<p><label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php _e( 'Widget Title :', 'mading' ); ?></label>
		<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" /></p>
		
		<p><label for="<?php echo esc_attr( $this->get_field_id( 'agenda_total' ) ); ?>"><?php _e( 'Post count :', 'mading' ); ?></label>
		<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'agenda_total' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'agenda_total' ) ); ?>" type="number" value="<?php echo esc_attr( $agenda_total ); ?>" /></p>

    <?php
	}
}