<?php
class RecentBlog extends WP_Widget {
	function __construct() {
		parent::__construct(
			'recentblog',
			esc_html__( 'Mading : Teacher Blogs', 'mading' ),
			array( 'description' => esc_html__( 'Use widget to show blog', 'mading' ), 'customize_selective_refresh' => true, )
		);
	}

	public function widget( $args, $instance ) {
		if ( ! isset( $args['widget_id'] ) ) {
			$args['widget_id'] = $this->id;
		}

		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : __( 'Teacher Blogs', 'mading' );

		/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );
		
		$blog_guru = ( ! empty( $instance['blog_guru'] ) ) ? absint( $instance['blog_guru'] ) : 3;
		if ( ! $blog_guru ) {
			$blog_guru = 3;
		}
		
		$q_args = array( 
			'post_type' => 'blog',
			'ignore_sticky_posts' => 1,
			'numberposts' => $blog_guru,
			); 
			
		global $post;
		$rpthumb_posts = get_posts($q_args);
		
		echo $args['before_widget']; 
		
		if ( $title ) {
			echo $args['before_title'] . $title . $args['after_title'];
		}
		
		foreach ($rpthumb_posts as $post):
			setup_postdata($post);
		?>
        <div class="post_widget madclear">
	    	<div class="widget_thumb">
		        <?php 
				    if (has_post_thumbnail()) {
			            the_post_thumbnail('small');
		            } else {
						if ( get_theme_mod('madingthumb_image') != "" ) {
					    	$mini = attachment_url_to_postid( get_theme_mod('madingthumb_image'));
							$showmini = wp_get_attachment_image_url( $mini, 'small' );
							echo '<img src="'. esc_url( $showmini ) .'"/>';
						} else {
							echo '<img src="'. get_template_directory_uri() .'/images/small.jpg"/>';
						}
					}
		        ?>
		    </div>
		    <div class="post_widinfo">
			    <div class="post_wtitle"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></div>
			    <span class="post_widspan"><?php echo __( 'By :', 'mading'); ?> <?php the_author(); ?></span>
		    </div>
        </div>
	<?php	endforeach;
		
		echo $args['after_widget'];
	}


	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = sanitize_text_field( $new_instance['title'] );
		$instance['blog_guru'] = sanitize_text_field( $new_instance['blog_guru'] );
		return $instance;
	}
		
		
	public function form( $instance ) {
		$title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : __( 'Teacher Blogs', 'mading' );
		$blog_guru     = isset( $instance['blog_guru'] ) ? esc_attr( $instance['blog_guru'] ) : 10; ?>
		<p><?php _e('Use widget to show blog', 'mading'); ?><br/></p>
		<p><label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php _e( 'Widget Title :', 'mading' ); ?></label>
		<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" /></p>
		
		<p><label for="<?php echo $this->get_field_id( 'blog_guru' ); ?>"><?php _e( 'Post count :', 'mading' ); ?></label>
		<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'blog_guru' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'blog_guru' ) ); ?>" type="number" value="<?php echo esc_attr( $blog_guru ); ?>" /></p>

    <?php
	}
}