<?php
class RecentPengumuman extends WP_Widget {
	function __construct() {
		parent::__construct(
			'recentpengumuman',
			esc_html__( 'Mading : Announcement', 'mading' ),
			array( 'description' => esc_html__( 'Use widget to show announcement', 'mading' ), 'customize_selective_refresh' => true, )
		);
	}

	public function widget( $args, $instance ) {
		if ( ! isset( $args['widget_id'] ) ) {
			$args['widget_id'] = $this->id;
		}

		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : __( 'Announcement', 'mading' );

		/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );
		
		$mading_peng = ( ! empty( $instance['mading_peng'] ) ) ? absint( $instance['mading_peng'] ) : 3;
		if ( ! $mading_peng ) {
			$mading_peng = 3;
		}
		
		$q_args = array( 
			'post_type' => 'pengumuman', 
			'ignore_sticky_posts' => 1,
			'numberposts' => $mading_peng,
			); 
			
		global $post;
		$rpthumb_posts = get_posts($q_args);
		
		echo $args['before_widget']; 
		
		if ( $title ) {
			echo $args['before_title'] . $title . $args['after_title'];
		}
		
		foreach ($rpthumb_posts as $post):
			setup_postdata($post);
	    	?>
	    	<div class="post_widget madclear">
		    	<div class="post_widspan"><?php printf(__('Publish : %s', 'mading'), get_the_date()); ?></div>
		        <div class="post_wtitle"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></div>
		        <div class="post_widspan"><?php if (function_exists('smart_excerpt')) smart_excerpt(get_the_excerpt(), 15); ?></div>
	    	</div> 
        	<?php	
		endforeach;
		
		echo $args['after_widget'];
	}


	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = sanitize_text_field( $new_instance['title'] );
		$instance['mading_peng'] = sanitize_text_field( $new_instance['mading_peng'] );
		return $instance;
	}
		
		
	public function form( $instance ) {
		$title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : __( 'Announcement', 'mading' );
		$mading_peng     = isset( $instance['mading_peng'] ) ? esc_attr( $instance['mading_peng'] ) : 3; ?>
		<p><?php _e( 'Use widget to show announcement', 'mading' ); ?><br/></p>
		<p><label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php _e( 'Widget Title :', 'mading' ); ?></label>
		<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" /></p>
		
		<p><label for="<?php echo esc_attr( $this->get_field_id( 'mading_peng' ) ); ?>"><?php _e( 'Post count :', 'mading' ); ?></label>
		<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'mading_peng' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'mading_peng' ) ); ?>" type="number" value="<?php echo esc_attr( $mading_peng ); ?>" /></p>

    <?php
	}
}