<?php
class Videos extends WP_Widget {
	function __construct() {
		parent::__construct(
			'mading_widvideo',
			esc_html__( 'Mading : Latest Video', 'mading' ),
			array( 'description' => esc_html__( 'Use widget to show post video', 'mading' ), 'customize_selective_refresh' => true, )
		);
	}

	public function widget( $args, $instance ) {
		if ( ! isset( $args['widget_id'] ) ) {
			$args['widget_id'] = $this->id;
		}

		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : __( 'Latest Video', 'mading' );

		/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );
		
		$vidpost = ( ! empty( $instance['vidpost'] ) ) ? absint( $instance['vidpost'] ) : 3;
		if ( ! $vidpost ) {
			$vidpost = 3;
		}
		
		$q_args = array( 
			'post_type' => 'video', 
			'numberposts' => $vidpost,
			); 
			
		global $post;
		$rpthumb_posts = get_posts($q_args);
		
		
		echo $args['before_widget']; 
		
		if ( $title ) {
			echo $args['before_title'] . $title . $args['after_title'];
		}
		
		echo '<div class="vid_widget madclear">';
		
		foreach ($rpthumb_posts as $post):
		    $vidembed = get_post_meta($post->ID, '_vidembed', true); 
			$video_embed = get_post_meta($post->ID, 'video_embed', true);
			setup_postdata($post);
		?>
		
		    <div class="vid_widbox">
			    <div class="vid_widin">
                    <?php
						if ($video_embed == !'') {
							echo wp_oembed_get( $video_embed );
						} else {
				        	?>
				                <iframe src="<?php echo esc_url( 'https://www.youtube.com/embed/'. rawurlencode( $vidembed ) .'' ); ?>" frameborder="0" allowfullscreen></iframe>
						    <?php 
				    	}
			    	?>
				</div>
			</div>
		
	<?php	endforeach;
		
		echo '</div>';
		
		echo $args['after_widget'];
	}


	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = sanitize_text_field( $new_instance['title'] );
		$instance['vidpost'] = sanitize_text_field( $new_instance['vidpost'] );
		return $instance;
	}
		
		
	public function form( $instance ) {
		$title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : __( 'Latest Video', 'mading' );
		$vidpost     = isset( $instance['vidpost'] ) ? esc_attr( $instance['vidpost'] ) : 3; ?>
		<p><?php echo __('Use widget to show post video', 'mading'); ?><br/></p>
		<p><label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Widget Title :', 'mading' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" /></p>
		
		<p><label for="<?php echo $this->get_field_id( 'vidpost' ); ?>"><?php _e( 'Count post :', 'mading' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'vidpost' ); ?>" name="<?php echo $this->get_field_name( 'vidpost' ); ?>" type="number" value="<?php echo $vidpost; ?>" /></p>

    <?php
	}
}