<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}


/**
 * library_sekolahpro_this_host
 *
 * @return void
 */
function library_sekolahpro_this_host()
{
    return preg_replace("(^https?://)", "", site_url());
}

function library_sekolahpro_decrypt($string, $length = 16)
{
    $secret_key = 'AUTH_KEY';
    $secret_iv = 'AUTH_SALT';

    $encrypt_method = "AES-256-CBC";
    $key = hash('sha256', $secret_key);
    $iv = substr(hash('sha256', $secret_iv), 0, $length);

    return openssl_decrypt(base64_decode($string), $encrypt_method, $key, 0, $iv);
}

/**
 * verify nonce
 */
function library_sekolahpro_verify_nonce($nonce)
{
    if (!isset($_COOKIE['wp_library_sekolahpro'])) return false;

    $cookie = library_sekolahpro_decrypt(sanitize_text_field($_COOKIE['wp_library_sekolahpro']));
    $nonce  = library_sekolahpro_decrypt(sanitize_text_field($nonce));
    $args   = json_decode($cookie, true);

    if (\Salesloo\Libraries\User_Info::get_ip() != $args['ip']) return false;

    if (strtotime('- 6 hours') > $nonce) return false;

    return true;
}

show_admin_bar(false);

function library_sekolahpro_encrypt($string, $length = 16)
{
    $secret_key = 'AUTH_KEY';
    $secret_iv = 'AUTH_SALT';

    $encrypt_method = "AES-256-CBC";
    $key = hash('sha256', $secret_key);
    $iv = substr(hash('sha256', $secret_iv), 0, $length);

    return base64_encode(openssl_encrypt($string, $encrypt_method, $key, 0, $iv));
}

if ( get_theme_mod('opsi_editor') != "false" ) {
    add_filter('use_block_editor_for_post', '__return_true');
} else {
	add_filter('use_block_editor_for_post', '__return_false');
}

function owl_enqueue_scripts() {
    // Memuat CSS
    wp_enqueue_style('owl-style', plugin_dir_url(__FILE__) . 'public/css/owl.carousel.min.css');
	wp_enqueue_style('ani-style', plugin_dir_url(__FILE__) . 'public/css/owl.animate.css');
	wp_enqueue_style('theme-style', plugin_dir_url(__FILE__) . 'public/css/owl.theme.default.min.css');

    // Memuat JS
    wp_enqueue_script('owl-script', plugin_dir_url(__FILE__) . 'public/js/owl.carousel.min.js', array('jquery'), null, true);
}

// Hook untuk memanggil fungsi enqueue pada frontend
add_action('wp_enqueue_scripts', 'owl_enqueue_scripts');