<?php

namespace CL\Elementor;

use Elementor\Core\Settings\Manager as SettingsManager;

defined('ABSPATH') || die();

class Assets_Manager {

	/**
	 * Bind hook and run internal methods here
	 */
	public static function init() {
		add_action('elementor/editor/after_enqueue_scripts', [__CLASS__, 'editor_enqueue']);
	}


	public static function get_dark_stylesheet_url() {
		return SEKOLAHPRO_URL . 'admin/css/editor-dark.min.css';
	}

	public static function enqueue_dark_stylesheet() {
		$theme = SettingsManager::get_settings_managers('editorPreferences')->get_model()->get_settings('ui_theme');

		if ('light' !== $theme) {
			$media_queries = 'all';

			if ('auto' === $theme) {
				$media_queries = '(prefers-color-scheme: dark)';
			}

			wp_enqueue_style(
				'dl-editor-dark',
				self::get_dark_stylesheet_url(),
				[
					'elementor-editor',
				],
				SEKOLAHPRO_VERSION,
				$media_queries
			);
		}
	}

	/**
	 * Enqueue editor assets
	 *
	 * @return void
	 */
	public static function editor_enqueue() {

		wp_enqueue_script(
			'dl-editor',
			SEKOLAHPRO_URL . 'admin/js/editor.min.js',
			['elementor-editor', 'jquery'],
			SEKOLAHPRO_VERSION,
			true
		);

		Library_Manager::enqueue_assets();

		/**
		 * Make sure to enqueue this at the end
		 * otherwise it may not work properly
		 */
		self::enqueue_dark_stylesheet();

		$localize_data = [
			'editor_nonce'            => wp_create_nonce('dl_editor_nonce'),
			'dark_stylesheet_url'     => self::get_dark_stylesheet_url(),
			'ASSETS_URL' => SEKOLAHPRO_URL
		];

		wp_localize_script(
			'dl-editor',
			'CLEditor',
			$localize_data
		);
	}

}

Assets_Manager::init();
