<?php 
	
	 
	
	register_post_type( 'agenda',		
	array(			
	    'menu_icon'       => 'dashicons-calendar-alt',
		'labels'          => array(				
	    'name'                => __( 'Agenda', 'sekolahpro' ),				
	    'singular_name'       => __( 'Agenda', 'sekolahpro' ),        
	    'add_new'             => __( 'Add New', 'sekolahpro'  ),	
	    'add_new_item'        => __( 'Add New Item', 'sekolahpro'  ),	
	    'edit'                => __( 'Edit', 'sekolahpro'  ),	 
	    'edit_item'           => __( 'Edit Item', 'sekolahpro'  ),	
	    'new_item'            => __( 'New Item', 'sekolahpro'  ),	
	    'view'                => __( 'View', 'sekolahpro'  ),	
	    'view_item'           => __( 'View Item', 'sekolahpro'  ),	
	    'search_items'        => __( 'Search Item', 'sekolahpro'  ),	
	    'not_found'           => __( 'Item not found', 'sekolahpro'  ),	
	    'not_found_in_trash'  => __( 'Item not found in Trash', 'sekolahpro'  ),	
	    'parent'              => __( 'Parent Super Duper', 'sekolahpro'  ),
        'featured_image'      => __( 'Image 600 x 400 pixel', 'sekolahpro'  ),		
	    ),		                	
	    	'public'               => true,           					            
	    	'has_archive'          => true,        			            
	    	'supports'             => array( 'title', 'editor', 'thumbnail'),        			            
	    	'exclude_from_search'  => false, 	 
	    	'show_in_rest'         => true,
			'capabilities' => array(
                'edit_post'                 => 'edit_acara',
				'edit_posts'                => 'edit_acaras',
                'edit_others_posts'         => 'edit_other_acaras',
				'edit_private_posts'        => 'edit_private_acaras',
				'edit_published_posts'      => 'edit_published_acaras',
				'read_post'                 => 'read_acara',
				'read_private_posts'        => 'read_private_acaras',
				'publish_posts'             => 'publish_acaras',
				'delete_post'               => 'delete_acara',
                'delete_posts'              => 'delete_acaras',
                'delete_private_posts'      => 'delete_private_acaras',
				'delete_others_posts'       => 'delete_others_acaras',
                'delete_published_posts'    => 'delete_published_acaras',
            ),
			'map_meta_cap' => true
		 )	
    );
	
	if ( get_theme_mod( 'hide_tutor' ) !== 'off' ) {
	add_action('admin_init', 'agenda_tutorial', 1);
	
	function agenda_tutorial() {
	    add_meta_box('agendatutorial', __('Tutorial', 'sekolahpro'), 'agendatutorial', 'agenda', 'normal', 'default');
	}

	function agendatutorial() { ?>
		    
		<div class="mading_metabox">
		    <?php echo wp_oembed_get( 'https://www.youtube.com/watch?v=6xO6j725LCE' ); ?>
		</div>
    
	<?php }
	}
	
	add_action('admin_init', 'masevents', 1);
	
	function masevents() {
	    add_meta_box('agenda_events', __('Agenda Data', 'sekolahpro'), 'agenda_events', 'agenda', 'normal', 'default');
	}

	function agenda_events($post) {
	    global $post;
	    echo '<input type="hidden" name="event_madingnonce" id="event_madingnonce" value="' . esc_attr( wp_create_nonce( plugin_basename(__FILE__) ) ) . '" />';
        
		$minus    = strtotime(get_post_meta($post->ID, '_tevent', true).''.get_post_meta($post->ID, '_jam', true));
	    $tevent   = get_post_meta($post->ID, '_tevent', true);
	    $jam      = get_post_meta($post->ID, '_jam', true);
		$lokasi   = get_post_meta($post->ID, '_lokasi', true);
		$roomaps  = get_post_meta($post->ID, '_roomaps', true);
		$contper  = get_post_meta($post->ID, '_contper', true);
		$contwa   = get_post_meta($post->ID, '_contwa', true);
		$hariini  = strtotime(gmdate("Y-m-d"));
		$sekarang = strtotime(wp_date("Y-m-d H:i"));
		$currents = $sekarang-$minus;
		?>
		    
		<div class="mading_metabox">
			<label><?php echo esc_html_e( 'Date', 'sekolahpro' ); ?></label>
			<input type="date" name="_tevent" value="<?php echo esc_attr( $tevent ); ?>" class="widefat" />
		
		    <label><?php echo esc_html_e( 'Time', 'sekolahpro' ); ?></label>
			<input type="time" name="_jam" value="<?php echo esc_attr( $jam ); ?>" class="widefat" />
			
			<label><?php echo esc_html_e( 'Location', 'sekolahpro' ); ?></label>
			<input type="text" name="_lokasi" value="<?php echo esc_attr( $lokasi ); ?>" class="widefat" />
			
			<label><?php echo esc_html_e( 'Embed Maps', 'sekolahpro' ); ?></label>
			<textarea name="_roomaps" class="widefat"><?php echo esc_textarea( $roomaps ); ?></textarea><br/><br/>
			
			<label><?php echo esc_html_e( 'Coordinator', 'sekolahpro' ); ?></label>
			<input type="text" name="_contper" value="<?php echo esc_attr( $contper ); ?>" class="widefat" />
		
		    <label><?php echo esc_html_e( 'WhatsApp', 'sekolahpro' ); ?></label>
			<input type="number" placeholder="62..." name="_contwa" value="<?php echo esc_attr( $contwa ); ?>" class="widefat" />
			
		</div>
    
	<?php }

	function agenda_events_meta($post_id, $post) {
	    
		if ( ! isset( $_POST['event_madingnonce'] ) || !wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['event_madingnonce'] ) ), plugin_basename(__FILE__) )) {
	        return $post_id;
	    }

	    if ( !current_user_can( 'edit_post', $post_id ))
	        return $post_id;
        $realevent               = isset($_POST['_tevent']) ? sanitize_text_field(wp_unslash($_POST['_tevent'])) : '' ;
		$realjam                 = isset($_POST['_jam']) ? sanitize_text_field(wp_unslash($_POST['_jam'])) : '' ;
		$events_meta['_minus']   = strtotime(wp_date( $realevent.''.$realjam ));
	    $events_meta['_tevent']  = isset($_POST['_tevent']) ? sanitize_text_field(wp_unslash($_POST['_tevent'])) : '' ;
		$events_meta['_jam']     = isset($_POST['_jam']) ? sanitize_text_field(wp_unslash($_POST['_jam'])) : '' ;
		$events_meta['_lokasi']  = isset($_POST['_lokasi']) ? sanitize_text_field(wp_unslash($_POST['_lokasi'])) : '' ;
		$events_meta['_roomaps'] = isset($_POST['_roomaps']) ? wp_unslash($_POST['_roomaps']) : '' ;
		$events_meta['_contper'] = isset($_POST['_contper']) ? sanitize_text_field(wp_unslash($_POST['_contper'])) : '' ;
		$events_meta['_contwa']  = isset($_POST['_contwa']) ? wp_unslash($_POST['_contwa']) : '' ;
		
	    foreach ($events_meta as $key => $value) {         
		    if( $post->post_type == 'revision' ) return; 
	        $value = implode(',', (array)$value); 
	        if(get_post_meta($post_id, $key, FALSE)) { 
	            update_post_meta($post_id, $key, $value);
	        } else { 
	            add_post_meta($post_id, $key, $value);
	        }
	        if(!$value) delete_post_meta($post_id, $key); 
	    }
	}

	add_action('save_post', 'agenda_events_meta', 1, 2); 