<?php
    
	 
	
	register_post_type( 'download',		
	array(			
	    'menu_icon' => 'dashicons-arrow-down-alt2',
	    'labels'          => array(				
	    'name'                => __( 'Download', 'sekolahpro' ),				
	    'singular_name'       => __( 'Download', 'sekolahpro' ),        
	    'add_new'             => __( 'Add New', 'sekolahpro'  ),	
	    'add_new_item'        => __( 'Add New Item', 'sekolahpro'  ),	
	    'edit'                => __( 'Edit', 'sekolahpro'  ),	 
	    'edit_item'           => __( 'Edit Item', 'sekolahpro'  ),	
	    'new_item'            => __( 'New Item', 'sekolahpro'  ),	
	    'view'                => __( 'View', 'sekolahpro'  ),	
	    'view_item'           => __( 'View Item', 'sekolahpro'  ),	
	    'search_items'        => __( 'Search Item', 'sekolahpro'  ),	
	    'not_found'           => __( 'Item not found', 'sekolahpro'  ),	
	    'not_found_in_trash'  => __( 'Item not found in Trash', 'sekolahpro'  ),	
	    'parent'              => __( 'Parent Super Duper', 'sekolahpro'  ),
        'featured_image'      => __( 'Featured Image', 'sekolahpro' ),		
	    ),		                	
	    	'public'               => true,           					            
	    	'has_archive'          => true,        			            
	    	'supports'             => array( 'title', 'editor', 'author'),        			            
	    	'exclude_from_search'  => false, 	 
	    	'show_in_rest'         => true,
			'capabilities' => array(
                'edit_post'                 => 'edit_down',
				'edit_posts'                => 'edit_downs',
                'edit_others_posts'         => 'edit_other_downs',
				'edit_private_posts'        => 'edit_private_downs',
				'edit_published_posts'      => 'edit_published_downs',
				'read_post'                 => 'read_down',
				'read_private_posts'        => 'read_private_downs',
				'publish_posts'             => 'publish_downs',
				'delete_post'               => 'delete_down',
                'delete_posts'              => 'delete_downs',
                'delete_private_posts'      => 'delete_private_downs',
				'delete_others_posts'       => 'delete_others_downs',
                'delete_published_posts'    => 'delete_published_downs',
            ),
			'map_meta_cap' => true
		 )	
    );
	
	if ( get_theme_mod( 'hide_tutor' ) !== 'off' ) {
	add_action('admin_init', 'download_tutorial', 1);
	 
	function download_tutorial() {
	    add_meta_box('downloadtutorial', __('Tutorial', 'sekolahpro'), 'downloadtutorial', 'download', 'normal', 'default');
	}

	function downloadtutorial() { ?>
		    
		<div class="mading_metabox">
		    <?php echo wp_oembed_get( 'https://www.youtube.com/watch?v=BlcS_MKuzUE' ); ?>
		</div>
    
	<?php }
	}
	
add_action('admin_init', 'add_upload_file_metaboxes', 1);

function add_upload_file_metaboxes() {
    add_meta_box('swp_file_upload', __('File Upload', 'sekolahpro'), 'swp_file_upload', 'download', 'normal', 'default');
}


function swp_file_upload($post) {
    global $post;
    
	echo '<input type="hidden" name="podcastmeta_noncename" id="podcastmeta_noncename" value="'. esc_attr( wp_create_nonce( plugin_basename(__FILE__) ) ). '" />';
    global $wpdb;
    $strFile    = get_post_meta($post->ID, $key = 'podcast_file', true);
	$sizeFile   = get_post_meta($post->ID, $key = 'size_file', true);
    $media_file = get_post_meta($post->ID, $key = '_wp_attached_file', true);
    if (!empty($media_file)) {
        $strFile = $media_file;
    } 
	?>

    <script type = "text/javascript">

        
		var file_frame;
        jQuery('#swp_file_upload').on('click', '#upload_image_button', function(podcast) {

        podcast.preventDefault();

        
		if (file_frame) {
            file_frame.open();
            return;
        }

        file_frame = wp.media.frames.file_frame = wp.media({
            title: jQuery(this).data('uploader_title'),
            button: {
                text: jQuery(this).data('uploader_button_text'),
            },
            multiple: false 
        });

        file_frame.on('select', function(){
            
            attachment = file_frame.state().get('selection').first().toJSON();

            var all = JSON.stringify( attachment );      
            var url = attachment.url;
            var filesizeHumanReadable = attachment.filesizeHumanReadable;

            var namefile = document.getElementById("podcast_file");
			var sizefile = document.getElementById("size_file");

            namefile.value = url; 
			sizefile.value = filesizeHumanReadable; 
        });

        file_frame.open();
    });

    </script>
    
	<div class="mading_metabox">
	
	    <label><?php echo esc_html_e( 'Upload file form computer or select file from the Media Library', 'sekolahpro' ); ?><br/><?php echo esc_html_e( 'IMPORTANT: You can also insert link file from sources outside this website (make sure link is open and not locked by a password), but system cannot read file size if it comes from an external link', 'sekolahpro' ); ?></label>
	    <div class="madding_hidden clearing">
		    <input type="text" name="podcast_file" placeholder="<?php echo esc_html_e( 'push upload button...', 'sekolahpro' ); ?>" id="podcast_file" value="<?php echo esc_attr( $strFile ); ?>"/>
	        <input type="text" name="size_file" placeholder="<?php echo esc_html_e( 'file size', 'sekolahpro' ); ?>" id="size_file" value="<?php echo esc_attr( $sizeFile); ?>"/>
		</div>
	
	</div>
	<div class="mading_metabox">
	    <br/>
	    <input id ="upload_image_button" type="button" value="<?php echo esc_attr_e( 'Upload', 'sekolahpro' ); ?>" class="button button-primary button-large" />
	</div>
    
	<?php
}


//Saving the file
function save_podcasts_meta($post_id, $post) {
    if ( ! isset( $_POST['podcastmeta_noncename'] ) || !wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['podcastmeta_noncename'] ) ), plugin_basename(__FILE__) ) ) {
	    return $post_id;
    }
    
	if (!current_user_can('edit_post', $post_id))
        return $post_id;
    
	$podcasts_meta['podcast_file'] = isset($_POST['podcast_file']) ? sanitize_text_field(wp_unslash($_POST['podcast_file'])) : '';
	$podcasts_meta['size_file']    = isset($_POST['size_file']) ? sanitize_text_field(wp_unslash($_POST['size_file'])) : '';
    
    foreach($podcasts_meta as $key => $value) {
        if ($post -> post_type == 'revision') return;
        $value = implode(',', (array) $value);
        if (get_post_meta($post_id, $key, FALSE)) { 
            update_post_meta($post_id, $key, $value);
        } else { 
            add_post_meta($post_id, $key, $value);
        }
        if (!$value) delete_post_meta($post_id, $key); 
    }
}
add_action('save_post', 'save_podcasts_meta', 1, 2); 