<?php
    
	 
	
	register_post_type( 'materi',		
	array(			
	    'menu_icon' => 'dashicons-clipboard',
	    'labels'          => array(				
	    'name'                => __( 'Materi + Tugas', 'sekolahpro' ),				
	    'singular_name'       => __( 'Materi + Tugas', 'sekolahpro' ),        
	    'add_new'             => __( 'Add New', 'sekolahpro'  ),	
	    'add_new_item'        => __( 'Add New Item', 'sekolahpro'  ),	
	    'edit'                => __( 'Edit', 'sekolahpro'  ),	 
	    'edit_item'           => __( 'Edit Item', 'sekolahpro'  ),	
	    'new_item'            => __( 'New Item', 'sekolahpro'  ),	
	    'view'                => __( 'View', 'sekolahpro'  ),	
	    'view_item'           => __( 'View Item', 'sekolahpro'  ),	
	    'search_items'        => __( 'Search Item', 'sekolahpro'  ),	
	    'not_found'           => __( 'Item not found', 'sekolahpro'  ),	
	    'not_found_in_trash'  => __( 'Item not found in Trash', 'sekolahpro'  ),	
	    'parent'              => __( 'Parent Super Duper', 'sekolahpro'  ),
	    ),		                	
	    	'public'               => true,           					            
	    	'has_archive'          => true,        			            
	    	'supports'             => array( 'title', 'editor',),        			            
	    	'exclude_from_search'  => false, 	 
	    	'show_in_rest'         => true,
			'capabilities' => array(
                'edit_post'                 => 'edit_tugas',
				'edit_posts'                => 'edit_tugass',
                'edit_others_posts'         => 'edit_other_tugass',
				'edit_private_posts'        => 'edit_private_tugass',
				'edit_published_posts'      => 'edit_published_tugass',
				'read_post'                 => 'read_tugas',
				'read_private_posts'        => 'read_private_tugass',
				'publish_posts'             => 'publish_tugass',
				'delete_post'               => 'delete_tugas',
                'delete_posts'              => 'delete_tugass',
                'delete_private_posts'      => 'delete_private_tugass',
				'delete_others_posts'       => 'delete_others_tugass',
                'delete_published_posts'    => 'delete_published_tugass',
            ),
			'map_meta_cap' => true
		 )	
    );
	
	add_action('admin_init', 'materi_timer', 1);
	
	function materi_timer() {
	    add_meta_box('timer', __('Expiration', 'sekolahpro'), 'materi_expired', 'materi', 'normal', 'default');
	}

	function materi_expired($post) {
	    global $post;
	    echo '<input type="hidden" name="materi_madingnonce" id="materi_madingnonce" value="' . esc_attr( wp_create_nonce( plugin_basename(__FILE__) ) ) . '" />';
        
	    $matdate  = get_post_meta($post->ID, 'matdate', true);
	    $mattime  = get_post_meta($post->ID, 'mattime', true);
		
	    $showdate = get_post_meta($post->ID, 'showdate', true);
	    $showtime = get_post_meta($post->ID, 'showtime', true);
		
		?>
		    
		<div class="mading_metabox">
		
		    <p><?php echo esc_html_e('Set the material due date to be hidden from student', 'sekolahpro'); ?></p>
		
			<label><?php echo esc_html_e( 'Date', 'sekolahpro' ); ?></label>
			<input type="date" name="matdate" value="<?php echo esc_attr( $matdate ); ?>" class="widefat" />
		
		    <label><?php echo esc_html_e( 'Time', 'sekolahpro' ); ?></label>
			<input type="time" name="mattime" value="<?php echo esc_attr( $mattime ); ?>" class="widefat" />
			
			<p><?php echo esc_html_e('Set a date for the material to appear again', 'sekolahpro'); ?></p>
		
			<label><?php echo esc_html_e( 'Date', 'sekolahpro' ); ?></label>
			<input type="date" name="showdate" value="<?php echo esc_attr( $showdate ); ?>" class="widefat" />
		
		    <label><?php echo esc_html_e( 'Time', 'sekolahpro' ); ?></label>
			<input type="time" name="showtime" value="<?php echo esc_attr( $showtime ); ?>" class="widefat" />
			
		</div>
    
	<?php }

	function materi_timer_meta($post_id, $post) {
	    if ( ! isset( $_POST['materi_madingnonce'] ) || !wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['materi_madingnonce'] ) ), plugin_basename(__FILE__) )) {
	    return $post_id;
	    }

	    if ( !current_user_can( 'edit_post', $post_id ))
	        return $post_id;

		$events_meta['matdate']  = isset($_POST['matdate']) ? sanitize_text_field(wp_unslash( $_POST['matdate'] ) ) : '' ;
	    $events_meta['mattime']  = isset($_POST['mattime']) ? sanitize_text_field(wp_unslash( $_POST['mattime'] ) ) : '' ;
		$events_meta['showdate'] = isset($_POST['showdate']) ? sanitize_text_field(wp_unslash( $_POST['showdate'] ) ) : '' ;
	    $events_meta['showtime'] = isset($_POST['showtime']) ? sanitize_text_field(wp_unslash( $_POST['showtime'] ) ) : '' ;
		
	    foreach ($events_meta as $key => $value) {         
		    if( $post->post_type == 'revision' ) return; 
	        $value = implode(',', (array)$value); 
	        if(get_post_meta($post_id, $key, FALSE)) { 
	            update_post_meta($post_id, $key, $value);
	        } else { 
	            add_post_meta($post_id, $key, $value);
	        }
	        if(!$value) delete_post_meta($post_id, $key); 
	    }
	}

	add_action('save_post', 'materi_timer_meta', 1, 2); 
	
	
	// Start Materi
	
	add_action('admin_init', 'materi_tugas', 1);
	
	function materi_tugas() {
    	add_meta_box( 'boxmateri', __('Create Question', 'sekolahpro'), 'add_materi', 'materi', 'normal', 'default');
    }

	function add_materi($post) {
    	global $post;
    	$materi_soal = get_post_meta($post->ID, 'materi_soal', true);
    	wp_nonce_field( 'materi_soalmeta', 'materi_soalmeta' );
    	?>
    
    	<script type="text/javascript">
     	jQuery(document).ready(function( $ ){
    		$( '#add-his' ).on('click', function() {
			var row = $( '.emptysoal.screen-reader-text' ).clone(true);
			row.removeClass( 'emptysoal screen-reader-text' );
			row.insertBefore( '#listingsoal tbody>tr:last' );
			return false;
		});
  	
		$( '.remove-soal' ).on('click', function() {
			$(this).parents('tr').remove();
			return false;
		});
    	});
    	</script>
  
    	<div class="mading_metabox">
    		<table id="listingsoal">
		    
			
         	<?php if ( $materi_soal ) :
			foreach ( $materi_soal as $field ) { ?>
             	<tr>
            		<td>
					    <div class="madclear">
						    <div class="full">
							    <div class="halfin">
				                	<input type="text" placeholder="<?php echo esc_attr_e('Create a question here..', 'sekolahpro'); ?>" class="widefat" name="question[]" value="<?php if($field['question'] != '') echo esc_attr( $field['question'] ); ?>" />
								</div>
							</div>
						</div>
						<div class="madclear">
							<div class="abcd">
							    <div class="halfin">
				                	<input type="text" placeholder="<?php echo esc_attr_e('Answer A', 'sekolahpro'); ?>" class="widefat" name="answer1[]" value="<?php if ($field['answer1'] != '') echo esc_attr( $field['answer1'] ); ?>" />
								</div>
							</div>
							<div class="abcd">
							    <div class="halfin">
				                	<input type="text" placeholder="<?php echo esc_attr_e('Answer B', 'sekolahpro'); ?>" class="widefat" name="answer2[]" value="<?php if ($field['answer2'] != '') echo esc_attr( $field['answer2'] ); ?>" />
								</div>
							</div>
							<div class="abcd">
							    <div class="halfin">
				                	<input type="text" placeholder="<?php echo esc_attr_e('Answer C', 'sekolahpro'); ?>" class="widefat" name="answer3[]" value="<?php if ($field['answer3'] != '') echo esc_attr( $field['answer3'] ); ?>" />
								</div>
							</div>
							<div class="abcd">
							    <div class="halfin">
				                	<input type="text" placeholder="<?php echo esc_attr_e('Answer D', 'sekolahpro'); ?>" class="widefat" name="answer4[]" value="<?php if ($field['answer4'] != '') echo esc_attr( $field['answer4'] ); ?>" />
								</div>
							</div>
						</div>
						<div class="halfclose">
							<div class="halfin">
							    <a class="button remove-soal button-move" href="#"><?php echo esc_html_e( 'Remove', 'sekolahpro' ); ?></a>
					        </div>
						</div>
					</td>
				</tr>
				
			<?php } else : ?>
			
	    		<tr>
            		<td>
					    <div class="madclear">
						    <div class="full">
							    <div class="halfin">
			    	            	<input type="text" placeholder="<?php echo esc_attr_e('Create a question here..', 'sekolahpro'); ?>" class="widefat" name="question[]" />
								</div>
							</div>
						</div>
						<div class="madclear">
							<div class="abcd">
							    <div class="halfin">
						        	<input type="text" placeholder="<?php echo esc_attr_e('Answer A', 'sekolahpro'); ?>" class="widefat" name="answer1[]" />
							    </div>
							</div>
							<div class="abcd">
							    <div class="halfin">
						        	<input type="text" placeholder="<?php echo esc_attr_e('Answer B', 'sekolahpro'); ?>" class="widefat" name="answer2[]" />
							    </div>
							</div>
							<div class="abcd">
							    <div class="halfin">
						        	<input type="text" placeholder="<?php echo esc_attr_e('Answer C', 'sekolahpro'); ?>" class="widefat" name="answer3[]" />
							    </div>
							</div>
							<div class="abcd">
							    <div class="halfin">
						        	<input type="text" placeholder="<?php echo esc_attr_e('Answer D', 'sekolahpro'); ?>" class="widefat" name="answer4[]" />
							    </div>
							</div>
						</div>
						<div class="halfclose">
							<div class="halfin">
							    <a class="button remove-soal button-move" href="#"><?php echo esc_html_e( 'Remove', 'sekolahpro' ); ?></a>
					        </div>
						</div>
					</td>
				</tr>
				
			<?php endif; ?>
	
            	<!-- empty hidden one for jQuery -->
            	<tr class="emptysoal screen-reader-text">
            		<td>
					    <div class="madclear">
						    <div class="full">
							    <div class="halfin">
			    	            	<input type="text" placeholder="<?php echo esc_attr_e('Create a question here..', 'sekolahpro'); ?>" class="widefat" name="question[]" />
								</div>
							</div>
						</div>
						<div class="madclear">
							<div class="abcd">
							    <div class="halfin">
						        	<input type="text" placeholder="<?php echo esc_attr_e('Answer A', 'sekolahpro'); ?>" class="widefat" name="answer1[]" />
							    </div>
							</div>
							<div class="abcd">
							    <div class="halfin">
						        	<input type="text" placeholder="<?php echo esc_attr_e('Answer B', 'sekolahpro'); ?>" class="widefat" name="answer2[]" />
							    </div>
							</div>
							<div class="abcd">
							    <div class="halfin">
						        	<input type="text" placeholder="<?php echo esc_attr_e('Answer C', 'sekolahpro'); ?>" class="widefat" name="answer3[]" />
							    </div>
							</div>
							<div class="abcd">
							    <div class="halfin">
						        	<input type="text" placeholder="<?php echo esc_attr_e('Answer D', 'sekolahpro'); ?>" class="widefat" name="answer4[]" />
							    </div>
							</div>
						</div>
						<div class="halfclose">
							<div class="halfin">
							    <a class="button remove-soal button-move" href="#"><?php echo esc_html_e( 'Remove', 'sekolahpro' ); ?></a>
					        </div>
						</div>
					</td>
				</tr>
	    	</table>
		</div>
		
		<div class="mading_metabox"><a id="add-his" class="button button-primary button-large" href="#"><?php echo esc_html_e( 'Add New', 'sekolahpro' ); ?></a></div> 
			
	<?php
    }

	add_action('save_post', 'save_materi');

	function save_materi($post_id) {
    	if ( ! isset( $_POST['materi_soalmeta'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['materi_soalmeta'] ) ), 'materi_soalmeta' ) )
	    	return;
	
    	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
	    	return;
	
    	if (!current_user_can('edit_post', $post_id))
	    	return;
	
    	$olds = get_post_meta($post_id, 'materi_soal', true);
    	$news = array();
	
    	$questions = isset($_POST['question']) ? $_POST['question'] : array();
    	$answer1s  = isset($_POST['answer1']) ? $_POST['answer1'] : array();
		$answer2s  = isset($_POST['answer2']) ? $_POST['answer2'] : array();
		$answer3s  = isset($_POST['answer3']) ? $_POST['answer3'] : array();
		$answer4s  = isset($_POST['answer4']) ? $_POST['answer4'] : array();
	
    	$counts = count( $questions );
	
    	for ( $i = 0; $i < $counts; $i++ ) {
	    	if ( $questions[$i] != '' ) {
	    		$news[$i]['question'] = wp_kses($questions[$i], array());
				$news[$i]['answer1']  = wp_kses($answer1s[$i], array());
				$news[$i]['answer2']  = wp_kses($answer2s[$i], array());
				$news[$i]['answer3']  = wp_kses($answer3s[$i], array());
				$news[$i]['answer4']  = wp_kses($answer4s[$i], array());
	    	}
    	}
		
    	if ( !empty( $news ) && $news != $olds )
    		update_post_meta( $post_id, 'materi_soal', $news );
    	elseif ( empty($news) && $olds )
    		delete_post_meta( $post_id, 'materi_soal', $olds );
	}	
    
	// End Work History